/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.index.chain;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.index.chain.MonotoneChainOverlapAction;
import org.locationtech.jts.index.chain.MonotoneChainSelectAction;

public class MonotoneChain {
    private Coordinate[] pts;
    private int start;
    private int end;
    private Envelope env = null;
    private Object context = null;
    private int id;

    public MonotoneChain(Coordinate[] pts, int start2, int end, Object context) {
        this.pts = pts;
        this.start = start2;
        this.end = end;
        this.context = context;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setOverlapDistance(double distance) {
    }

    public int getId() {
        return this.id;
    }

    public Object getContext() {
        return this.context;
    }

    public Envelope getEnvelope() {
        return this.getEnvelope(0.0);
    }

    public Envelope getEnvelope(double expansionDistance) {
        if (this.env == null) {
            Coordinate p0 = this.pts[this.start];
            Coordinate p1 = this.pts[this.end];
            this.env = new Envelope(p0, p1);
            if (expansionDistance > 0.0) {
                this.env.expandBy(expansionDistance);
            }
        }
        return this.env;
    }

    public int getStartIndex() {
        return this.start;
    }

    public int getEndIndex() {
        return this.end;
    }

    public void getLineSegment(int index2, LineSegment ls) {
        ls.p0 = this.pts[index2];
        ls.p1 = this.pts[index2 + 1];
    }

    public Coordinate[] getCoordinates() {
        Coordinate[] coord = new Coordinate[this.end - this.start + 1];
        int index2 = 0;
        for (int i2 = this.start; i2 <= this.end; ++i2) {
            coord[index2++] = this.pts[i2];
        }
        return coord;
    }

    public void select(Envelope searchEnv, MonotoneChainSelectAction mcs) {
        this.computeSelect(searchEnv, this.start, this.end, mcs);
    }

    private void computeSelect(Envelope searchEnv, int start0, int end0, MonotoneChainSelectAction mcs) {
        Coordinate p0 = this.pts[start0];
        Coordinate p1 = this.pts[end0];
        if (end0 - start0 == 1) {
            mcs.select(this, start0);
            return;
        }
        if (!searchEnv.intersects(p0, p1)) {
            return;
        }
        int mid = (start0 + end0) / 2;
        if (start0 < mid) {
            this.computeSelect(searchEnv, start0, mid, mcs);
        }
        if (mid < end0) {
            this.computeSelect(searchEnv, mid, end0, mcs);
        }
    }

    public void computeOverlaps(MonotoneChain mc, MonotoneChainOverlapAction mco) {
        this.computeOverlaps(this.start, this.end, mc, mc.start, mc.end, 0.0, mco);
    }

    public void computeOverlaps(MonotoneChain mc, double overlapTolerance, MonotoneChainOverlapAction mco) {
        this.computeOverlaps(this.start, this.end, mc, mc.start, mc.end, overlapTolerance, mco);
    }

    private void computeOverlaps(int start0, int end0, MonotoneChain mc, int start1, int end1, double overlapTolerance, MonotoneChainOverlapAction mco) {
        if (end0 - start0 == 1 && end1 - start1 == 1) {
            mco.overlap(this, start0, mc, start1);
            return;
        }
        if (!this.overlaps(start0, end0, mc, start1, end1, overlapTolerance)) {
            return;
        }
        int mid0 = (start0 + end0) / 2;
        int mid1 = (start1 + end1) / 2;
        if (start0 < mid0) {
            if (start1 < mid1) {
                this.computeOverlaps(start0, mid0, mc, start1, mid1, overlapTolerance, mco);
            }
            if (mid1 < end1) {
                this.computeOverlaps(start0, mid0, mc, mid1, end1, overlapTolerance, mco);
            }
        }
        if (mid0 < end0) {
            if (start1 < mid1) {
                this.computeOverlaps(mid0, end0, mc, start1, mid1, overlapTolerance, mco);
            }
            if (mid1 < end1) {
                this.computeOverlaps(mid0, end0, mc, mid1, end1, overlapTolerance, mco);
            }
        }
    }

    private boolean overlaps(int start0, int end0, MonotoneChain mc, int start1, int end1, double overlapTolerance) {
        if (overlapTolerance > 0.0) {
            return this.overlaps(this.pts[start0], this.pts[end0], mc.pts[start1], mc.pts[end1], overlapTolerance);
        }
        return Envelope.intersects(this.pts[start0], this.pts[end0], mc.pts[start1], mc.pts[end1]);
    }

    private boolean overlaps(Coordinate p1, Coordinate p2, Coordinate q1, Coordinate q2, double overlapTolerance) {
        double minq = Math.min(q1.x, q2.x);
        double maxq = Math.max(q1.x, q2.x);
        double minp = Math.min(p1.x, p2.x);
        double maxp = Math.max(p1.x, p2.x);
        if (minp > maxq + overlapTolerance) {
            return false;
        }
        if (maxp < minq - overlapTolerance) {
            return false;
        }
        minq = Math.min(q1.y, q2.y);
        maxq = Math.max(q1.y, q2.y);
        minp = Math.min(p1.y, p2.y);
        maxp = Math.max(p1.y, p2.y);
        if (minp > maxq + overlapTolerance) {
            return false;
        }
        return !(maxp < minq - overlapTolerance);
    }
}

