/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Coordinates;
import org.locationtech.jts.geom.Envelope;

public interface CoordinateSequence
extends Cloneable {
    public static final int X = 0;
    public static final int Y = 1;
    public static final int Z = 2;
    public static final int M = 3;

    public int getDimension();

    default public int getMeasures() {
        return 0;
    }

    default public boolean hasZ() {
        return this.getDimension() - this.getMeasures() > 2;
    }

    default public boolean hasM() {
        return this.getMeasures() > 0;
    }

    default public Coordinate createCoordinate() {
        return Coordinates.create(this.getDimension(), this.getMeasures());
    }

    public Coordinate getCoordinate(int var1);

    public Coordinate getCoordinateCopy(int var1);

    public void getCoordinate(int var1, Coordinate var2);

    public double getX(int var1);

    public double getY(int var1);

    default public double getZ(int index2) {
        if (this.hasZ()) {
            return this.getOrdinate(index2, 2);
        }
        return Double.NaN;
    }

    default public double getM(int index2) {
        if (this.hasM()) {
            int mIndex = this.getDimension() - this.getMeasures();
            return this.getOrdinate(index2, mIndex);
        }
        return Double.NaN;
    }

    public double getOrdinate(int var1, int var2);

    public int size();

    public void setOrdinate(int var1, int var2, double var3);

    public Coordinate[] toCoordinateArray();

    public Envelope expandEnvelope(Envelope var1);

    public Object clone();

    public CoordinateSequence copy();
}

