/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.wire;

import com.google.inject.ProvisionException;
import com.google.inject.TypeLiteral;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Provider;
import org.eclipse.sisu.inject.Weak;
import org.eclipse.sisu.wire.DynamicGlue;

final class GlueLoader
extends ClassLoader {
    private static final Object SYSTEM_LOADER_LOCK = new Object();
    private static final String PROVIDER_NAME = Provider.class.getName();
    private static final String GLUE_SUFFIX = "$__sisu__$";
    private static final String DYNAMIC = "dyn";
    private static final ConcurrentMap<Integer, GlueLoader> cachedGlue = Weak.concurrentValues();

    GlueLoader() {
    }

    GlueLoader(ClassLoader parent2) {
        super(parent2);
    }

    public static <T> T dynamicGlue(TypeLiteral<T> type2, Provider<T> provider) {
        try {
            return (T)GlueLoader.dynamicGlue(type2.getRawType()).getConstructor(Provider.class).newInstance(provider);
        }
        catch (Exception e2) {
            Throwable cause = e2 instanceof InvocationTargetException ? e2.getCause() : e2;
            throw new ProvisionException("Error proxying: " + type2, cause);
        }
        catch (LinkageError e3) {
            throw new ProvisionException("Error proxying: " + type2, (Throwable)e3);
        }
    }

    @Override
    protected Class<?> loadClass(String name2, boolean resolve2) throws ClassNotFoundException {
        if (PROVIDER_NAME.equals(name2)) {
            return Provider.class;
        }
        return super.loadClass(name2, resolve2);
    }

    @Override
    protected Class<?> findClass(String name2) throws ClassNotFoundException {
        if (name2.endsWith("$__sisu__$dyn")) {
            Class<?> facade = this.loadClass(GlueLoader.unwrap(name2));
            byte[] code = DynamicGlue.generateProxyClass(name2.replace('.', '/'), facade);
            return this.defineClass(name2, code, 0, code.length);
        }
        throw new ClassNotFoundException(name2);
    }

    private static Class<?> dynamicGlue(Class<?> facade) throws ClassNotFoundException {
        return GlueLoader.glue(facade.getClassLoader()).loadClass(GlueLoader.wrap(facade.getName(), DYNAMIC));
    }

    private static String wrap(String name2, String kind) {
        StringBuilder buf = new StringBuilder();
        if (name2.startsWith("java.") || name2.startsWith("java/")) {
            buf.append('$');
        }
        return buf.append(name2).append(GLUE_SUFFIX).append(kind).toString();
    }

    private static String unwrap(String name2) {
        int head = '$' == name2.charAt(0) ? 1 : 0;
        int tail = name2.lastIndexOf(GLUE_SUFFIX);
        return tail > 0 ? name2.substring(head, tail) : name2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static GlueLoader glue(ClassLoader parent2) {
        int id = System.identityHashCode(parent2);
        GlueLoader result2 = (GlueLoader)cachedGlue.get(id);
        if (result2 == null || result2.getParent() != parent2) {
            Object object = parent2 != null ? parent2 : SYSTEM_LOADER_LOCK;
            synchronized (object) {
                GlueLoader glue = GlueLoader.createGlue(parent2);
                do {
                    if ((result2 = cachedGlue.putIfAbsent(id++, glue)) != null) continue;
                    return glue;
                } while (result2.getParent() != parent2);
            }
        }
        return result2;
    }

    private static GlueLoader createGlue(final ClassLoader parent2) {
        return AccessController.doPrivileged(new PrivilegedAction<GlueLoader>(){

            @Override
            public GlueLoader run() {
                return parent2 != null ? new GlueLoader(parent2) : new GlueLoader();
            }
        });
    }
}

