/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.io.File;
import java.util.Objects;
import java.util.TreeSet;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.internal.impl.SimpleDigest;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.LocalArtifactRegistration;
import org.eclipse.aether.repository.LocalArtifactRequest;
import org.eclipse.aether.repository.LocalArtifactResult;
import org.eclipse.aether.repository.LocalMetadataRegistration;
import org.eclipse.aether.repository.LocalMetadataRequest;
import org.eclipse.aether.repository.LocalMetadataResult;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;

class SimpleLocalRepositoryManager
implements LocalRepositoryManager {
    private final LocalRepository repository;

    SimpleLocalRepositoryManager(File basedir) {
        this(basedir, "simple");
    }

    SimpleLocalRepositoryManager(String basedir) {
        this(basedir != null ? new File(basedir) : null, "simple");
    }

    SimpleLocalRepositoryManager(File basedir, String type2) {
        Objects.requireNonNull(basedir, "base directory cannot be null");
        this.repository = new LocalRepository(basedir.getAbsoluteFile(), type2);
    }

    @Override
    public LocalRepository getRepository() {
        return this.repository;
    }

    String getPathForArtifact(Artifact artifact, boolean local) {
        StringBuilder path = new StringBuilder(128);
        path.append(artifact.getGroupId().replace('.', '/')).append('/');
        path.append(artifact.getArtifactId()).append('/');
        path.append(artifact.getBaseVersion()).append('/');
        path.append(artifact.getArtifactId()).append('-');
        if (local) {
            path.append(artifact.getBaseVersion());
        } else {
            path.append(artifact.getVersion());
        }
        if (artifact.getClassifier().length() > 0) {
            path.append('-').append(artifact.getClassifier());
        }
        if (artifact.getExtension().length() > 0) {
            path.append('.').append(artifact.getExtension());
        }
        return path.toString();
    }

    @Override
    public String getPathForLocalArtifact(Artifact artifact) {
        return this.getPathForArtifact(artifact, true);
    }

    @Override
    public String getPathForRemoteArtifact(Artifact artifact, RemoteRepository repository, String context) {
        return this.getPathForArtifact(artifact, false);
    }

    @Override
    public String getPathForLocalMetadata(Metadata metadata) {
        return this.getPath(metadata, "local");
    }

    @Override
    public String getPathForRemoteMetadata(Metadata metadata, RemoteRepository repository, String context) {
        return this.getPath(metadata, this.getRepositoryKey(repository, context));
    }

    String getRepositoryKey(RemoteRepository repository, String context) {
        String key2;
        if (repository.isRepositoryManager()) {
            StringBuilder buffer = new StringBuilder(128);
            buffer.append(repository.getId());
            buffer.append('-');
            TreeSet<String> subKeys = new TreeSet<String>();
            for (RemoteRepository mirroredRepo : repository.getMirroredRepositories()) {
                subKeys.add(mirroredRepo.getId());
            }
            SimpleDigest digest = new SimpleDigest();
            digest.update(context);
            for (String subKey : subKeys) {
                digest.update(subKey);
            }
            buffer.append(digest.digest());
            key2 = buffer.toString();
        } else {
            key2 = repository.getId();
        }
        return key2;
    }

    private String getPath(Metadata metadata, String repositoryKey) {
        StringBuilder path = new StringBuilder(128);
        if (metadata.getGroupId().length() > 0) {
            path.append(metadata.getGroupId().replace('.', '/')).append('/');
            if (metadata.getArtifactId().length() > 0) {
                path.append(metadata.getArtifactId()).append('/');
                if (metadata.getVersion().length() > 0) {
                    path.append(metadata.getVersion()).append('/');
                }
            }
        }
        path.append(this.insertRepositoryKey(metadata.getType(), repositoryKey));
        return path.toString();
    }

    private String insertRepositoryKey(String filename, String repositoryKey) {
        int idx = filename.indexOf(46);
        String result2 = idx < 0 ? filename + '-' + repositoryKey : filename.substring(0, idx) + '-' + repositoryKey + filename.substring(idx);
        return result2;
    }

    @Override
    public LocalArtifactResult find(RepositorySystemSession session2, LocalArtifactRequest request2) {
        String path = this.getPathForArtifact(request2.getArtifact(), false);
        File file = new File(this.getRepository().getBasedir(), path);
        LocalArtifactResult result2 = new LocalArtifactResult(request2);
        if (file.isFile()) {
            result2.setFile(file);
            result2.setAvailable(true);
        }
        return result2;
    }

    @Override
    public void add(RepositorySystemSession session2, LocalArtifactRegistration request2) {
    }

    public String toString() {
        return String.valueOf(this.getRepository());
    }

    @Override
    public LocalMetadataResult find(RepositorySystemSession session2, LocalMetadataRequest request2) {
        LocalMetadataResult result2 = new LocalMetadataResult(request2);
        Metadata metadata = request2.getMetadata();
        String context = request2.getContext();
        RemoteRepository remote = request2.getRepository();
        String path = remote != null ? this.getPathForRemoteMetadata(metadata, remote, context) : this.getPathForLocalMetadata(metadata);
        File file = new File(this.getRepository().getBasedir(), path);
        if (file.isFile()) {
            result2.setFile(file);
        }
        return result2;
    }

    @Override
    public void add(RepositorySystemSession session2, LocalMetadataRegistration request2) {
    }
}

