/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class FastMap<K, V>
implements Map<K, V>,
Cloneable,
Serializable {
    private transient EntryImpl[] _entries;
    private transient int _capacity;
    private transient int _mask;
    private transient EntryImpl _poolFirst;
    private transient EntryImpl _mapFirst;
    private transient EntryImpl _mapLast;
    private transient int _size;
    private transient Values _values;
    private transient EntrySet _entrySet;
    private transient KeySet _keySet;

    public FastMap() {
        this.initialize(256);
    }

    public FastMap(Map map2) {
        int capacity = map2 instanceof FastMap ? ((FastMap)map2).capacity() : map2.size();
        this.initialize(capacity);
        this.putAll(map2);
    }

    public FastMap(int capacity) {
        this.initialize(capacity);
    }

    @Override
    public int size() {
        return this._size;
    }

    public int capacity() {
        return this._capacity;
    }

    @Override
    public boolean isEmpty() {
        return this._size == 0;
    }

    @Override
    public boolean containsKey(Object key2) {
        EntryImpl entry = this._entries[FastMap.keyHash(key2) & this._mask];
        while (entry != null) {
            if (key2.equals(entry._key)) {
                return true;
            }
            entry = entry._next;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value2) {
        EntryImpl entry = this._mapFirst;
        while (entry != null) {
            if (value2.equals(entry._value)) {
                return true;
            }
            entry = entry._after;
        }
        return false;
    }

    @Override
    public V get(Object key2) {
        EntryImpl entry = this._entries[FastMap.keyHash(key2) & this._mask];
        while (entry != null) {
            if (key2.equals(entry._key)) {
                return (V)entry._value;
            }
            entry = entry._next;
        }
        return null;
    }

    public Map.Entry getEntry(Object key2) {
        EntryImpl entry = this._entries[FastMap.keyHash(key2) & this._mask];
        while (entry != null) {
            if (key2.equals(entry._key)) {
                return entry;
            }
            entry = entry._next;
        }
        return null;
    }

    @Override
    public Object put(Object key2, Object value2) {
        EntryImpl entry = this._entries[FastMap.keyHash(key2) & this._mask];
        while (entry != null) {
            if (key2.equals(entry._key)) {
                Object prevValue = entry._value;
                entry._value = value2;
                return prevValue;
            }
            entry = entry._next;
        }
        this.addEntry(key2, value2);
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map2) {
        for (Map.Entry<K, V> entry : map2.entrySet()) {
            this.addEntry(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object key2) {
        EntryImpl entry = this._entries[FastMap.keyHash(key2) & this._mask];
        while (entry != null) {
            if (key2.equals(entry._key)) {
                Object prevValue = entry._value;
                this.removeEntry(entry);
                return (V)prevValue;
            }
            entry = entry._next;
        }
        return null;
    }

    @Override
    public void clear() {
        EntryImpl entry = this._mapFirst;
        while (entry != null) {
            entry._key = null;
            entry._value = null;
            entry._before = null;
            entry._next = null;
            if (entry._previous == null) {
                this._entries[((EntryImpl)entry)._index] = null;
            } else {
                entry._previous = null;
            }
            entry = entry._after;
        }
        if (this._mapLast != null) {
            this._mapLast._after = this._poolFirst;
            this._poolFirst = this._mapFirst;
            this._mapFirst = null;
            this._mapLast = null;
            this._size = 0;
            this.sizeChanged();
        }
    }

    public void setCapacity(int newCapacity) {
        int tableLength;
        EntryImpl entry;
        int i2;
        if (newCapacity > this._capacity) {
            for (i2 = this._capacity; i2 < newCapacity; ++i2) {
                entry = new EntryImpl();
                entry._after = this._poolFirst;
                this._poolFirst = entry;
            }
        } else if (newCapacity < this._capacity) {
            for (i2 = newCapacity; i2 < this._capacity && this._poolFirst != null; ++i2) {
                entry = this._poolFirst;
                this._poolFirst = entry._after;
                entry._after = null;
            }
        }
        for (tableLength = 16; tableLength < newCapacity; tableLength <<= 1) {
        }
        if (this._entries.length != tableLength) {
            this._entries = new EntryImpl[tableLength];
            this._mask = tableLength - 1;
            entry = this._mapFirst;
            while (entry != null) {
                int index2 = FastMap.keyHash(entry._key) & this._mask;
                entry._index = index2;
                entry._previous = null;
                EntryImpl next = this._entries[index2];
                entry._next = next;
                if (next != null) {
                    next._previous = entry;
                }
                this._entries[index2] = entry;
                entry = entry._after;
            }
        }
        this._capacity = newCapacity;
    }

    public Object clone() {
        try {
            FastMap clone = (FastMap)super.clone();
            clone.initialize(this._capacity);
            clone.putAll(this);
            return clone;
        }
        catch (CloneNotSupportedException e2) {
            throw new InternalError();
        }
    }

    @Override
    public boolean equals(Object obj2) {
        if (obj2 == this) {
            return true;
        }
        if (obj2 instanceof Map) {
            Map that = (Map)obj2;
            if (this.size() == that.size()) {
                EntryImpl entry = this._mapFirst;
                while (entry != null) {
                    if (!that.entrySet().contains(entry)) {
                        return false;
                    }
                    entry = entry._after;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int code = 0;
        EntryImpl entry = this._mapFirst;
        while (entry != null) {
            code += entry.hashCode();
            entry = entry._after;
        }
        return code;
    }

    public String toString() {
        return this.entrySet().toString();
    }

    @Override
    public Collection values() {
        return this._values;
    }

    @Override
    public Set entrySet() {
        return this._entrySet;
    }

    @Override
    public Set keySet() {
        return this._keySet;
    }

    protected void sizeChanged() {
        if (this.size() > this.capacity()) {
            this.setCapacity(this.capacity() * 2);
        }
    }

    private static int keyHash(Object key2) {
        int hashCode = key2.hashCode();
        hashCode += ~(hashCode << 9);
        hashCode ^= hashCode >>> 14;
        hashCode += hashCode << 4;
        hashCode ^= hashCode >>> 10;
        return hashCode;
    }

    private void addEntry(Object key2, Object value2) {
        EntryImpl entry = this._poolFirst;
        if (entry != null) {
            this._poolFirst = entry._after;
            entry._after = null;
        } else {
            entry = new EntryImpl();
        }
        entry._key = key2;
        entry._value = value2;
        int index2 = FastMap.keyHash(key2) & this._mask;
        entry._index = index2;
        EntryImpl next = this._entries[index2];
        entry._next = next;
        if (next != null) {
            next._previous = entry;
        }
        this._entries[index2] = entry;
        if (this._mapLast != null) {
            entry._before = this._mapLast;
            this._mapLast._after = entry;
        } else {
            this._mapFirst = entry;
        }
        this._mapLast = entry;
        ++this._size;
        this.sizeChanged();
    }

    private void removeEntry(EntryImpl entry) {
        EntryImpl previous = entry._previous;
        EntryImpl next = entry._next;
        if (previous != null) {
            previous._next = next;
            entry._previous = null;
        } else {
            this._entries[((EntryImpl)entry)._index] = next;
        }
        if (next != null) {
            next._previous = previous;
            entry._next = null;
        }
        EntryImpl before2 = entry._before;
        EntryImpl after2 = entry._after;
        if (before2 != null) {
            before2._after = after2;
            entry._before = null;
        } else {
            this._mapFirst = after2;
        }
        if (after2 != null) {
            after2._before = before2;
        } else {
            this._mapLast = before2;
        }
        entry._key = null;
        entry._value = null;
        entry._after = this._poolFirst;
        this._poolFirst = entry;
        --this._size;
        this.sizeChanged();
    }

    private void initialize(int capacity) {
        int tableLength;
        for (tableLength = 16; tableLength < capacity; tableLength <<= 1) {
        }
        this._entries = new EntryImpl[tableLength];
        this._mask = tableLength - 1;
        this._capacity = capacity;
        this._size = 0;
        this._values = new Values();
        this._entrySet = new EntrySet();
        this._keySet = new KeySet();
        this._poolFirst = null;
        this._mapFirst = null;
        this._mapLast = null;
        for (int i2 = 0; i2 < capacity; ++i2) {
            EntryImpl entry = new EntryImpl();
            entry._after = this._poolFirst;
            this._poolFirst = entry;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        int capacity = stream.readInt();
        this.initialize(capacity);
        int size = stream.readInt();
        for (int i2 = 0; i2 < size; ++i2) {
            Object key2 = stream.readObject();
            Object value2 = stream.readObject();
            this.addEntry(key2, value2);
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeInt(this._capacity);
        stream.writeInt(this._size);
        int count = 0;
        EntryImpl entry = this._mapFirst;
        while (entry != null) {
            stream.writeObject(entry._key);
            stream.writeObject(entry._value);
            ++count;
            entry = entry._after;
        }
        if (count != this._size) {
            throw new IOException("FastMap Corrupted");
        }
    }

    private static final class EntryImpl<K, V>
    implements Map.Entry<K, V> {
        private K _key;
        private V _value;
        private int _index;
        private EntryImpl _previous;
        private EntryImpl _next;
        private EntryImpl _before;
        private EntryImpl _after;

        private EntryImpl() {
        }

        @Override
        public K getKey() {
            return this._key;
        }

        @Override
        public V getValue() {
            return this._value;
        }

        @Override
        public V setValue(V value2) {
            V old2 = this._value;
            this._value = value2;
            return old2;
        }

        @Override
        public boolean equals(Object that) {
            if (that instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)that;
                return this._key.equals(entry.getKey()) && (this._value != null ? this._value.equals(entry.getValue()) : entry.getValue() == null);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this._key.hashCode() ^ (this._value != null ? this._value.hashCode() : 0);
        }

        public String toString() {
            return this._key + "=" + this._value;
        }
    }

    private class KeySet
    extends AbstractSet {
        private KeySet() {
        }

        @Override
        public Iterator iterator() {
            return new Iterator(){
                EntryImpl after;
                EntryImpl before;
                {
                    this.after = FastMap.this._mapFirst;
                }

                @Override
                public void remove() {
                    FastMap.this.removeEntry(this.before);
                }

                @Override
                public boolean hasNext() {
                    return this.after != null;
                }

                public Object next() {
                    this.before = this.after;
                    this.after = this.after._after;
                    return this.before._key;
                }
            };
        }

        @Override
        public int size() {
            return FastMap.this._size;
        }

        @Override
        public boolean contains(Object obj2) {
            return FastMap.this.containsKey(obj2);
        }

        @Override
        public boolean remove(Object obj2) {
            return FastMap.this.remove(obj2) != null;
        }

        @Override
        public void clear() {
            FastMap.this.clear();
        }
    }

    private class EntrySet
    extends AbstractSet {
        private EntrySet() {
        }

        @Override
        public Iterator iterator() {
            return new Iterator(){
                EntryImpl after;
                EntryImpl before;
                {
                    this.after = FastMap.this._mapFirst;
                }

                @Override
                public void remove() {
                    FastMap.this.removeEntry(this.before);
                }

                @Override
                public boolean hasNext() {
                    return this.after != null;
                }

                public Object next() {
                    this.before = this.after;
                    this.after = this.after._after;
                    return this.before;
                }
            };
        }

        @Override
        public int size() {
            return FastMap.this._size;
        }

        @Override
        public boolean contains(Object obj2) {
            if (obj2 instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)obj2;
                Map.Entry mapEntry = FastMap.this.getEntry(entry.getKey());
                return entry.equals(mapEntry);
            }
            return false;
        }

        @Override
        public boolean remove(Object obj2) {
            Map.Entry entry;
            EntryImpl mapEntry;
            if (obj2 instanceof Map.Entry && (mapEntry = (EntryImpl)FastMap.this.getEntry((entry = (Map.Entry)obj2).getKey())) != null && entry.getValue().equals(mapEntry._value)) {
                FastMap.this.removeEntry(mapEntry);
                return true;
            }
            return false;
        }
    }

    private class Values
    extends AbstractCollection {
        private Values() {
        }

        @Override
        public Iterator iterator() {
            return new Iterator(){
                EntryImpl after;
                EntryImpl before;
                {
                    this.after = FastMap.this._mapFirst;
                }

                @Override
                public void remove() {
                    FastMap.this.removeEntry(this.before);
                }

                @Override
                public boolean hasNext() {
                    return this.after != null;
                }

                public Object next() {
                    this.before = this.after;
                    this.after = this.after._after;
                    return this.before._value;
                }
            };
        }

        @Override
        public int size() {
            return FastMap.this._size;
        }

        @Override
        public boolean contains(Object o2) {
            return FastMap.this.containsValue(o2);
        }

        @Override
        public void clear() {
            FastMap.this.clear();
        }
    }
}

