/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class CollectionUtils {
    public static <K, V> Map<K, V> mergeMaps(Map<K, V> dominantMap, Map<K, V> recessiveMap) {
        if (dominantMap == null && recessiveMap == null) {
            return null;
        }
        if (dominantMap != null && recessiveMap == null) {
            return dominantMap;
        }
        if (dominantMap == null) {
            return recessiveMap;
        }
        HashMap<K, V> result2 = new HashMap<K, V>();
        Set<K> dominantMapKeys = dominantMap.keySet();
        Set<K> recessiveMapKeys = recessiveMap.keySet();
        Collection<K> contributingRecessiveKeys = CollectionUtils.subtract(recessiveMapKeys, CollectionUtils.intersection(dominantMapKeys, recessiveMapKeys));
        result2.putAll(dominantMap);
        for (K key2 : contributingRecessiveKeys) {
            result2.put(key2, recessiveMap.get(key2));
        }
        return result2;
    }

    public static <K, V> Map<K, V> mergeMaps(Map<K, V>[] maps) {
        Map<K, V> result2;
        if (maps.length == 0) {
            result2 = null;
        } else if (maps.length == 1) {
            result2 = maps[0];
        } else {
            result2 = CollectionUtils.mergeMaps(maps[0], maps[1]);
            for (int i2 = 2; i2 < maps.length; ++i2) {
                result2 = CollectionUtils.mergeMaps(result2, maps[i2]);
            }
        }
        return result2;
    }

    public static <E> Collection<E> intersection(Collection<E> a, Collection<E> b2) {
        ArrayList list = new ArrayList();
        Map<E, Integer> mapa = CollectionUtils.getCardinalityMap(a);
        Map<E, Integer> mapb = CollectionUtils.getCardinalityMap(b2);
        HashSet<E> elts = new HashSet<E>(a);
        elts.addAll(b2);
        for (Object obj2 : elts) {
            int m = Math.min(CollectionUtils.getFreq(obj2, mapa), CollectionUtils.getFreq(obj2, mapb));
            for (int i2 = 0; i2 < m; ++i2) {
                list.add(obj2);
            }
        }
        return list;
    }

    public static <T> Collection<T> subtract(Collection<T> a, Collection<T> b2) {
        ArrayList<T> list = new ArrayList<T>(a);
        for (T aB : b2) {
            list.remove(aB);
        }
        return list;
    }

    public static <E> Map<E, Integer> getCardinalityMap(Collection<E> col) {
        HashMap<E, Integer> count = new HashMap<E, Integer>();
        for (E obj2 : col) {
            Integer c2 = (Integer)count.get(obj2);
            if (null == c2) {
                count.put(obj2, 1);
                continue;
            }
            count.put(obj2, c2 + 1);
        }
        return count;
    }

    public static <E> List<E> iteratorToList(Iterator<E> it2) {
        if (it2 == null) {
            throw new NullPointerException("it cannot be null.");
        }
        ArrayList<E> list = new ArrayList<E>();
        while (it2.hasNext()) {
            list.add(it2.next());
        }
        return list;
    }

    private static <E> int getFreq(E obj2, Map<E, Integer> freqMap) {
        try {
            Integer o2 = freqMap.get(obj2);
            if (o2 != null) {
                return o2;
            }
        }
        catch (NullPointerException | NoSuchElementException runtimeException) {
            // empty catch block
        }
        return 0;
    }
}

