/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jettison.json;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ListIterator;
import java.util.Map;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.codehaus.jettison.json.JSONTokener;

public class JSONArray
implements Serializable {
    private ArrayList myArrayList;
    private boolean escapeForwardSlashAlways = true;

    public boolean isEscapeForwardSlashAlways() {
        return this.escapeForwardSlashAlways;
    }

    public void setEscapeForwardSlashAlways(boolean escapeForwardSlashAlways) {
        this.escapeForwardSlashAlways = escapeForwardSlashAlways;
    }

    public JSONArray() {
        this.myArrayList = new ArrayList();
    }

    public JSONArray(int capacity) {
        this.myArrayList = new ArrayList(capacity);
    }

    public JSONArray(JSONTokener x) throws JSONException {
        this();
        if (x.nextClean() != '[') {
            throw x.syntaxError("A JSONArray text must start with '['");
        }
        char c2 = x.nextClean();
        if (c2 == '\u0000') {
            throw x.syntaxError("JSONArray text must end with ']'");
        }
        if (c2 == ',') {
            throw x.syntaxError("JSONArray text has a trailing ','");
        }
        if (c2 == ']') {
            return;
        }
        x.back();
        block4: while (true) {
            if (x.nextClean() == ',') {
                if (c2 == '[') {
                    throw x.syntaxError("JSONArray text has a trailing ','");
                }
                x.back();
                this.myArrayList.add(null);
            } else {
                x.back();
                this.myArrayList.add(x.nextValue());
            }
            switch (x.nextClean()) {
                case ',': 
                case ';': {
                    char nextClean = x.nextClean();
                    if (nextClean == '\u0000') {
                        throw x.syntaxError("JSONArray text has a trailing ','");
                    }
                    if (nextClean == ']') {
                        return;
                    }
                    x.back();
                    continue block4;
                }
                case ']': {
                    return;
                }
            }
            break;
        }
        throw x.syntaxError("Expected a ',' or ']'");
    }

    public JSONArray(String string) throws JSONException {
        this(new JSONTokener(string));
    }

    public JSONArray(Collection collection2) throws JSONException {
        this(collection2, 0);
    }

    private JSONArray(Collection collection2, int recursionDepth) throws JSONException {
        if (recursionDepth > JSONObject.getGlobalRecursionDepthLimit()) {
            throw new JSONException("JSONArray has reached recursion depth limit of " + JSONObject.getGlobalRecursionDepthLimit());
        }
        this.myArrayList = collection2 == null ? new ArrayList() : new ArrayList(collection2);
        ListIterator<Serializable> iter = this.myArrayList.listIterator();
        while (iter.hasNext()) {
            Object e2 = iter.next();
            if (e2 instanceof Collection) {
                iter.set(new JSONArray((Collection)e2, recursionDepth + 1));
            }
            if (!(e2 instanceof Map)) continue;
            iter.set(new JSONObject((Map)e2));
        }
    }

    public Object get(int index2) throws JSONException {
        Object o2 = this.opt(index2);
        if (o2 == null) {
            throw new JSONException("JSONArray[" + index2 + "] not found.");
        }
        return o2;
    }

    public boolean getBoolean(int index2) throws JSONException {
        Object o2 = this.get(index2);
        if (o2.equals(Boolean.FALSE) || o2 instanceof String && ((String)o2).equalsIgnoreCase("false")) {
            return false;
        }
        if (o2.equals(Boolean.TRUE) || o2 instanceof String && ((String)o2).equalsIgnoreCase("true")) {
            return true;
        }
        throw new JSONException("JSONArray[" + index2 + "] is not a Boolean.");
    }

    public double getDouble(int index2) throws JSONException {
        Object o2 = this.get(index2);
        try {
            return o2 instanceof Number ? ((Number)o2).doubleValue() : Double.valueOf((String)o2).doubleValue();
        }
        catch (Exception e2) {
            throw new JSONException("JSONArray[" + index2 + "] is not a number.");
        }
    }

    public int getInt(int index2) throws JSONException {
        Object o2 = this.get(index2);
        return o2 instanceof Number ? ((Number)o2).intValue() : (int)this.getDouble(index2);
    }

    public JSONArray getJSONArray(int index2) throws JSONException {
        Object o2 = this.get(index2);
        if (o2 instanceof JSONArray) {
            return (JSONArray)o2;
        }
        throw new JSONException("JSONArray[" + index2 + "] is not a JSONArray.");
    }

    public JSONObject getJSONObject(int index2) throws JSONException {
        Object o2 = this.get(index2);
        if (o2 instanceof JSONObject) {
            return (JSONObject)o2;
        }
        throw new JSONException("JSONArray[" + index2 + "] is not a JSONObject.");
    }

    public long getLong(int index2) throws JSONException {
        Object o2 = this.get(index2);
        return o2 instanceof Number ? ((Number)o2).longValue() : (long)this.getDouble(index2);
    }

    public String getString(int index2) throws JSONException {
        return this.get(index2).toString();
    }

    public boolean isNull(int index2) {
        return JSONObject.NULL.equals(this.opt(index2));
    }

    public String join(String separator) throws JSONException {
        int len = this.length();
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < len; ++i2) {
            if (i2 > 0) {
                sb.append(separator);
            }
            sb.append(JSONObject.valueToString(this.myArrayList.get(i2), this.escapeForwardSlashAlways));
        }
        return sb.toString();
    }

    public int length() {
        return this.myArrayList.size();
    }

    public Object opt(int index2) {
        return index2 < 0 || index2 >= this.length() ? null : this.myArrayList.get(index2);
    }

    public boolean optBoolean(int index2) {
        return this.optBoolean(index2, false);
    }

    public boolean optBoolean(int index2, boolean defaultValue) {
        try {
            return this.getBoolean(index2);
        }
        catch (Exception e2) {
            return defaultValue;
        }
    }

    public double optDouble(int index2) {
        return this.optDouble(index2, Double.NaN);
    }

    public double optDouble(int index2, double defaultValue) {
        try {
            return this.getDouble(index2);
        }
        catch (Exception e2) {
            return defaultValue;
        }
    }

    public int optInt(int index2) {
        return this.optInt(index2, 0);
    }

    public int optInt(int index2, int defaultValue) {
        try {
            return this.getInt(index2);
        }
        catch (Exception e2) {
            return defaultValue;
        }
    }

    public JSONArray optJSONArray(int index2) {
        Object o2 = this.opt(index2);
        return o2 instanceof JSONArray ? (JSONArray)o2 : null;
    }

    public JSONObject optJSONObject(int index2) {
        Object o2 = this.opt(index2);
        return o2 instanceof JSONObject ? (JSONObject)o2 : null;
    }

    public long optLong(int index2) {
        return this.optLong(index2, 0L);
    }

    public long optLong(int index2, long defaultValue) {
        try {
            return this.getLong(index2);
        }
        catch (Exception e2) {
            return defaultValue;
        }
    }

    public String optString(int index2) {
        return this.optString(index2, "");
    }

    public String optString(int index2, String defaultValue) {
        Object o2 = this.opt(index2);
        return o2 != null ? o2.toString() : defaultValue;
    }

    public JSONArray put(boolean value2) {
        this.put(value2 ? Boolean.TRUE : Boolean.FALSE);
        return this;
    }

    public JSONArray put(Collection value2) throws JSONException {
        this.put(new JSONArray(value2));
        return this;
    }

    public JSONArray put(double value2) throws JSONException {
        Double d2 = new Double(value2);
        JSONObject.testValidity(d2);
        this.put(d2);
        return this;
    }

    public JSONArray put(int value2) {
        this.put((Object)value2);
        return this;
    }

    public JSONArray put(long value2) {
        this.put((Object)value2);
        return this;
    }

    public JSONArray put(Map value2) throws JSONException {
        this.put(new JSONObject(value2));
        return this;
    }

    public JSONArray put(Object value2) {
        this.myArrayList.add(value2);
        return this;
    }

    public JSONArray remove(Object value2) {
        this.myArrayList.remove(value2);
        return this;
    }

    public JSONArray put(int index2, boolean value2) throws JSONException {
        this.put(index2, value2 ? Boolean.TRUE : Boolean.FALSE);
        return this;
    }

    public JSONArray put(int index2, Collection value2) throws JSONException {
        this.put(index2, new JSONArray(value2));
        return this;
    }

    public JSONArray put(int index2, double value2) throws JSONException {
        this.put(index2, new Double(value2));
        return this;
    }

    public JSONArray put(int index2, int value2) throws JSONException {
        this.put(index2, (Object)value2);
        return this;
    }

    public JSONArray put(int index2, long value2) throws JSONException {
        this.put(index2, (Object)value2);
        return this;
    }

    public JSONArray put(int index2, Map value2) throws JSONException {
        this.put(index2, new JSONObject(value2));
        return this;
    }

    public JSONArray put(int index2, Object value2) throws JSONException {
        JSONObject.testValidity(value2);
        if (index2 < 0) {
            throw new JSONException("JSONArray[" + index2 + "] not found.");
        }
        if (index2 < this.length()) {
            this.myArrayList.set(index2, value2);
        } else {
            while (index2 != this.length()) {
                this.put(JSONObject.NULL);
            }
            this.put(value2);
        }
        return this;
    }

    public JSONObject toJSONObject(JSONArray names2) throws JSONException {
        if (names2 == null || names2.length() == 0 || this.length() == 0) {
            return null;
        }
        JSONObject jo = new JSONObject();
        for (int i2 = 0; i2 < names2.length(); ++i2) {
            jo.put(names2.getString(i2), this.opt(i2));
        }
        return jo;
    }

    public String toString() {
        try {
            return '[' + this.join(",") + ']';
        }
        catch (Exception e2) {
            return null;
        }
    }

    public String toString(int indentFactor) throws JSONException {
        return this.toString(indentFactor, 0);
    }

    String toString(int indentFactor, int indent) throws JSONException {
        int len = this.length();
        if (len == 0) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder("[");
        if (len == 1) {
            sb.append(JSONObject.valueToString(this.myArrayList.get(0), indentFactor, indent, this.escapeForwardSlashAlways));
        } else {
            int i2;
            int newindent = indent + indentFactor;
            sb.append('\n');
            for (i2 = 0; i2 < len; ++i2) {
                if (i2 > 0) {
                    sb.append(",\n");
                }
                for (int j = 0; j < newindent; ++j) {
                    sb.append(' ');
                }
                sb.append(JSONObject.valueToString(this.myArrayList.get(i2), indentFactor, newindent, this.escapeForwardSlashAlways));
            }
            sb.append('\n');
            for (i2 = 0; i2 < indent; ++i2) {
                sb.append(' ');
            }
        }
        sb.append(']');
        return sb.toString();
    }

    public int hashCode() {
        return this.myArrayList.hashCode();
    }

    public boolean equals(Object obj2) {
        if (obj2 instanceof JSONArray) {
            return this.myArrayList.equals(((JSONArray)obj2).myArrayList);
        }
        return false;
    }

    public Writer write(Writer writer) throws JSONException {
        try {
            boolean b2 = false;
            int len = this.length();
            writer.write(91);
            for (int i2 = 0; i2 < len; ++i2) {
                Object v2;
                if (b2) {
                    writer.write(44);
                }
                if ((v2 = this.myArrayList.get(i2)) instanceof JSONObject) {
                    ((JSONObject)v2).write(writer);
                } else if (v2 instanceof JSONArray) {
                    ((JSONArray)v2).write(writer);
                } else {
                    writer.write(JSONObject.valueToString(v2, this.escapeForwardSlashAlways));
                }
                b2 = true;
            }
            writer.write(93);
            return writer;
        }
        catch (IOException e2) {
            throw new JSONException(e2);
        }
    }
}

