/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.repository.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.License;
import org.apache.maven.model.Model;
import org.apache.maven.model.Prerequisites;
import org.apache.maven.model.Repository;
import org.apache.maven.repository.internal.ArtifactDescriptorUtils;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.ArtifactType;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.artifact.DefaultArtifactType;
import org.eclipse.aether.graph.Exclusion;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;

public class ArtifactDescriptorReaderDelegate {
    public void populateResult(RepositorySystemSession session2, ArtifactDescriptorResult result2, Model model2) {
        ArtifactTypeRegistry stereotypes = session2.getArtifactTypeRegistry();
        for (Repository repository : model2.getRepositories()) {
            result2.addRepository(ArtifactDescriptorUtils.toRemoteRepository(repository));
        }
        for (Dependency dependency : model2.getDependencies()) {
            result2.addDependency(this.convert(dependency, stereotypes));
        }
        DependencyManagement mgmt = model2.getDependencyManagement();
        if (mgmt != null) {
            for (Dependency dependency : mgmt.getDependencies()) {
                result2.addManagedDependency(this.convert(dependency, stereotypes));
            }
        }
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        Prerequisites prerequisites = model2.getPrerequisites();
        if (prerequisites != null) {
            linkedHashMap.put("prerequisites.maven", prerequisites.getMaven());
        }
        List<License> licenses = model2.getLicenses();
        linkedHashMap.put("license.count", licenses.size());
        for (int i2 = 0; i2 < licenses.size(); ++i2) {
            License license = licenses.get(i2);
            linkedHashMap.put("license." + i2 + ".name", license.getName());
            linkedHashMap.put("license." + i2 + ".url", license.getUrl());
            linkedHashMap.put("license." + i2 + ".comments", license.getComments());
            linkedHashMap.put("license." + i2 + ".distribution", license.getDistribution());
        }
        result2.setProperties(linkedHashMap);
        this.setArtifactProperties(result2, model2);
    }

    private org.eclipse.aether.graph.Dependency convert(Dependency dependency, ArtifactTypeRegistry stereotypes) {
        ArtifactType stereotype = stereotypes.get(dependency.getType());
        if (stereotype == null) {
            stereotype = new DefaultArtifactType(dependency.getType());
        }
        boolean system = dependency.getSystemPath() != null && dependency.getSystemPath().length() > 0;
        Map<String, String> props = null;
        if (system) {
            props = Collections.singletonMap("localPath", dependency.getSystemPath());
        }
        DefaultArtifact artifact = new DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getClassifier(), null, dependency.getVersion(), props, stereotype);
        ArrayList<Exclusion> exclusions = new ArrayList<Exclusion>(dependency.getExclusions().size());
        for (org.apache.maven.model.Exclusion exclusion : dependency.getExclusions()) {
            exclusions.add(this.convert(exclusion));
        }
        org.eclipse.aether.graph.Dependency result2 = new org.eclipse.aether.graph.Dependency((Artifact)artifact, dependency.getScope(), dependency.getOptional() != null ? Boolean.valueOf(dependency.isOptional()) : null, exclusions);
        return result2;
    }

    private Exclusion convert(org.apache.maven.model.Exclusion exclusion) {
        return new Exclusion(exclusion.getGroupId(), exclusion.getArtifactId(), "*", "*");
    }

    private void setArtifactProperties(ArtifactDescriptorResult result2, Model model2) {
        String downloadUrl = null;
        DistributionManagement distMgmt = model2.getDistributionManagement();
        if (distMgmt != null) {
            downloadUrl = distMgmt.getDownloadUrl();
        }
        if (downloadUrl != null && downloadUrl.length() > 0) {
            Artifact artifact = result2.getArtifact();
            HashMap<String, String> props = new HashMap<String, String>(artifact.getProperties());
            props.put("downloadUrl", downloadUrl);
            result2.setArtifact(artifact.setProperties(props));
        }
    }
}

