/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.validation;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.model.Activation;
import org.apache.maven.model.ActivationFile;
import org.apache.maven.model.Build;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.InputLocationTracker;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.Profile;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.Reporting;
import org.apache.maven.model.Repository;
import org.apache.maven.model.Resource;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.building.ModelProblemCollectorRequest;
import org.apache.maven.model.interpolation.ModelVersionProcessor;
import org.apache.maven.model.validation.ModelValidator;
import org.codehaus.plexus.util.StringUtils;

@Named
@Singleton
public class DefaultModelValidator
implements ModelValidator {
    private static final Pattern CI_FRIENDLY_EXPRESSION = Pattern.compile("\\$\\{(.+?)}");
    private static final String ILLEGAL_FS_CHARS = "\\/:\"<>|?*";
    private static final String ILLEGAL_VERSION_CHARS = "\\/:\"<>|?*";
    private static final String ILLEGAL_REPO_ID_CHARS = "\\/:\"<>|?*";
    private static final String EMPTY = "";
    private final Set<String> validIds = new HashSet<String>();
    private ModelVersionProcessor versionProcessor;

    @Inject
    public DefaultModelValidator(ModelVersionProcessor versionProcessor) {
        this.versionProcessor = versionProcessor;
    }

    @Override
    public void validateRawModel(Model m, ModelBuildingRequest request2, ModelProblemCollector problems) {
        Parent parent2 = m.getParent();
        if (parent2 != null) {
            this.validateStringNotEmpty("parent.groupId", problems, ModelProblem.Severity.FATAL, ModelProblem.Version.BASE, parent2.getGroupId(), parent2);
            this.validateStringNotEmpty("parent.artifactId", problems, ModelProblem.Severity.FATAL, ModelProblem.Version.BASE, parent2.getArtifactId(), parent2);
            this.validateStringNotEmpty("parent.version", problems, ModelProblem.Severity.FATAL, ModelProblem.Version.BASE, parent2.getVersion(), parent2);
            if (DefaultModelValidator.equals(parent2.getGroupId(), m.getGroupId()) && DefaultModelValidator.equals(parent2.getArtifactId(), m.getArtifactId())) {
                DefaultModelValidator.addViolation(problems, ModelProblem.Severity.FATAL, ModelProblem.Version.BASE, "parent.artifactId", null, "must be changed, the parent element cannot have the same groupId:artifactId as the project.", parent2);
            }
            if (DefaultModelValidator.equals("LATEST", parent2.getVersion()) || DefaultModelValidator.equals("RELEASE", parent2.getVersion())) {
                DefaultModelValidator.addViolation(problems, ModelProblem.Severity.WARNING, ModelProblem.Version.BASE, "parent.version", null, "is either LATEST or RELEASE (both of them are being deprecated)", parent2);
            }
        }
        if (request2.getValidationLevel() >= 20) {
            ModelProblem.Severity errOn30 = DefaultModelValidator.getSeverity(request2, 30);
            this.validateStringNotEmpty("modelVersion", problems, ModelProblem.Severity.ERROR, ModelProblem.Version.V20, m.getModelVersion(), m);
            this.validateModelVersion(problems, m.getModelVersion(), m, "4.0.0");
            this.validateStringNoExpression("groupId", problems, ModelProblem.Severity.WARNING, ModelProblem.Version.V20, m.getGroupId(), m);
            if (parent2 == null) {
                this.validateStringNotEmpty("groupId", problems, ModelProblem.Severity.FATAL, ModelProblem.Version.V20, m.getGroupId(), m);
            }
            this.validateStringNoExpression("artifactId", problems, ModelProblem.Severity.WARNING, ModelProblem.Version.V20, m.getArtifactId(), m);
            this.validateStringNotEmpty("artifactId", problems, ModelProblem.Severity.FATAL, ModelProblem.Version.V20, m.getArtifactId(), m);
            this.validateVersionNoExpression("version", problems, ModelProblem.Severity.WARNING, ModelProblem.Version.V20, m.getVersion(), m);
            if (parent2 == null) {
                this.validateStringNotEmpty("version", problems, ModelProblem.Severity.FATAL, ModelProblem.Version.V20, m.getVersion(), m);
            }
            this.validate20RawDependencies(problems, m.getDependencies(), "dependencies.dependency.", EMPTY, request2);
            this.validate20RawDependenciesSelfReferencing(problems, m, m.getDependencies(), "dependencies.dependency", request2);
            if (m.getDependencyManagement() != null) {
                this.validate20RawDependencies(problems, m.getDependencyManagement().getDependencies(), "dependencyManagement.dependencies.dependency.", EMPTY, request2);
            }
            this.validateRawRepositories(problems, m.getRepositories(), "repositories.repository.", EMPTY, request2);
            this.validateRawRepositories(problems, m.getPluginRepositories(), "pluginRepositories.pluginRepository.", EMPTY, request2);
            Build build2 = m.getBuild();
            if (build2 != null) {
                this.validate20RawPlugins(problems, build2.getPlugins(), "build.plugins.plugin.", EMPTY, request2);
                PluginManagement mgmt = build2.getPluginManagement();
                if (mgmt != null) {
                    this.validate20RawPlugins(problems, mgmt.getPlugins(), "build.pluginManagement.plugins.plugin.", EMPTY, request2);
                }
            }
            HashSet<String> profileIds = new HashSet<String>();
            for (Profile profile2 : m.getProfiles()) {
                String prefix = "profiles.profile[" + profile2.getId() + "].";
                if (!profileIds.add(profile2.getId())) {
                    DefaultModelValidator.addViolation(problems, errOn30, ModelProblem.Version.V20, "profiles.profile.id", null, "must be unique but found duplicate profile with id " + profile2.getId(), profile2);
                }
                this.validate30RawProfileActivation(problems, profile2.getActivation(), profile2.getId(), prefix, "activation", request2);
                this.validate20RawDependencies(problems, profile2.getDependencies(), prefix, "dependencies.dependency.", request2);
                if (profile2.getDependencyManagement() != null) {
                    this.validate20RawDependencies(problems, profile2.getDependencyManagement().getDependencies(), prefix, "dependencyManagement.dependencies.dependency.", request2);
                }
                this.validateRawRepositories(problems, profile2.getRepositories(), prefix, "repositories.repository.", request2);
                this.validateRawRepositories(problems, profile2.getPluginRepositories(), prefix, "pluginRepositories.pluginRepository.", request2);
                BuildBase buildBase = profile2.getBuild();
                if (buildBase == null) continue;
                this.validate20RawPlugins(problems, buildBase.getPlugins(), prefix, "plugins.plugin.", request2);
                PluginManagement mgmt = buildBase.getPluginManagement();
                if (mgmt == null) continue;
                this.validate20RawPlugins(problems, mgmt.getPlugins(), prefix, "pluginManagement.plugins.plugin.", request2);
            }
        }
    }

    private void validate30RawProfileActivation(ModelProblemCollector problems, Activation activation, String sourceHint, String prefix, String fieldName, ModelBuildingRequest request2) {
        if (activation == null) {
            return;
        }
        ActivationFile file = activation.getFile();
        if (file != null) {
            boolean missing;
            String path;
            if (StringUtils.isNotEmpty(file.getExists())) {
                path = file.getExists();
                missing = false;
            } else if (StringUtils.isNotEmpty(file.getMissing())) {
                path = file.getMissing();
                missing = true;
            } else {
                return;
            }
            if (path.contains("${project.basedir}")) {
                DefaultModelValidator.addViolation(problems, ModelProblem.Severity.WARNING, ModelProblem.Version.V30, prefix + fieldName + (missing ? ".file.missing" : ".file.exists"), null, "Failed to interpolate file location " + path + " for profile " + sourceHint + ": ${project.basedir} expression not supported during profile activation, use ${basedir} instead", file.getLocation(missing ? "missing" : "exists"));
            } else if (this.hasProjectExpression(path)) {
                DefaultModelValidator.addViolation(problems, ModelProblem.Severity.WARNING, ModelProblem.Version.V30, prefix + fieldName + (missing ? ".file.missing" : ".file.exists"), null, "Failed to interpolate file location " + path + " for profile " + sourceHint + ": ${project.*} expressions are not supported during profile activation", file.getLocation(missing ? "missing" : "exists"));
            }
        }
    }

    private void validate20RawPlugins(ModelProblemCollector problems, List<Plugin> plugins, String prefix, String prefix2, ModelBuildingRequest request2) {
        ModelProblem.Severity errOn31 = DefaultModelValidator.getSeverity(request2, 31);
        HashMap<String, Plugin> index2 = new HashMap<String, Plugin>();
        for (Plugin plugin : plugins) {
            String key2;
            Plugin existing;
            if (plugin.getGroupId() == null || plugin.getGroupId() != null && plugin.getGroupId().trim().isEmpty()) {
                DefaultModelValidator.addViolation(problems, ModelProblem.Severity.FATAL, ModelProblem.Version.V20, prefix + prefix2 + "(groupId:artifactId)", null, "groupId of a plugin must be defined. ", plugin);
            }
            if (plugin.getArtifactId() == null || plugin.getArtifactId() != null && plugin.getArtifactId().trim().isEmpty()) {
                DefaultModelValidator.addViolation(problems, ModelProblem.Severity.FATAL, ModelProblem.Version.V20, prefix + prefix2 + "(groupId:artifactId)", null, "artifactId of a plugin must be defined. ", plugin);
            }
            if (plugin.getVersion() != null && plugin.getVersion().trim().isEmpty()) {
                DefaultModelValidator.addViolation(problems, ModelProblem.Severity.FATAL, ModelProblem.Version.V20, prefix + prefix2 + "(groupId:artifactId)", null, "version of a plugin must be defined. ", plugin);
            }
            if ((existing = (Plugin)index2.get(key2 = plugin.getKey())) != null) {
                DefaultModelValidator.addViolation(problems, errOn31, ModelProblem.Version.V20, prefix + prefix2 + "(groupId:artifactId)", null, "must be unique but found duplicate declaration of plugin " + key2, plugin);
            } else {
                index2.put(key2, plugin);
            }
            HashSet<String> executionIds = new HashSet<String>();
            for (PluginExecution exec : plugin.getExecutions()) {
                if (executionIds.add(exec.getId())) continue;
                DefaultModelValidator.addViolation(problems, ModelProblem.Severity.ERROR, ModelProblem.Version.V20, prefix + prefix2 + "[" + plugin.getKey() + "].executions.execution.id", null, "must be unique but found duplicate execution with id " + exec.getId(), exec);
            }
        }
    }

    @Override
    public void validateEffectiveModel(Model m, ModelBuildingRequest request2, ModelProblemCollector problems) {
        this.validateStringNotEmpty("modelVersion", problems, ModelProblem.Severity.ERROR, ModelProblem.Version.BASE, m.getModelVersion(), m);
        this.validateId("groupId", problems, m.getGroupId(), m);
        this.validateId("artifactId", problems, m.getArtifactId(), m);
        this.validateStringNotEmpty("packaging", problems, ModelProblem.Severity.ERROR, ModelProblem.Version.BASE, m.getPackaging(), m);
        if (!m.getModules().isEmpty()) {
            if (!"pom".equals(m.getPackaging())) {
                DefaultModelValidator.addViolation(problems, ModelProblem.Severity.ERROR, ModelProblem.Version.BASE, "packaging", null, "with value '" + m.getPackaging() + "' is invalid. Aggregator projects require 'pom' as packaging.", m);
            }
            int n = m.getModules().size();
            for (int i2 = 0; i2 < n; ++i2) {
                String module = m.getModules().get(i2);
                if (!StringUtils.isBlank(module)) continue;
                DefaultModelValidator.addViolation(problems, ModelProblem.Severity.ERROR, ModelProblem.Version.BASE, "modules.module[" + i2 + "]", null, "has been specified without a path to the project directory.", m.getLocation("modules"));
            }
        }
        this.validateStringNotEmpty("version", problems, ModelProblem.Severity.ERROR, ModelProblem.Version.BASE, m.getVersion(), m);
        ModelProblem.Severity errOn30 = DefaultModelValidator.getSeverity(request2, 30);
        this.validateEffectiveDependencies(problems, m, m.getDependencies(), false, request2);
        DependencyManagement mgmt = m.getDependencyManagement();
        if (mgmt != null) {
            this.validateEffectiveDependencies(problems, m, mgmt.getDependencies(), true, request2);
        }
        if (request2.getValidationLevel() >= 20) {
            Reporting reporting;
            HashSet<String> modules = new HashSet<String>();
            int n = m.getModules().size();
            for (int i3 = 0; i3 < n; ++i3) {
                String module = m.getModules().get(i3);
                if (modules.add(module)) continue;
                DefaultModelValidator.addViolation(problems, ModelProblem.Severity.ERROR, ModelProblem.Version.V20, "modules.module[" + i3 + "]", null, "specifies duplicate child module " + (String)module, m.getLocation("modules"));
            }
            ModelProblem.Severity errOn31 = DefaultModelValidator.getSeverity(request2, 31);
            this.validateBannedCharacters(EMPTY, "version", problems, errOn31, ModelProblem.Version.V20, m.getVersion(), null, m, "\\/:\"<>|?*");
            this.validate20ProperSnapshotVersion("version", problems, errOn31, ModelProblem.Version.V20, m.getVersion(), null, m);
            Build build2 = m.getBuild();
            if (build2 != null) {
                for (Plugin plugin : build2.getPlugins()) {
                    this.validateStringNotEmpty("build.plugins.plugin.artifactId", problems, ModelProblem.Severity.ERROR, ModelProblem.Version.V20, plugin.getArtifactId(), plugin);
                    this.validateStringNotEmpty("build.plugins.plugin.groupId", problems, ModelProblem.Severity.ERROR, ModelProblem.Version.V20, plugin.getGroupId(), plugin);
                    this.validate20PluginVersion("build.plugins.plugin.version", problems, plugin.getVersion(), plugin.getKey(), plugin, request2);
                    this.validateBoolean("build.plugins.plugin.inherited", EMPTY, problems, errOn30, ModelProblem.Version.V20, plugin.getInherited(), plugin.getKey(), plugin);
                    this.validateBoolean("build.plugins.plugin.extensions", EMPTY, problems, errOn30, ModelProblem.Version.V20, plugin.getExtensions(), plugin.getKey(), plugin);
                    this.validate20EffectivePluginDependencies(problems, plugin, request2);
                }
                this.validate20RawResources(problems, build2.getResources(), "build.resources.resource.", request2);
                this.validate20RawResources(problems, build2.getTestResources(), "build.testResources.testResource.", request2);
            }
            if ((reporting = m.getReporting()) != null) {
                for (ReportPlugin p3 : reporting.getPlugins()) {
                    this.validateStringNotEmpty("reporting.plugins.plugin.artifactId", problems, ModelProblem.Severity.ERROR, ModelProblem.Version.V20, p3.getArtifactId(), p3);
                    this.validateStringNotEmpty("reporting.plugins.plugin.groupId", problems, ModelProblem.Severity.ERROR, ModelProblem.Version.V20, p3.getGroupId(), p3);
                }
            }
            for (Repository repository : m.getRepositories()) {
                this.validate20EffectiveRepository(problems, repository, "repositories.repository.", request2);
            }
            for (Repository repository : m.getPluginRepositories()) {
                this.validate20EffectiveRepository(problems, repository, "pluginRepositories.pluginRepository.", request2);
            }
            DistributionManagement distributionManagement = m.getDistributionManagement();
            if (distributionManagement != null) {
                if (distributionManagement.getStatus() != null) {
                    DefaultModelValidator.addViolation(problems, ModelProblem.Severity.ERROR, ModelProblem.Version.V20, "distributionManagement.status", null, "must not be specified.", distributionManagement);
                }
                this.validate20EffectiveRepository(problems, distributionManagement.getRepository(), "distributionManagement.repository.", request2);
                this.validate20EffectiveRepository(problems, distributionManagement.getSnapshotRepository(), "distributionManagement.snapshotRepository.", request2);
            }
        }
    }

    private void validate20RawDependencies(ModelProblemCollector problems, List<Dependency> dependencies, String prefix, String prefix2, ModelBuildingRequest request2) {
        ModelProblem.Severity errOn30 = DefaultModelValidator.getSeverity(request2, 30);
        ModelProblem.Severity errOn31 = DefaultModelValidator.getSeverity(request2, 31);
        HashMap<String, Dependency> index2 = new HashMap<String, Dependency>();
        for (Dependency dependency : dependencies) {
            Dependency existing;
            String key2 = dependency.getManagementKey();
            if ("import".equals(dependency.getScope())) {
                if (!"pom".equals(dependency.getType())) {
                    DefaultModelValidator.addViolation(problems, ModelProblem.Severity.WARNING, ModelProblem.Version.V20, prefix + prefix2 + "type", key2, "must be 'pom' to import the managed dependencies.", dependency);
                } else if (StringUtils.isNotEmpty(dependency.getClassifier())) {
                    DefaultModelValidator.addViolation(problems, errOn30, ModelProblem.Version.V20, prefix + prefix2 + "classifier", key2, "must be empty, imported POM cannot have a classifier.", dependency);
                }
            } else if ("system".equals(dependency.getScope())) {
                String sysPath;
                if (request2.getValidationLevel() >= 31) {
                    DefaultModelValidator.addViolation(problems, ModelProblem.Severity.WARNING, ModelProblem.Version.V31, prefix + prefix2 + "scope", key2, "declares usage of deprecated 'system' scope ", dependency);
                }
                if (StringUtils.isNotEmpty(sysPath = dependency.getSystemPath())) {
                    if (!this.hasExpression(sysPath)) {
                        DefaultModelValidator.addViolation(problems, ModelProblem.Severity.WARNING, ModelProblem.Version.V20, prefix + prefix2 + "systemPath", key2, "should use a variable instead of a hard-coded path " + sysPath, dependency);
                    } else if (sysPath.contains("${basedir}") || sysPath.contains("${project.basedir}")) {
                        DefaultModelValidator.addViolation(problems, ModelProblem.Severity.WARNING, ModelProblem.Version.V20, prefix + prefix2 + "systemPath", key2, "should not point at files within the project directory, " + sysPath + " will be unresolvable by dependent projects", dependency);
                    }
                }
            }
            if (DefaultModelValidator.equals("LATEST", dependency.getVersion()) || DefaultModelValidator.equals("RELEASE", dependency.getVersion())) {
                DefaultModelValidator.addViolation(problems, ModelProblem.Severity.WARNING, ModelProblem.Version.BASE, prefix + prefix2 + "version", key2, "is either LATEST or RELEASE (both of them are being deprecated)", dependency);
            }
            if ((existing = (Dependency)index2.get(key2)) != null) {
                String msg = DefaultModelValidator.equals(existing.getVersion(), dependency.getVersion()) ? "duplicate declaration of version " + Objects.toString(dependency.getVersion(), "(?)") : "version " + Objects.toString(existing.getVersion(), "(?)") + " vs " + Objects.toString(dependency.getVersion(), "(?)");
                DefaultModelValidator.addViolation(problems, errOn31, ModelProblem.Version.V20, prefix + prefix2 + "(groupId:artifactId:type:classifier)", null, "must be unique: " + key2 + " -> " + msg, dependency);
                continue;
            }
            index2.put(key2, dependency);
        }
    }

    private void validate20RawDependenciesSelfReferencing(ModelProblemCollector problems, Model m, List<Dependency> dependencies, String prefix, ModelBuildingRequest request2) {
        for (Dependency dependency : dependencies) {
            String mKey;
            String key2 = dependency.getGroupId() + ":" + dependency.getArtifactId() + ":" + dependency.getVersion() + (dependency.getClassifier() != null ? ":" + dependency.getClassifier() : EMPTY);
            if (!key2.equals(mKey = m.getGroupId() + ":" + m.getArtifactId() + ":" + m.getVersion())) continue;
            DefaultModelValidator.addViolation(problems, ModelProblem.Severity.FATAL, ModelProblem.Version.V31, prefix + "[" + key2 + "]", key2, "is referencing itself.", dependency);
        }
    }

    private void validateEffectiveDependencies(ModelProblemCollector problems, Model m, List<Dependency> dependencies, boolean management, ModelBuildingRequest request2) {
        ModelProblem.Severity errOn30 = DefaultModelValidator.getSeverity(request2, 30);
        String prefix = management ? "dependencyManagement.dependencies.dependency." : "dependencies.dependency.";
        for (Dependency d2 : dependencies) {
            this.validateEffectiveDependency(problems, d2, management, prefix, request2);
            if (request2.getValidationLevel() < 20) continue;
            this.validateBoolean(prefix, "optional", problems, errOn30, ModelProblem.Version.V20, d2.getOptional(), d2.getManagementKey(), d2);
            if (!management) {
                this.validateVersion(prefix, "version", problems, errOn30, ModelProblem.Version.V20, d2.getVersion(), d2.getManagementKey(), d2);
                this.validateEnum(prefix, "scope", problems, ModelProblem.Severity.WARNING, ModelProblem.Version.V20, d2.getScope(), d2.getManagementKey(), d2, "provided", "compile", "runtime", "test", "system");
                this.validateEffectiveModelAgainstDependency(prefix, problems, m, d2, request2);
                continue;
            }
            this.validateEnum(prefix, "scope", problems, ModelProblem.Severity.WARNING, ModelProblem.Version.V20, d2.getScope(), d2.getManagementKey(), d2, "provided", "compile", "runtime", "test", "system", "import");
        }
    }

    private void validateEffectiveModelAgainstDependency(String prefix, ModelProblemCollector problems, Model m, Dependency d2, ModelBuildingRequest request2) {
        String mKey;
        String key2 = d2.getGroupId() + ":" + d2.getArtifactId() + ":" + d2.getVersion() + (d2.getClassifier() != null ? ":" + d2.getClassifier() : EMPTY);
        if (key2.equals(mKey = m.getGroupId() + ":" + m.getArtifactId() + ":" + m.getVersion())) {
            DefaultModelValidator.addViolation(problems, ModelProblem.Severity.FATAL, ModelProblem.Version.V31, prefix + "[" + key2 + "]", key2, "is referencing itself.", d2);
        }
    }

    private void validate20EffectivePluginDependencies(ModelProblemCollector problems, Plugin plugin, ModelBuildingRequest request2) {
        List<Dependency> dependencies = plugin.getDependencies();
        if (!dependencies.isEmpty()) {
            String prefix = "build.plugins.plugin[" + plugin.getKey() + "].dependencies.dependency.";
            ModelProblem.Severity errOn30 = DefaultModelValidator.getSeverity(request2, 30);
            for (Dependency d2 : dependencies) {
                this.validateEffectiveDependency(problems, d2, false, prefix, request2);
                this.validateVersion(prefix, "version", problems, errOn30, ModelProblem.Version.BASE, d2.getVersion(), d2.getManagementKey(), d2);
                this.validateEnum(prefix, "scope", problems, errOn30, ModelProblem.Version.BASE, d2.getScope(), d2.getManagementKey(), d2, "compile", "runtime", "system");
            }
        }
    }

    private void validateEffectiveDependency(ModelProblemCollector problems, Dependency d2, boolean management, String prefix, ModelBuildingRequest request2) {
        this.validateId(prefix, "artifactId", problems, ModelProblem.Severity.ERROR, ModelProblem.Version.BASE, d2.getArtifactId(), d2.getManagementKey(), d2);
        this.validateId(prefix, "groupId", problems, ModelProblem.Severity.ERROR, ModelProblem.Version.BASE, d2.getGroupId(), d2.getManagementKey(), d2);
        if (!management) {
            this.validateStringNotEmpty(prefix, "type", problems, ModelProblem.Severity.ERROR, ModelProblem.Version.BASE, d2.getType(), d2.getManagementKey(), d2);
            this.validateDependencyVersion(problems, d2, prefix);
        }
        if ("system".equals(d2.getScope())) {
            String systemPath = d2.getSystemPath();
            if (StringUtils.isEmpty(systemPath)) {
                DefaultModelValidator.addViolation(problems, ModelProblem.Severity.ERROR, ModelProblem.Version.BASE, prefix + "systemPath", d2.getManagementKey(), "is missing.", d2);
            } else {
                File sysFile = new File(systemPath);
                if (!sysFile.isAbsolute()) {
                    DefaultModelValidator.addViolation(problems, ModelProblem.Severity.ERROR, ModelProblem.Version.BASE, prefix + "systemPath", d2.getManagementKey(), "must specify an absolute path but is " + systemPath, d2);
                } else if (!sysFile.isFile()) {
                    String jdkHome;
                    String msg = "refers to a non-existing file " + sysFile.getAbsolutePath();
                    if ((systemPath = systemPath.replace('/', File.separatorChar).replace('\\', File.separatorChar)).startsWith(jdkHome = request2.getSystemProperties().getProperty("java.home", EMPTY) + File.separator + "..")) {
                        msg = msg + ". Please verify that you run Maven using a JDK and not just a JRE.";
                    }
                    DefaultModelValidator.addViolation(problems, ModelProblem.Severity.WARNING, ModelProblem.Version.BASE, prefix + "systemPath", d2.getManagementKey(), msg, d2);
                }
            }
        } else if (StringUtils.isNotEmpty(d2.getSystemPath())) {
            DefaultModelValidator.addViolation(problems, ModelProblem.Severity.ERROR, ModelProblem.Version.BASE, prefix + "systemPath", d2.getManagementKey(), "must be omitted. This field may only be specified for a dependency with system scope.", d2);
        }
        if (request2.getValidationLevel() >= 20) {
            for (Exclusion exclusion : d2.getExclusions()) {
                if (request2.getValidationLevel() < 30) {
                    this.validateId(prefix, "exclusions.exclusion.groupId", problems, ModelProblem.Severity.WARNING, ModelProblem.Version.V20, exclusion.getGroupId(), d2.getManagementKey(), exclusion);
                    this.validateId(prefix, "exclusions.exclusion.artifactId", problems, ModelProblem.Severity.WARNING, ModelProblem.Version.V20, exclusion.getArtifactId(), d2.getManagementKey(), exclusion);
                    continue;
                }
                this.validateIdWithWildcards(prefix, "exclusions.exclusion.groupId", problems, ModelProblem.Severity.WARNING, ModelProblem.Version.V30, exclusion.getGroupId(), d2.getManagementKey(), exclusion);
                this.validateIdWithWildcards(prefix, "exclusions.exclusion.artifactId", problems, ModelProblem.Severity.WARNING, ModelProblem.Version.V30, exclusion.getArtifactId(), d2.getManagementKey(), exclusion);
            }
        }
    }

    protected void validateDependencyVersion(ModelProblemCollector problems, Dependency d2, String prefix) {
        this.validateStringNotEmpty(prefix, "version", problems, ModelProblem.Severity.ERROR, ModelProblem.Version.BASE, d2.getVersion(), d2.getManagementKey(), d2);
    }

    private void validateRawRepositories(ModelProblemCollector problems, List<Repository> repositories, String prefix, String prefix2, ModelBuildingRequest request2) {
        HashMap<String, Repository> index2 = new HashMap<String, Repository>();
        for (Repository repository : repositories) {
            this.validateStringNotEmpty(prefix, prefix2, "id", problems, ModelProblem.Severity.ERROR, ModelProblem.Version.V20, repository.getId(), null, repository);
            this.validateStringNotEmpty(prefix, prefix2, "[" + repository.getId() + "].url", problems, ModelProblem.Severity.ERROR, ModelProblem.Version.V20, repository.getUrl(), null, repository);
            String key2 = repository.getId();
            Repository existing = (Repository)index2.get(key2);
            if (existing != null) {
                ModelProblem.Severity errOn30 = DefaultModelValidator.getSeverity(request2, 30);
                DefaultModelValidator.addViolation(problems, errOn30, ModelProblem.Version.V20, prefix + prefix2 + "id", null, "must be unique: " + repository.getId() + " -> " + existing.getUrl() + " vs " + repository.getUrl(), repository);
                continue;
            }
            index2.put(key2, repository);
        }
    }

    private void validate20EffectiveRepository(ModelProblemCollector problems, Repository repository, String prefix, ModelBuildingRequest request2) {
        if (repository != null) {
            ModelProblem.Severity errOn31 = DefaultModelValidator.getSeverity(request2, 31);
            this.validateBannedCharacters(prefix, "id", problems, errOn31, ModelProblem.Version.V20, repository.getId(), null, repository, "\\/:\"<>|?*");
            if ("local".equals(repository.getId())) {
                DefaultModelValidator.addViolation(problems, errOn31, ModelProblem.Version.V20, prefix + "id", null, "must not be 'local', this identifier is reserved for the local repository, using it for other repositories will corrupt your repository metadata.", repository);
            }
            if ("legacy".equals(repository.getLayout())) {
                DefaultModelValidator.addViolation(problems, ModelProblem.Severity.WARNING, ModelProblem.Version.V20, prefix + "layout", repository.getId(), "uses the unsupported value 'legacy', artifact resolution might fail.", repository);
            }
        }
    }

    private void validate20RawResources(ModelProblemCollector problems, List<Resource> resources, String prefix, ModelBuildingRequest request2) {
        ModelProblem.Severity errOn30 = DefaultModelValidator.getSeverity(request2, 30);
        for (Resource resource : resources) {
            this.validateStringNotEmpty(prefix, "directory", problems, ModelProblem.Severity.ERROR, ModelProblem.Version.V20, resource.getDirectory(), null, resource);
            this.validateBoolean(prefix, "filtering", problems, errOn30, ModelProblem.Version.V20, resource.getFiltering(), resource.getDirectory(), resource);
        }
    }

    private boolean validateId(String fieldName, ModelProblemCollector problems, String id, InputLocationTracker tracker) {
        return this.validateId(EMPTY, fieldName, problems, ModelProblem.Severity.ERROR, ModelProblem.Version.BASE, id, null, tracker);
    }

    private boolean validateId(String prefix, String fieldName, ModelProblemCollector problems, ModelProblem.Severity severity, ModelProblem.Version version, String id, String sourceHint, InputLocationTracker tracker) {
        if (this.validIds.contains(id)) {
            return true;
        }
        if (!this.validateStringNotEmpty(prefix, fieldName, problems, severity, version, id, sourceHint, tracker)) {
            return false;
        }
        if (!this.isValidId(id)) {
            DefaultModelValidator.addViolation(problems, severity, version, prefix + fieldName, sourceHint, "with value '" + id + "' does not match a valid id pattern.", tracker);
            return false;
        }
        this.validIds.add(id);
        return true;
    }

    private boolean isValidId(String id) {
        for (int i2 = 0; i2 < id.length(); ++i2) {
            char c2 = id.charAt(i2);
            if (this.isValidIdCharacter(c2)) continue;
            return false;
        }
        return true;
    }

    private boolean isValidIdCharacter(char c2) {
        return c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 >= '0' && c2 <= '9' || c2 == '-' || c2 == '_' || c2 == '.';
    }

    private boolean validateIdWithWildcards(String prefix, String fieldName, ModelProblemCollector problems, ModelProblem.Severity severity, ModelProblem.Version version, String id, String sourceHint, InputLocationTracker tracker) {
        if (!this.validateStringNotEmpty(prefix, fieldName, problems, severity, version, id, sourceHint, tracker)) {
            return false;
        }
        if (!this.isValidIdWithWildCards(id)) {
            DefaultModelValidator.addViolation(problems, severity, version, prefix + fieldName, sourceHint, "with value '" + id + "' does not match a valid id pattern.", tracker);
            return false;
        }
        return true;
    }

    private boolean isValidIdWithWildCards(String id) {
        for (int i2 = 0; i2 < id.length(); ++i2) {
            char c2 = id.charAt(i2);
            if (this.isValidIdWithWildCardCharacter(c2)) continue;
            return false;
        }
        return true;
    }

    private boolean isValidIdWithWildCardCharacter(char c2) {
        return this.isValidIdCharacter(c2) || c2 == '?' || c2 == '*';
    }

    private boolean validateStringNoExpression(String fieldName, ModelProblemCollector problems, ModelProblem.Severity severity, ModelProblem.Version version, String string, InputLocationTracker tracker) {
        if (!this.hasExpression(string)) {
            return true;
        }
        DefaultModelValidator.addViolation(problems, severity, version, fieldName, null, "contains an expression but should be a constant.", tracker);
        return false;
    }

    private boolean validateVersionNoExpression(String fieldName, ModelProblemCollector problems, ModelProblem.Severity severity, ModelProblem.Version version, String string, InputLocationTracker tracker) {
        if (!this.hasExpression(string)) {
            return true;
        }
        Matcher m = CI_FRIENDLY_EXPRESSION.matcher(string.trim());
        while (m.find()) {
            String property = m.group(1);
            if (this.versionProcessor.isValidProperty(property)) continue;
            DefaultModelValidator.addViolation(problems, severity, version, fieldName, null, "contains an expression but should be a constant.", tracker);
            return false;
        }
        return true;
    }

    private boolean hasExpression(String value2) {
        return value2 != null && value2.contains("${");
    }

    private boolean hasProjectExpression(String value2) {
        return value2 != null && value2.contains("${project.");
    }

    private boolean validateStringNotEmpty(String fieldName, ModelProblemCollector problems, ModelProblem.Severity severity, ModelProblem.Version version, String string, InputLocationTracker tracker) {
        return this.validateStringNotEmpty(EMPTY, fieldName, problems, severity, version, string, null, tracker);
    }

    private boolean validateStringNotEmpty(String prefix, String prefix2, String fieldName, ModelProblemCollector problems, ModelProblem.Severity severity, ModelProblem.Version version, String string, String sourceHint, InputLocationTracker tracker) {
        if (!this.validateNotNull(prefix, prefix2, fieldName, problems, severity, version, string, sourceHint, tracker)) {
            return false;
        }
        if (!string.isEmpty()) {
            return true;
        }
        DefaultModelValidator.addViolation(problems, severity, version, prefix + prefix2 + fieldName, sourceHint, "is missing.", tracker);
        return false;
    }

    private boolean validateStringNotEmpty(String prefix, String fieldName, ModelProblemCollector problems, ModelProblem.Severity severity, ModelProblem.Version version, String string, String sourceHint, InputLocationTracker tracker) {
        if (!this.validateNotNull(prefix, fieldName, problems, severity, version, string, sourceHint, tracker)) {
            return false;
        }
        if (string.length() > 0) {
            return true;
        }
        DefaultModelValidator.addViolation(problems, severity, version, prefix + fieldName, sourceHint, "is missing.", tracker);
        return false;
    }

    private boolean validateNotNull(String prefix, String fieldName, ModelProblemCollector problems, ModelProblem.Severity severity, ModelProblem.Version version, Object object, String sourceHint, InputLocationTracker tracker) {
        if (object != null) {
            return true;
        }
        DefaultModelValidator.addViolation(problems, severity, version, prefix + fieldName, sourceHint, "is missing.", tracker);
        return false;
    }

    private boolean validateNotNull(String prefix, String prefix2, String fieldName, ModelProblemCollector problems, ModelProblem.Severity severity, ModelProblem.Version version, Object object, String sourceHint, InputLocationTracker tracker) {
        if (object != null) {
            return true;
        }
        DefaultModelValidator.addViolation(problems, severity, version, prefix + prefix2 + fieldName, sourceHint, "is missing.", tracker);
        return false;
    }

    private boolean validateBoolean(String prefix, String fieldName, ModelProblemCollector problems, ModelProblem.Severity severity, ModelProblem.Version version, String string, String sourceHint, InputLocationTracker tracker) {
        if (string == null || string.length() <= 0) {
            return true;
        }
        if ("true".equalsIgnoreCase(string) || "false".equalsIgnoreCase(string)) {
            return true;
        }
        DefaultModelValidator.addViolation(problems, severity, version, prefix + fieldName, sourceHint, "must be 'true' or 'false' but is '" + string + "'.", tracker);
        return false;
    }

    private boolean validateEnum(String prefix, String fieldName, ModelProblemCollector problems, ModelProblem.Severity severity, ModelProblem.Version version, String string, String sourceHint, InputLocationTracker tracker, String ... validValues) {
        if (string == null || string.length() <= 0) {
            return true;
        }
        List<String> values2 = Arrays.asList(validValues);
        if (values2.contains(string)) {
            return true;
        }
        DefaultModelValidator.addViolation(problems, severity, version, prefix + fieldName, sourceHint, "must be one of " + values2 + " but is '" + string + "'.", tracker);
        return false;
    }

    private boolean validateModelVersion(ModelProblemCollector problems, String string, InputLocationTracker tracker, String ... validVersions) {
        if (string == null || string.length() <= 0) {
            return true;
        }
        List<String> values2 = Arrays.asList(validVersions);
        if (values2.contains(string)) {
            return true;
        }
        boolean newerThanAll = true;
        boolean olderThanAll = true;
        for (String validValue : validVersions) {
            int comparison = DefaultModelValidator.compareModelVersions(validValue, string);
            newerThanAll = newerThanAll && comparison < 0;
            olderThanAll = olderThanAll && comparison > 0;
        }
        if (newerThanAll) {
            DefaultModelValidator.addViolation(problems, ModelProblem.Severity.FATAL, ModelProblem.Version.V20, "modelVersion", null, "of '" + string + "' is newer than the versions supported by this version of Maven: " + values2 + ". Building this project requires a newer version of Maven.", tracker);
        } else if (olderThanAll) {
            DefaultModelValidator.addViolation(problems, ModelProblem.Severity.FATAL, ModelProblem.Version.V20, "modelVersion", null, "of '" + string + "' is older than the versions supported by this version of Maven: " + values2 + ". Building this project requires an older version of Maven.", tracker);
        } else {
            DefaultModelValidator.addViolation(problems, ModelProblem.Severity.ERROR, ModelProblem.Version.V20, "modelVersion", null, "must be one of " + values2 + " but is '" + string + "'.", tracker);
        }
        return false;
    }

    private static int compareModelVersions(String first2, String second) {
        String[] firstSegments = StringUtils.split(first2, ".");
        String[] secondSegments = StringUtils.split(second, ".");
        for (int i2 = 0; i2 < Math.min(firstSegments.length, secondSegments.length); ++i2) {
            int result2 = Long.valueOf(firstSegments[i2]).compareTo(Long.valueOf(secondSegments[i2]));
            if (result2 == 0) continue;
            return result2;
        }
        if (firstSegments.length == secondSegments.length) {
            return 0;
        }
        return firstSegments.length > secondSegments.length ? -1 : 1;
    }

    private boolean validateBannedCharacters(String prefix, String fieldName, ModelProblemCollector problems, ModelProblem.Severity severity, ModelProblem.Version version, String string, String sourceHint, InputLocationTracker tracker, String banned) {
        if (string != null) {
            for (int i2 = string.length() - 1; i2 >= 0; --i2) {
                if (banned.indexOf(string.charAt(i2)) < 0) continue;
                DefaultModelValidator.addViolation(problems, severity, version, prefix + fieldName, sourceHint, "must not contain any of these characters " + banned + " but found " + string.charAt(i2), tracker);
                return false;
            }
        }
        return true;
    }

    private boolean validateVersion(String prefix, String fieldName, ModelProblemCollector problems, ModelProblem.Severity severity, ModelProblem.Version version, String string, String sourceHint, InputLocationTracker tracker) {
        if (string == null || string.length() <= 0) {
            return true;
        }
        if (this.hasExpression(string)) {
            DefaultModelValidator.addViolation(problems, severity, version, prefix + fieldName, sourceHint, "must be a valid version but is '" + string + "'.", tracker);
            return false;
        }
        return this.validateBannedCharacters(prefix, fieldName, problems, severity, version, string, sourceHint, tracker, "\\/:\"<>|?*");
    }

    private boolean validate20ProperSnapshotVersion(String fieldName, ModelProblemCollector problems, ModelProblem.Severity severity, ModelProblem.Version version, String string, String sourceHint, InputLocationTracker tracker) {
        if (string == null || string.length() <= 0) {
            return true;
        }
        if (string.endsWith("SNAPSHOT") && !string.endsWith("-SNAPSHOT")) {
            DefaultModelValidator.addViolation(problems, severity, version, fieldName, sourceHint, "uses an unsupported snapshot version format, should be '*-SNAPSHOT' instead.", tracker);
            return false;
        }
        return true;
    }

    private boolean validate20PluginVersion(String fieldName, ModelProblemCollector problems, String string, String sourceHint, InputLocationTracker tracker, ModelBuildingRequest request2) {
        if (string == null) {
            return true;
        }
        ModelProblem.Severity errOn30 = DefaultModelValidator.getSeverity(request2, 30);
        if (!this.validateVersion(EMPTY, fieldName, problems, errOn30, ModelProblem.Version.V20, string, sourceHint, tracker)) {
            return false;
        }
        if (string.length() <= 0 || "RELEASE".equals(string) || "LATEST".equals(string)) {
            DefaultModelValidator.addViolation(problems, errOn30, ModelProblem.Version.V20, fieldName, sourceHint, "must be a valid version but is '" + string + "'.", tracker);
            return false;
        }
        return true;
    }

    private static void addViolation(ModelProblemCollector problems, ModelProblem.Severity severity, ModelProblem.Version version, String fieldName, String sourceHint, String message2, InputLocationTracker tracker) {
        StringBuilder buffer = new StringBuilder(256);
        buffer.append('\'').append(fieldName).append('\'');
        if (sourceHint != null) {
            buffer.append(" for ").append(sourceHint);
        }
        buffer.append(' ').append(message2);
        problems.add(new ModelProblemCollectorRequest(severity, version).setMessage(buffer.toString()).setLocation(DefaultModelValidator.getLocation(fieldName, tracker)));
    }

    private static InputLocation getLocation(String fieldName, InputLocationTracker tracker) {
        InputLocation location = null;
        if (tracker != null) {
            if (fieldName != null) {
                Object key2 = fieldName;
                int idx = fieldName.lastIndexOf(46);
                if (idx >= 0) {
                    fieldName = fieldName.substring(idx + 1);
                    key2 = fieldName;
                }
                if (fieldName.endsWith("]")) {
                    key2 = fieldName.substring(fieldName.lastIndexOf(91) + 1, fieldName.length() - 1);
                    try {
                        key2 = Integer.valueOf(key2.toString());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                location = tracker.getLocation(key2);
            }
            if (location == null) {
                location = tracker.getLocation(EMPTY);
            }
        }
        return location;
    }

    private static boolean equals(String s1, String s2) {
        return StringUtils.clean(s1).equals(StringUtils.clean(s2));
    }

    private static ModelProblem.Severity getSeverity(ModelBuildingRequest request2, int errorThreshold) {
        return DefaultModelValidator.getSeverity(request2.getValidationLevel(), errorThreshold);
    }

    private static ModelProblem.Severity getSeverity(int validationLevel, int errorThreshold) {
        if (validationLevel < errorThreshold) {
            return ModelProblem.Severity.WARNING;
        }
        return ModelProblem.Severity.ERROR;
    }
}

