/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.path;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.Scm;
import org.apache.maven.model.Site;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.path.ModelUrlNormalizer;
import org.apache.maven.model.path.UrlNormalizer;

@Named
@Singleton
public class DefaultModelUrlNormalizer
implements ModelUrlNormalizer {
    @Inject
    private UrlNormalizer urlNormalizer;

    public DefaultModelUrlNormalizer setUrlNormalizer(UrlNormalizer urlNormalizer) {
        this.urlNormalizer = urlNormalizer;
        return this;
    }

    @Override
    public void normalize(Model model2, ModelBuildingRequest request2) {
        Site site;
        DistributionManagement dist;
        if (model2 == null) {
            return;
        }
        model2.setUrl(this.normalize(model2.getUrl()));
        Scm scm = model2.getScm();
        if (scm != null) {
            scm.setUrl(this.normalize(scm.getUrl()));
            scm.setConnection(this.normalize(scm.getConnection()));
            scm.setDeveloperConnection(this.normalize(scm.getDeveloperConnection()));
        }
        if ((dist = model2.getDistributionManagement()) != null && (site = dist.getSite()) != null) {
            site.setUrl(this.normalize(site.getUrl()));
        }
    }

    private String normalize(String url) {
        return this.urlNormalizer.normalize(url);
    }
}

