/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.persistence;

import com.thoughtworks.xstream.persistence.PersistenceStrategy;
import com.thoughtworks.xstream.persistence.XmlMap;
import java.util.AbstractList;

public class XmlArrayList
extends AbstractList {
    private final XmlMap map;

    public XmlArrayList(PersistenceStrategy persistenceStrategy) {
        this.map = new XmlMap(persistenceStrategy);
    }

    public int size() {
        return this.map.size();
    }

    public Object set(int index2, Object element2) {
        this.rangeCheck(index2);
        Object value2 = this.get(index2);
        this.map.put(new Integer(index2), element2);
        return value2;
    }

    public void add(int index2, Object element2) {
        int size = this.size();
        if (index2 >= size + 1 || index2 < 0) {
            throw new IndexOutOfBoundsException("Index: " + index2 + ", Size: " + size);
        }
        int to = index2 != size ? index2 - 1 : index2;
        for (int i2 = size; i2 > to; --i2) {
            this.map.put(new Integer(i2 + 1), this.map.get(new Integer(i2)));
        }
        this.map.put(new Integer(index2), element2);
    }

    private void rangeCheck(int index2) {
        int size = this.size();
        if (index2 >= size || index2 < 0) {
            throw new IndexOutOfBoundsException("Index: " + index2 + ", Size: " + size);
        }
    }

    public Object get(int index2) {
        this.rangeCheck(index2);
        return this.map.get(new Integer(index2));
    }

    public Object remove(int index2) {
        int size = this.size();
        this.rangeCheck(index2);
        Object value2 = this.map.get(new Integer(index2));
        for (int i2 = index2; i2 < size - 1; ++i2) {
            this.map.put(new Integer(i2), this.map.get(new Integer(i2 + 1)));
        }
        this.map.remove(new Integer(size - 1));
        return value2;
    }
}

