/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.time;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;

public class LocalDateTimeConverter
implements SingleValueConverter {
    private static final DateTimeFormatter FORMATTER = new DateTimeFormatterBuilder().appendPattern("uuuu-MM-dd'T'HH:mm:ss").appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).toFormatter();

    @Override
    public boolean canConvert(Class type2) {
        return LocalDateTime.class == type2;
    }

    @Override
    public Object fromString(String str) {
        try {
            return LocalDateTime.parse(str);
        }
        catch (DateTimeParseException e2) {
            ConversionException exception = new ConversionException("Cannot parse value as local date time", e2);
            exception.add("value", str);
            throw exception;
        }
    }

    @Override
    public String toString(Object obj2) {
        if (obj2 == null) {
            return null;
        }
        LocalDateTime localDateTime = (LocalDateTime)obj2;
        return FORMATTER.format(localDateTime);
    }
}

