/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.reflection;

import com.thoughtworks.xstream.converters.reflection.FieldDictionary;
import com.thoughtworks.xstream.converters.reflection.ObjectAccessException;
import com.thoughtworks.xstream.converters.reflection.SunLimitedUnsafeReflectionProvider;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.WeakHashMap;

public class SunUnsafeReflectionProvider
extends SunLimitedUnsafeReflectionProvider {
    private transient Map fieldOffsetCache;

    public SunUnsafeReflectionProvider() {
    }

    public SunUnsafeReflectionProvider(FieldDictionary dic) {
        super(dic);
    }

    public void writeField(Object object, String fieldName, Object value2, Class definedIn) {
        this.write(this.fieldDictionary.field(object.getClass(), fieldName, definedIn), object, value2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void write(Field field, Object object, Object value2) {
        if (exception != null) {
            ObjectAccessException ex = new ObjectAccessException("Cannot set field", exception);
            ex.add("field", object.getClass() + "." + field.getName());
            throw ex;
        }
        try {
            long offset = this.getFieldOffset(field);
            Class<?> type2 = field.getType();
            if (!type2.isPrimitive()) {
                unsafe.putObject(object, offset, value2);
                return;
            }
            if (type2.equals(Integer.TYPE)) {
                unsafe.putInt(object, offset, (Integer)value2);
                return;
            }
            if (type2.equals(Long.TYPE)) {
                unsafe.putLong(object, offset, (Long)value2);
                return;
            }
            if (type2.equals(Short.TYPE)) {
                unsafe.putShort(object, offset, (Short)value2);
                return;
            }
            if (type2.equals(Character.TYPE)) {
                unsafe.putChar(object, offset, ((Character)value2).charValue());
                return;
            }
            if (type2.equals(Byte.TYPE)) {
                unsafe.putByte(object, offset, (Byte)value2);
                return;
            }
            if (type2.equals(Float.TYPE)) {
                unsafe.putFloat(object, offset, ((Float)value2).floatValue());
                return;
            }
            if (type2.equals(Double.TYPE)) {
                unsafe.putDouble(object, offset, (Double)value2);
                return;
            }
            if (type2.equals(Boolean.TYPE)) {
                unsafe.putBoolean(object, offset, (Boolean)value2);
                return;
            }
            ObjectAccessException ex = new ObjectAccessException("Cannot set field of unknown type", exception);
            ex.add("field", object.getClass() + "." + field.getName());
            ex.add("unknown-type", type2.getName());
            throw ex;
        }
        catch (IllegalArgumentException e2) {
            ObjectAccessException ex = new ObjectAccessException("Cannot set field", e2);
            ex.add("field", object.getClass() + "." + field.getName());
            throw ex;
        }
    }

    private synchronized long getFieldOffset(Field f) {
        Long l = (Long)this.fieldOffsetCache.get(f);
        if (l == null) {
            l = new Long(unsafe.objectFieldOffset(f));
            this.fieldOffsetCache.put(f, l);
        }
        return l;
    }

    private Object readResolve() {
        this.init();
        return this;
    }

    protected void init() {
        super.init();
        this.fieldOffsetCache = new WeakHashMap();
    }
}

