/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.extended;

import com.thoughtworks.xstream.core.util.Fields;
import java.lang.reflect.Field;

public class StackTraceElementFactory {
    public StackTraceElement nativeMethodElement(String declaringClass, String methodName) {
        return this.create(declaringClass, methodName, "Native Method", -2);
    }

    public StackTraceElement unknownSourceElement(String declaringClass, String methodName) {
        return this.create(declaringClass, methodName, "Unknown Source", -1);
    }

    public StackTraceElement element(String declaringClass, String methodName, String fileName) {
        return this.create(declaringClass, methodName, fileName, -1);
    }

    public StackTraceElement element(String declaringClass, String methodName, String fileName, int lineNumber) {
        return this.create(declaringClass, methodName, fileName, lineNumber);
    }

    protected StackTraceElement create(String declaringClass, String methodName, String fileName, int lineNumber) {
        StackTraceElement result2 = new Throwable().getStackTrace()[0];
        this.setField(result2, "declaringClass", declaringClass);
        this.setField(result2, "methodName", methodName);
        this.setField(result2, "fileName", fileName);
        this.setField(result2, "lineNumber", new Integer(lineNumber));
        return result2;
    }

    private void setField(StackTraceElement element2, String fieldName, Object value2) {
        Field field = Fields.find(StackTraceElement.class, fieldName);
        Fields.write(field, element2, value2);
    }
}

