/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.extended;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.extended.TextAttributeConverter;
import com.thoughtworks.xstream.core.JVM;
import com.thoughtworks.xstream.io.ExtendedHierarchicalStreamWriterHelper;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.awt.Font;
import java.awt.font.TextAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.plaf.FontUIResource;

public class FontConverter
implements Converter {
    private final SingleValueConverter textAttributeConverter;
    private final Mapper mapper;
    static /* synthetic */ Class class$com$thoughtworks$xstream$mapper$Mapper$Null;

    public FontConverter() {
        this(null);
    }

    public FontConverter(Mapper mapper) {
        this.mapper = mapper;
        this.textAttributeConverter = mapper == null ? null : new TextAttributeConverter();
    }

    public boolean canConvert(Class type2) {
        return type2 != null && (type2.getName().equals("java.awt.Font") || type2.getName().equals("javax.swing.plaf.FontUIResource"));
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        Font font2 = (Font)source;
        Map<TextAttribute, ?> attributes2 = font2.getAttributes();
        if (this.mapper != null) {
            String classAlias = this.mapper.aliasForSystemAttribute("class");
            Iterator<Map.Entry<TextAttribute, ?>> iter = attributes2.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<TextAttribute, ?> entry = iter.next();
                String name2 = this.textAttributeConverter.toString(entry.getKey());
                Object value2 = entry.getValue();
                Class type2 = value2 != null ? value2.getClass() : (class$com$thoughtworks$xstream$mapper$Mapper$Null == null ? FontConverter.class$("com.thoughtworks.xstream.mapper.Mapper$Null") : class$com$thoughtworks$xstream$mapper$Mapper$Null);
                ExtendedHierarchicalStreamWriterHelper.startNode(writer, name2, type2);
                writer.addAttribute(classAlias, this.mapper.serializedClass(type2));
                if (value2 != null) {
                    context.convertAnother(value2);
                }
                writer.endNode();
            }
        } else {
            writer.startNode("attributes");
            context.convertAnother(attributes2);
            writer.endNode();
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        HashMap<TextAttribute, Object> attributes2;
        if (reader.hasMoreChildren()) {
            reader.moveDown();
            if (!reader.getNodeName().equals("attributes")) {
                String classAlias = this.mapper.aliasForSystemAttribute("class");
                attributes2 = new HashMap<TextAttribute, Object>();
                do {
                    if (!attributes2.isEmpty()) {
                        reader.moveDown();
                    }
                    Class type2 = this.mapper.realClass(reader.getAttribute(classAlias));
                    TextAttribute attribute = (TextAttribute)this.textAttributeConverter.fromString(reader.getNodeName());
                    Object value2 = type2 == (class$com$thoughtworks$xstream$mapper$Mapper$Null == null ? FontConverter.class$("com.thoughtworks.xstream.mapper.Mapper$Null") : class$com$thoughtworks$xstream$mapper$Mapper$Null) ? null : context.convertAnother(null, type2);
                    attributes2.put(attribute, value2);
                    reader.moveUp();
                } while (reader.hasMoreChildren());
            } else {
                attributes2 = (Map)context.convertAnother(null, Map.class);
                reader.moveUp();
            }
        } else {
            attributes2 = Collections.EMPTY_MAP;
        }
        if (!JVM.isVersion(6)) {
            Iterator iter = attributes2.values().iterator();
            while (iter.hasNext()) {
                if (iter.next() != null) continue;
                iter.remove();
            }
        }
        Font font2 = Font.getFont(attributes2);
        if (context.getRequiredType() == FontUIResource.class) {
            return new FontUIResource(font2);
        }
        return font2;
    }
}

