/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.collections;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.collections.AbstractCollectionConverter;
import com.thoughtworks.xstream.core.SecurityUtils;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Vector;

public class CollectionConverter
extends AbstractCollectionConverter {
    private final Class type;

    public CollectionConverter(Mapper mapper) {
        this(mapper, null);
    }

    public CollectionConverter(Mapper mapper, Class type2) {
        super(mapper);
        this.type = type2;
        if (type2 != null && !Collection.class.isAssignableFrom(type2)) {
            throw new IllegalArgumentException(type2 + " not of type " + Collection.class);
        }
    }

    public boolean canConvert(Class type2) {
        if (this.type != null) {
            return type2.equals(this.type);
        }
        return type2.equals(ArrayList.class) || type2.equals(HashSet.class) || type2.equals(LinkedList.class) || type2.equals(Vector.class) || type2.equals(LinkedHashSet.class);
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        Collection collection2 = (Collection)source;
        Iterator iterator = collection2.iterator();
        while (iterator.hasNext()) {
            Object item = iterator.next();
            this.writeCompleteItem(item, context, writer);
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Collection collection2 = (Collection)this.createCollection(context.getRequiredType());
        this.populateCollection(reader, context, collection2);
        return collection2;
    }

    protected void populateCollection(HierarchicalStreamReader reader, UnmarshallingContext context, Collection collection2) {
        this.populateCollection(reader, context, collection2, collection2);
    }

    protected void populateCollection(HierarchicalStreamReader reader, UnmarshallingContext context, Collection collection2, Collection target2) {
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            this.addCurrentElementToCollection(reader, context, collection2, target2);
            reader.moveUp();
        }
    }

    protected void addCurrentElementToCollection(HierarchicalStreamReader reader, UnmarshallingContext context, Collection collection2, Collection target2) {
        Object item = this.readItem(reader, context, collection2);
        long now = System.currentTimeMillis();
        target2.add(item);
        SecurityUtils.checkForCollectionDoSAttack(context, now);
    }

    protected Object createCollection(Class type2) {
        return super.createCollection(this.type != null ? this.type : type2);
    }
}

