/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream;

import com.thoughtworks.xstream.MarshallingStrategy;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.ConverterLookup;
import com.thoughtworks.xstream.converters.ConverterMatcher;
import com.thoughtworks.xstream.converters.ConverterRegistry;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.javabean.JavaBeanProvider;
import com.thoughtworks.xstream.converters.reflection.FieldKeySorter;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.core.JVM;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.StreamException;
import com.thoughtworks.xstream.io.naming.NameCoder;
import com.thoughtworks.xstream.io.xml.XppDriver;
import com.thoughtworks.xstream.mapper.Mapper;
import com.thoughtworks.xstream.security.TypeHierarchyPermission;
import com.thoughtworks.xstream.security.TypePermission;
import com.thoughtworks.xstream.security.WildcardTypePermission;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.datatype.DatatypeFactory;

public class XStreamer {
    private static final TypePermission[] PERMISSIONS = new TypePermission[]{new TypeHierarchyPermission(ConverterMatcher.class), new TypeHierarchyPermission(Mapper.class), new TypeHierarchyPermission(XStream.class), new TypeHierarchyPermission(ReflectionProvider.class), new TypeHierarchyPermission(JavaBeanProvider.class), new TypeHierarchyPermission(FieldKeySorter.class), new TypeHierarchyPermission(ConverterLookup.class), new TypeHierarchyPermission(ConverterRegistry.class), new TypeHierarchyPermission(HierarchicalStreamDriver.class), new TypeHierarchyPermission(MarshallingStrategy.class), new TypeHierarchyPermission(MarshallingContext.class), new TypeHierarchyPermission(UnmarshallingContext.class), new TypeHierarchyPermission(NameCoder.class), new TypeHierarchyPermission(TypePermission.class), new WildcardTypePermission(true, new String[]{JVM.class.getPackage().getName() + ".**"}), new TypeHierarchyPermission(DatatypeFactory.class)};

    public String toXML(XStream xstream, Object obj2) throws ObjectStreamException {
        StringWriter writer = new StringWriter();
        try {
            this.toXML(xstream, obj2, writer);
        }
        catch (ObjectStreamException e2) {
            throw e2;
        }
        catch (IOException e3) {
            throw new StreamException("Unexpected IO error from a StringWriter", e3);
        }
        return ((Object)writer).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toXML(XStream xstream, Object obj2, Writer out) throws IOException {
        XStream outer = new XStream();
        ObjectOutputStream oos = outer.createObjectOutputStream(out);
        try {
            oos.writeObject(xstream);
            oos.flush();
            xstream.toXML(obj2, out);
        }
        finally {
            oos.close();
        }
    }

    public Object fromXML(String xml) throws ClassNotFoundException, ObjectStreamException {
        try {
            return this.fromXML(new StringReader(xml));
        }
        catch (ObjectStreamException e2) {
            throw e2;
        }
        catch (IOException e3) {
            throw new StreamException("Unexpected IO error from a StringReader", e3);
        }
    }

    public Object fromXML(String xml, TypePermission[] permissions) throws ClassNotFoundException, ObjectStreamException {
        try {
            return this.fromXML(new StringReader(xml), permissions);
        }
        catch (ObjectStreamException e2) {
            throw e2;
        }
        catch (IOException e3) {
            throw new StreamException("Unexpected IO error from a StringReader", e3);
        }
    }

    public Object fromXML(HierarchicalStreamDriver driver2, String xml) throws ClassNotFoundException, ObjectStreamException {
        try {
            return this.fromXML(driver2, new StringReader(xml));
        }
        catch (ObjectStreamException e2) {
            throw e2;
        }
        catch (IOException e3) {
            throw new StreamException("Unexpected IO error from a StringReader", e3);
        }
    }

    public Object fromXML(HierarchicalStreamDriver driver2, String xml, TypePermission[] permissions) throws ClassNotFoundException, ObjectStreamException {
        try {
            return this.fromXML(driver2, new StringReader(xml), permissions);
        }
        catch (ObjectStreamException e2) {
            throw e2;
        }
        catch (IOException e3) {
            throw new StreamException("Unexpected IO error from a StringReader", e3);
        }
    }

    public Object fromXML(Reader xml) throws IOException, ClassNotFoundException {
        return this.fromXML((HierarchicalStreamDriver)new XppDriver(), xml);
    }

    public Object fromXML(Reader xml, TypePermission[] permissions) throws IOException, ClassNotFoundException {
        return this.fromXML((HierarchicalStreamDriver)new XppDriver(), xml, permissions);
    }

    public Object fromXML(HierarchicalStreamDriver driver2, Reader xml) throws IOException, ClassNotFoundException {
        return this.fromXML(driver2, xml, PERMISSIONS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object fromXML(HierarchicalStreamDriver driver2, Reader xml, TypePermission[] permissions) throws IOException, ClassNotFoundException {
        XStream outer = new XStream(driver2);
        for (int i2 = 0; i2 < permissions.length; ++i2) {
            outer.addPermission(permissions[i2]);
        }
        HierarchicalStreamReader reader = driver2.createReader(xml);
        ObjectInputStream configIn = outer.createObjectInputStream(reader);
        try {
            Object object;
            XStream configured = (XStream)configIn.readObject();
            ObjectInputStream in = configured.createObjectInputStream(reader);
            try {
                object = in.readObject();
            }
            catch (Throwable throwable) {
                in.close();
                throw throwable;
            }
            in.close();
            return object;
        }
        finally {
            configIn.close();
        }
    }

    public static TypePermission[] getDefaultPermissions() {
        return (TypePermission[])PERMISSIONS.clone();
    }
}

