/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.refactoring.extractFunction;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.intentions.UtilsKt;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlParenthesizedExpression;
import com.intellij.sql.psi.SqlRoutineDefinition;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.refactoring.SqlIntroduceHandlerBase;
import com.intellij.sql.refactoring.extractFunction.SqlExtractFunctionDialog;
import com.intellij.sql.refactoring.extractFunction.SqlExtractFunctionHelper;
import com.intellij.sql.refactoring.extractFunction.SqlExtractFunctionInfo;
import com.intellij.sql.refactoring.extractFunction.SqlExtractableCodeInfo;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0017\u0010\n\u001a\t\u0018\u00010\u0002\u00a2\u0006\u0002\b\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J \u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\tH\u0014\u00a8\u0006\u0014"}, d2={"Lcom/intellij/sql/refactoring/extractFunction/SqlExtractFunctionHandler;", "Lcom/intellij/sql/refactoring/SqlIntroduceHandlerBase;", "Lcom/intellij/sql/refactoring/extractFunction/SqlExtractFunctionHelper;", "()V", "doRefactor", "", "routineInfo", "Lcom/intellij/sql/refactoring/extractFunction/SqlExtractFunctionInfo;", "getExpressionToReplace", "Lcom/intellij/sql/psi/SqlExpression;", "getHelper", "Lorg/jetbrains/annotations/Nullable;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "invoke", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "expression", "intellij.database.sql.impl"})
public final class SqlExtractFunctionHandler
extends SqlIntroduceHandlerBase<SqlExtractFunctionHelper> {
    @NotNull
    public static final SqlExtractFunctionHandler INSTANCE = new SqlExtractFunctionHandler();

    private SqlExtractFunctionHandler() {
        String string = SqlBundle.message((String)"extract.function", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        super(string);
    }

    @Override
    @Nullable
    protected SqlExtractFunctionHelper getHelper(@NotNull SqlLanguageDialectEx dialect) {
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        return dialect.getExtractFunctionHelper();
    }

    @Override
    protected void invoke(@NotNull Project project, @NotNull Editor editor2, @NotNull SqlExpression expression) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe((PsiElement)expression);
        Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialectEx, (String)"getSqlDialectSafe(...)");
        SqlExtractFunctionHelper sqlExtractFunctionHelper = this.getHelper(sqlLanguageDialectEx);
        if (sqlExtractFunctionHelper == null) {
            return;
        }
        SqlExtractFunctionHelper helper = sqlExtractFunctionHelper;
        SqlExpression expressionToExtract = UtilsKt.unwrapAlias(expression);
        String string = helper.validateExpression(expressionToExtract);
        if (string != null) {
            String it2 = string;
            boolean bl = false;
            String string2 = SqlBundle.message((String)it2, (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            INSTANCE.showError(project, editor2, string2);
            return;
        }
        PsiElement it2 = helper.findTopmostBlock((PsiElement)expressionToExtract);
        SqlElement sqlElement = it2 instanceof SqlElement ? (SqlElement)it2 : null;
        if (sqlElement == null) {
            return;
        }
        SqlElement container = sqlElement;
        SqlExtractableCodeInfo codeInfo = new SqlExtractableCodeInfo(expressionToExtract, container);
        SqlExtractFunctionInfo routineInfo = new SqlExtractFunctionInfo(codeInfo, "my_function", codeInfo.getParameterInfos());
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.doRefactor(routineInfo);
        } else {
            new SqlExtractFunctionDialog(routineInfo, helper, (Function1<? super SqlExtractFunctionInfo, Unit>)((Function1)new Function1<SqlExtractFunctionInfo, Unit>((Object)this){

                public final void invoke(@NotNull SqlExtractFunctionInfo p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    SqlExtractFunctionHandler.access$doRefactor((SqlExtractFunctionHandler)this.receiver, p0);
                }
            })).show();
        }
    }

    private final SqlExpression getExpressionToReplace(SqlExtractFunctionInfo routineInfo) {
        PsiElement p2;
        SqlExpression e2 = routineInfo.getCodeInfo().getOriginalExpression();
        if (routineInfo.getCodeInfo().isQuery() && (p2 = e2.getParent()) instanceof SqlParenthesizedExpression) {
            e2 = (SqlExpression)p2;
        }
        return e2;
    }

    private final void doRefactor(SqlExtractFunctionInfo routineInfo) {
        SqlExtractFunctionHelper sqlExtractFunctionHelper = this.getHelper(routineInfo.getCodeInfo().getDialect());
        if (sqlExtractFunctionHelper == null) {
            return;
        }
        SqlExtractFunctionHelper helper = sqlExtractFunctionHelper;
        Project project = routineInfo.getCodeInfo().getProject();
        SqlExpression expression = routineInfo.getCodeInfo().getOriginalExpression();
        SqlRoutineDefinition routineDefinition = helper.generateRoutine(routineInfo, false);
        SqlExpression call2 = helper.generateCall(routineInfo);
        PsiElement anchor2 = helper.findAnchor((PsiElement)expression, (PsiElement)routineInfo.getCodeInfo().getContainer());
        SqlExpression expressionToReplace = this.getExpressionToReplace(routineInfo);
        WriteCommandAction.runWriteCommandAction((Project)project, (String)this.getName(), null, () -> SqlExtractFunctionHandler.doRefactor$lambda$1(expressionToReplace, call2, helper, routineDefinition, anchor2, routineInfo, project), (PsiFile[])new PsiFile[0]);
    }

    private static final void doRefactor$lambda$1(SqlExpression $expressionToReplace, SqlExpression $call, SqlExtractFunctionHelper $helper, SqlRoutineDefinition $routineDefinition, PsiElement $anchor, SqlExtractFunctionInfo $routineInfo, Project $project) {
        Intrinsics.checkNotNullParameter((Object)$expressionToReplace, (String)"$expressionToReplace");
        Intrinsics.checkNotNullParameter((Object)$call, (String)"$call");
        Intrinsics.checkNotNullParameter((Object)$helper, (String)"$helper");
        Intrinsics.checkNotNullParameter((Object)$routineDefinition, (String)"$routineDefinition");
        Intrinsics.checkNotNullParameter((Object)$routineInfo, (String)"$routineInfo");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        $expressionToReplace.replace((PsiElement)$call);
        SqlRoutineDefinition routineInPlace = $helper.addRoutine($routineDefinition, $anchor, $routineInfo.getCodeInfo().getContainer());
        CodeStyleManager.getInstance((Project)$project).reformat((PsiElement)routineInPlace);
    }

    public static final /* synthetic */ void access$doRefactor(SqlExtractFunctionHandler $this, SqlExtractFunctionInfo routineInfo) {
        $this.doRefactor(routineInfo);
    }
}

