/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.types.DasBuiltinType;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.SqlTypedDefinition;
import com.intellij.sql.psi.impl.SqlDefinitionImpl;
import com.intellij.sql.psi.impl.SqlExpressionImpl;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.sql.psi.impl.TableBasedSqlTableTypeImpl;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlPivotedQueryExpressionImpl
extends SqlExpressionImpl
implements SqlExpression {
    public SqlPivotedQueryExpressionImpl(@NotNull IElementType elementType) {
        if (elementType == null) {
            SqlPivotedQueryExpressionImpl.$$$reportNull$$$0(0);
        }
        super(elementType);
    }

    @Override
    @NotNull
    protected DasType computeDasType() {
        SqlClause columnsClause = this.getColumnsClause();
        SqlClause forClause = (SqlClause)PsiTreeUtil.getNextSiblingOfType((PsiElement)columnsClause, SqlClause.class);
        SqlClause inClause = this.getInClause();
        if (forClause == null || inClause == null) {
            return this.getPivotedExpressionType();
        }
        SqlTableType pivotedType = this.getPivotedType(columnsClause, forClause, inClause);
        SqlTableType restType = this.getRestType(columnsClause, forClause, inClause).alias(null, (PsiElement)this, Collections.emptyList());
        SqlTableType sqlTableType = restType.add(pivotedType);
        if (sqlTableType == null) {
            SqlPivotedQueryExpressionImpl.$$$reportNull$$$0(1);
        }
        return sqlTableType;
    }

    @NotNull
    protected SqlTableType getPivotedType(@NotNull SqlClause columnsClause, @NotNull SqlClause forClause, @NotNull SqlClause inClause) {
        List columns2;
        if (columnsClause == null) {
            SqlPivotedQueryExpressionImpl.$$$reportNull$$$0(2);
        }
        if (forClause == null) {
            SqlPivotedQueryExpressionImpl.$$$reportNull$$$0(3);
        }
        if (inClause == null) {
            SqlPivotedQueryExpressionImpl.$$$reportNull$$$0(4);
        }
        return (columns2 = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)inClause, SqlPivotColumnDefinition.class)).isEmpty() ? SqlTableTypeBase.EMPTY_TABLE : new TableBasedSqlTableTypeImpl(columns2, (PsiElement)this);
    }

    @NotNull
    protected SqlTableType getRestType(@NotNull SqlClause columnsClause, @NotNull SqlClause forClause, @NotNull SqlClause inClause) {
        if (columnsClause == null) {
            SqlPivotedQueryExpressionImpl.$$$reportNull$$$0(5);
        }
        if (forClause == null) {
            SqlPivotedQueryExpressionImpl.$$$reportNull$$$0(6);
        }
        if (inClause == null) {
            SqlPivotedQueryExpressionImpl.$$$reportNull$$$0(7);
        }
        SqlTableType sqlTableType = this.getRestTypeImpl(columnsClause, forClause);
        if (sqlTableType == null) {
            SqlPivotedQueryExpressionImpl.$$$reportNull$$$0(8);
        }
        return sqlTableType;
    }

    @NotNull
    protected SqlTableType getRestTypeImpl(SqlClause ... clauses) {
        SqlTableType pivotedType = this.getPivotedExpressionType();
        if (pivotedType == SqlTableTypeBase.EMPTY_TABLE) {
            SqlTableType sqlTableType = pivotedType;
            if (sqlTableType == null) {
                SqlPivotedQueryExpressionImpl.$$$reportNull$$$0(9);
            }
            return sqlTableType;
        }
        LinkedHashSet toSubtract = new LinkedHashSet();
        for (SqlReferenceExpression ref2 : ((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoots((Iterable)JBIterable.of((Object[])clauses))).filter(SqlReferenceExpression.class)) {
            if (SqlImplUtil.isAsteriskRef((PsiElement)ref2) || ref2.getReferenceElementType().getTargetKind() != ObjectKind.COLUMN) continue;
            for (ResolveResult result2 : ref2.multiResolve(false)) {
                ContainerUtil.addIfNotNull(toSubtract, (Object)result2.getElement());
            }
        }
        for (PsiElement element2 : toSubtract) {
            pivotedType = pivotedType.subtract(element2);
        }
        SqlTableType sqlTableType = pivotedType;
        if (sqlTableType == null) {
            SqlPivotedQueryExpressionImpl.$$$reportNull$$$0(10);
        }
        return sqlTableType;
    }

    @NotNull
    private SqlTableType getPivotedExpressionType() {
        SqlTableType tableType2;
        SqlExpression expression = this.getPivotedExpression();
        if (expression == null) {
            SqlTableType sqlTableType = SqlTableTypeBase.EMPTY_TABLE;
            if (sqlTableType == null) {
                SqlPivotedQueryExpressionImpl.$$$reportNull$$$0(11);
            }
            return sqlTableType;
        }
        DasType pivotedType = expression.getDasType();
        SqlTableType sqlTableType = pivotedType instanceof SqlTableType ? (tableType2 = (SqlTableType)pivotedType) : SqlTableTypeBase.EMPTY_TABLE;
        if (sqlTableType == null) {
            SqlPivotedQueryExpressionImpl.$$$reportNull$$$0(12);
        }
        return sqlTableType;
    }

    @Nullable
    protected SqlClause getColumnsClause() {
        return (SqlClause)PsiTreeUtil.getChildOfType((PsiElement)this, SqlClause.class);
    }

    @Nullable
    protected SqlClause getInClause() {
        PsiElement child = this.getLastChild();
        if (child == null || child instanceof SqlClause) {
            return (SqlClause)child;
        }
        return (SqlClause)PsiTreeUtil.getPrevSiblingOfType((PsiElement)child, SqlClause.class);
    }

    @Override
    public boolean processDeclarations(@NotNull SqlScopeProcessor processor2, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        if (processor2 == null) {
            SqlPivotedQueryExpressionImpl.$$$reportNull$$$0(13);
        }
        if (state == null) {
            SqlPivotedQueryExpressionImpl.$$$reportNull$$$0(14);
        }
        if (place == null) {
            SqlPivotedQueryExpressionImpl.$$$reportNull$$$0(15);
        }
        SqlExpression expression = this.getPivotedExpression();
        if ((lastParent == null || lastParent.getContext() == this && !PsiTreeUtil.isContextAncestor((PsiElement)expression, (PsiElement)place, (boolean)false)) && expression != null && !SqlImplUtil.processDeclarationsInType(expression, processor2, state, place)) {
            return false;
        }
        return super.processDeclarations(processor2, state, lastParent, place);
    }

    @Nullable
    private SqlExpression getPivotedExpression() {
        return (SqlExpression)PsiTreeUtil.getChildOfType((PsiElement)this, SqlExpression.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 8, 9, 10, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 1: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlPivotedQueryExpressionImpl";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnsClause";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forClause";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inClause";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlPivotedQueryExpressionImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "computeDasType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRestType";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRestTypeImpl";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getPivotedExpressionType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPivotedType";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getRestType";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 8, 9, 10, 11, 12 -> new IllegalStateException(string);
        };
    }

    public static class SqlPivotColumnDefinition
    extends SqlDefinitionImpl
    implements SqlTypedDefinition {
        public SqlPivotColumnDefinition(@NotNull IElementType elementType) {
            if (elementType == null) {
                SqlPivotColumnDefinition.$$$reportNull$$$0(0);
            }
            super(elementType);
        }

        @Nullable
        public SqlTypeElement getTypeElement() {
            return null;
        }

        @NotNull
        public DasType getDasType() {
            SqlClause columnsClause;
            PsiElement parent2 = this.getParent();
            SqlPivotedQueryExpressionImpl grandParent = parent2 == null ? null : (SqlPivotedQueryExpressionImpl)((Object)ObjectUtils.tryCast((Object)parent2.getParent(), SqlPivotedQueryExpressionImpl.class));
            SqlClause sqlClause = columnsClause = grandParent == null ? null : grandParent.getColumnsClause();
            if (columnsClause == null) {
                DasBuiltinType<?> dasBuiltinType = DasTypeSystemBase.UNKNOWN;
                if (dasBuiltinType == null) {
                    SqlPivotColumnDefinition.$$$reportNull$$$0(1);
                }
                return dasBuiltinType;
            }
            if (grandParent.getNode().getElementType() == SqlCompositeElementTypes.SQL_UNPIVOTED_QUERY_EXPRESSION) {
                SqlClause inClause = grandParent.getInClause();
                SqlReferenceExpression ref2 = (SqlReferenceExpression)PsiTreeUtil.getChildOfType((PsiElement)inClause, SqlReferenceExpression.class);
                if (ref2 == null) {
                    DasBuiltinType<?> dasBuiltinType = DasTypeSystemBase.UNKNOWN;
                    if (dasBuiltinType == null) {
                        SqlPivotColumnDefinition.$$$reportNull$$$0(2);
                    }
                    return dasBuiltinType;
                }
                if (parent2 == columnsClause) {
                    DasType dasType = ref2.getDasType();
                    if (dasType == null) {
                        SqlPivotColumnDefinition.$$$reportNull$$$0(3);
                    }
                    return dasType;
                }
                SqlExpression expr = (SqlExpression)PsiTreeUtil.getNextSiblingOfType((PsiElement)ref2, SqlExpression.class);
                if (expr == null || expr instanceof SqlReferenceExpression) {
                    DasType dasType = SqlImplUtil.getTypeSystem((PsiElement)this).getStringType();
                    if (dasType == null) {
                        SqlPivotColumnDefinition.$$$reportNull$$$0(4);
                    }
                    return dasType;
                }
                DasType dasType = expr.getDasType();
                if (dasType == null) {
                    SqlPivotColumnDefinition.$$$reportNull$$$0(5);
                }
                return dasType;
            }
            SqlExpression ref3 = (SqlExpression)PsiTreeUtil.getChildOfType((PsiElement)columnsClause, SqlExpression.class);
            DasType dasType = ref3 == null ? DasTypeSystemBase.UNKNOWN : ref3.getDasType();
            if (dasType == null) {
                SqlPivotColumnDefinition.$$$reportNull$$$0(6);
            }
            return dasType;
        }

        public boolean isNotNull() {
            return false;
        }

        @Nullable
        public String getDefault() {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3, 4, 5, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elementType";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/psi/impl/SqlPivotedQueryExpressionImpl$SqlPivotColumnDefinition";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/psi/impl/SqlPivotedQueryExpressionImpl$SqlPivotColumnDefinition";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDasType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3, 4, 5, 6 -> new IllegalStateException(string);
            };
        }
    }

    public static class ByValues
    extends SqlPivotedQueryExpressionImpl {
        public ByValues(@NotNull IElementType elementType) {
            if (elementType == null) {
                ByValues.$$$reportNull$$$0(0);
            }
            super(elementType);
        }

        @Override
        @NotNull
        protected SqlTableType getPivotedType(@NotNull SqlClause columnsClause, @NotNull SqlClause forClause, @NotNull SqlClause inClause) {
            if (columnsClause == null) {
                ByValues.$$$reportNull$$$0(1);
            }
            if (forClause == null) {
                ByValues.$$$reportNull$$$0(2);
            }
            if (inClause == null) {
                ByValues.$$$reportNull$$$0(3);
            }
            SqlTableType sqlTableType = (SqlTableType)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create((Object)this.calcPivotedType(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
            if (sqlTableType == null) {
                ByValues.$$$reportNull$$$0(4);
            }
            return sqlTableType;
        }

        @NotNull
        private SqlTableType calcPivotedType() {
            SqlClause columnsClause = this.getColumnsClause();
            SqlClause inClause = this.getInClause();
            List values2 = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)columnsClause, SqlExpression.class);
            List columns2 = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)inClause, SqlExpression.class);
            if (values2.isEmpty() || columns2.isEmpty()) {
                SqlTableType sqlTableType = SqlTableTypeBase.EMPTY_TABLE;
                if (sqlTableType == null) {
                    ByValues.$$$reportNull$$$0(5);
                }
                return sqlTableType;
            }
            ArrayList<MyFakeDefinition> result2 = new ArrayList<MyFakeDefinition>(values2.size() * columns2.size());
            for (SqlExpression column2 : columns2) {
                for (SqlExpression value2 : values2) {
                    result2.add(MyFakeDefinition.create((PsiElement)this, value2, column2));
                }
            }
            return new TableBasedSqlTableTypeImpl(result2, (PsiElement)this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elementType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columnsClause";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "forClause";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inClause";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/psi/impl/SqlPivotedQueryExpressionImpl$ByValues";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/psi/impl/SqlPivotedQueryExpressionImpl$ByValues";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPivotedType";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "calcPivotedType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getPivotedType";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5 -> new IllegalStateException(string);
            };
        }

        private static class MyFakeDefinition
        extends SqlFileImpl.FakeDefinition
        implements SqlTypedDefinition {
            private final boolean myQuoted;
            private final SqlExpression myValue;
            private final SqlExpression myColumn;

            MyFakeDefinition(@NotNull PsiElement parent2, @Nullable String name2, boolean quoted, @NotNull SqlExpression value2, @NotNull SqlExpression column2) {
                if (parent2 == null) {
                    MyFakeDefinition.$$$reportNull$$$0(0);
                }
                if (value2 == null) {
                    MyFakeDefinition.$$$reportNull$$$0(1);
                }
                if (column2 == null) {
                    MyFakeDefinition.$$$reportNull$$$0(2);
                }
                super(parent2, StringUtil.notNullize((String)name2));
                this.myQuoted = quoted;
                this.myValue = value2;
                this.myColumn = column2;
            }

            @Override
            @NotNull
            public Dbms getDbms() {
                Dbms dbms = super.getDbms();
                if (dbms == null) {
                    MyFakeDefinition.$$$reportNull$$$0(3);
                }
                return dbms;
            }

            public boolean isNameQuoted() {
                return this.myQuoted;
            }

            @NotNull
            public ObjectKind getKind() {
                ObjectKind objectKind = ObjectKind.COLUMN;
                if (objectKind == null) {
                    MyFakeDefinition.$$$reportNull$$$0(4);
                }
                return objectKind;
            }

            @NotNull
            public PsiElement getNavigationElement() {
                SqlExpression sqlExpression = this.myColumn;
                if (sqlExpression == null) {
                    MyFakeDefinition.$$$reportNull$$$0(5);
                }
                return sqlExpression;
            }

            @Nullable
            public SqlTypeElement getTypeElement() {
                return null;
            }

            @NotNull
            public DasType getDasType() {
                DasType dasType = this.myValue.getDasType();
                if (dasType == null) {
                    MyFakeDefinition.$$$reportNull$$$0(6);
                }
                return dasType;
            }

            public boolean isNotNull() {
                return false;
            }

            @Nullable
            public String getDefault() {
                return null;
            }

            public static MyFakeDefinition create(@NotNull PsiElement parent2, @NotNull SqlExpression value2, @NotNull SqlExpression column2) {
                String vName;
                if (parent2 == null) {
                    MyFakeDefinition.$$$reportNull$$$0(7);
                }
                if (value2 == null) {
                    MyFakeDefinition.$$$reportNull$$$0(8);
                }
                if (column2 == null) {
                    MyFakeDefinition.$$$reportNull$$$0(9);
                }
                boolean columnQuoted = DbSqlUtilCore.isQuoted((DasObject)ObjectUtils.tryCast((Object)column2, DasObject.class));
                boolean valueQuoted = DbSqlUtilCore.isQuoted((DasObject)ObjectUtils.tryCast((Object)value2, DasObject.class));
                String cName = column2.getName();
                String string = vName = value2 instanceof DasObject ? value2.getName() : null;
                if (valueQuoted != columnQuoted) {
                    SqlLanguageDialectEx language = SqlImplUtil.getSqlDialectSafe(parent2);
                    Casing casing = language.getCasing(ObjectKind.COLUMN, null);
                    if (casing.quoted == Case.EXACT) {
                        if (!columnQuoted) {
                            cName = casing.plain.apply(cName);
                        }
                        if (!valueQuoted) {
                            vName = casing.plain.apply(vName);
                        }
                    }
                }
                String name2 = cName == null || vName == null ? cName : cName + "_" + vName;
                return new MyFakeDefinition(parent2, name2, columnQuoted || valueQuoted, value2, column2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 3, 4, 5, 6 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "parent";
                        break;
                    }
                    case 1: 
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "value";
                        break;
                    }
                    case 2: 
                    case 9: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "column";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/sql/psi/impl/SqlPivotedQueryExpressionImpl$ByValues$MyFakeDefinition";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/sql/psi/impl/SqlPivotedQueryExpressionImpl$ByValues$MyFakeDefinition";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDbms";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getKind";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getNavigationElement";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDasType";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        break;
                    }
                    case 7: 
                    case 8: 
                    case 9: {
                        objectArray = objectArray;
                        objectArray[2] = "create";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 3, 4, 5, 6 -> new IllegalStateException(string);
                };
            }
        }
    }
}

