/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.model.DasObject;
import com.intellij.database.model.DataType;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.psi.PsiElement;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlImplicitTarget;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.impl.SqlColumnSymbol;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AliasedSqlTableType
extends SqlTableTypeBase {
    private final SqlTableType myType;
    private final String myAliasName;
    private final List<? extends SqlElement> myNewColumns;
    private final PsiElement myAliasElement;

    public static AliasedSqlTableType fromNames(SqlTableType type2, String aliasName, @Nullable PsiElement aliasElement, List<? extends SqlNameElement> newColumns) {
        return new AliasedSqlTableType(type2, aliasName, aliasElement, newColumns);
    }

    public static AliasedSqlTableType fromDefs(SqlTableType type2, String aliasName, @Nullable PsiElement aliasElement, List<? extends SqlDefinition> newColumns) {
        return new AliasedSqlTableType(type2, aliasName, aliasElement, newColumns);
    }

    protected AliasedSqlTableType(SqlTableType type2, String aliasName, @Nullable PsiElement aliasElement, List<? extends SqlElement> newColumns) {
        this.myType = type2;
        this.myAliasName = aliasName;
        this.myNewColumns = newColumns;
        this.myAliasElement = aliasElement;
    }

    public final SqlTableType getAliasedType() {
        return this.myType;
    }

    @NotNull
    public List<DasObject> getMethods() {
        List list = this.myType.getMethods();
        if (list == null) {
            AliasedSqlTableType.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    public DataType toDataType() {
        DataType dataType = this.myType.toDataType();
        if (dataType == null) {
            AliasedSqlTableType.$$$reportNull$$$0(1);
        }
        return dataType;
    }

    @Override
    @Nullable
    public PsiElement getImmediateTypeElement() {
        return this.myAliasElement != null ? this.myAliasElement : this.myType.getImmediateTypeElement();
    }

    @Override
    @Nullable
    public PsiElement getTypeElement() {
        return this.myType.getTypeElement();
    }

    @Nullable
    public PsiElement getColumnQualifier(int i2) {
        return this.myAliasElement;
    }

    @Override
    @Nullable
    public String getTypeName() {
        return this.myAliasName;
    }

    public int getColumnCount() {
        return this.myNewColumns.isEmpty() ? this.myType.getColumnCount() : this.myNewColumns.size();
    }

    public String getColumnName(int i2) {
        SqlElement newColumn = this.myNewColumns.isEmpty() ? null : this.myNewColumns.get(i2);
        return newColumn == null ? this.myType.getColumnName(i2) : newColumn.getName();
    }

    public boolean isColumnQuoted(int i2) {
        SqlElement newColumn = this.myNewColumns.isEmpty() ? null : this.myNewColumns.get(i2);
        return newColumn == null ? this.myType.isColumnQuoted(i2) : Boolean.TRUE.equals(AliasedSqlTableType.isQuoted((PsiElement)newColumn));
    }

    public DasType getColumnDasType(int i2) {
        return this.myNewColumns.isEmpty() ? this.myType.getColumnDasType(i2) : (i2 < this.myType.getColumnCount() ? this.myType.getColumnDasType(i2) : DasTypeSystemBase.UNKNOWN);
    }

    @NotNull
    public PsiElement getColumnElement(int i2) {
        SqlElement newColumn = this.myNewColumns.isEmpty() ? null : this.myNewColumns.get(i2);
        Object object = newColumn == null ? this.myType.getColumnElement(i2) : newColumn;
        if (object == null) {
            AliasedSqlTableType.$$$reportNull$$$0(2);
        }
        return object;
    }

    public PsiElement getSourceColumnElement(int i2) {
        return i2 < this.myType.getColumnCount() ? this.myType.getSourceColumnElement(i2) : null;
    }

    protected PsiElement getColumnBackingElement(int i2) {
        return i2 >= 0 && i2 < this.myType.getColumnCount() ? this.myType.getImmediateSourceColumnElement(i2) : null;
    }

    public boolean isGeneratedColumn(int i2) {
        return this.myNewColumns.isEmpty() ? this.myType.isGeneratedColumn(i2) : i2 < this.myType.getColumnCount() && this.myType.isGeneratedColumn(i2);
    }

    @Override
    public PsiElement getImmediateSourceColumnElement(final int i2) {
        String columnName;
        PsiElement originalSource = this.getSourceColumnElement(i2);
        PsiElement backingElement = this.getColumnBackingElement(i2);
        if (backingElement == null) {
            return originalSource;
        }
        if (backingElement instanceof SqlImplicitTarget) {
            return backingElement;
        }
        PsiElement qualifier = this.myAliasName != null && !this.myAliasName.equals("*") ? this.myAliasElement : this.myType.getColumnQualifier(i2);
        String string = columnName = i2 < this.myType.getColumnCount() ? this.myType.getColumnName(i2) : null;
        if (columnName == null) {
            return originalSource;
        }
        return new SqlColumnSymbol(columnName, this.isColumnQuoted(i2), backingElement, i2, originalSource, qualifier){

            @Override
            @NotNull
            public DasType getType() {
                DasType dasType = AliasedSqlTableType.this.getColumnDasType(i2);
                if (dasType == null) {
                    1.$$$reportNull$$$0(0);
                }
                return dasType;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/AliasedSqlTableType$1", "getType"));
            }
        };
    }

    @Override
    @Nullable
    public String getColumnTypeAlias(int i2) {
        return this.myAliasName != null ? this.myAliasName : this.myType.getColumnTypeAlias(i2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/sql/psi/impl/AliasedSqlTableType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethods";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "toDataType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnElement";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

