/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.database.Dbms;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.intentions.IntentionUtilsKt;
import com.intellij.sql.intentions.SqlBaseElementAtCaretIntentionAction;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlGroupByClause;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlSelectOption;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0012\u0010\u000e\u001a\f0\u000f\u00a2\u0006\u0002\b\u0010\u00a2\u0006\u0002\b\u0011H\u0016J!\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\rH\u0096\u0002J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\rH\u0016J\f\u0010\u001b\u001a\u00020\u001a*\u00020\u000bH\u0002R\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001c"}, d2={"Lcom/intellij/sql/intentions/SqlReplaceDistinctWithGroupByIntention;", "Lcom/intellij/sql/intentions/SqlBaseElementAtCaretIntentionAction;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "()V", "groupByClause", "Lcom/intellij/sql/psi/SqlGroupByClause;", "Lcom/intellij/sql/psi/SqlQueryExpression;", "getGroupByClause", "(Lcom/intellij/sql/psi/SqlQueryExpression;)Lcom/intellij/sql/psi/SqlGroupByClause;", "getExpressions", "", "Lcom/intellij/sql/psi/SqlExpression;", "context", "Lcom/intellij/psi/PsiElement;", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "isAvailable", "", "isReference", "intellij.database.sql.impl"})
@SourceDebugExtension(value={"SMAP\nSqlReplaceDistinctWithGroupByIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlReplaceDistinctWithGroupByIntention.kt\ncom/intellij/sql/intentions/SqlReplaceDistinctWithGroupByIntention\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,70:1\n1855#2,2:71\n1747#2,3:75\n1#3:73\n436#4:74\n*S KotlinDebug\n*F\n+ 1 SqlReplaceDistinctWithGroupByIntention.kt\ncom/intellij/sql/intentions/SqlReplaceDistinctWithGroupByIntention\n*L\n32#1:71,2\n58#1:75,3\n56#1:74\n*E\n"})
public final class SqlReplaceDistinctWithGroupByIntention
extends SqlBaseElementAtCaretIntentionAction
implements LowPriorityAction {
    @NotNull
    public String getFamilyName() {
        String string = SqlBundle.message((String)"intention.family.name.replace.distinct.with.group.by", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        return !((Collection)this.getExpressions(element2)).isEmpty();
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiElement element2) {
        SqlGroupByClause sqlGroupByClause;
        block9: {
            block8: {
                SqlSelectOption it2;
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
                Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
                List<SqlExpression> expressions2 = this.getExpressions(element2);
                if (expressions2.isEmpty()) {
                    return;
                }
                SqlSelectClause sqlSelectClause = (SqlSelectClause)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)CollectionsKt.first(expressions2)), SqlSelectClause.class);
                if (sqlSelectClause == null) {
                    return;
                }
                SqlSelectClause selectClause = sqlSelectClause;
                PsiElement psiElement = selectClause.getParent();
                SqlQueryExpression sqlQueryExpression = psiElement instanceof SqlQueryExpression ? (SqlQueryExpression)psiElement : null;
                if (sqlQueryExpression == null) {
                    return;
                }
                SqlQueryExpression query = sqlQueryExpression;
                if (this.getGroupByClause(query) != null) {
                    return;
                }
                SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe((PsiElement)query);
                Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialectEx, (String)"getSqlDialectSafe(...)");
                SqlLanguageDialectEx dialect = sqlLanguageDialectEx;
                List list = selectClause.getOptions();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getOptions(...)");
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it2 = (SqlSelectOption)element$iv;
                    boolean bl = false;
                    if (!StringsKt.equals((String)it2.getName(), (String)"distinct", (boolean)true) && !StringsKt.equals((String)it2.getName(), (String)"distinctrow", (boolean)true)) continue;
                    PsiElement psiElement2 = it2.getNextSibling();
                    PsiWhiteSpace psiWhiteSpace = psiElement2 instanceof PsiWhiteSpace ? (PsiWhiteSpace)psiElement2 : null;
                    PsiElement next = psiWhiteSpace != null ? (PsiElement)psiWhiteSpace : (PsiElement)it2;
                    it2.getParent().deleteChildRange((PsiElement)it2, next);
                }
                sqlGroupByClause = IntentionUtilsKt.createGroupByClause(expressions2, dialect, project);
                if (sqlGroupByClause == null) break block8;
                it2 = sqlGroupByClause;
                boolean bl = false;
                SqlGroupByClause sqlGroupByClause2 = IntentionUtilsKt.addGroupBy(query, (SqlGroupByClause)it2);
                sqlGroupByClause = sqlGroupByClause2;
                if (sqlGroupByClause2 != null) break block9;
            }
            return;
        }
        SqlGroupByClause groupBy = sqlGroupByClause;
        CodeStyleManager.getInstance((Project)project).reformat((PsiElement)groupBy);
    }

    private final List<SqlExpression> getExpressions(PsiElement context) {
        PsiElement sibling;
        IElementType elementType = PsiUtilCore.getElementType((PsiElement)context);
        if (!Intrinsics.areEqual((Object)elementType, (Object)SqlCommonKeywords.SQL_DISTINCT) && !Intrinsics.areEqual((Object)elementType, (Object)SqlCommonKeywords.SQL_DISTINCTROW)) {
            return CollectionsKt.emptyList();
        }
        SqlSelectOption sqlSelectOption = (SqlSelectOption)PsiTreeUtil.getParentOfType((PsiElement)context, SqlSelectOption.class);
        if (sqlSelectOption == null) {
            return CollectionsKt.emptyList();
        }
        SqlSelectOption selectOption = sqlSelectOption;
        PsiElement psiElement = selectOption.getParent();
        SqlSelectClause sqlSelectClause = psiElement instanceof SqlSelectClause ? (SqlSelectClause)psiElement : null;
        if (sqlSelectClause == null) {
            return CollectionsKt.emptyList();
        }
        SqlSelectClause selectClause = sqlSelectClause;
        PsiElement psiElement2 = selectClause.getParent();
        SqlQueryExpression sqlQueryExpression = psiElement2 instanceof SqlQueryExpression ? (SqlQueryExpression)psiElement2 : null;
        if (sqlQueryExpression == null) {
            return CollectionsKt.emptyList();
        }
        SqlQueryExpression query = sqlQueryExpression;
        if (this.getGroupByClause(query) != null) {
            return CollectionsKt.emptyList();
        }
        SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe((PsiElement)selectClause);
        Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialectEx, (String)"getSqlDialectSafe(...)");
        SqlLanguageDialectEx dialect = sqlLanguageDialectEx;
        Dbms dbms = dialect.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        Dbms dbms2 = dbms;
        Object distinctClause = dbms2.isPostgres() ? (Intrinsics.areEqual((Object)PsiUtilCore.getElementType((PsiElement)(sibling = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)context))), (Object)SqlCommonKeywords.SQL_ON) ? selectOption.getClause() : null) : null;
        SqlClause sqlClause = distinctClause;
        if (sqlClause == null) {
            sqlClause = (SqlClause)selectClause;
        }
        PsiElement $this$childrenOfType$iv = (PsiElement)sqlClause;
        boolean $i$f$childrenOfType = false;
        List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)$this$childrenOfType$iv, SqlExpression.class);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildrenOfTypeAsList(...)");
        List expressions2 = list;
        if (Intrinsics.areEqual((Object)dialect.getDisplayName(), (Object)"SQL92") || dbms2.isCassandra() || dbms2.isDerby()) {
            boolean bl;
            block11: {
                Iterable $this$any$iv = expressions2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        SqlExpression it2 = (SqlExpression)element$iv;
                        boolean bl2 = false;
                        if (!(!this.isReference(it2))) continue;
                        bl = true;
                        break block11;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return CollectionsKt.emptyList();
            }
        }
        return expressions2;
    }

    private final boolean isReference(SqlExpression $this$isReference) {
        SqlAsExpression sqlAsExpression = $this$isReference instanceof SqlAsExpression ? (SqlAsExpression)$this$isReference : null;
        if (sqlAsExpression == null || (sqlAsExpression = sqlAsExpression.getExpression()) == null) {
            sqlAsExpression = $this$isReference;
        }
        return sqlAsExpression instanceof SqlReferenceExpression;
    }

    private final SqlGroupByClause getGroupByClause(SqlQueryExpression $this$groupByClause) {
        SqlTableExpression sqlTableExpression = $this$groupByClause.getTableExpression();
        if (sqlTableExpression == null || (sqlTableExpression = sqlTableExpression.getGroupByClause()) == null) {
            sqlTableExpression = (SqlGroupByClause)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)$this$groupByClause), SqlGroupByClause.class);
        }
        return sqlTableExpression;
    }
}

