/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.PsiColumn;
import com.intellij.database.model.PsiObject;
import com.intellij.database.model.PsiTable;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbDataSourceImpl;
import com.intellij.database.psi.DbTable;
import com.intellij.database.util.DasUtil;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.refactoring.rename.RenameHandlerRegistry;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.SqlNamesGenerator;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.editor.SqlEditorOptions;
import com.intellij.sql.intentions.SqlBaseElementAtCaretIntentionAction;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlNAryExpression;
import com.intellij.sql.psi.SqlParenthesizedExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlResultSetExpression;
import com.intellij.sql.psi.SqlTableColumnsList;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.util.Query;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 !2\u00020\u0001:\u0001!B\u0011\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J \u0010\u000e\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u000fH\u0002J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0012\u0010\u0019\u001a\f0\u001a\u00a2\u0006\u0002\b\u001b\u00a2\u0006\u0002\b\u001cH\u0017J!\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\u000fH\u0096\u0002J \u0010\u001f\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\u000fH\u0016J\b\u0010 \u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/sql/intentions/SqlIntroduceTableAliasIntention;", "Lcom/intellij/sql/intentions/SqlBaseElementAtCaretIntentionAction;", "isPreview", "", "(Z)V", "collectItemsToQualify", "", "Lcom/intellij/sql/psi/SqlReferenceExpression;", "element", "Lcom/intellij/database/model/PsiTable;", "searchScope", "Lcom/intellij/psi/search/LocalSearchScope;", "topSqlExpression", "Lcom/intellij/sql/psi/SqlResultSetExpression;", "doInvoke", "Lcom/intellij/psi/PsiElement;", "editor", "Lcom/intellij/openapi/editor/Editor;", "project", "Lcom/intellij/openapi/project/Project;", "findReference", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "file", "Lcom/intellij/psi/PsiFile;", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "invoke", "", "isAvailable", "startInWriteAction", "Companion", "intellij.database.sql.impl"})
@SourceDebugExtension(value={"SMAP\nSqlIntroduceTableAliasIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlIntroduceTableAliasIntention.kt\ncom/intellij/sql/intentions/SqlIntroduceTableAliasIntention\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,152:1\n1855#2,2:153\n1855#2,2:155\n*S KotlinDebug\n*F\n+ 1 SqlIntroduceTableAliasIntention.kt\ncom/intellij/sql/intentions/SqlIntroduceTableAliasIntention\n*L\n81#1:153,2\n121#1:155,2\n*E\n"})
public final class SqlIntroduceTableAliasIntention
extends SqlBaseElementAtCaretIntentionAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isPreview;

    @JvmOverloads
    public SqlIntroduceTableAliasIntention(boolean isPreview) {
        this.isPreview = isPreview;
    }

    public /* synthetic */ SqlIntroduceTableAliasIntention(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = SqlBundle.message((String)"introduce.table.alias", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiElement element2) {
        SqlReferenceExpression reference;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        SqlReferenceExpression sqlReferenceExpression = reference = this.findReference(element2);
        PsiElement psiElement = sqlReferenceExpression != null ? sqlReferenceExpression.resolve() : null;
        PsiTable psiTable = psiElement instanceof PsiTable ? (PsiTable)psiElement : null;
        if (psiTable == null) {
            return false;
        }
        PsiTable target2 = psiTable;
        return Companion.getTopExpression((SqlExpression)reference, target2) != null;
    }

    private final SqlReferenceExpression findReference(PsiElement element2) {
        SqlReferenceExpression sqlReferenceExpression = (SqlReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)element2, SqlReferenceExpression.class);
        if (sqlReferenceExpression == null) {
            return null;
        }
        SqlReferenceExpression reference = sqlReferenceExpression;
        if (reference.getReferenceElementType() != SqlCompositeElementTypes.SQL_TABLE_REFERENCE) {
            return null;
        }
        if (!(reference.resolve() instanceof DasTable)) {
            return null;
        }
        PsiElement parent2 = reference.getParent();
        if (parent2 instanceof SqlReferenceExpression || parent2 instanceof SqlAsExpression || parent2 instanceof SqlTableColumnsList) {
            return null;
        }
        return reference;
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        new SqlIntroduceTableAliasIntention(true).invoke(project, editor2, file);
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.DIFF;
        Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"DIFF");
        return intentionPreviewInfo;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiElement element2) {
        block2: {
            PsiFile file;
            block1: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
                Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
                file = element2.getContainingFile();
                if (!this.isPreview) break block1;
                this.doInvoke(element2, editor2, project);
                break block2;
            }
            if (!((Boolean)ApplicationManager.getApplication().runWriteAction(() -> SqlIntroduceTableAliasIntention.invoke$lambda$0(this, element2, editor2, project))).booleanValue()) {
                return;
            }
            DataContext dataContext = DataManager.getInstance().getDataContext((Component)editor2.getComponent());
            Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
            DataContext dataContext2 = dataContext;
            RenameHandler renameHandler = RenameHandlerRegistry.getInstance().getRenameHandler(dataContext2);
            if (renameHandler == null) break block2;
            renameHandler.invoke(project, editor2, file, dataContext2);
        }
    }

    private final boolean doInvoke(PsiElement element2, Editor editor2, Project project) {
        SqlReferenceExpression reference = this.findReference(element2);
        if (reference == null) {
            return false;
        }
        PsiElement psiElement = reference.resolve();
        PsiTable psiTable = psiElement instanceof PsiTable ? (PsiTable)psiElement : null;
        if (psiTable == null) {
            return false;
        }
        PsiTable target2 = psiTable;
        SqlResultSetExpression topSqlExpression = Companion.getTopExpression((SqlExpression)reference, target2);
        if (topSqlExpression == null) {
            return false;
        }
        String string = SqlNamesGenerator.suggestAliasName(reference.getName(), (PsiElement)reference);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"suggestAliasName(...)");
        String aliasName = string;
        ArrayList<PsiElement> toReplace = new ArrayList<PsiElement>();
        LocalSearchScope searchScope = new LocalSearchScope((PsiElement)topSqlExpression);
        Query query = ReferencesSearch.search((PsiElement)target2, (SearchScope)((SearchScope)searchScope));
        Intrinsics.checkNotNullExpressionValue((Object)query, (String)"search(...)");
        Iterable $this$forEach$iv = (Iterable)query;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiElement psiElement2;
            PsiReference it2 = (PsiReference)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it2.getElement(), (String)"getElement(...)");
            if (Intrinsics.areEqual((Object)psiElement2, (Object)reference)) continue;
            if (!(psiElement2 instanceof SqlReferenceExpression)) {
                return false;
            }
            if (Companion.getTopExpression((SqlExpression)psiElement2, target2) != topSqlExpression) continue;
            toReplace.add(psiElement2);
        }
        List<SqlReferenceExpression> toQualify = this.collectItemsToQualify(target2, searchScope, topSqlExpression);
        SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe((PsiElement)reference);
        Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialectEx, (String)"getSqlDialectSafe(...)");
        SqlLanguageDialectEx dialect = sqlLanguageDialectEx;
        SqlExpression sqlExpression = SqlPsiElementFactory.createTableAliasFromText(reference.getText() + " " + aliasName, dialect, (PsiElement)reference);
        Intrinsics.checkNotNull((Object)sqlExpression);
        SqlExpression expression = sqlExpression;
        PsiElement newExpression = reference.replace((PsiElement)expression);
        for (SqlReferenceExpression sqlReferenceExpression : toReplace) {
            SqlReferenceExpression sqlReferenceExpression2 = SqlPsiElementFactory.createReferenceFromText(aliasName, dialect, sqlReferenceExpression.getReferenceElementType(), (PsiElement)sqlReferenceExpression);
            Intrinsics.checkNotNull((Object)sqlReferenceExpression2);
            sqlReferenceExpression.replace((PsiElement)sqlReferenceExpression2);
        }
        for (SqlReferenceExpression sqlReferenceExpression : toQualify) {
            SqlReferenceExpression sqlReferenceExpression3 = SqlPsiElementFactory.createReferenceFromText(aliasName + "." + sqlReferenceExpression.getText(), dialect, sqlReferenceExpression.getReferenceElementType(), (PsiElement)sqlReferenceExpression);
            Intrinsics.checkNotNull((Object)sqlReferenceExpression3);
            sqlReferenceExpression.replace((PsiElement)sqlReferenceExpression3);
        }
        editor2.getCaretModel().moveToOffset(newExpression.getTextRange().getEndOffset());
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        documentManager.commitDocument(editor2.getDocument());
        documentManager.doPostponedOperationsAndUnblockDocument(editor2.getDocument());
        return true;
    }

    private final List<SqlReferenceExpression> collectItemsToQualify(PsiTable element2, LocalSearchScope searchScope, SqlResultSetExpression topSqlExpression) {
        SqlEditorOptions sqlEditorOptions = SqlEditorOptions.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)sqlEditorOptions, (String)"getInstance(...)");
        SqlEditorOptions options2 = sqlEditorOptions;
        SqlEditorOptions.QualificationType qualificationType = options2.getAliasQualification().and(options2.getRefactoringQualification());
        Intrinsics.checkNotNullExpressionValue((Object)qualificationType, (String)"and(...)");
        SqlEditorOptions.QualificationType aliasQualification = qualificationType;
        if (aliasQualification != SqlEditorOptions.QualificationType.ALWAYS) {
            return CollectionsKt.emptyList();
        }
        ArrayList<PsiElement> toQualify = new ArrayList<PsiElement>();
        DbTable dbTable = element2 instanceof DbTable ? (DbTable)element2 : null;
        DbDataSource dbDataSource = dbTable != null ? dbTable.getDataSource() : null;
        DbDataSourceImpl dataSourceImpl = dbDataSource instanceof DbDataSourceImpl ? (DbDataSourceImpl)dbDataSource : null;
        for (DasColumn column2 : DasUtil.getColumns(element2)) {
            PsiObject col;
            PsiObject psiObject;
            PsiColumn psiColumn = column2 instanceof PsiColumn ? (PsiColumn)column2 : null;
            if (psiColumn != null) {
                psiObject = psiColumn;
            } else {
                DbDataSourceImpl dbDataSourceImpl = dataSourceImpl;
                psiObject = dbDataSourceImpl != null ? dbDataSourceImpl.findElement(column2) : null;
            }
            if ((col = psiObject) == null) continue;
            Query query = ReferencesSearch.search((PsiElement)col, (SearchScope)((SearchScope)searchScope));
            Intrinsics.checkNotNullExpressionValue((Object)query, (String)"search(...)");
            Iterable $this$forEach$iv = (Iterable)query;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PsiElement psiElement;
                PsiReference it2 = (PsiReference)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it2.getElement(), (String)"getElement(...)");
                if (!(psiElement instanceof SqlReferenceExpression) || SqlImplUtil.isAsteriskRef(psiElement) || ((SqlReferenceExpression)psiElement).getQualifierExpression() != null || ((SqlReferenceExpression)psiElement).getReferenceElementType() != SqlCompositeElementTypes.SQL_COLUMN_REFERENCE || Companion.getTopExpression((SqlExpression)psiElement, element2) != topSqlExpression) continue;
                toQualify.add(psiElement);
            }
        }
        return toQualify;
    }

    public boolean startInWriteAction() {
        return false;
    }

    @JvmOverloads
    public SqlIntroduceTableAliasIntention() {
        this(false, 1, null);
    }

    private static final Boolean invoke$lambda$0(SqlIntroduceTableAliasIntention this$0, PsiElement $element, Editor $editor, Project $project) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$element, (String)"$element");
        Intrinsics.checkNotNullParameter((Object)$editor, (String)"$editor");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        return this$0.doInvoke($element, $editor, $project);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/sql/intentions/SqlIntroduceTableAliasIntention$Companion;", "", "()V", "getTopExpression", "Lcom/intellij/sql/psi/SqlResultSetExpression;", "reference", "Lcom/intellij/sql/psi/SqlExpression;", "table", "Lcom/intellij/psi/PsiElement;", "intellij.database.sql.impl"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final SqlResultSetExpression getTopExpression(@Nullable SqlExpression reference, @Nullable PsiElement table) {
            SqlResultSetExpression sqlExpression = (SqlResultSetExpression)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)reference), SqlResultSetExpression.class);
            SqlResultSetExpression parentParent = null;
            if (sqlExpression != null && (!(sqlExpression.getParent() instanceof SqlParenthesizedExpression) || SqlImplUtil.isCorrelatedQuery(sqlExpression, table))) {
                while ((parentParent = (SqlResultSetExpression)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)sqlExpression), SqlResultSetExpression.class)) != null && !(parentParent instanceof SqlNAryExpression)) {
                    sqlExpression = parentParent;
                    if (SqlImplUtil.isCorrelatedQuery(parentParent, table) || !(parentParent.getParent() instanceof SqlParenthesizedExpression)) continue;
                    break;
                }
            }
            return sqlExpression;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

