/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.refactoring.rename.RenameHandlerRegistry;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.SqlNamesGenerator;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.intentions.SqlBaseElementAtCaretIntentionAction;
import com.intellij.sql.intentions.SqlConvertToSubqueryIntentionKt;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlResultSetExpression;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import java.awt.Component;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\f0\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\bH\u0016J\u0010\u0010\t\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bH\u0016J!\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0096\u0002J \u0010\u0014\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/sql/intentions/SqlConvertToSubqueryIntention;", "Lcom/intellij/sql/intentions/SqlBaseElementAtCaretIntentionAction;", "isPreview", "", "(Z)V", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getFileModifierForPreview", "target", "Lcom/intellij/psi/PsiFile;", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "isAvailable", "intellij.database.sql.impl"})
@SourceDebugExtension(value={"SMAP\nSqlConvertToSubqueryIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlConvertToSubqueryIntention.kt\ncom/intellij/sql/intentions/SqlConvertToSubqueryIntention\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,68:1\n67#2:69\n67#2:70\n*S KotlinDebug\n*F\n+ 1 SqlConvertToSubqueryIntention.kt\ncom/intellij/sql/intentions/SqlConvertToSubqueryIntention\n*L\n33#1:69\n40#1:70\n*E\n"})
public final class SqlConvertToSubqueryIntention
extends SqlBaseElementAtCaretIntentionAction {
    private final boolean isPreview;

    @JvmOverloads
    public SqlConvertToSubqueryIntention(boolean isPreview) {
        this.isPreview = isPreview;
    }

    public /* synthetic */ SqlConvertToSubqueryIntention(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    @NotNull
    public String getFamilyName() {
        String string = SqlBundle.message((String)"intention.family.convert.to.subquery", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiElement element2) {
        void $this$parentOfType$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        if (SqlImplUtil.getSqlDialectSafe(element2).getDbms().isCassandra()) {
            return false;
        }
        PsiElement psiElement = element2;
        boolean withSelf$iv = true;
        boolean $i$f$parentOfType = false;
        SqlResultSetExpression sqlResultSetExpression = (SqlResultSetExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, SqlResultSetExpression.class, (boolean)false);
        if (sqlResultSetExpression == null) {
            return false;
        }
        SqlResultSetExpression sqlResultSetExpression2 = sqlResultSetExpression;
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        return !SqlConvertToSubqueryIntentionKt.access$hasNonEditableInjectionFragment(document, (PsiElement)sqlResultSetExpression2);
    }

    @NotNull
    public SqlConvertToSubqueryIntention getFileModifierForPreview(@NotNull PsiFile target2) {
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        return new SqlConvertToSubqueryIntention(true);
    }

    /*
     * WARNING - void declaration
     */
    public void invoke(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiElement element2) {
        SqlExpression sqlExpression;
        void $this$parentOfType$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        PsiElement psiElement = element2;
        boolean withSelf$iv = true;
        boolean $i$f$parentOfType = false;
        SqlResultSetExpression sqlResultSetExpression = (SqlResultSetExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, SqlResultSetExpression.class, (boolean)false);
        if (sqlResultSetExpression == null) {
            return;
        }
        SqlResultSetExpression expression = sqlResultSetExpression;
        String string = SqlNamesGenerator.suggestAliasName((SqlExpression)expression);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"suggestAliasName(...)");
        String aliasName = string;
        SqlQueryExpression sqlQueryExpression = SqlPsiElementFactory.createQueryExpressionFromText("select * from (" + expression.getText() + ") " + aliasName, (SqlLanguageDialect)SqlImplUtil.getSqlDialectSafe((PsiElement)expression), project);
        if (sqlQueryExpression == null) {
            return;
        }
        SqlQueryExpression outerQuery = sqlQueryExpression;
        PsiElement psiElement2 = expression.replace((PsiElement)outerQuery);
        SqlQueryExpression sqlQueryExpression2 = psiElement2 instanceof SqlQueryExpression ? (SqlQueryExpression)psiElement2 : null;
        if (sqlQueryExpression2 == null) {
            return;
        }
        SqlQueryExpression newQuery = sqlQueryExpression2;
        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor2.getDocument());
        CodeStyleManager.getInstance((Project)project).reformat((PsiElement)newQuery);
        SqlTableExpression sqlTableExpression = newQuery.getTableExpression();
        SqlExpression sqlExpression2 = sqlExpression = sqlTableExpression != null && (sqlTableExpression = sqlTableExpression.getFromClause()) != null ? sqlTableExpression.getFromExpression() : null;
        SqlAsExpression sqlAsExpression = sqlExpression instanceof SqlAsExpression ? (SqlAsExpression)sqlExpression : null;
        if (sqlAsExpression == null || (sqlAsExpression = sqlAsExpression.getNameElement()) == null) {
            return;
        }
        SqlAsExpression aliasNameElement = sqlAsExpression;
        editor2.getCaretModel().moveToOffset(aliasNameElement.getNameRange().getStartOffset() + PsiTreeUtilKt.getStartOffset((PsiElement)((PsiElement)aliasNameElement)));
        if (!this.isPreview) {
            DataContext dataContext = DataManager.getInstance().getDataContext((Component)editor2.getComponent());
            Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
            DataContext dataContext2 = dataContext;
            RenameHandler renameHandler = RenameHandlerRegistry.getInstance().getRenameHandler(dataContext2);
            if (renameHandler == null) {
                return;
            }
            RenameHandler renameHandler2 = renameHandler;
            renameHandler2.invoke(project, editor2, newQuery.getContainingFile(), dataContext2);
        }
    }

    @JvmOverloads
    public SqlConvertToSubqueryIntention() {
        this(false, 1, null);
    }
}

