/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.SqlNamesGenerator;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.RenamePsiFix;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u000f"}, d2={"Lcom/intellij/sql/inspections/SqlMissingColumnAliasesInspection;", "Lcom/intellij/sql/inspections/SqlInspectionBase;", "()V", "createAnnotationVisitor", "Lcom/intellij/sql/inspections/SqlInspectionBase$SqlAnnotationVisitor;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "result", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "onTheFly", "", "IntroduceAliasFix", "intellij.database.sql.impl"})
public final class SqlMissingColumnAliasesInspection
extends SqlInspectionBase {
    @Override
    @NotNull
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result2, boolean onTheFly) {
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result2, onTheFly){
            final /* synthetic */ boolean $onTheFly;
            {
                this.$onTheFly = $onTheFly;
                super($manager, $dialect, (Collection<ProblemDescriptor>)$result);
            }

            public void visitSqlSelectClause(@NotNull SqlSelectClause o2) {
                Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
                super.visitSqlSelectClause(o2);
                for (SqlExpression expression : o2.getExpressions()) {
                    if (expression instanceof SqlAsExpression || expression instanceof SqlReferenceExpression) continue;
                    LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{IntroduceAliasFix.Companion.getINSTANCE()};
                    this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)expression, SqlBundle.message((String)"inspection.message.missing.column.alias", (Object[])new Object[0]), true, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.$onTheFly, localQuickFixArray));
                }
            }
        };
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\nH\u0016J\u0012\u0010\u000e\u001a\f0\u000f\u00a2\u0006\u0002\b\u0010\u00a2\u0006\u0002\b\u0011H\u0016J!\u0010\u0012\u001a\u0002H\u0013\"\u0004\b\u0000\u0010\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0015H\u0002\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u0017\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/sql/inspections/SqlMissingColumnAliasesInspection$IntroduceAliasFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "isPreview", "", "(Z)V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "previewDescriptor", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "runWriteActionOrPreview", "T", "runnable", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "startInWriteAction", "Companion", "intellij.database.sql.impl"})
    private static final class IntroduceAliasFix
    implements LocalQuickFix {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final boolean isPreview;
        @NotNull
        private static final IntroduceAliasFix INSTANCE = new IntroduceAliasFix(false);
        @NotNull
        private static final IntroduceAliasFix PREVIEW_INSTANCE = new IntroduceAliasFix(true);

        private IntroduceAliasFix(boolean isPreview) {
            this.isPreview = isPreview;
        }

        @NotNull
        public String getFamilyName() {
            String string = SqlBundle.message((String)"intention.family.name.introduce.alias", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        public boolean startInWriteAction() {
            return this.isPreview;
        }

        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)previewDescriptor, (String)"previewDescriptor");
            PREVIEW_INSTANCE.applyFix(project, previewDescriptor);
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.DIFF;
            Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"DIFF");
            return intentionPreviewInfo;
        }

        private final <T> T runWriteActionOrPreview(Function0<? extends T> runnable) {
            return (T)(this.isPreview ? runnable.invoke() : ActionsKt.runWriteAction(runnable));
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement = descriptor2.getStartElement();
            SqlExpression sqlExpression = psiElement instanceof SqlExpression ? (SqlExpression)psiElement : null;
            if (sqlExpression == null) {
                return;
            }
            SqlExpression expression = sqlExpression;
            PsiFile file = expression.getContainingFile();
            SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe((PsiElement)file);
            Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialectEx, (String)"getSqlDialectSafe(...)");
            SqlLanguageDialectEx dialect = sqlLanguageDialectEx;
            String string = SqlNamesGenerator.suggestAliasName(expression);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"suggestAliasName(...)");
            String aliasName = string;
            String string2 = new DdlBuilder().configureBuilder(project, dialect).withDialect(dialect.getDatabaseDialect()).plain(expression.getText()).keyword(" as ").alias(aliasName).getStatement();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getStatement(...)");
            String aliasExprText = string2;
            Object t = this.runWriteActionOrPreview((Function0)new Function0<PsiElement>(expression, aliasExprText, dialect){
                final /* synthetic */ SqlExpression $expression;
                final /* synthetic */ String $aliasExprText;
                final /* synthetic */ SqlLanguageDialectEx $dialect;
                {
                    this.$expression = $expression;
                    this.$aliasExprText = $aliasExprText;
                    this.$dialect = $dialect;
                    super(0);
                }

                public final PsiElement invoke() {
                    SqlExpression sqlExpression = SqlPsiElementFactory.createColumnAliasFromText(this.$aliasExprText, this.$dialect, (PsiElement)this.$expression);
                    Intrinsics.checkNotNull((Object)sqlExpression);
                    return this.$expression.replace((PsiElement)sqlExpression);
                }
            });
            SqlAsExpression sqlAsExpression = t instanceof SqlAsExpression ? (SqlAsExpression)t : null;
            if (sqlAsExpression == null) {
                return;
            }
            SqlAsExpression aliasExpression2 = sqlAsExpression;
            if (!this.isPreview) {
                PsiDocumentManager docManager = PsiDocumentManager.getInstance((Project)project);
                Document document = docManager.getDocument(file);
                if (document == null) {
                    return;
                }
                Document doc = document;
                docManager.commitDocument(doc);
                docManager.doPostponedOperationsAndUnblockDocument(doc);
                SqlIdentifier sqlIdentifier = aliasExpression2.getNameElement();
                if (sqlIdentifier == null) {
                    return;
                }
                RenamePsiFix.INSTANCE.applyFix((PsiElement)sqlIdentifier);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/sql/inspections/SqlMissingColumnAliasesInspection$IntroduceAliasFix$Companion;", "", "()V", "INSTANCE", "Lcom/intellij/sql/inspections/SqlMissingColumnAliasesInspection$IntroduceAliasFix;", "getINSTANCE", "()Lcom/intellij/sql/inspections/SqlMissingColumnAliasesInspection$IntroduceAliasFix;", "PREVIEW_INSTANCE", "intellij.database.sql.impl"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final IntroduceAliasFix getINSTANCE() {
                return INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

