/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.formatting.Block;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.sql.formatter.model.BlockShape;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlFormattingContext;
import com.intellij.sql.formatter.model.SqlFormattingModelFun;
import com.intellij.sql.formatter.model.SqlSingleNodeBlock;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\t\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0006\u0010/\u001a\u000200J\b\u00101\u001a\u000200H$J\u0010\u00102\u001a\u00020\u00052\u0006\u00103\u001a\u000204H\u0016J\b\u00105\u001a\u00020\u000bH\u0016J\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u001d07J\b\u00108\u001a\u000200H\u0016J\b\u00109\u001a\u00020\u0005H\u0016J\b\u0010:\u001a\u000200H$J\u001d\u0010;\u001a\u0002002\u0006\u0010&\u001a\u00020\u00012\u0006\u0010<\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b=J\b\u0010>\u001a\u00020\u0005H\u0016J\b\u0010?\u001a\u00020\u0005H\u0016R$\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR$\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u000b@TX\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0015\u001a\u0004\u0018\u00010\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R$\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\b\"\u0004\b\u001a\u0010\nR\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0016\u0010 \u001a\u0004\u0018\u00010\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0017R\u0014\u0010\"\u001a\u00020#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R$\u0010&\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0001@TX\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u0017\"\u0004\b(\u0010)R\u001c\u0010*\u001a\n ,*\u0004\u0018\u00010+0+8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010.\u00a8\u0006@"}, d2={"Lcom/intellij/sql/formatter/model/SqlInjectionHostBlock;", "Lcom/intellij/sql/formatter/model/SqlBlock;", "Lcom/intellij/sql/formatter/model/SqlSingleNodeBlock;", "()V", "<set-?>", "", "analyzed", "getAnalyzed", "()Z", "setAnalyzed", "(Z)V", "Lcom/intellij/lang/ASTNode;", "blockNode", "getBlockNode", "()Lcom/intellij/lang/ASTNode;", "setBlockNode", "(Lcom/intellij/lang/ASTNode;)V", "context", "Lcom/intellij/sql/formatter/model/SqlFormattingContext;", "getContext", "()Lcom/intellij/sql/formatter/model/SqlFormattingContext;", "firstNestedSqlBlock", "getFirstNestedSqlBlock", "()Lcom/intellij/sql/formatter/model/SqlBlock;", "grown", "getGrown", "setGrown", "injectedBlocks", "", "Lcom/intellij/formatting/Block;", "getInjectedBlocks", "()Ljava/util/List;", "lastNestedSqlBlock", "getLastNestedSqlBlock", "minLength", "", "getMinLength", "()I", "parent", "getParent", "setParent", "(Lcom/intellij/sql/formatter/model/SqlBlock;)V", "range", "Lcom/intellij/openapi/util/TextRange;", "kotlin.jvm.PlatformType", "getRange", "()Lcom/intellij/openapi/util/TextRange;", "analyze", "", "analyzeInjectedContent", "contains", "char", "", "getNode", "getSubBlocks", "", "grow", "isLeaf", "makeInjectionBlocks", "setup", "node", "setup$intellij_database_sql_core_impl", "tailCompleted", "tailFormed", "intellij.database.sql.core.impl"})
public abstract class SqlInjectionHostBlock
extends SqlBlock
implements SqlSingleNodeBlock {
    protected SqlBlock parent;
    protected ASTNode blockNode;
    @NotNull
    private final List<Block> injectedBlocks = new ArrayList();
    private boolean analyzed;
    private boolean grown;

    public SqlInjectionHostBlock() {
        super(null);
    }

    @Override
    @NotNull
    public SqlBlock getParent() {
        SqlBlock sqlBlock = this.parent;
        if (sqlBlock != null) {
            return sqlBlock;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"parent");
        return null;
    }

    protected void setParent(@NotNull SqlBlock sqlBlock) {
        Intrinsics.checkNotNullParameter((Object)sqlBlock, (String)"<set-?>");
        this.parent = sqlBlock;
    }

    @Override
    @NotNull
    public SqlFormattingContext getContext() {
        return this.getParent().getContext();
    }

    @Override
    @NotNull
    public ASTNode getBlockNode() {
        ASTNode aSTNode = this.blockNode;
        if (aSTNode != null) {
            return aSTNode;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"blockNode");
        return null;
    }

    protected void setBlockNode(@NotNull ASTNode aSTNode) {
        Intrinsics.checkNotNullParameter((Object)aSTNode, (String)"<set-?>");
        this.blockNode = aSTNode;
    }

    @NotNull
    protected final List<Block> getInjectedBlocks() {
        return this.injectedBlocks;
    }

    public final boolean getAnalyzed() {
        return this.analyzed;
    }

    protected final void setAnalyzed(boolean bl) {
        this.analyzed = bl;
    }

    public final boolean getGrown() {
        return this.grown;
    }

    protected final void setGrown(boolean bl) {
        this.grown = bl;
    }

    public final void setup$intellij_database_sql_core_impl(@NotNull SqlBlock parent2, @NotNull ASTNode node2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        boolean bl2 = bl = !Intrinsics.areEqual((Object)parent2, (Object)this);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.setParent(parent2);
        this.setBlockNode(node2);
        this.setShape(BlockShape.DECIDE_LATER);
    }

    @Override
    public void grow() {
        if (this.grown) {
            return;
        }
        this.grown = true;
        this.makeInjectionBlocks();
    }

    @Override
    public final void analyze() {
        if (this.analyzed) {
            return;
        }
        this.analyzed = true;
        this.setHasUserBreaks(this.contains('\n'));
        this.analyzeInjectedContent();
    }

    protected abstract void makeInjectionBlocks();

    protected abstract void analyzeInjectedContent();

    @Override
    @NotNull
    public ASTNode getNode() {
        return this.getBlockNode();
    }

    @Override
    public TextRange getRange() {
        return this.getBlockNode().getTextRange();
    }

    @Override
    public int getMinLength() {
        return this.getBlockNode().getTextLength();
    }

    @Override
    @NotNull
    public final List<Block> getSubBlocks() {
        this.grow();
        return this.injectedBlocks;
    }

    @Override
    @Nullable
    public SqlBlock getFirstNestedSqlBlock() {
        return null;
    }

    @Override
    @Nullable
    public SqlBlock getLastNestedSqlBlock() {
        return null;
    }

    @Override
    public boolean contains(char c2) {
        SqlFormattingContext sqlFormattingContext = this.getContext();
        TextRange textRange = this.getBlockNode().getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
        return sqlFormattingContext.textContains(textRange, c2);
    }

    public boolean isLeaf() {
        return this.grown ? this.injectedBlocks.isEmpty() : !SqlFormattingModelFun.hasInjection(this.getBlockNode());
    }

    @Override
    public boolean tailFormed() {
        return true;
    }

    @Override
    public boolean tailCompleted() {
        return true;
    }
}

