/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.psi.codeStyle.lineIndent.LineIndentProvider;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.formatter.model.AdjacentBlocks;
import com.intellij.sql.formatter.model.BlockRole;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlErrorFlowBlock;
import com.intellij.sql.formatter.model.SqlFileBlockKt;
import com.intellij.sql.formatter.model.SqlFlowBlock;
import com.intellij.sql.formatter.model.SqlFormattingContext;
import com.intellij.sql.formatter.model.SqlFormattingFunKt;
import com.intellij.sql.formatter.model.SqlNodeBlock;
import com.intellij.sql.psi.IsExternal;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlTokenType;
import com.intellij.sql.psi.SqlTokens;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\b\u0010\u0012\u001a\u00020\tH\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0016\u00a8\u0006\u001c"}, d2={"Lcom/intellij/sql/formatter/model/SqlFileBlock;", "Lcom/intellij/sql/formatter/model/SqlNodeBlock;", "()V", "decideSpacing", "Lcom/intellij/formatting/Spacing;", "block1", "Lcom/intellij/sql/formatter/model/SqlBlock;", "block2", "defaultChildIndent", "Lcom/intellij/formatting/Indent;", "block", "determinePostgresSpecialRole", "Lcom/intellij/sql/formatter/model/BlockRole;", "node", "Lcom/intellij/lang/ASTNode;", "determineRole", "getAlignment", "Lcom/intellij/formatting/Alignment;", "getIndent", "getNewLineIndent", "", "blocks", "Lcom/intellij/sql/formatter/model/AdjacentBlocks;", "getWrap", "Lcom/intellij/formatting/Wrap;", "makeSpacingBeforeDelimiter", "userBreakFirstElement", "", "intellij.database.sql.core.impl"})
public final class SqlFileBlock
extends SqlNodeBlock {
    public SqlFileBlock() {
        this.setMyWrap(Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false));
    }

    @Override
    @NotNull
    public BlockRole determineRole(@NotNull ASTNode node2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        IElementType iElementType = node2.getElementType();
        return ((Intrinsics.areEqual((Object)iElementType, (Object)SqlCommonTokens.SQL_SEMICOLON) ? true : Intrinsics.areEqual((Object)iElementType, (Object)SqlTokens.ORAP_SLASH_DELIMITER_TOKEN)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)SqlCommonTokens.PG_COPY_TERMINATOR)) ? BlockRole.DELIMITER : ((Intrinsics.areEqual((Object)iElementType, (Object)SqlCommonTokens.SQL_OP_DIV) ? true : Intrinsics.areEqual((Object)iElementType, (Object)SqlCommonKeywords.SQL_GO)) ? BlockRole.DELIMITER : ((Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_INJECTABLE_RAW_INPUT) ? true : Intrinsics.areEqual((Object)iElementType, (Object)SqlTokens.SQL_RAW_INPUT)) ? BlockRole.AMENDMENT : (CollectionsKt.contains((Iterable)SqlFormattingFunKt.getCOMMENT_TYPES(), (Object)iElementType) ? super.determineRole(node2) : (iElementType instanceof IsExternal ? this.determinePostgresSpecialRole(node2) : (iElementType instanceof SqlTokenType.Synthetic ? BlockRole.UNKNOWN : BlockRole.ELEMENT)))));
    }

    /*
     * Enabled aggressive block sorting
     */
    private final BlockRole determinePostgresSpecialRole(ASTNode node2) {
        BlockRole blockRole;
        if (node2.getTextLength() < 80) {
            String string = node2.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            if (StringsKt.startsWith$default((CharSequence)string, (char)'\\', (boolean)false, (int)2, null)) {
                blockRole = BlockRole.PREFIX;
                return blockRole;
            }
        }
        blockRole = BlockRole.AMENDMENT;
        return blockRole;
    }

    @Override
    public boolean userBreakFirstElement() {
        return true;
    }

    @Override
    @Nullable
    public Spacing decideSpacing(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
        Intrinsics.checkNotNullParameter((Object)block1, (String)"block1");
        Intrinsics.checkNotNullParameter((Object)block2, (String)"block2");
        BlockRole r1 = block1.getRole();
        BlockRole r2 = block2.getRole();
        return r2 == BlockRole.DELIMITER ? this.makeSpacingBeforeDelimiter(block2) : (r1 == BlockRole.PREFIX || r1 == BlockRole.AMENDMENT || r2 == BlockRole.AMENDMENT ? this.getContext().makeAutoSpacing(true) : (r1 == BlockRole.DELIMITER ? SqlFileBlockKt.makeSpacingBetweenStatements(this.getContext()) : (r2 == BlockRole.ELEMENT ? SqlFileBlockKt.makeSpacingBetweenStatements(this.getContext()) : (r1 == BlockRole.UNKNOWN || r2 == BlockRole.UNKNOWN ? this.getContext().makeAutoSpacing(true) : Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)true, (int)3)))));
    }

    private final Spacing makeSpacingBeforeDelimiter(SqlBlock block2) {
        return SqlFileBlockKt.makeSpacingBeforeStatementDelimiter(this.getContext(), block2);
    }

    @Override
    @NotNull
    public Indent defaultChildIndent(@NotNull SqlBlock block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        return SqlFormattingFunKt.getNONE_INDENT();
    }

    @Override
    @Nullable
    public String getNewLineIndent(@NotNull AdjacentBlocks blocks) {
        Intrinsics.checkNotNullParameter((Object)blocks, (String)"blocks");
        SqlBlock block1 = blocks.getBlock1();
        return block1 == null ? "" : (block1.getRole() == BlockRole.DELIMITER ? "" : (block1 instanceof SqlFlowBlock ? (block1 instanceof SqlErrorFlowBlock ? SqlFormattingContext.currIndentOf$default(this.getContext(), block1, true, false, false, 12, null) : (((SqlFlowBlock)block1).tailFormed() ? SqlFormattingContext.currIndentOf$default(this.getContext(), block1, true, false, false, 12, null) : ((SqlFlowBlock)block1).getNewLineIndent(new AdjacentBlocks(((SqlFlowBlock)block1).getLastNestedSqlBlock(), null)))) : LineIndentProvider.DO_NOT_ADJUST));
    }

    @Override
    @Nullable
    public Wrap getWrap() {
        return this.getMyWrap();
    }

    @Override
    @NotNull
    public Indent getIndent() {
        return SqlFormattingFunKt.getNONE_INDENT();
    }

    @Override
    @Nullable
    public Alignment getAlignment() {
        return null;
    }
}

