/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.formatter.Change;
import com.intellij.sql.formatter.SqlPreFormatHelper;
import com.intellij.sql.formatter.SqlQueryPreFormatter;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import java.util.Collection;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J\u000e\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/sql/formatter/SqlQueryPreFormatter;", "", "settings", "Lcom/intellij/sql/formatter/settings/SqlCodeStyleSettings;", "changes", "", "Lcom/intellij/sql/formatter/Change;", "(Lcom/intellij/sql/formatter/settings/SqlCodeStyleSettings;Ljava/util/Collection;)V", "AS", "", "comma1st", "", "commaLast", "commaPosition", "", "commaProcessing", "useAsWord", "processClauseAS", "", "queryElement", "Lcom/intellij/psi/PsiElement;", "asExpressionElement", "processQuery", "processQueryForCommas", "processQueryForKeywordAS", "intellij.database.sql.core.impl"})
@SourceDebugExtension(value={"SMAP\nSqlQueryPreFormatter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlQueryPreFormatter.kt\ncom/intellij/sql/formatter/SqlQueryPreFormatter\n+ 2 SqlUtilFun.kt\ncom/intellij/sql/SqlUtilFun\n+ 3 BooleanFun.kt\ncom/intellij/database/util/common/BooleanFun\n*L\n1#1,127:1\n248#2:128\n14#3:129\n*S KotlinDebug\n*F\n+ 1 SqlQueryPreFormatter.kt\ncom/intellij/sql/formatter/SqlQueryPreFormatter\n*L\n42#1:128\n72#1:129\n*E\n"})
public final class SqlQueryPreFormatter {
    @NotNull
    private final Collection<Change> changes;
    private final int useAsWord;
    @Nullable
    private final String AS;
    private final int commaPosition;
    private final boolean comma1st;
    private final boolean commaLast;
    private final boolean commaProcessing;

    /*
     * WARNING - void declaration
     */
    public SqlQueryPreFormatter(@NotNull SqlCodeStyleSettings settings, @NotNull Collection<Change> changes) {
        void what$iv;
        void $this$change$iv;
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        this.changes = changes;
        this.useAsWord = settings.SELECT_USE_AS_WORD;
        this.AS = switch (settings.KEYWORD_CASE) {
            case 1 -> "as";
            case 2 -> "AS";
            case 5 -> "As";
            default -> null;
        };
        int n = settings.SELECT_EL_COMMA;
        int n3 = -1;
        int with$iv = settings.QUERY_EL_COMMA;
        boolean $i$f$change = false;
        this.commaPosition = $this$change$iv == what$iv ? with$iv : n;
        this.comma1st = this.commaPosition == 1;
        this.commaLast = this.commaPosition == 2;
        this.commaProcessing = this.comma1st || this.commaLast;
    }

    public final void processQuery(@NotNull PsiElement queryElement) {
        Intrinsics.checkNotNullParameter((Object)queryElement, (String)"queryElement");
        if (this.useAsWord > 0) {
            this.processQueryForKeywordAS(queryElement);
        }
        if (this.commaProcessing) {
            this.processQueryForCommas(queryElement);
        }
    }

    private final void processQueryForKeywordAS(PsiElement queryElement) {
        for (PsiElement e2 = queryElement.getFirstChild(); e2 != null; e2 = e2.getNextSibling()) {
            if (PsiTreeUtilKt.getElementType((PsiElement)e2) != SqlCompositeElementTypes.SQL_AS_EXPRESSION) continue;
            this.processClauseAS(queryElement, e2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void processClauseAS(PsiElement queryElement, PsiElement asExpressionElement) {
        PsiElement psiElement = asExpressionElement.getFirstChild();
        if (psiElement == null) {
            return;
        }
        PsiElement firstChild = psiElement;
        switch (this.useAsWord) {
            case 1: {
                boolean bl;
                Function1[] function1Array = new Function1[]{processClauseAS.s.1.INSTANCE, processClauseAS.s.2.INSTANCE};
                PsiElement[] s2 = SqlPreFormatHelper.findSubSequence(firstChild, function1Array);
                if (s2 == null) break;
                boolean bl2 = bl = s2.length == 2;
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                Object object = this.AS;
                if (object == null) {
                    void _true_$iv;
                    void $this$choose$iv;
                    boolean bl3 = SqlPreFormatHelper.whetherKeywordsUpper(queryElement);
                    String string = "AS";
                    String _false_$iv = "as";
                    boolean $i$f$choose = false;
                    object = $this$choose$iv != false ? _true_$iv : _false_$iv;
                }
                String word = object;
                Change change = Change.Companion.insert(s2[1].getTextRange().getStartOffset(), word + " ");
                this.changes.add(change);
                break;
            }
            case 2: {
                Function1[] word = new Function1[]{processClauseAS.s.3.INSTANCE, processClauseAS.s.4.INSTANCE, processClauseAS.s.5.INSTANCE};
                PsiElement[] s3 = SqlPreFormatHelper.findSubSequence(firstChild, word);
                if (s3 == null) break;
                boolean bl = word = s3.length == 3;
                if (_Assertions.ENABLED && !word) {
                    String change = "Assertion failed";
                    throw new AssertionError((Object)change);
                }
                TextRange r = s3[1].getTextRange();
                Intrinsics.checkNotNull((Object)r);
                Change change = Change.Companion.delete(r);
                this.changes.add(change);
            }
        }
    }

    private final void processQueryForCommas(PsiElement queryElement) {
        block6: {
            Object ch12;
            PsiElement[] s2;
            PsiElement begin;
            block5: {
                Function1[] function1Array;
                PsiElement[] s3;
                PsiElement psiElement = queryElement.getFirstChild();
                if (psiElement == null) {
                    return;
                }
                begin = psiElement;
                if (!this.comma1st) break block5;
                while ((s3 = SqlPreFormatHelper.findSubSequence(begin, function1Array = new Function1[]{processQueryForCommas.s.1.INSTANCE, processQueryForCommas.s.2.INSTANCE, processQueryForCommas.s.3.INSTANCE, processQueryForCommas.s.4.INSTANCE})) != null) {
                    boolean bl;
                    boolean bl2 = bl = s3.length == 4;
                    if (_Assertions.ENABLED && !bl) {
                        String string = "Assertion failed";
                        throw new AssertionError((Object)string);
                    }
                    TextRange textRange = s3[1].getTextRange();
                    Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
                    Change ch12 = Change.Companion.delete(textRange);
                    TextRange textRange2 = s3[2].getTextRange();
                    Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"getTextRange(...)");
                    Change ch2 = Change.Companion.insertAfter(textRange2, "\n,");
                    this.changes.add(ch12);
                    this.changes.add(ch2);
                    begin = s3[3];
                }
                break block6;
            }
            if (!this.commaLast) break block6;
            while ((s2 = SqlPreFormatHelper.findSubSequence(begin, ch12 = new Function1[]{processQueryForCommas.s.5.INSTANCE, processQueryForCommas.s.6.INSTANCE, processQueryForCommas.s.7.INSTANCE, processQueryForCommas.s.8.INSTANCE})) != null) {
                Object ch2;
                boolean bl = ch12 = s2.length == 4;
                if (_Assertions.ENABLED && !ch12) {
                    ch2 = "Assertion failed";
                    throw new AssertionError(ch2);
                }
                TextRange textRange = s2[1].getTextRange();
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
                ch12 = Change.Companion.insertBefore(textRange, ", ");
                TextRange textRange3 = s2[2].getTextRange();
                Intrinsics.checkNotNullExpressionValue((Object)textRange3, (String)"getTextRange(...)");
                ch2 = Change.Companion.delete(textRange3);
                this.changes.add((Change)ch12);
                this.changes.add((Change)ch2);
                begin = s2[3];
            }
        }
    }
}

