/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.editor;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.HighlightVisitor;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.editor.SqlValidatingHighlightVisitorKt;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlImplUtil;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0003J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0000H\u0016J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/sql/editor/SqlValidatingHighlightVisitor;", "Lcom/intellij/codeInsight/daemon/impl/HighlightVisitor;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "delegate", "Lcom/intellij/sql/editor/SqlValidatingHighlightVisitor$Delegate;", "analyze", "", "file", "Lcom/intellij/psi/PsiFile;", "updateWholeFile", "holder", "Lcom/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder;", "action", "Ljava/lang/Runnable;", "clone", "suitableForFile", "visit", "", "element", "Lcom/intellij/psi/PsiElement;", "Delegate", "intellij.database.sql.core.impl"})
public final class SqlValidatingHighlightVisitor
implements HighlightVisitor,
DumbAware {
    @Nullable
    private Delegate delegate;

    public boolean suitableForFile(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return file instanceof SqlFile;
    }

    public void visit(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        try {
            SqlElement sqlElement = element2 instanceof SqlElement ? (SqlElement)element2 : null;
            if (sqlElement != null) {
                sqlElement.accept((SqlVisitor)this.delegate);
            }
        }
        catch (IndexNotReadyException e2) {
            SqlValidatingHighlightVisitorKt.access$getLOG$p().error((Throwable)e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean analyze(@NotNull PsiFile file, boolean updateWholeFile, @NotNull HighlightInfoHolder holder, @NotNull Runnable action) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        this.delegate = SqlImplUtil.getSqlDialectSafe((PsiElement)file).createValidationDelegate(holder);
        try {
            action.run();
        }
        finally {
            this.delegate = null;
        }
        return true;
    }

    @NotNull
    public SqlValidatingHighlightVisitor clone() {
        return new SqlValidatingHighlightVisitor();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0004J.\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0001\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0004J&\u0010\u0017\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0001\u0010\u0011\u001a\u00020\u00122\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0004J&\u0010\u0018\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0001\u0010\u0011\u001a\u00020\u00122\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0019"}, d2={"Lcom/intellij/sql/editor/SqlValidatingHighlightVisitor$Delegate;", "Lcom/intellij/sql/psi/SqlVisitor;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "holder", "Lcom/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder;", "(Lcom/intellij/sql/dialects/SqlLanguageDialectEx;Lcom/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder;)V", "getDialect", "()Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "getHolder", "()Lcom/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder;", "report", "", "info", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfo;", "element", "Lcom/intellij/psi/PsiElement;", "message", "", "infoType", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfoType;", "fix", "Lcom/intellij/codeInsight/intention/IntentionAction;", "reportError", "reportWarning", "intellij.database.sql.core.impl"})
    public static abstract class Delegate
    extends SqlVisitor {
        @NotNull
        private final SqlLanguageDialectEx dialect;
        @NotNull
        private final HighlightInfoHolder holder;

        public Delegate(@NotNull SqlLanguageDialectEx dialect, @NotNull HighlightInfoHolder holder) {
            Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            this.dialect = dialect;
            this.holder = holder;
        }

        @NotNull
        protected final SqlLanguageDialectEx getDialect() {
            return this.dialect;
        }

        @NotNull
        protected final HighlightInfoHolder getHolder() {
            return this.holder;
        }

        protected final void report(@NotNull HighlightInfo info2) {
            Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
            this.holder.add(info2);
        }

        protected final void report(@NotNull PsiElement element2, @InspectionMessage @NotNull String message2, @NotNull HighlightInfoType infoType, @Nullable IntentionAction fix) {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            Intrinsics.checkNotNullParameter((Object)infoType, (String)"infoType");
            HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo((HighlightInfoType)infoType).range(element2).descriptionAndTooltip(message2);
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"descriptionAndTooltip(...)");
            HighlightInfo.Builder builder2 = builder;
            if (fix != null) {
                builder2.registerFix(fix, CollectionsKt.emptyList(), fix.getFamilyName(), null, null);
            }
            HighlightInfo highlightInfo = builder2.create();
            if (highlightInfo == null) {
                return;
            }
            HighlightInfo info2 = highlightInfo;
            this.report(info2);
        }

        public static /* synthetic */ void report$default(Delegate delegate, PsiElement psiElement, String string, HighlightInfoType highlightInfoType, IntentionAction intentionAction, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: report");
            }
            if ((n & 8) != 0) {
                intentionAction = null;
            }
            delegate.report(psiElement, string, highlightInfoType, intentionAction);
        }

        protected final void reportError(@NotNull PsiElement element2, @InspectionMessage @NotNull String message2, @Nullable IntentionAction fix) {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            HighlightInfoType highlightInfoType = HighlightInfoType.ERROR;
            Intrinsics.checkNotNullExpressionValue((Object)highlightInfoType, (String)"ERROR");
            this.report(element2, message2, highlightInfoType, fix);
        }

        public static /* synthetic */ void reportError$default(Delegate delegate, PsiElement psiElement, String string, IntentionAction intentionAction, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: reportError");
            }
            if ((n & 4) != 0) {
                intentionAction = null;
            }
            delegate.reportError(psiElement, string, intentionAction);
        }

        protected final void reportWarning(@NotNull PsiElement element2, @InspectionMessage @NotNull String message2, @Nullable IntentionAction fix) {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            HighlightInfoType highlightInfoType = HighlightInfoType.WARNING;
            Intrinsics.checkNotNullExpressionValue((Object)highlightInfoType, (String)"WARNING");
            this.report(element2, message2, highlightInfoType, fix);
        }

        public static /* synthetic */ void reportWarning$default(Delegate delegate, PsiElement psiElement, String string, IntentionAction intentionAction, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: reportWarning");
            }
            if ((n & 4) != 0) {
                intentionAction = null;
            }
            delegate.reportWarning(psiElement, string, intentionAction);
        }
    }
}

