/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.sql92;

import com.intellij.database.script.ScriptModelUtilCore;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.base.SqlEvaluationHelperBase;
import com.intellij.sql.psi.SqlCompositeElementType;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.script.SqlScriptTraverserCreatorImpl;
import com.intellij.util.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\b0\u0007\"\b\b\u0000\u0010\b*\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\b0\u000bH\u0016J:\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\b0\r\"\b\b\u0000\u0010\b*\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0011H\u0014R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/sql/dialects/sql92/Sql92EvaluationHelper;", "Lcom/intellij/sql/dialects/base/SqlEvaluationHelperBase;", "()V", "fakeStatementElementType", "Lcom/intellij/sql/psi/SqlCompositeElementType;", "kotlin.jvm.PlatformType", "isStatement", "Lcom/intellij/openapi/util/Condition;", "V", "", "api", "Lcom/intellij/psi/SyntaxTraverser$Api;", "parse", "Lcom/intellij/psi/SyntaxTraverser;", "project", "Lcom/intellij/openapi/project/Project;", "language", "Lcom/intellij/lang/Language;", "documentText", "", "hostLanguage", "intellij.database.dialects.sql92"})
public final class Sql92EvaluationHelper
extends SqlEvaluationHelperBase {
    private final SqlCompositeElementType fakeStatementElementType = SqlCompositeElementTypes.SQL_STATEMENT;

    @Override
    @NotNull
    public <V> Condition<V> isStatement(@NotNull SyntaxTraverser.Api<V> api) {
        Intrinsics.checkNotNullParameter(api, (String)"api");
        Condition condition2 = Conditions.or(super.isStatement(api), (Condition)Conditions.compose((Function)api.TO_TYPE, (Condition)Conditions.equalTo((Object)this.fakeStatementElementType)));
        Intrinsics.checkNotNullExpressionValue((Object)condition2, (String)"or(...)");
        return condition2;
    }

    @Override
    @NotNull
    protected <V> SyntaxTraverser<V> parse(@NotNull Project project, @NotNull Language language, @NotNull CharSequence documentText, @Nullable Language hostLanguage) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)documentText, (String)"documentText");
        DatabaseSettings.SplitScriptMode splitScriptMode = DatabaseSettings.getSettings().splitScriptMode;
        if (splitScriptMode == DatabaseSettings.SplitScriptMode.ON_STATEMENTS) {
            object = super.parse(project, language, documentText, hostLanguage);
        } else {
            PsiFile psiFile = SqlPsiElementFactory.createROFileFromText(documentText, language, project, hostLanguage);
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"createROFileFromText(...)");
            PsiFile file = psiFile;
            object = SqlScriptTraverserCreatorImpl.getScriptTraverser(file, (SyntaxTraverser.ApiEx<PsiElement>)SyntaxTraverser.psiApi(), language, documentText, splitScriptMode, (IElementType)this.fakeStatementElementType);
        }
        SyntaxTraverser traverser2 = object;
        traverser2.putUserData(ScriptModelUtilCore.SPLIT_SCRIPT_MODE, (Object)splitScriptMode);
        Intrinsics.checkNotNull(traverser2, (String)"null cannot be cast to non-null type com.intellij.psi.SyntaxTraverser<V of com.intellij.sql.dialects.sql92.Sql92EvaluationHelper.parse>");
        return traverser2;
    }
}

