/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.oracle.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.dialects.oracle.types.OraTypeSystem;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.oracle.OraCanonicalSignature;
import com.intellij.sql.dialects.oracle.inspections.OraOverloadInspection;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlBlockStatement;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlParameterList;
import com.intellij.sql.psi.SqlRoutineDefinition;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u000e"}, d2={"Lcom/intellij/sql/dialects/oracle/inspections/OraOverloadInspection;", "Lcom/intellij/sql/inspections/SqlInspectionBase;", "()V", "createAnnotationVisitor", "Lcom/intellij/sql/inspections/SqlInspectionBase$SqlAnnotationVisitor;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "result", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "onTheFly", "", "intellij.database.dialects.oracle"})
public final class OraOverloadInspection
extends SqlInspectionBase {
    @Override
    @Nullable
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result2, boolean onTheFly) {
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        if (!dialect.getDbms().isOracle()) {
            return null;
        }
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result2, onTheFly){
            @NotNull
            private final OraTypeSystem typeSystem;
            final /* synthetic */ InspectionManager $manager;
            final /* synthetic */ SqlLanguageDialectEx $dialect;
            final /* synthetic */ boolean $onTheFly;
            {
                this.$manager = $manager;
                this.$dialect = $dialect;
                this.$onTheFly = $onTheFly;
                super($manager, $dialect, (Collection<ProblemDescriptor>)$result);
                DasTypeSystemBase dasTypeSystemBase = this.myDialect.getTypeSystem();
                Intrinsics.checkNotNull((Object)dasTypeSystemBase, (String)"null cannot be cast to non-null type com.intellij.database.dialects.oracle.types.OraTypeSystem");
                this.typeSystem = (OraTypeSystem)dasTypeSystemBase;
            }

            @NotNull
            public final OraTypeSystem getTypeSystem() {
                return this.typeSystem;
            }

            public void visitSqlBlockStatement(@NotNull SqlBlockStatement o2) {
                Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
                super.visitSqlBlockStatement(o2);
                this.checkRoutineGroup((SqlElement)o2);
            }

            public void visitSqlCreateStatement(@NotNull SqlCreateStatement o2) {
                Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
                super.visitSqlCreateStatement(o2);
                ObjectKind objectKind = o2.getKind();
                Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"getKind(...)");
                ObjectKind kind = objectKind;
                if (Intrinsics.areEqual((Object)kind, (Object)ObjectKind.PACKAGE) || Intrinsics.areEqual((Object)kind, (Object)ObjectKind.BODY)) {
                    this.checkRoutineGroup((SqlElement)o2);
                }
            }

            public void visitSqlFile(@NotNull SqlFile o2) {
                Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
                super.visitSqlFile(o2);
                this.checkRoutineGroup((SqlElement)o2);
            }

            /*
             * WARNING - void declaration
             */
            private final void checkRoutineGroup(SqlElement block) {
                void $this$groupByTo$iv$iv;
                void $this$groupBy$iv;
                JBIterable jBIterable = SqlImplUtil.sqlChildren((PsiElement)block).filter(SqlRoutineDefinition.class).filter(arg_0 -> createAnnotationVisitor.1.checkRoutineGroup$lambda$0(createAnnotationVisitor.checkRoutineGroup.1.INSTANCE, arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
                Iterable iterable = (Iterable)jBIterable;
                InspectionManager inspectionManager = this.$manager;
                boolean $i$f$groupBy = false;
                void var5_7 = $this$groupBy$iv;
                Map destination$iv$iv = new LinkedHashMap<K, V>();
                boolean $i$f$groupByTo = false;
                for (T element$iv$iv : $this$groupByTo$iv$iv) {
                    Object object;
                    SqlRoutineDefinition it2 = (SqlRoutineDefinition)element$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it2);
                    DasRoutine dasRoutine = (DasRoutine)it2;
                    Project project = inspectionManager.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                    OraCanonicalSignature key$iv$iv = this.typeSystem.getCanonicalSignature(dasRoutine, project);
                    Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                    boolean $i$f$getOrPut = false;
                    V value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                    if (value$iv$iv$iv == null) {
                        boolean bl2 = false;
                        List answer$iv$iv$iv = new ArrayList<E>();
                        $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                        object = answer$iv$iv$iv;
                    } else {
                        object = value$iv$iv$iv;
                    }
                    List list$iv$iv = (List)object;
                    list$iv$iv.add(element$iv$iv);
                }
                Iterable $this$forEach$iv = destination$iv$iv.values();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    List p0 = (List)element$iv;
                    boolean bl = false;
                    this.reportConflictingSignatures(p0);
                }
            }

            private final void reportConflictingSignatures(List<? extends SqlRoutineDefinition> routines) {
                if (routines.size() <= 1) {
                    return;
                }
                String message2 = SqlBundle.message((String)"inspection.message.overload.conflicting.signatures", (Object[])new Object[0]) + "\n" + CollectionsKt.joinToString$default((Iterable)routines, (CharSequence)"\n", null, null, (int)0, null, (Function1)((Function1)new Function1<SqlRoutineDefinition, CharSequence>(this.$dialect){
                    final /* synthetic */ SqlLanguageDialectEx $dialect;
                    {
                        this.$dialect = $dialect;
                        super(1);
                    }

                    @NotNull
                    public final CharSequence invoke(@NotNull SqlRoutineDefinition routine2) {
                        Intrinsics.checkNotNullParameter((Object)routine2, (String)"routine");
                        return "\t\u2022 " + DbImplUtilCore.renderRoutineHeader((DasRoutine)routine2, this.$dialect.getDbms());
                    }
                }), (int)30, null);
                for (SqlRoutineDefinition sqlRoutineDefinition : routines) {
                    PsiElement psiElement;
                    PsiElement startAnchor = sqlRoutineDefinition.getFirstChild();
                    SqlParameterList sqlParameterList = sqlRoutineDefinition.getParameterList();
                    if (sqlParameterList != null) {
                        psiElement = (PsiElement)sqlParameterList;
                    } else {
                        SqlNameElement sqlNameElement = sqlRoutineDefinition.getNameElement();
                        psiElement = sqlNameElement != null ? (PsiElement)sqlNameElement : startAnchor;
                    }
                    PsiElement endAnchor = psiElement;
                    this.addDescriptor(this.myManager.createProblemDescriptor(startAnchor, endAnchor, message2, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.$onTheFly, new LocalQuickFix[0]));
                }
            }

            private static final boolean checkRoutineGroup$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (Boolean)$tmp0.invoke(p0);
            }
        };
    }
}

