/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlDialectImplUtilCore;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqlDialectImplUtil
extends SqlDialectImplUtilCore {
    private SqlDialectImplUtil() {
    }

    @NotNull
    public static String getDialectHelpResource(Class<?> dialectClass, @NonNls String name2) throws IOException {
        String text2;
        @NonNls String resourceName = null;
        InputStream zipIs = null;
        for (Class<?> c2 = dialectClass; c2 != null; c2 = c2.getSuperclass()) {
            String specificResourceName = "help/" + SqlDialectImplUtil.getSqlDialectName(c2) + "-help.zip";
            ClassLoader loader = c2.getClassLoader();
            zipIs = loader == null ? null : loader.getResourceAsStream(specificResourceName);
            String string = resourceName = zipIs != null || resourceName == null ? specificResourceName : resourceName;
            if (zipIs != null) break;
        }
        if (zipIs == null) {
            throw new IOException(SqlBundle.message((String)"help.file.0.not.found", (Object[])new Object[]{StringUtil.notNullize(resourceName)}));
        }
        try {
            text2 = SqlDialectImplUtil.loadFileFromZip(zipIs, name2);
        }
        catch (IOException e2) {
            LOG.warn((Throwable)e2);
            throw new IOException(SqlBundle.message((String)"help.file.0.not.found", (Object[])new Object[]{name2}) + "\n" + e2.getMessage(), e2);
        }
        if (text2 == null) {
            throw new IOException(SqlBundle.message((String)"help.file.0.not.found", (Object[])new Object[]{resourceName + "!/" + name2}));
        }
        String string = text2;
        if (string == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    public static String loadFileFromZip(InputStream stream, @NonNls String fileName) throws IOException {
        if (stream == null) {
            return null;
        }
        try (ZipInputStream zip = new ZipInputStream(stream);){
            ZipEntry zipEntry = zip.getNextEntry();
            while (zipEntry != null) {
                if (zipEntry.getName().equalsIgnoreCase(fileName)) {
                    String string = new String(FileUtil.adaptiveLoadText((Reader)new InputStreamReader((InputStream)zip, StandardCharsets.UTF_8)));
                    return string;
                }
                zipEntry = zip.getNextEntry();
            }
        }
        return null;
    }

    @NotNull
    private static String getSqlDialectName(@NotNull Class<?> dialectClass) {
        if (dialectClass == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(1);
        }
        String className = dialectClass.getName();
        int endIndex = className.indexOf("Dialect");
        String string = StringUtil.toLowerCase((String)className.substring(className.lastIndexOf(46) + 1, endIndex > -1 ? endIndex : className.length()));
        if (string == null) {
            SqlDialectImplUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/SqlDialectImplUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialectClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDialectHelpResource";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/SqlDialectImplUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlDialectName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getSqlDialectName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

