/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.schemaEditor.model.DeNamespace;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.database.view.editors.DatabaseObjectEditor;
import com.intellij.database.view.models.ObjectEditorModel;
import com.intellij.database.view.ui.AbstractDbRefactoringDialog;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbObjectDialog
extends AbstractDbRefactoringDialog<DatabaseObjectEditor> {
    private final ObjectKind myKind;
    protected ObjectEditorModel<?> myObjectModel;

    public DbObjectDialog(@NotNull DatabaseEditorContext context, @NotNull ObjectKind kind) {
        if (context == null) {
            DbObjectDialog.$$$reportNull$$$0(0);
        }
        if (kind == null) {
            DbObjectDialog.$$$reportNull$$$0(1);
        }
        super(context);
        if (kind != ObjectKind.DATABASE && kind != ObjectKind.SCHEMA) {
            throw new AssertionError((Object)"Invalid kind");
        }
        this.myKind = kind;
        this.setTitle(this.getTitle(this.myRefactoring));
    }

    @Override
    @NotNull
    @NlsContexts.DialogTitle
    protected String getTitle(boolean modify) {
        String string = (modify ? DatabaseBundle.message("dialog.title.modify", new Object[0]) : DatabaseBundle.message("dialog.title.add", new Object[0])) + (this.myKind == null ? DatabaseBundle.message("dialog.title.object", new Object[0]) : StringUtil.capitalize((String)this.myKind.getPresentableName()));
        if (string == null) {
            DbObjectDialog.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void setObject(@NotNull DeObject object, boolean allowEverything) {
        if (object == null) {
            DbObjectDialog.$$$reportNull$$$0(3);
        }
        if (object.model != this.myModel || this.myKind != object.getKind()) {
            throw new AssertionError((Object)"Invalid object");
        }
        this.myObjectModel = this.myEditorModelsCache.get(object, ObjectEditorModel.class);
        DatabaseEditorCapabilities.ObjectEditorCaps caps = this.getObjectEditorCaps(!allowEverything && object.hasEdited(), this.myKind);
        if (caps == null) {
            throw new AssertionError((Object)"Unable to edit object");
        }
        this.setEditor(new DatabaseObjectEditor(this.myState, caps, this.myObjectModel));
    }

    @Nullable
    private DatabaseEditorCapabilities.ObjectEditorCaps getObjectEditorCaps(boolean existing, ObjectKind kind) {
        if (kind == ObjectKind.DATABASE) {
            return this.getContext().getSchemaEditor().getDbEditorCaps().getDatabaseEditorCaps(existing);
        }
        if (kind == ObjectKind.SCHEMA) {
            return this.getContext().getSchemaEditor().getDbEditorCaps().getSchemaEditorCaps(existing);
        }
        return null;
    }

    @Override
    protected ValidationInfo doValidate() {
        ValidationInfo info2 = ((DatabaseObjectEditor)this.myEditor).validate();
        return info2 == null ? super.doValidate() : info2;
    }

    @Override
    @Nullable
    protected String getDimensionServiceKey() {
        return this.getClass().getName();
    }

    @NotNull
    public DeObject createEmptyTemplate(@Nullable BasicElement parent2, @NotNull ObjectKind kind) {
        if (kind == null) {
            DbObjectDialog.$$$reportNull$$$0(4);
        }
        this.checkObjectInContext(parent2);
        if (kind != ObjectKind.DATABASE && kind != ObjectKind.SCHEMA) {
            throw new AssertionError((Object)"only database and schema");
        }
        DeNamespace res2 = new DeNamespace("new_" + kind.code(), kind, this.myModel);
        if (parent2 != null) {
            res2.parent = (DeNamespace)this.export(parent2, false);
        }
        if (res2.parent != null) {
            res2.parent.addLightChild(res2);
        } else {
            this.myModel.addRoot(res2);
        }
        DeNamespace deNamespace = res2;
        if (deNamespace == null) {
            DbObjectDialog.$$$reportNull$$$0(5);
        }
        return deNamespace;
    }

    public void configureForModification(@NotNull BasicElement object, boolean allowEverything) {
        if (object == null) {
            DbObjectDialog.$$$reportNull$$$0(6);
        }
        this.checkObjectInContext(object);
        this.configureForModification((DeObject)this.export(object, false), allowEverything);
    }

    public void configureForModification(@NotNull DeObject object, boolean allowEverything) {
        if (object == null) {
            DbObjectDialog.$$$reportNull$$$0(7);
        }
        if (object.model != this.myModel) {
            throw new AssertionError((Object)"Invalid object");
        }
        this.setObject(object, allowEverything);
        this.setRefactoring(true);
    }

    public void configureForCreation(@NotNull DeObject object, boolean allowEverything) {
        if (object == null) {
            DbObjectDialog.$$$reportNull$$$0(8);
        }
        this.setObject(object, allowEverything);
        ((DatabaseObjectEditor)this.myEditor).getNameEditor().selectAll();
    }

    @Nullable
    protected String getHelpId() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/ui/DbObjectDialog";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/ui/DbObjectDialog";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmptyTemplate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setObject";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createEmptyTemplate";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "configureForModification";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "configureForCreation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5 -> new IllegalStateException(string);
        };
    }
}

