/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.structure;

import com.github.benmanes.caffeine.cache.Cache;
import com.intellij.database.Dbms;
import com.intellij.database.DbmsExtension;
import com.intellij.database.dataSource.DataSourceFun;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.ModelFacade;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModRoutine;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicNamespaceOwner;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.BasicRoutine;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.HostFamily;
import com.intellij.database.model.meta.BasicMetaModel;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaProperty;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.SimpleCache;
import com.intellij.database.util.common.CollectionFun;
import com.intellij.database.util.common.MapFun;
import com.intellij.database.view.structure.DvExtraTreeNode;
import com.intellij.database.view.structure.DvFamilyDivision;
import com.intellij.database.view.structure.DvFamilyFilterDescriptor;
import com.intellij.database.view.structure.DvFamilyHierarchyDescriptor;
import com.intellij.database.view.structure.DvFamilyId;
import com.intellij.database.view.structure.DvFamilyNestDescriptor;
import com.intellij.database.view.structure.DvFamilyRelocationDescriptor;
import com.intellij.database.view.structure.DvFamilySeparationDescriptor;
import com.intellij.database.view.structure.DvFamilyUnnestDescriptor;
import com.intellij.database.view.structure.DvNestFamily;
import com.intellij.database.view.structure.DvStructureExtension;
import com.intellij.database.view.structure.DvTransformDescriptor;
import com.intellij.database.view.structure.DvTransformDescriptors;
import com.intellij.database.view.structure.DvTreeInternalFunKt;
import com.intellij.database.view.structure.DvTreeLayer;
import com.intellij.database.view.structure.DvTreeStoreyLayer;
import com.intellij.database.view.structure.DvTreeTransformLayer;
import com.intellij.database.view.structure.DvTreeTransformLayer$childrenOfElement$;
import com.intellij.database.view.structure.DvUnnestFamily;
import com.intellij.database.view.structure.DvViewOptionsFun;
import com.intellij.database.view.structure.HostFamilyKin;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.UtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 [2\u00020\u0001:\u0003[\\]B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u0018\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0014H\u0002J\u001c\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r2\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0017H\u0002J\u0018\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J4\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r2\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u001c2\u000e\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\r2\u0006\u0010\u0016\u001a\u00020!H\u0002J\u0018\u0010\"\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r2\u0006\u0010\u0016\u001a\u00020#H\u0002J\b\u0010$\u001a\u00020%H\u0016J \u0010&\u001a\u00020%2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00052\u0006\u0010*\u001a\u00020+H\u0002J\u0010\u0010,\u001a\u00020-2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u0017\u0010.\u001a\u0004\u0018\u00010-2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010/J\u001b\u00100\u001a\u0004\u0018\u00010-2\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0017H\u0002\u00a2\u0006\u0002\u00101J\u0010\u00102\u001a\u00020-2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u0010\u00103\u001a\u00020\u00062\u0006\u0010)\u001a\u00020\u0005H\u0002J\u0016\u00104\u001a\u0004\u0018\u0001052\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0017H\u0002J\u001e\u00106\u001a\u0010\u0012\u0004\u0012\u000208\u0012\u0004\u0012\u000205\u0018\u0001072\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J&\u00109\u001a\u0010\u0012\u0004\u0012\u000208\u0012\u0004\u0012\u000205\u0018\u0001072\u0006\u0010:\u001a\u00020\u00062\u0006\u0010;\u001a\u000208H\u0002J\u0010\u0010<\u001a\u00020=2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010>\u001a\u00020=2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u0010\u0010?\u001a\u00020=2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J*\u0010@\u001a\b\u0012\u0004\u0012\u00020\u001a0A2\u0006\u0010:\u001a\u00020\u00062\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u00172\u0006\u0010B\u001a\u00020CH\u0002J\u001e\u0010D\u001a\b\u0012\u0004\u0012\u00020!0\r2\u0006\u0010:\u001a\u00020\u00062\u0006\u0010E\u001a\u00020\u0012H\u0002J\u001e\u0010F\u001a\b\u0012\u0004\u0012\u00020#0\r2\u0006\u0010:\u001a\u00020\u00062\u0006\u0010E\u001a\u00020\u0012H\u0002J\u0015\u0010G\u001a\u00020%2\u0006\u0010'\u001a\u00020(H\u0010\u00a2\u0006\u0002\bHJ)\u0010I\u001a\u00020%2\u0006\u0010'\u001a\u00020(2\b\u0010J\u001a\u0004\u0018\u00010+2\b\u0010K\u001a\u0004\u0018\u00010+H\u0010\u00a2\u0006\u0002\bLJ\u001d\u0010M\u001a\u00020%2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0005H\u0010\u00a2\u0006\u0002\bNJ\r\u0010O\u001a\u00020%H\u0010\u00a2\u0006\u0002\bPJ\u0012\u0010Q\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u0012\u0010R\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J0\u0010S\u001a\"\u0012\u0004\u0012\u000208\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u000208\u0012\u0004\u0012\u00020507\u0018\u000107j\u0004\u0018\u0001`T2\u0006\u0010)\u001a\u00020\u0005H\u0002J0\u0010U\u001a\"\u0012\u0004\u0012\u000208\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u000208\u0012\u0004\u0012\u00020507\u0018\u000107j\u0004\u0018\u0001`T2\u0006\u0010)\u001a\u00020\u0005H\u0002J\u0012\u0010V\u001a\u0004\u0018\u00010\u00062\u0006\u0010)\u001a\u00020\u0005H\u0002J0\u0010W\u001a\"\u0012\u0004\u0012\u000208\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u000208\u0012\u0004\u0012\u00020507\u0018\u000107j\u0004\u0018\u0001`T2\u0006\u0010)\u001a\u00020\u0005H\u0002J\u0010\u0010X\u001a\u00020Y2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u0010\u0010Z\u001a\u00020Y2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006^"}, d2={"Lcom/intellij/database/view/structure/DvTreeTransformLayer;", "Lcom/intellij/database/view/structure/DvTreeStoreyLayer;", "()V", "dbmsContexts", "Ljava/util/HashMap;", "Lcom/intellij/database/Dbms;", "Lcom/intellij/database/view/structure/DvTreeTransformLayer$DbmsContext;", "emptyDbmsContext", "level", "", "getLevel", "()B", "childrenOf", "Lcom/intellij/util/containers/JBIterable;", "Lcom/intellij/database/model/basic/BasicNode;", "node", "childrenOfElement", "element", "Lcom/intellij/database/model/basic/BasicElement;", "childrenOfExtraTreeNode", "Lcom/intellij/database/view/structure/DvExtraTreeNode;", "childrenOfFamily", "family", "Lcom/intellij/database/model/families/HostFamily;", "childrenOfFamilyDivision", "ff", "Lcom/intellij/database/view/structure/DvFamilyDivision;", "childrenOfFamilyPartiallyRelocated", "Lcom/intellij/database/model/families/Family;", "children", "descriptor", "Lcom/intellij/database/view/structure/DvFamilyRelocationDescriptor;", "childrenOfNestFamily", "Lcom/intellij/database/view/structure/DvNestFamily;", "childrenOfUnnestFamily", "Lcom/intellij/database/view/structure/DvUnnestFamily;", "clearAll", "", "clearCachesForDataSource", "dataSource", "Lcom/intellij/database/model/RawDataSource;", "dbms", "model", "Lcom/intellij/database/model/basic/BasicModel;", "countAllChildrenOf", "", "countChildrenOf", "(Lcom/intellij/database/model/basic/BasicNode;)Ljava/lang/Integer;", "countChildrenOfFamily", "(Lcom/intellij/database/model/families/HostFamily;)Ljava/lang/Integer;", "countRealChildrenOf", "ensureDbmsContext", "findDescriptorForFamily", "Lcom/intellij/database/view/structure/DvTransformDescriptor;", "getDescriptorsOfElement", "", "Lcom/intellij/database/model/ObjectKind;", "getHostTransformDescriptorsFor", "ctx", "hostKind", "ifAlwaysLeafElement", "", "ifAlwaysLeafOther", "isAlwaysLeaf", "obtainFamilyDivisions", "", "fsd", "Lcom/intellij/database/view/structure/DvFamilySeparationDescriptor;", "obtainNestFamilies", "host", "obtainUnnestFamilies", "onDataSourceChanged", "onDataSourceChanged$intellij_database_core_impl", "onDataSourceModelReplaced", "oldModel", "newModel", "onDataSourceModelReplaced$intellij_database_core_impl", "onDataSourceRemoved", "onDataSourceRemoved$intellij_database_core_impl", "onViewOptionsChanged", "onViewOptionsChanged$intellij_database_core_impl", "parentOf", "parentOfElement", "prepareCommonTransformDescriptors", "Lcom/intellij/database/view/structure/DvTransformDescriptors;", "prepareCustomTransformDescriptors", "prepareDbmsContext", "prepareTransformDescriptors", "presentableNameOf", "", "presentableNameOfElement", "Companion", "DbmsContext", "Handler", "intellij.database.core.impl"})
@SourceDebugExtension(value={"SMAP\nDvTreeTransformLayer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DvTreeTransformLayer.kt\ncom/intellij/database/view/structure/DvTreeTransformLayer\n+ 2 MapFun.kt\ncom/intellij/database/util/common/MapFun\n+ 3 AnyFun.kt\ncom/intellij/database/util/common/AnyFunKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,602:1\n150#2:603\n49#3:604\n49#3:605\n1#4:606\n288#5,2:607\n1855#5,2:612\n1855#5,2:614\n179#6,2:609\n473#6:611\n*S KotlinDebug\n*F\n+ 1 DvTreeTransformLayer.kt\ncom/intellij/database/view/structure/DvTreeTransformLayer\n*L\n194#1:603\n238#1:604\n239#1:605\n246#1:607,2\n460#1:612,2\n572#1:614,2\n259#1:609,2\n337#1:611\n*E\n"})
public final class DvTreeTransformLayer
extends DvTreeStoreyLayer {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final HashMap<Dbms, DbmsContext> dbmsContexts = new HashMap(16);
    @NotNull
    private final DbmsContext emptyDbmsContext = new DbmsContext(null);
    @NotNull
    private static final Logger logger;

    @Override
    public byte getLevel() {
        return 5;
    }

    private final DbmsContext ensureDbmsContext(Dbms dbms) {
        DbmsContext ctx = this.dbmsContexts.get(dbms);
        if (ctx == null) {
            ctx = this.prepareDbmsContext(dbms);
            DbmsContext dbmsContext = ctx;
            if (dbmsContext == null) {
                dbmsContext = this.emptyDbmsContext;
            }
            ctx = dbmsContext;
            ((Map)this.dbmsContexts).put(dbms, ctx);
        }
        return ctx;
    }

    private final DbmsContext prepareDbmsContext(Dbms dbms) {
        Map<ObjectKind, Map<ObjectKind, DvTransformDescriptor>> map2 = this.prepareTransformDescriptors(dbms);
        if (map2 == null) {
            return null;
        }
        Map<ObjectKind, Map<ObjectKind, DvTransformDescriptor>> descriptors = map2;
        return new DbmsContext(descriptors);
    }

    private final Map<ObjectKind, Map<ObjectKind, DvTransformDescriptor>> prepareTransformDescriptors(Dbms dbms) {
        Map<ObjectKind, Map<ObjectKind, DvTransformDescriptor>> commonDescriptors = this.prepareCommonTransformDescriptors(dbms);
        Map<ObjectKind, Map<ObjectKind, DvTransformDescriptor>> customDescriptors = this.prepareCustomTransformDescriptors(dbms);
        Map<ObjectKind, Map<ObjectKind, DvTransformDescriptor>> descriptors = DvTransformDescriptors.orElse(customDescriptors, commonDescriptors);
        return descriptors;
    }

    private final Map<ObjectKind, Map<ObjectKind, DvTransformDescriptor>> prepareCommonTransformDescriptors(Dbms dbms) {
        Map<ObjectKind, Map<ObjectKind, DvTransformDescriptor>> descriptors = null;
        if (this.getContext().vo.getSeparateRoutines() && Handler.INSTANCE.getOurDbmsHasSeparatedProceduresAndFunctions().get(dbms).booleanValue()) {
            descriptors = Handler.INSTANCE.getOurDbmsRoutineSeparationFamilyDescriptors().get(dbms);
        }
        if (DvViewOptionsFun.getUnnestTableSubObjectsAndGroupSchemaObjects(this.getContext().vo)) {
            descriptors = DvTransformDescriptors.orElse(descriptors, Handler.INSTANCE.getOurDbmsUnnestTableSubObjectsDescriptors().get(dbms));
        }
        Map<ObjectKind, Map<ObjectKind, DvTransformDescriptor>> $this$nullize$iv = descriptors;
        boolean $i$f$nullize = false;
        Map<ObjectKind, Map<ObjectKind, DvTransformDescriptor>> map2 = $this$nullize$iv;
        return !(map2 == null || map2.isEmpty()) ? $this$nullize$iv : null;
    }

    private final Map<ObjectKind, Map<ObjectKind, DvTransformDescriptor>> prepareCustomTransformDescriptors(Dbms dbms) {
        DvStructureExtension dvStructureExtension = this.extension(dbms);
        if (dvStructureExtension == null) {
            return null;
        }
        DvStructureExtension extension = dvStructureExtension;
        Map<ObjectKind, Map<ObjectKind, DvTransformDescriptor>> descriptors = extension.getTransformDescriptors(this.getVo());
        return descriptors;
    }

    @Override
    @Nullable
    public BasicNode parentOf(@NotNull BasicNode node2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        BasicNode basicNode = node2;
        return basicNode instanceof BasicElement ? this.parentOfElement((BasicElement)node2) : (basicNode instanceof DvExtraTreeNode ? ((DvExtraTreeNode)node2).getParentNode() : this.baseParentOf(node2));
    }

    /*
     * WARNING - void declaration
     */
    private final BasicNode parentOfElement(BasicElement element2) {
        boolean skip;
        BasicNode p2 = this.baseParentOf(element2);
        if (element2 instanceof BasicNamespace || element2 instanceof BasicRoot) {
            return p2;
        }
        Object object = element2.getModel();
        if (object == null || (object = object.getDbms()) == null) {
            return null;
        }
        Object dbms = object;
        DbmsContext ctx = this.ensureDbmsContext((Dbms)dbms);
        Family<? extends BasicElement> family = element2.getParentFamily();
        HostFamily hostFamily = family instanceof HostFamily ? (HostFamily)family : null;
        if (hostFamily == null) {
            return p2;
        }
        HostFamily parentFamily = hostFamily;
        BasicElement basicElement = parentFamily.getHost();
        Intrinsics.checkNotNullExpressionValue((Object)basicElement, (String)"getHost(...)");
        BasicElement parentElement = basicElement;
        ObjectKind objectKind = parentElement.getKind();
        Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"getKind(...)");
        ObjectKind parentKind = objectKind;
        boolean bl = DbImplUtilCore.SCHEMA_KINDS.contains(parentKind) ? !this.getVo().getGroupSchemaObjects() : (skip = !this.getVo().getGroupObjectElements());
        if (skip) {
            return p2;
        }
        Map<ObjectKind, Map<ObjectKind, DvTransformDescriptor>> map2 = ctx.getTransformDescriptors();
        if (map2 == null || (map2 = map2.get(parentKind)) == null || (map2 = (DvTransformDescriptor)map2.get(element2.getKind())) == null) {
            return p2;
        }
        Map<ObjectKind, Map<ObjectKind, DvTransformDescriptor>> transformDescriptor = map2;
        Map<ObjectKind, Map<ObjectKind, DvTransformDescriptor>> map3 = transformDescriptor;
        if (map3 instanceof DvFamilySeparationDescriptor) {
            List<DvFamilyDivision> ffs = this.obtainFamilyDivisions(ctx, parentFamily, (DvFamilySeparationDescriptor)((Object)transformDescriptor));
            for (DvFamilyDivision ff : ffs) {
                if (!ff.predicate.test(element2)) continue;
                return ff;
            }
        } else if (map3 instanceof DvFamilyRelocationDescriptor) {
            HostFamily elementFamily;
            HostFamily hostFamily2 = element2.getParentFamily();
            HostFamily hostFamily3 = elementFamily = hostFamily2 instanceof HostFamily ? (HostFamily)hostFamily2 : null;
            if (elementFamily != null) {
                BasicElement $this$meets$iv;
                hostFamily2 = elementFamily;
                Predicate<BasicNode> predicate$iv = ((DvFamilyRelocationDescriptor)((Object)transformDescriptor)).getFamilyPredicate();
                boolean $i$f$meets = false;
                if (predicate$iv.test($this$meets$iv)) {
                    $this$meets$iv = element2;
                    predicate$iv = ((DvFamilyRelocationDescriptor)((Object)transformDescriptor)).getElementPredicate();
                    $i$f$meets = false;
                    if (predicate$iv.test($this$meets$iv)) {
                        DvTransformDescriptor locationDescriptor = ((DvFamilyRelocationDescriptor)((Object)transformDescriptor)).getLocationDescriptor();
                        DvTransformDescriptor dvTransformDescriptor = locationDescriptor;
                        if (dvTransformDescriptor instanceof DvFamilyUnnestDescriptor) {
                            DvUnnestFamily unnestFamily;
                            DvUnnestFamily dvUnnestFamily;
                            List<DvUnnestFamily> unnestFamilies;
                            List<DvUnnestFamily> list;
                            BasicElement grandHost;
                            HostFamilyKin locationKin = locationDescriptor.kin;
                            BasicElement basicElement2 = grandHost = ModelFun.ancestorOf(element2, locationKin.hostKind);
                            if (basicElement2 != null) {
                                BasicElement gh = basicElement2;
                                boolean bl2 = false;
                                list = DvTreeInternalFunKt.get(ctx.getUnnestFamilyCache(), gh);
                            } else {
                                list = null;
                            }
                            List<DvUnnestFamily> list2 = unnestFamilies = list;
                            if (list2 != null) {
                                Object v10;
                                block29: {
                                    List<DvUnnestFamily> list3 = list2;
                                    boolean bl3 = false;
                                    Iterable $this$firstOrNull$iv = list3;
                                    boolean $i$f$firstOrNull = false;
                                    for (Object element$iv : $this$firstOrNull$iv) {
                                        DvUnnestFamily it2 = (DvUnnestFamily)element$iv;
                                        boolean bl4 = false;
                                        if (!Intrinsics.areEqual((Object)it2.getChildrenKind(), (Object)locationKin.childrenKind)) continue;
                                        v10 = element$iv;
                                        break block29;
                                    }
                                    v10 = null;
                                }
                                dvUnnestFamily = v10;
                            } else {
                                dvUnnestFamily = null;
                            }
                            DvUnnestFamily dvUnnestFamily2 = unnestFamily = dvUnnestFamily;
                            if (dvUnnestFamily2 != null) {
                                return dvUnnestFamily2;
                            }
                        } else if (dvTransformDescriptor instanceof DvFamilyNestDescriptor) {
                            HostFamilyKin locationKin = locationDescriptor.kin;
                            DvNestFamily npFamily = DvTreeInternalFunKt.get(ctx.getNestParentFamilyCache(), element2);
                            if (npFamily == null) {
                                HostFamily sourceFamily;
                                HostFamily unnestFamily;
                                HostFamily it3 = unnestFamily = elementFamily;
                                boolean bl5 = false;
                                HostFamily hostFamily4 = sourceFamily = Intrinsics.areEqual((Object)it3.getChildrenKind(), (Object)locationKin.hostKind) ? unnestFamily : null;
                                if (sourceFamily != null) {
                                    Object v14;
                                    block30: {
                                        void $this$firstOrNull$iv;
                                        unnestFamily = SequencesKt.flattenSequenceOfIterable((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)sourceFamily), (Function1)((Function1)new Function1<BasicElement, List<? extends DvNestFamily>>(ctx){
                                            final /* synthetic */ DbmsContext $ctx;
                                            {
                                                this.$ctx = $ctx;
                                                super(1);
                                            }

                                            @Nullable
                                            public final List<DvNestFamily> invoke(BasicElement it2) {
                                                Cache<BasicElement, List<DvNestFamily>> cache2 = this.$ctx.getNestFamilyCache();
                                                Intrinsics.checkNotNull((Object)it2);
                                                return DvTreeInternalFunKt.get(cache2, it2);
                                            }
                                        })));
                                        boolean $i$f$firstOrNull = false;
                                        for (Object element$iv : $this$firstOrNull$iv) {
                                            DvNestFamily it4 = (DvNestFamily)element$iv;
                                            boolean bl6 = false;
                                            if (!(Intrinsics.areEqual((Object)it4.getChildrenKind(), (Object)locationKin.childrenKind) && (Boolean)((DvFamilyNestDescriptor)locationDescriptor).isInnerElementOf().invoke((Object)it4.host, (Object)element2) != false)) continue;
                                            v14 = element$iv;
                                            break block30;
                                        }
                                        v14 = null;
                                    }
                                    npFamily = v14;
                                    if (npFamily != null) {
                                        DvTreeInternalFunKt.set(ctx.getNestParentFamilyCache(), element2, npFamily);
                                    }
                                }
                            }
                            DvNestFamily dvNestFamily = npFamily;
                            if (dvNestFamily != null) {
                                return dvNestFamily;
                            }
                        } else if (dvTransformDescriptor instanceof DvFamilyHierarchyDescriptor) {
                            BasicNode basicNode = (BasicNode)((DvFamilyHierarchyDescriptor)locationDescriptor).getDoFindParent().invoke((Object)elementFamily, (Object)element2);
                            if (basicNode == null) {
                                basicNode = p2;
                            }
                            return basicNode;
                        }
                    }
                }
            }
        }
        return p2;
    }

    @Override
    @NotNull
    public JBIterable<? extends BasicNode> childrenOf(@NotNull BasicNode node2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        BasicNode basicNode = node2;
        return basicNode instanceof BasicElement ? this.childrenOfElement((BasicElement)node2) : (basicNode instanceof HostFamily ? this.childrenOfFamily((HostFamily)node2) : (basicNode instanceof DvFamilyDivision ? this.childrenOfFamilyDivision((DvFamilyDivision)node2) : (basicNode instanceof DvUnnestFamily ? this.childrenOfUnnestFamily((DvUnnestFamily)node2) : (basicNode instanceof DvNestFamily ? this.childrenOfNestFamily((DvNestFamily)node2) : (basicNode instanceof DvExtraTreeNode ? this.childrenOfExtraTreeNode((DvExtraTreeNode)node2) : this.getBase().childrenOf(node2))))));
    }

    private final JBIterable<? extends BasicNode> childrenOfElement(BasicElement element2) {
        JBIterable<DvNestFamily> nestFamilies;
        boolean possibleNestFamilies2;
        JBIterable<DvUnnestFamily> unnestFamilies;
        boolean possibleUnnestFamilies2;
        DvFamilyRelocationDescriptor familyRelocationDescriptor;
        DvTransformDescriptor dvTransformDescriptor;
        JBIterable children2 = this.getBase().childrenOf(element2);
        if (element2 instanceof BasicNamespaceOwner) {
            return children2;
        }
        Object object = element2.getModel();
        if (object == null || (object = object.getDbms()) == null) {
            return children2;
        }
        Object dbms = object;
        DbmsContext ctx = this.ensureDbmsContext((Dbms)dbms);
        ObjectKind objectKind = element2.getKind();
        Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"getKind(...)");
        Map<ObjectKind, DvTransformDescriptor> map2 = this.getHostTransformDescriptorsFor(ctx, objectKind);
        if (map2 == null) {
            return children2;
        }
        Map<ObjectKind, DvTransformDescriptor> descriptors = map2;
        JBIterable jBIterable = children2.flatten(arg_0 -> DvTreeTransformLayer.childrenOfElement$lambda$5((Function1)new Function1<BasicNode, Iterable<? extends BasicNode>>(descriptors, this, ctx){
            final /* synthetic */ Map<ObjectKind, DvTransformDescriptor> $descriptors;
            final /* synthetic */ DvTreeTransformLayer this$0;
            final /* synthetic */ DbmsContext $ctx;
            {
                this.$descriptors = $descriptors;
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final Iterable<BasicNode> invoke(BasicNode node2) {
                if (node2 instanceof HostFamily) {
                    DvFamilySeparationDescriptor fsd;
                    ObjectKind objectKind = ((HostFamily)node2).getChildrenKind();
                    Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"getChildrenKind(...)");
                    ObjectKind childrenKind = objectKind;
                    DvTransformDescriptor dvTransformDescriptor = this.$descriptors.get(childrenKind);
                    DvFamilySeparationDescriptor dvFamilySeparationDescriptor = fsd = dvTransformDescriptor instanceof DvFamilySeparationDescriptor ? (DvFamilySeparationDescriptor)dvTransformDescriptor : null;
                    if (fsd != null) {
                        List ffs = DvTreeTransformLayer.access$obtainFamilyDivisions(this.this$0, this.$ctx, (HostFamily)node2, fsd);
                        if (!this.this$0.getVo().getShowEmptyGroups()) {
                            void $this$filterTo$iv$iv;
                            void $this$filter$iv;
                            Iterable iterable = ffs;
                            DvTreeTransformLayer dvTreeTransformLayer = this.this$0;
                            boolean $i$f$filter = false;
                            void var8_8 = $this$filter$iv;
                            Collection destination$iv$iv = new ArrayList<E>();
                            boolean $i$f$filterTo = false;
                            for (T element$iv$iv : $this$filterTo$iv$iv) {
                                DvFamilyDivision it2 = (DvFamilyDivision)element$iv$iv;
                                boolean bl = false;
                                if (!DvTreeTransformLayer.access$childrenOfFamilyDivision(dvTreeTransformLayer, it2).isNotEmpty()) continue;
                                destination$iv$iv.add(element$iv$iv);
                            }
                            ffs = (List)destination$iv$iv;
                        }
                        return ffs;
                    }
                }
                return Collections.singleton(node2);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"flatten(...)");
        children2 = jBIterable;
        Family<? extends BasicElement> family = element2.getParentFamily();
        DvFamilyRelocationDescriptor dvFamilyRelocationDescriptor = family instanceof HostFamily ? ((dvTransformDescriptor = descriptors.get(((HostFamily)family).getHost().getKind())) instanceof DvFamilyRelocationDescriptor ? (DvFamilyRelocationDescriptor)dvTransformDescriptor : null) : (familyRelocationDescriptor = null);
        if (familyRelocationDescriptor != null) {
            DvFamilyHierarchyDescriptor hierarchyDescriptor;
            DvTransformDescriptor dvTransformDescriptor2 = familyRelocationDescriptor.getLocationDescriptor();
            DvFamilyHierarchyDescriptor dvFamilyHierarchyDescriptor = hierarchyDescriptor = dvTransformDescriptor2 instanceof DvFamilyHierarchyDescriptor ? (DvFamilyHierarchyDescriptor)dvTransformDescriptor2 : null;
            if (hierarchyDescriptor != null && Intrinsics.areEqual((Object)hierarchyDescriptor.kin.childrenKind, (Object)element2.getKind()) && family != null) {
                JBIterable successors2 = (JBIterable)hierarchyDescriptor.getDoFetchChildren().invoke(family, (Object)element2);
                JBIterable jBIterable2 = children2.append((Iterable)successors2);
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"append(...)");
                children2 = jBIterable2;
            }
        }
        if ((possibleUnnestFamilies2 = MapFun.containsValues(descriptors, childrenOfElement.possibleUnnestFamilies.1.INSTANCE)) && (unnestFamilies = this.obtainUnnestFamilies(ctx, element2)).isNotEmpty()) {
            JBIterable jBIterable3 = children2.append((Iterable)unnestFamilies);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable3, (String)"append(...)");
            children2 = jBIterable3;
        }
        if ((possibleNestFamilies2 = MapFun.containsValues(descriptors, childrenOfElement.possibleNestFamilies.1.INSTANCE)) && (nestFamilies = this.obtainNestFamilies(ctx, element2)).isNotEmpty()) {
            JBIterable jBIterable4 = children2.append((Iterable)nestFamilies);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable4, (String)"append(...)");
            children2 = jBIterable4;
        }
        Sequence $this$filterIsInstance$iv = CollectionsKt.asSequence((Iterable)descriptors.values());
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)childrenOfElement$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        Set removedFamilies2 = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)sequence, (Function1)childrenOfElement.removedFamilies.1.INSTANCE), (Function1)childrenOfElement.removedFamilies.2.INSTANCE));
        if (!((Collection)removedFamilies2).isEmpty()) {
            JBIterable jBIterable5 = children2.filter(arg_0 -> DvTreeTransformLayer.childrenOfElement$lambda$6((Function1)new Function1<BasicNode, Boolean>((Set<? extends ObjectKind>)removedFamilies2){
                final /* synthetic */ Set<ObjectKind> $removedFamilies;
                {
                    this.$removedFamilies = $removedFamilies;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(BasicNode it2) {
                    return it2 instanceof HostFamily ? !this.$removedFamilies.contains(((HostFamily)it2).getChildrenKind()) : true;
                }
            }, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable5, (String)"filter(...)");
            children2 = jBIterable5;
        }
        return children2;
    }

    private final Map<ObjectKind, DvTransformDescriptor> getHostTransformDescriptorsFor(DbmsContext ctx, ObjectKind hostKind) {
        Map<ObjectKind, Map<ObjectKind, DvTransformDescriptor>> map2 = ctx.getTransformDescriptors();
        if (map2 == null) {
            return null;
        }
        Map<ObjectKind, Map<ObjectKind, DvTransformDescriptor>> transformDescriptors = map2;
        return transformDescriptors.get(hostKind);
    }

    private final JBIterable<? extends BasicNode> childrenOfFamily(HostFamily<?> family) {
        JBIterable jBIterable;
        JBIterable children2 = this.getBase().childrenOf(family);
        if (children2.isEmpty()) {
            return children2;
        }
        DvTransformDescriptor dvTransformDescriptor = this.findDescriptorForFamily(family);
        if (dvTransformDescriptor == null) {
            return children2;
        }
        DvTransformDescriptor descriptor2 = dvTransformDescriptor;
        DvTransformDescriptor dvTransformDescriptor2 = descriptor2;
        if (dvTransformDescriptor2 instanceof DvFamilyHierarchyDescriptor) {
            jBIterable = (JBIterable)((DvFamilyHierarchyDescriptor)descriptor2).getDoFetchTopNodes().invoke(family);
        } else if (dvTransformDescriptor2 instanceof DvFamilyRelocationDescriptor) {
            jBIterable = this.childrenOfFamilyPartiallyRelocated((Family)family, children2, (DvFamilyRelocationDescriptor)descriptor2);
        } else if (dvTransformDescriptor2 instanceof DvFamilyFilterDescriptor) {
            JBIterable jBIterable2 = children2.filter(arg_0 -> DvTreeTransformLayer.childrenOfFamily$lambda$7((Function1)new Function1<BasicNode, Boolean>(descriptor2){
                final /* synthetic */ DvTransformDescriptor $descriptor;
                {
                    this.$descriptor = $descriptor;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(BasicNode it2) {
                    return it2 instanceof BasicElement && ((DvFamilyFilterDescriptor)this.$descriptor).getPredicate().test((BasicElement)it2);
                }
            }, arg_0));
            jBIterable = jBIterable2;
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"filter(...)");
        } else {
            jBIterable = children2;
        }
        return jBIterable;
    }

    private final DvTransformDescriptor findDescriptorForFamily(HostFamily<?> family) {
        BasicElement basicElement = family.getHost();
        Intrinsics.checkNotNullExpressionValue((Object)basicElement, (String)"getHost(...)");
        BasicElement host = basicElement;
        ObjectKind objectKind = host.getKind();
        Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"getKind(...)");
        ObjectKind hostKind = objectKind;
        Object object = host.getModel();
        if (object == null || (object = object.getDbms()) == null) {
            return null;
        }
        Object dbms = object;
        DbmsContext ctx = this.ensureDbmsContext((Dbms)dbms);
        Map<ObjectKind, DvTransformDescriptor> map2 = this.getHostTransformDescriptorsFor(ctx, hostKind);
        if (map2 == null) {
            return null;
        }
        Map<ObjectKind, DvTransformDescriptor> descriptors = map2;
        DvTransformDescriptor descriptor2 = descriptors.get(family.getChildrenKind());
        return descriptor2;
    }

    private final JBIterable<? extends BasicNode> childrenOfFamilyPartiallyRelocated(Family<?> family, JBIterable<? extends BasicNode> children2, DvFamilyRelocationDescriptor descriptor2) {
        JBIterable jBIterable;
        DvTransformDescriptor ld = descriptor2.getLocationDescriptor();
        if (ld instanceof DvFamilyHierarchyDescriptor) {
            jBIterable = (JBIterable)((DvFamilyHierarchyDescriptor)ld).getDoFetchTopNodes().invoke(family);
        } else {
            JBIterable jBIterable2 = children2.filter(arg_0 -> DvTreeTransformLayer.childrenOfFamilyPartiallyRelocated$lambda$8((Function1)new Function1<BasicNode, Boolean>(descriptor2){
                final /* synthetic */ DvFamilyRelocationDescriptor $descriptor;
                {
                    this.$descriptor = $descriptor;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(BasicNode it2) {
                    return it2 instanceof BasicElement && !this.$descriptor.getElementPredicate().test((BasicElement)it2);
                }
            }, arg_0));
            jBIterable = jBIterable2;
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"filter(...)");
        }
        return jBIterable;
    }

    private final List<DvFamilyDivision> obtainFamilyDivisions(DbmsContext ctx, HostFamily<?> family, DvFamilySeparationDescriptor fsd) {
        List ffs = DvTreeInternalFunKt.get(ctx.getFdCache(), family);
        if (ffs == null) {
            List<DvFamilySeparationDescriptor.Division> filterDescriptors = fsd.getFilterDescriptors();
            ffs = new ArrayList(filterDescriptors.size());
            for (DvFamilySeparationDescriptor.Division d2 : filterDescriptors) {
                BasicElement basicElement = family.getHost();
                Intrinsics.checkNotNullExpressionValue((Object)basicElement, (String)"getHost(...)");
                DvFamilyDivision f = new DvFamilyDivision(basicElement, family, d2.orderNum, d2.displayName, d2.familyId, d2.predicate);
                ((ArrayList)ffs).add(f);
            }
            DvTreeInternalFunKt.set(ctx.getFdCache(), family, ffs);
        }
        return ffs;
    }

    private final JBIterable<? extends BasicNode> childrenOfFamilyDivision(DvFamilyDivision ff) {
        JBIterable children2 = this.getBase().childrenOf(ff.family);
        if (children2.isEmpty()) {
            JBIterable jBIterable = JBIterable.empty();
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"empty(...)");
            return jBIterable;
        }
        JBIterable jBIterable = children2.filter(arg_0 -> DvTreeTransformLayer.childrenOfFamilyDivision$lambda$9((Function1)new Function1<BasicNode, Boolean>(ff){
            final /* synthetic */ DvFamilyDivision $ff;
            {
                this.$ff = $ff;
                super(1);
            }

            @NotNull
            public final Boolean invoke(BasicNode it2) {
                return it2 instanceof BasicElement && this.$ff.predicate.test((BasicElement)it2);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
        children2 = jBIterable;
        return children2;
    }

    private final JBIterable<DvUnnestFamily> obtainUnnestFamilies(DbmsContext ctx, BasicElement host) {
        List unnestFamilies = DvTreeInternalFunKt.get(ctx.getUnnestFamilyCache(), host);
        if (unnestFamilies == null) {
            ObjectKind objectKind = host.getKind();
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"getKind(...)");
            Map<ObjectKind, DvTransformDescriptor> map2 = this.getHostTransformDescriptorsFor(ctx, objectKind);
            if (map2 == null) {
                JBIterable jBIterable = JBIterable.empty();
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"empty(...)");
                return jBIterable;
            }
            Map<ObjectKind, DvTransformDescriptor> descriptors = map2;
            ArrayList newUnnestFamilies = new ArrayList(descriptors.size());
            for (DvTransformDescriptor descriptor2 : descriptors.values()) {
                if (!(descriptor2 instanceof DvFamilyUnnestDescriptor)) continue;
                DvUnnestFamily f = new DvUnnestFamily(host, (DvFamilyUnnestDescriptor)descriptor2);
                ((Collection)newUnnestFamilies).add(f);
            }
            unnestFamilies = newUnnestFamilies;
            DvTreeInternalFunKt.set(ctx.getUnnestFamilyCache(), host, unnestFamilies);
        }
        JBIterable jBIterable = UtilKt.asJBIterable((Iterable)unnestFamilies).filter(arg_0 -> DvTreeTransformLayer.obtainUnnestFamilies$lambda$10((Function1)new Function1<DvUnnestFamily, Boolean>(this){
            final /* synthetic */ DvTreeTransformLayer this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(DvUnnestFamily it2) {
                Intrinsics.checkNotNull((Object)it2);
                return DvTreeTransformLayer.access$childrenOfUnnestFamily(this.this$0, it2).isNotEmpty();
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
        return jBIterable;
    }

    private final JBIterable<? extends BasicNode> childrenOfUnnestFamily(DvUnnestFamily family) {
        DvFamilyUnnestDescriptor descriptor2 = family.getDescriptor();
        Set<ObjectKind> nestedHostKinds = descriptor2.getNestedHostKinds();
        JBIterable jBIterable = UtilKt.asJBIterable((Iterable)family.host.getFamilies()).filter(HostFamily.class).filter(arg_0 -> DvTreeTransformLayer.childrenOfUnnestFamily$lambda$11((Function1)new Function1<HostFamily<?>, Boolean>(nestedHostKinds){
            final /* synthetic */ Set<ObjectKind> $nestedHostKinds;
            {
                this.$nestedHostKinds = $nestedHostKinds;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull HostFamily<?> f) {
                Intrinsics.checkNotNullParameter(f, (String)"f");
                return this.$nestedHostKinds.contains(f.getChildrenKind()) && f.hasChildren();
            }
        }, arg_0)).flatten(arg_0 -> DvTreeTransformLayer.childrenOfUnnestFamily$lambda$12(childrenOfUnnestFamily.result.2.INSTANCE, arg_0)).filterMap(arg_0 -> DvTreeTransformLayer.childrenOfUnnestFamily$lambda$13((Function1)new Function1<BasicElement, HostFamily<?>>(descriptor2){
            final /* synthetic */ DvFamilyUnnestDescriptor $descriptor;
            {
                this.$descriptor = $descriptor;
                super(1);
            }

            @Nullable
            public final HostFamily<?> invoke(@NotNull BasicElement e2) {
                Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
                Family<? extends BasicElement> family = e2.familyOf(this.$descriptor.kin.childrenKind);
                return family instanceof HostFamily ? (HostFamily)family : null;
            }
        }, arg_0)).flatten(arg_0 -> DvTreeTransformLayer.childrenOfUnnestFamily$lambda$14((Function1)new Function1<HostFamily<?>, Iterable<? extends BasicNode>>(this){
            final /* synthetic */ DvTreeTransformLayer this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final Iterable<BasicNode> invoke(@Nullable HostFamily<?> f) {
                DvTreeLayer dvTreeLayer = this.this$0.getBase();
                HostFamily<?> hostFamily = f;
                Intrinsics.checkNotNull(hostFamily);
                return (Iterable)dvTreeLayer.childrenOf(hostFamily);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"flatten(...)");
        JBIterable result2 = jBIterable;
        return result2;
    }

    private final JBIterable<DvNestFamily> obtainNestFamilies(DbmsContext ctx, BasicElement host) {
        List nestFamilies = DvTreeInternalFunKt.get(ctx.getNestFamilyCache(), host);
        if (nestFamilies == null) {
            ObjectKind objectKind = host.getKind();
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"getKind(...)");
            Map<ObjectKind, DvTransformDescriptor> map2 = this.getHostTransformDescriptorsFor(ctx, objectKind);
            if (map2 == null) {
                JBIterable jBIterable = JBIterable.empty();
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"empty(...)");
                return jBIterable;
            }
            Map<ObjectKind, DvTransformDescriptor> descriptors = map2;
            ArrayList newNestFamilies = new ArrayList(descriptors.size());
            for (DvTransformDescriptor descriptor2 : descriptors.values()) {
                if (!(descriptor2 instanceof DvFamilyNestDescriptor)) continue;
                DvNestFamily f = new DvNestFamily(host, (DvFamilyNestDescriptor)descriptor2);
                ((Collection)newNestFamilies).add(f);
            }
            nestFamilies = newNestFamilies;
            DvTreeInternalFunKt.set(ctx.getNestFamilyCache(), host, nestFamilies);
        }
        JBIterable jBIterable = UtilKt.asJBIterable((Iterable)nestFamilies).filter(arg_0 -> DvTreeTransformLayer.obtainNestFamilies$lambda$15((Function1)new Function1<DvNestFamily, Boolean>(this){
            final /* synthetic */ DvTreeTransformLayer this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(DvNestFamily it2) {
                Intrinsics.checkNotNull((Object)it2);
                return DvTreeTransformLayer.access$childrenOfNestFamily(this.this$0, it2).isNotEmpty();
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
        return jBIterable;
    }

    private final JBIterable<? extends BasicElement> childrenOfNestFamily(DvNestFamily family) {
        Object object;
        Object ctx;
        BasicElement host;
        DvFamilyNestDescriptor descriptor2;
        block8: {
            block7: {
                Object object2;
                block6: {
                    block5: {
                        descriptor2 = family.getDescriptor();
                        host = family.host;
                        object2 = host.getModel();
                        if (object2 == null) break block5;
                        BasicModel it2 = object2;
                        boolean bl = false;
                        Dbms dbms = it2.getDbms();
                        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
                        DbmsContext dbmsContext = this.ensureDbmsContext(dbms);
                        object2 = dbmsContext;
                        if (dbmsContext != null) break block6;
                    }
                    JBIterable jBIterable = JBIterable.empty();
                    Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"empty(...)");
                    return jBIterable;
                }
                ctx = object2;
                object = host.getParentFamily();
                if (object == null) break block7;
                Object object3 = object;
                Family<? extends BasicElement> it3 = object3;
                boolean bl = false;
                object = it3 instanceof HostFamily && Intrinsics.areEqual((Object)((HostFamily)it3).getChildrenKind(), (Object)family.getChildrenKind()) ? object3 : null;
                if (object != null) break block8;
            }
            JBIterable jBIterable = JBIterable.empty();
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"empty(...)");
            return jBIterable;
        }
        Family<? extends BasicElement> sourceFamily = object;
        JBIterable jBIterable = sourceFamily.jbi().filter(arg_0 -> DvTreeTransformLayer.childrenOfNestFamily$lambda$18((Function1)new Function1<BasicElement, Boolean>((DbmsContext)ctx, family, descriptor2, host){
            final /* synthetic */ DbmsContext $ctx;
            final /* synthetic */ DvNestFamily $family;
            final /* synthetic */ DvFamilyNestDescriptor $descriptor;
            final /* synthetic */ BasicElement $host;
            {
                this.$ctx = $ctx;
                this.$family = $family;
                this.$descriptor = $descriptor;
                this.$host = $host;
                super(1);
            }

            @NotNull
            public final Boolean invoke(BasicElement it2) {
                Cache<BasicElement, DvNestFamily> cache2 = this.$ctx.getNestParentFamilyCache();
                Intrinsics.checkNotNull((Object)it2);
                return Intrinsics.areEqual((Object)DvTreeInternalFunKt.get(cache2, it2), (Object)this.$family) || (Boolean)this.$descriptor.isInnerElementOf().invoke((Object)this.$host, (Object)it2) != false;
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
        JBIterable result2 = jBIterable;
        Iterable $this$forEach$iv = (Iterable)result2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BasicElement it4 = (BasicElement)element$iv;
            boolean bl = false;
            Cache<BasicElement, DvNestFamily> cache2 = ((DbmsContext)ctx).getNestParentFamilyCache();
            Intrinsics.checkNotNull((Object)it4);
            DvTreeInternalFunKt.set(cache2, it4, family);
        }
        return result2;
    }

    private final JBIterable<? extends BasicNode> childrenOfExtraTreeNode(DvExtraTreeNode node2) {
        Object object = node2.getModel();
        if (object == null || (object = object.getDbms()) == null) {
            JBIterable jBIterable = JBIterable.empty();
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"empty(...)");
            return jBIterable;
        }
        Object dbms = object;
        DbmsContext ctx = this.ensureDbmsContext((Dbms)dbms);
        HostFamily<? extends BasicElement> family = node2.getFamily();
        ObjectKind objectKind = family.getChildrenKind();
        Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"getChildrenKind(...)");
        Map<ObjectKind, DvTransformDescriptor> map2 = this.getHostTransformDescriptorsFor(ctx, objectKind);
        if (map2 == null) {
            JBIterable jBIterable = JBIterable.empty();
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"empty(...)");
            return jBIterable;
        }
        Map<ObjectKind, DvTransformDescriptor> descriptors = map2;
        DvTransformDescriptor dvTransformDescriptor = descriptors.get(family.getChildrenKind());
        DvFamilyHierarchyDescriptor dvFamilyHierarchyDescriptor = dvTransformDescriptor instanceof DvFamilyHierarchyDescriptor ? (DvFamilyHierarchyDescriptor)dvTransformDescriptor : null;
        if (dvFamilyHierarchyDescriptor == null) {
            JBIterable jBIterable = JBIterable.empty();
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"empty(...)");
            return jBIterable;
        }
        DvFamilyHierarchyDescriptor descriptor2 = dvFamilyHierarchyDescriptor;
        return (JBIterable)descriptor2.getDoFetchChildren().invoke(family, (Object)node2);
    }

    @Override
    public int countAllChildrenOf(@NotNull BasicNode node2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        Integer n = this.countChildrenOf(node2);
        return n != null ? n.intValue() : this.getBase().countAllChildrenOf(node2);
    }

    @Override
    public int countRealChildrenOf(@NotNull BasicNode node2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        Integer n = this.countChildrenOf(node2);
        return n != null ? n.intValue() : this.getBase().countRealChildrenOf(node2);
    }

    private final Integer countChildrenOf(BasicNode node2) {
        return node2 instanceof HostFamily ? this.countChildrenOfFamily((HostFamily)node2) : null;
    }

    private final Integer countChildrenOfFamily(HostFamily<?> family) {
        DvTransformDescriptor ld;
        if (family.isEmpty()) {
            return null;
        }
        DvTransformDescriptor dvTransformDescriptor = this.findDescriptorForFamily(family);
        if (dvTransformDescriptor == null) {
            return null;
        }
        DvTransformDescriptor descriptor2 = dvTransformDescriptor;
        return descriptor2 instanceof DvFamilyRelocationDescriptor ? ((ld = ((DvFamilyRelocationDescriptor)descriptor2).getLocationDescriptor()) instanceof DvFamilyHierarchyDescriptor ? Integer.valueOf(CollectionsKt.count((Iterable)((Iterable)((DvFamilyHierarchyDescriptor)ld).getDoFetchTopNodes().invoke(family)))) : null) : null;
    }

    @Override
    public boolean isAlwaysLeaf(@NotNull BasicNode node2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        BasicNode basicNode = node2;
        return basicNode instanceof BasicElement ? this.ifAlwaysLeafElement((BasicElement)node2) : (basicNode instanceof DvExtraTreeNode ? false : this.ifAlwaysLeafOther(node2));
    }

    private final boolean ifAlwaysLeafElement(BasicElement element2) {
        Family<? extends BasicElement> family;
        DvFamilyHierarchyDescriptor hierarchyDescriptor;
        Map<ObjectKind, DvTransformDescriptor> map2 = this.getDescriptorsOfElement(element2);
        if (map2 == null) {
            return this.ifAlwaysLeafOther(element2);
        }
        Map<ObjectKind, DvTransformDescriptor> descriptors = map2;
        DvTransformDescriptor dvTransformDescriptor = descriptors.get(element2.getKind());
        DvFamilyHierarchyDescriptor dvFamilyHierarchyDescriptor = hierarchyDescriptor = dvTransformDescriptor instanceof DvFamilyHierarchyDescriptor ? (DvFamilyHierarchyDescriptor)dvTransformDescriptor : null;
        if (hierarchyDescriptor != null && (family = element2.getParentFamily()) != null) {
            return ((Number)hierarchyDescriptor.getDoCountChildren().invoke(family, (Object)element2)).intValue() <= 0;
        }
        return this.ifAlwaysLeafOther(element2);
    }

    private final boolean ifAlwaysLeafOther(BasicNode node2) {
        Object object;
        block5: {
            block4: {
                boolean baseIsAlwaysLeaf = this.getBase().isAlwaysLeaf(node2);
                if (!baseIsAlwaysLeaf || !(node2 instanceof BasicElement)) {
                    return baseIsAlwaysLeaf;
                }
                object = ((BasicElement)node2).getModel();
                if (object == null) break block4;
                BasicModel it2 = object;
                boolean bl = false;
                Dbms dbms = it2.getDbms();
                Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
                DbmsContext dbmsContext = this.ensureDbmsContext(dbms);
                object = dbmsContext;
                if (dbmsContext != null) break block5;
            }
            return true;
        }
        Object ctx = object;
        return !((DbmsContext)ctx).getNestRelocationTargetKinds().contains(((BasicElement)node2).getKind());
    }

    @Override
    @NotNull
    public String presentableNameOf(@NotNull BasicNode node2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        BasicNode basicNode = node2;
        if (basicNode instanceof BasicElement) {
            string = this.presentableNameOfElement((BasicElement)node2);
        } else if (basicNode instanceof DvExtraTreeNode) {
            String string2 = ((DvExtraTreeNode)node2).getDisplayName();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDisplayName(...)");
        } else {
            string = this.getBase().presentableNameOf(node2);
        }
        return string;
    }

    private final String presentableNameOfElement(BasicElement element2) {
        String pName;
        DvFamilyHierarchyDescriptor hierarchyDescriptor;
        Map<ObjectKind, DvTransformDescriptor> map2 = this.getDescriptorsOfElement(element2);
        if (map2 == null) {
            return this.getBase().presentableNameOf(element2);
        }
        Map<ObjectKind, DvTransformDescriptor> descriptors = map2;
        DvTransformDescriptor dvTransformDescriptor = descriptors.get(element2.getKind());
        DvFamilyHierarchyDescriptor dvFamilyHierarchyDescriptor = hierarchyDescriptor = dvTransformDescriptor instanceof DvFamilyHierarchyDescriptor ? (DvFamilyHierarchyDescriptor)dvTransformDescriptor : null;
        if (hierarchyDescriptor != null && (pName = (String)hierarchyDescriptor.getDoGetPresentableName().invoke((Object)element2)) != null) {
            return pName;
        }
        return this.getBase().presentableNameOf(element2);
    }

    private final Map<ObjectKind, DvTransformDescriptor> getDescriptorsOfElement(BasicElement element2) {
        if (element2 instanceof BasicNamespaceOwner) {
            return null;
        }
        Object object = element2.getModel();
        if (object == null || (object = object.getDbms()) == null) {
            return null;
        }
        Object dbms = object;
        DbmsContext ctx = this.ensureDbmsContext((Dbms)dbms);
        ObjectKind objectKind = element2.getKind();
        Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"getKind(...)");
        return this.getHostTransformDescriptorsFor(ctx, objectKind);
    }

    @Override
    public void onDataSourceModelReplaced$intellij_database_core_impl(@NotNull RawDataSource dataSource2, @Nullable BasicModel oldModel, @Nullable BasicModel newModel) {
        Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
        if (oldModel != null) {
            Dbms dbms = oldModel.getDbms();
            Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
            this.clearCachesForDataSource(dataSource2, dbms, oldModel);
        }
    }

    @Override
    public void onDataSourceChanged$intellij_database_core_impl(@NotNull RawDataSource dataSource2) {
        Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
        BasicModel basicModel = DataSourceFun.getBasicModel(dataSource2);
        if (basicModel == null) {
            return;
        }
        BasicModel model2 = basicModel;
        Dbms dbms = model2.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        this.clearCachesForDataSource(dataSource2, dbms, model2);
    }

    @Override
    public void onDataSourceRemoved$intellij_database_core_impl(@NotNull RawDataSource dataSource2, @NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        BasicModel basicModel = DataSourceFun.getBasicModel(dataSource2);
        if (basicModel == null) {
            return;
        }
        BasicModel model2 = basicModel;
        this.clearCachesForDataSource(dataSource2, dbms, model2);
    }

    private final void clearCachesForDataSource(RawDataSource dataSource2, Dbms dbms, BasicModel model2) {
        DbmsContext dbmsContext = this.dbmsContexts.get(dbms);
        if (dbmsContext == null) {
            return;
        }
        DbmsContext ctx = dbmsContext;
        DasModel dasModel = dataSource2.getModel();
        BasicModel basicModel = dasModel instanceof BasicModel ? (BasicModel)dasModel : null;
        if (basicModel == null) {
            return;
        }
        BasicModel model3 = basicModel;
        DvTreeInternalFunKt.invalidateThat(ctx.getNestFamilyCache(), (Function1)new Function1<BasicElement, Boolean>(model3){
            final /* synthetic */ BasicModel $model;
            {
                this.$model = $model;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull BasicElement it2) {
                Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                return Intrinsics.areEqual((Object)it2.getModel(), (Object)this.$model);
            }
        });
        DvTreeInternalFunKt.invalidateThat(ctx.getUnnestFamilyCache(), (Function1)new Function1<BasicElement, Boolean>(model3){
            final /* synthetic */ BasicModel $model;
            {
                this.$model = $model;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull BasicElement it2) {
                Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                return Intrinsics.areEqual((Object)it2.getModel(), (Object)this.$model);
            }
        });
        DvTreeInternalFunKt.invalidateThat(ctx.getFdCache(), (Function1)new Function1<HostFamily<?>, Boolean>(model3){
            final /* synthetic */ BasicModel $model;
            {
                this.$model = $model;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull HostFamily<?> it2) {
                Intrinsics.checkNotNullParameter(it2, (String)"it");
                return Intrinsics.areEqual((Object)it2.getModel(), (Object)this.$model);
            }
        });
        Iterable $this$forEach$iv = this.extensions();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DbmsExtension.Bean it2 = (DbmsExtension.Bean)element$iv;
            boolean bl = false;
            Object t = it2.getInstance();
            Intrinsics.checkNotNullExpressionValue(t, (String)"getInstance(...)");
            DvStructureExtension extension = (DvStructureExtension)t;
            try {
                if (!Intrinsics.areEqual((Object)it2.getDbms(), (Object)dbms)) continue;
                extension.clearCachesForDataSource(dataSource2, model3);
            }
            catch (Exception e2) {
                logger.error("Failed to clean caches in in the DvTreeExtension " + extension, (Throwable)e2);
            }
        }
    }

    @Override
    public void onViewOptionsChanged$intellij_database_core_impl() {
        this.dbmsContexts.clear();
    }

    @Override
    public void clearAll() {
        this.dbmsContexts.clear();
    }

    private static final Iterable childrenOfElement$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Iterable)$tmp0.invoke(p0);
    }

    private static final boolean childrenOfElement$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean childrenOfFamily$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean childrenOfFamilyPartiallyRelocated$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean childrenOfFamilyDivision$lambda$9(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean obtainUnnestFamilies$lambda$10(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean childrenOfUnnestFamily$lambda$11(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Iterable childrenOfUnnestFamily$lambda$12(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Iterable)$tmp0.invoke(p0);
    }

    private static final HostFamily childrenOfUnnestFamily$lambda$13(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (HostFamily)$tmp0.invoke(p0);
    }

    private static final Iterable childrenOfUnnestFamily$lambda$14(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Iterable)$tmp0.invoke(p0);
    }

    private static final boolean obtainNestFamilies$lambda$15(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean childrenOfNestFamily$lambda$18(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    @NotNull
    public static final Logger getLogger() {
        return Companion.getLogger();
    }

    public static final /* synthetic */ List access$obtainFamilyDivisions(DvTreeTransformLayer $this, DbmsContext ctx, HostFamily family, DvFamilySeparationDescriptor fsd) {
        return $this.obtainFamilyDivisions(ctx, family, fsd);
    }

    public static final /* synthetic */ JBIterable access$childrenOfFamilyDivision(DvTreeTransformLayer $this, DvFamilyDivision ff) {
        return $this.childrenOfFamilyDivision(ff);
    }

    public static final /* synthetic */ JBIterable access$childrenOfUnnestFamily(DvTreeTransformLayer $this, DvUnnestFamily family) {
        return $this.childrenOfUnnestFamily(family);
    }

    public static final /* synthetic */ JBIterable access$childrenOfNestFamily(DvTreeTransformLayer $this, DvNestFamily family) {
        return $this.childrenOfNestFamily(family);
    }

    static {
        Logger logger2 = Logger.getInstance(DvTreeTransformLayer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        logger = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R!\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/database/view/structure/DvTreeTransformLayer$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLogger$annotations", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.database.core.impl"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        @JvmStatic
        public static /* synthetic */ void getLogger$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B-\u0012&\u0010\u0002\u001a\"\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0018\u00010\u0003j\u0004\u0018\u0001`\u0006\u00a2\u0006\u0002\u0010\u0007R'\u0010\b\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR#\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u000b0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000eR\u001d\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000eR\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R1\u0010\u0002\u001a\"\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0018\u00010\u0003j\u0004\u0018\u0001`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR#\u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u000b0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u000e\u00a8\u0006\u001e"}, d2={"Lcom/intellij/database/view/structure/DvTreeTransformLayer$DbmsContext;", "", "transformDescriptors", "", "Lcom/intellij/database/model/ObjectKind;", "Lcom/intellij/database/view/structure/DvTransformDescriptor;", "Lcom/intellij/database/view/structure/DvTransformDescriptors;", "(Ljava/util/Map;)V", "fdCache", "Lcom/github/benmanes/caffeine/cache/Cache;", "Lcom/intellij/database/model/families/HostFamily;", "", "Lcom/intellij/database/view/structure/DvFamilyDivision;", "getFdCache", "()Lcom/github/benmanes/caffeine/cache/Cache;", "nestFamilyCache", "Lcom/intellij/database/model/basic/BasicElement;", "Lcom/intellij/database/view/structure/DvNestFamily;", "getNestFamilyCache", "nestParentFamilyCache", "getNestParentFamilyCache", "nestRelocationTargetKinds", "", "getNestRelocationTargetKinds", "()Ljava/util/Set;", "getTransformDescriptors", "()Ljava/util/Map;", "unnestFamilyCache", "Lcom/intellij/database/view/structure/DvUnnestFamily;", "getUnnestFamilyCache", "intellij.database.core.impl"})
    private static final class DbmsContext {
        @Nullable
        private final Map<ObjectKind, Map<ObjectKind, DvTransformDescriptor>> transformDescriptors;
        @NotNull
        private final Set<ObjectKind> nestRelocationTargetKinds;
        @NotNull
        private final Cache<HostFamily<?>, List<DvFamilyDivision>> fdCache;
        @NotNull
        private final Cache<BasicElement, List<DvUnnestFamily>> unnestFamilyCache;
        @NotNull
        private final Cache<BasicElement, List<DvNestFamily>> nestFamilyCache;
        @NotNull
        private final Cache<BasicElement, DvNestFamily> nestParentFamilyCache;

        public DbmsContext(@Nullable Map<ObjectKind, ? extends Map<ObjectKind, ? extends DvTransformDescriptor>> transformDescriptors) {
            this.transformDescriptors = transformDescriptors;
            this.nestRelocationTargetKinds = this.transformDescriptors != null ? SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.flatMapIterable((Sequence)CollectionsKt.asSequence((Iterable)this.transformDescriptors.values()), (Function1)nestRelocationTargetKinds.1.INSTANCE), (Function1)nestRelocationTargetKinds.2.INSTANCE), (Function1)nestRelocationTargetKinds.3.INSTANCE)) : SetsKt.emptySet();
            this.fdCache = DvTreeInternalFunKt.createWeakCache$default(false, 1, null);
            this.unnestFamilyCache = DvTreeInternalFunKt.createWeakCache$default(false, 1, null);
            this.nestFamilyCache = DvTreeInternalFunKt.createWeakCache$default(false, 1, null);
            this.nestParentFamilyCache = DvTreeInternalFunKt.createWeakCache(true);
        }

        @Nullable
        public final Map<ObjectKind, Map<ObjectKind, DvTransformDescriptor>> getTransformDescriptors() {
            return this.transformDescriptors;
        }

        @NotNull
        public final Set<ObjectKind> getNestRelocationTargetKinds() {
            return this.nestRelocationTargetKinds;
        }

        @NotNull
        public final Cache<HostFamily<?>, List<DvFamilyDivision>> getFdCache() {
            return this.fdCache;
        }

        @NotNull
        public final Cache<BasicElement, List<DvUnnestFamily>> getUnnestFamilyCache() {
            return this.unnestFamilyCache;
        }

        @NotNull
        public final Cache<BasicElement, List<DvNestFamily>> getNestFamilyCache() {
            return this.nestFamilyCache;
        }

        @NotNull
        public final Cache<BasicElement, DvNestFamily> getNestParentFamilyCache() {
            return this.nestParentFamilyCache;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0006\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u0005H\u0002J,\u0010\u001d\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n0\nj\u0002`\r2\u0006\u0010\u001c\u001a\u00020\u0005H\u0002J,\u0010\u001e\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n0\nj\u0002`\r2\u0006\u0010\u001c\u001a\u00020\u0005H\u0002R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR9\u0010\t\u001a*\u0012\u0004\u0012\u00020\u0005\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n0\nj\u0002`\r0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\bR9\u0010\u000f\u001a*\u0012\u0004\u0012\u00020\u0005\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n0\nj\u0002`\r0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\bR\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015R\u001c\u0010\u0018\u001a\u0010\u0012\f\u0012\n \u001a*\u0004\u0018\u00010\u000b0\u000b0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/database/view/structure/DvTreeTransformLayer$Handler;", "", "()V", "ourDbmsHasSeparatedProceduresAndFunctions", "Lcom/intellij/database/util/SimpleCache;", "Lcom/intellij/database/Dbms;", "", "getOurDbmsHasSeparatedProceduresAndFunctions", "()Lcom/intellij/database/util/SimpleCache;", "ourDbmsRoutineSeparationFamilyDescriptors", "", "Lcom/intellij/database/model/ObjectKind;", "Lcom/intellij/database/view/structure/DvTransformDescriptor;", "Lcom/intellij/database/view/structure/DvTransformDescriptors;", "getOurDbmsRoutineSeparationFamilyDescriptors", "ourDbmsUnnestTableSubObjectsDescriptors", "getOurDbmsUnnestTableSubObjectsDescriptors", "routineIsFunctionPredicate", "Ljava/util/function/Predicate;", "Lcom/intellij/database/model/basic/BasicElement;", "getRoutineIsFunctionPredicate", "()Ljava/util/function/Predicate;", "routineIsProcedurePredicate", "getRoutineIsProcedurePredicate", "unnestingFromTablesKinds", "", "kotlin.jvm.PlatformType", "checkDbmsHasProceduresAndFunctions", "dbms", "computeRoutineSeparationFamilyDescriptors", "computeUnnestTableSubObjectsDescriptors", "intellij.database.core.impl"})
    @SourceDebugExtension(value={"SMAP\nDvTreeTransformLayer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DvTreeTransformLayer.kt\ncom/intellij/database/view/structure/DvTreeTransformLayer$Handler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,602:1\n1#2:603\n766#3:604\n857#3,2:605\n1620#3,3:607\n*S KotlinDebug\n*F\n+ 1 DvTreeTransformLayer.kt\ncom/intellij/database/view/structure/DvTreeTransformLayer$Handler\n*L\n138#1:604\n138#1:605,2\n139#1:607,3\n*E\n"})
    private static final class Handler {
        @NotNull
        public static final Handler INSTANCE = new Handler();
        @NotNull
        private static final SimpleCache<Dbms, Boolean> ourDbmsHasSeparatedProceduresAndFunctions = new SimpleCache((Function1)new Function1<Dbms, Boolean>((Object)INSTANCE){

            @NotNull
            public final Boolean invoke(@NotNull Dbms p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return Handler.access$checkDbmsHasProceduresAndFunctions((Handler)this.receiver, p0);
            }
        });
        @NotNull
        private static final SimpleCache<Dbms, Map<ObjectKind, Map<ObjectKind, DvTransformDescriptor>>> ourDbmsRoutineSeparationFamilyDescriptors = new SimpleCache((Function1)new Function1<Dbms, Map<ObjectKind, ? extends Map<ObjectKind, ? extends DvTransformDescriptor>>>((Object)INSTANCE){

            @NotNull
            public final Map<ObjectKind, Map<ObjectKind, DvTransformDescriptor>> invoke(@NotNull Dbms p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return Handler.access$computeRoutineSeparationFamilyDescriptors((Handler)this.receiver, p0);
            }
        });
        @NotNull
        private static final SimpleCache<Dbms, Map<ObjectKind, Map<ObjectKind, DvTransformDescriptor>>> ourDbmsUnnestTableSubObjectsDescriptors = new SimpleCache((Function1)new Function1<Dbms, Map<ObjectKind, ? extends Map<ObjectKind, ? extends DvTransformDescriptor>>>((Object)INSTANCE){

            @NotNull
            public final Map<ObjectKind, Map<ObjectKind, DvTransformDescriptor>> invoke(@NotNull Dbms p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return Handler.access$computeUnnestTableSubObjectsDescriptors((Handler)this.receiver, p0);
            }
        });
        @NotNull
        private static final Predicate<BasicElement> routineIsProcedurePredicate = Handler::routineIsProcedurePredicate$lambda$0;
        @NotNull
        private static final Predicate<BasicElement> routineIsFunctionPredicate = Handler::routineIsFunctionPredicate$lambda$1;
        @NotNull
        private static final Set<ObjectKind> unnestingFromTablesKinds;

        private Handler() {
        }

        @NotNull
        public final SimpleCache<Dbms, Boolean> getOurDbmsHasSeparatedProceduresAndFunctions() {
            return ourDbmsHasSeparatedProceduresAndFunctions;
        }

        @NotNull
        public final SimpleCache<Dbms, Map<ObjectKind, Map<ObjectKind, DvTransformDescriptor>>> getOurDbmsRoutineSeparationFamilyDescriptors() {
            return ourDbmsRoutineSeparationFamilyDescriptors;
        }

        @NotNull
        public final SimpleCache<Dbms, Map<ObjectKind, Map<ObjectKind, DvTransformDescriptor>>> getOurDbmsUnnestTableSubObjectsDescriptors() {
            return ourDbmsUnnestTableSubObjectsDescriptors;
        }

        @NotNull
        public final Predicate<BasicElement> getRoutineIsProcedurePredicate() {
            return routineIsProcedurePredicate;
        }

        @NotNull
        public final Predicate<BasicElement> getRoutineIsFunctionPredicate() {
            return routineIsFunctionPredicate;
        }

        private final boolean checkDbmsHasProceduresAndFunctions(Dbms dbms) {
            BasicMetaModel<?> basicMetaModel = ModelFacade.forDbms(dbms).getMetaModel();
            Intrinsics.checkNotNullExpressionValue(basicMetaModel, (String)"getMetaModel(...)");
            BasicMetaModel<?> mm = basicMetaModel;
            JBIterable jBIterable = ((JBTreeTraverser)JBTreeTraverser.of(arg_0 -> Handler.checkDbmsHasProceduresAndFunctions$lambda$2((Function1)checkDbmsHasProceduresAndFunctions.metaElements.1.INSTANCE, arg_0)).withRoot(mm.root)).traverse();
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"traverse(...)");
            Iterable metaElements2 = (Iterable)jBIterable;
            for (BasicMetaObject metaElement : metaElements2) {
                BasicMetaProperty property;
                if (!Intrinsics.areEqual((Object)metaElement.kind, (Object)ObjectKind.ROUTINE) || (property = metaElement.getObjectProperty(BasicModRoutine.ROUTINE_KIND)) == null || property.isAbstract()) continue;
                return true;
            }
            return false;
        }

        private final Map<ObjectKind, Map<ObjectKind, DvTransformDescriptor>> computeRoutineSeparationFamilyDescriptors(Dbms dbms) {
            BasicMetaModel<?> basicMetaModel = ModelFacade.forDbms(dbms).getMetaModel();
            Intrinsics.checkNotNullExpressionValue(basicMetaModel, (String)"getMetaModel(...)");
            BasicMetaModel<?> mm = basicMetaModel;
            Map result2 = new TreeMap();
            BasicMetaObject<?> basicMetaObject = mm.root;
            Intrinsics.checkNotNullExpressionValue(basicMetaObject, (String)"root");
            Handler.computeRoutineSeparationFamilyDescriptors$travers(result2, basicMetaObject);
            return result2;
        }

        /*
         * WARNING - void declaration
         */
        private final Map<ObjectKind, Map<ObjectKind, DvTransformDescriptor>> computeUnnestTableSubObjectsDescriptors(Dbms dbms) {
            Map map2;
            Object object;
            BasicMetaObject metaMView;
            BasicMetaObject metaTable;
            block13: {
                Object object2;
                BasicMetaObject metaSchema;
                block12: {
                    Object object3;
                    Object it2;
                    int n;
                    block11: {
                        BasicMetaModel<?> basicMetaModel = ModelFacade.forDbms(dbms).getMetaModel();
                        Intrinsics.checkNotNullExpressionValue(basicMetaModel, (String)"getMetaModel(...)");
                        BasicMetaModel<?> mm = basicMetaModel;
                        BasicMetaObject basicMetaObject = (BasicMetaObject)mm.findMetaObjects(ObjectKind.SCHEMA).first();
                        if (basicMetaObject == null) {
                            return DvTransformDescriptors.emptyTransformDescriptors;
                        }
                        metaSchema = basicMetaObject;
                        Intrinsics.checkNotNullExpressionValue(metaSchema.children, (String)"children");
                        Object[] objectArray = metaSchema.children;
                        n = objectArray.length;
                        for (int j = 0; j < n; ++j) {
                            Object object4 = objectArray[j];
                            it2 = (BasicMetaObject)object4;
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)((BasicMetaObject)it2).kind, (Object)ObjectKind.TABLE)) continue;
                            object3 = object4;
                            break block11;
                        }
                        object3 = null;
                    }
                    metaTable = (BasicMetaObject)object3;
                    Intrinsics.checkNotNullExpressionValue(metaSchema.children, (String)"children");
                    Object[] objectArray = metaSchema.children;
                    int n3 = objectArray.length;
                    for (n = 0; n < n3; ++n) {
                        it2 = objectArray[n];
                        BasicMetaObject it3 = (BasicMetaObject)it2;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it3.kind, (Object)ObjectKind.MAT_VIEW)) continue;
                        object2 = it2;
                        break block12;
                    }
                    object2 = null;
                }
                metaMView = (BasicMetaObject)object2;
                Intrinsics.checkNotNullExpressionValue(metaSchema.children, (String)"children");
                for (Object it3 : (Object[])metaSchema.children) {
                    BasicMetaObject it4 = (BasicMetaObject)it3;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it4.kind, (Object)ObjectKind.VIEW)) continue;
                    object = it3;
                    break block13;
                }
                object = null;
            }
            BasicMetaObject metaView = (BasicMetaObject)object;
            Object[] objectArray = new BasicMetaObject[]{metaTable, metaMView, metaView};
            Set metaHosts = SetsKt.setOfNotNull((Object[])objectArray);
            if (metaHosts.isEmpty()) {
                return DvTransformDescriptors.emptyTransformDescriptors;
            }
            TreeMap<ObjectKind, TreeMap<ObjectKind, DvTransformDescriptor>> descriptors = new TreeMap<ObjectKind, TreeMap<ObjectKind, DvTransformDescriptor>>();
            for (ObjectKind unnestingKind : unnestingFromTablesKinds) {
                void $this$mapTo$iv;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = metaHosts;
                boolean $i$f$filter22 = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    BasicMetaObject mh = (BasicMetaObject)element$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue(mh.children, (String)"children");
                    if (!CollectionFun.containsElements((Object[])mh.children, (Function1)new Function1<BasicMetaObject<?>, Boolean>(unnestingKind){
                        final /* synthetic */ ObjectKind $unnestingKind;
                        {
                            this.$unnestingKind = $unnestingKind;
                            super(1);
                        }

                        @NotNull
                        public final Boolean invoke(BasicMetaObject<?> x) {
                            return Intrinsics.areEqual((Object)x.kind, (Object)this.$unnestingKind);
                        }
                    })) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List theHosts2 = (List)destination$iv$iv;
                Iterable $i$f$filter22 = theHosts2;
                Collection destination$iv = new LinkedHashSet();
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    void it5;
                    Object element$iv$iv;
                    element$iv$iv = (BasicMetaObject)item$iv;
                    Collection collection2 = destination$iv;
                    boolean bl = false;
                    collection2.add(it5.kind);
                }
                LinkedHashSet theHostKinds = (LinkedHashSet)destination$iv;
                ObjectKind objectKind = ObjectKind.SCHEMA;
                Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"SCHEMA");
                Intrinsics.checkNotNull((Object)unnestingKind);
                DvFamilyUnnestDescriptor aggregationDescriptor = new DvFamilyUnnestDescriptor(new HostFamilyKin(objectKind, unnestingKind), theHostKinds);
                DvTransformDescriptors.addDescriptor(descriptors, aggregationDescriptor);
                for (ObjectKind hostKind : theHostKinds) {
                    Intrinsics.checkNotNull((Object)hostKind);
                    DvFamilyRelocationDescriptor relocationDescriptor = new DvFamilyRelocationDescriptor(new HostFamilyKin(hostKind, unnestingKind), aggregationDescriptor, null, null, 12, null);
                    DvTransformDescriptors.addDescriptor(descriptors, relocationDescriptor);
                }
            }
            Map map3 = descriptors;
            if (map3.isEmpty()) {
                boolean bl = false;
                map2 = DvTransformDescriptors.emptyTransformDescriptors;
            } else {
                map2 = map3;
            }
            return map2;
        }

        private static final boolean routineIsProcedurePredicate$lambda$0(BasicElement it2) {
            Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
            return it2 instanceof BasicRoutine && ((BasicRoutine)it2).getRoutineKind() == DasRoutine.Kind.PROCEDURE;
        }

        private static final boolean routineIsFunctionPredicate$lambda$1(BasicElement it2) {
            Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
            return it2 instanceof BasicRoutine && ((BasicRoutine)it2).getRoutineKind() == DasRoutine.Kind.FUNCTION;
        }

        private static final BasicMetaObject[] checkDbmsHasProceduresAndFunctions$lambda$2(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (BasicMetaObject[])$tmp0.invoke(p0);
        }

        private static final void computeRoutineSeparationFamilyDescriptors$addTransformDescriptors(Map<ObjectKind, Map<ObjectKind, DvTransformDescriptor>> result2, ObjectKind parentKind, ObjectKind childKind, DvTransformDescriptor transformDescriptor) {
            Map m2 = result2.get(parentKind);
            if (m2 == null) {
                m2 = new TreeMap();
                result2.put(parentKind, m2);
            } else {
                boolean bl;
                boolean bl2 = bl = !m2.containsKey(childKind);
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
            }
            m2.put(childKind, transformDescriptor);
        }

        private static final void computeRoutineSeparationFamilyDescriptors$travers(Map<ObjectKind, Map<ObjectKind, DvTransformDescriptor>> result2, BasicMetaObject<?> m) {
            Intrinsics.checkNotNullExpressionValue(m.children, (String)"children");
            for (BasicMetaObject<?> child : m.children) {
                if (Intrinsics.areEqual((Object)child.kind, (Object)ObjectKind.ROUTINE)) {
                    BasicMetaProperty<?, DasRoutine.Kind> property = child.getObjectProperty(BasicModRoutine.ROUTINE_KIND);
                    if (property == null || property.isAbstract()) continue;
                    ObjectKind parentKind = m.kind;
                    Intrinsics.checkNotNull((Object)parentKind);
                    ObjectKind objectKind = ObjectKind.ROUTINE;
                    Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"ROUTINE");
                    HostFamilyKin kin = new HostFamilyKin(parentKind, objectKind);
                    DvFamilySeparationDescriptor.Division d1 = new DvFamilySeparationDescriptor.Division(kin, 1, DvFamilyId.PROCEDURE, routineIsProcedurePredicate);
                    DvFamilySeparationDescriptor.Division d2 = new DvFamilySeparationDescriptor.Division(kin, 2, DvFamilyId.FUNCTION, routineIsFunctionPredicate);
                    ObjectKind objectKind2 = ObjectKind.ROUTINE;
                    Intrinsics.checkNotNullExpressionValue((Object)objectKind2, (String)"ROUTINE");
                    Object[] objectArray = new DvFamilySeparationDescriptor.Division[]{d1, d2};
                    Handler.computeRoutineSeparationFamilyDescriptors$addTransformDescriptors(result2, parentKind, objectKind2, new DvFamilySeparationDescriptor(kin, CollectionsKt.listOf((Object[])objectArray)));
                    continue;
                }
                Intrinsics.checkNotNull(child);
                Handler.computeRoutineSeparationFamilyDescriptors$travers(result2, child);
            }
        }

        public static final /* synthetic */ boolean access$checkDbmsHasProceduresAndFunctions(Handler $this, Dbms dbms) {
            return $this.checkDbmsHasProceduresAndFunctions(dbms);
        }

        public static final /* synthetic */ Map access$computeRoutineSeparationFamilyDescriptors(Handler $this, Dbms dbms) {
            return $this.computeRoutineSeparationFamilyDescriptors(dbms);
        }

        public static final /* synthetic */ Map access$computeUnnestTableSubObjectsDescriptors(Handler $this, Dbms dbms) {
            return $this.computeUnnestTableSubObjectsDescriptors(dbms);
        }

        static {
            Object[] objectArray = new ObjectKind[]{ObjectKind.INDEX, ObjectKind.KEY, ObjectKind.FOREIGN_KEY, ObjectKind.CHECK, ObjectKind.TRIGGER, ObjectKind.RULE};
            unnestingFromTablesKinds = SetsKt.setOf((Object[])objectArray);
        }
    }
}

