/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.structure;

import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.psi.DataSourceManager;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.view.DatabaseViewOptions;
import com.intellij.database.view.structure.DvTreeStructure;
import com.intellij.database.view.structure.DvViewOptionsFun;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002:\u0003\u000f\u0010\u0011B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0002R \u0010\u0006\u001a\u0004\u0018\u00010\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/view/structure/DvTreeStructureService;", "Lcom/intellij/database/view/structure/DvTreeStructure;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "onStructureChanged", "Ljava/lang/Runnable;", "getOnStructureChanged", "()Ljava/lang/Runnable;", "setOnStructureChanged", "(Ljava/lang/Runnable;)V", "dispose", "", "structureJustChanged", "DataSourceEventsListener", "OptionsChangedListener", "StorageCoreListener", "intellij.database.core.impl"})
public final class DvTreeStructureService
extends DvTreeStructure
implements Disposable {
    @ApiStatus.Internal
    @Nullable
    private Runnable onStructureChanged;

    public DvTreeStructureService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project, DvViewOptionsFun.getDatabaseViewOptions(project));
        MessageBusConnection messageBusConnection = project.getMessageBus().connect((Disposable)this);
        OptionsChangedListener optionsChangedListener = new OptionsChangedListener();
        messageBusConnection.subscribe(DatabaseViewOptions.TOPIC, (Object)optionsChangedListener);
        Topic<Runnable> topic = DatabaseSettings.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)optionsChangedListener);
        DataSourceEventsListener dsEventsListener = new DataSourceEventsListener();
        Topic<DataSourceManager.Listener> topic2 = DataSourceManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic2, (String)"TOPIC");
        messageBusConnection.subscribe(topic2, (Object)dsEventsListener);
        Topic<AbstractDataSource.Listener> topic3 = AbstractDataSource.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic3, (String)"TOPIC");
        messageBusConnection.subscribe(topic3, (Object)dsEventsListener);
        StorageCoreListener dsStorageCoreListener = new StorageCoreListener();
        Topic<DataSourceStorage.Listener> topic4 = DataSourceStorage.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic4, (String)"TOPIC");
        messageBusConnection.subscribe(topic4, (Object)dsStorageCoreListener);
    }

    public void dispose() {
        this.onStructureChanged = null;
        this.clearAll();
    }

    @Nullable
    public final Runnable getOnStructureChanged() {
        return this.onStructureChanged;
    }

    public final void setOnStructureChanged(@Nullable Runnable runnable) {
        this.onStructureChanged = runnable;
    }

    private final void structureJustChanged() {
        block0: {
            Runnable runnable = this.onStructureChanged;
            if (runnable == null) break block0;
            runnable.run();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J-\u0010\u0004\u001a\u00020\u0005\"\b\b\u0000\u0010\u0006*\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00060\t2\u0006\u0010\n\u001a\u0002H\u0006H\u0016\u00a2\u0006\u0002\u0010\u000bJ1\u0010\f\u001a\u00020\u0005\"\b\b\u0000\u0010\u0006*\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u0002H\u0006\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u0001H\u0006H\u0016\u00a2\u0006\u0002\u0010\u000bJ3\u0010\r\u001a\u00020\u0005\"\b\b\u0000\u0010\u0006*\u00020\u00072\u0006\u0010\n\u001a\u0002H\u00062\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000fH\u0016\u00a2\u0006\u0002\u0010\u0011J-\u0010\u0012\u001a\u00020\u0005\"\b\b\u0000\u0010\u0006*\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00060\t2\u0006\u0010\n\u001a\u0002H\u0006H\u0016\u00a2\u0006\u0002\u0010\u000bJ$\u0010\u0013\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00072\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0015H\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/view/structure/DvTreeStructureService$DataSourceEventsListener;", "Lcom/intellij/database/psi/DataSourceManager$Listener;", "Lcom/intellij/database/dataSource/AbstractDataSource$Listener;", "(Lcom/intellij/database/view/structure/DvTreeStructureService;)V", "dataSourceAdded", "", "T", "Lcom/intellij/database/model/RawDataSource;", "manager", "Lcom/intellij/database/psi/DataSourceManager;", "dataSource", "(Lcom/intellij/database/psi/DataSourceManager;Lcom/intellij/database/model/RawDataSource;)V", "dataSourceChanged", "dataSourceGroupChanged", "oldGroupName", "", "newGroupName", "(Lcom/intellij/database/model/RawDataSource;Ljava/lang/String;Ljava/lang/String;)V", "dataSourceRemoved", "onModelReplaced", "oldModel", "Lcom/intellij/database/model/basic/BasicModel;", "newModel", "intellij.database.core.impl"})
    private final class DataSourceEventsListener
    implements DataSourceManager.Listener,
    AbstractDataSource.Listener {
        @Override
        public <T extends RawDataSource> void dataSourceAdded(@NotNull DataSourceManager<T> manager, @NotNull T dataSource2) {
            Intrinsics.checkNotNullParameter(manager, (String)"manager");
            Intrinsics.checkNotNullParameter(dataSource2, (String)"dataSource");
            DvTreeStructureService.this.dataSourceAdded(dataSource2);
            DvTreeStructureService.this.structureJustChanged();
        }

        @Override
        public void onModelReplaced(@NotNull RawDataSource dataSource2, @Nullable BasicModel oldModel, @Nullable BasicModel newModel) {
            Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
            DvTreeStructureService.this.dataSourceModelReplaced(dataSource2, oldModel, newModel);
            DvTreeStructureService.this.structureJustChanged();
        }

        @Override
        public <T extends RawDataSource> void dataSourceGroupChanged(@NotNull T dataSource2, @Nullable String oldGroupName, @Nullable String newGroupName) {
            Intrinsics.checkNotNullParameter(dataSource2, (String)"dataSource");
            DvTreeStructureService.this.notifyDataSourcePathChanged(dataSource2);
        }

        @Override
        public <T extends RawDataSource> void dataSourceChanged(@Nullable DataSourceManager<T> manager, @Nullable T dataSource2) {
            if (dataSource2 != null) {
                DvTreeStructureService.this.dataSourceChanged(dataSource2);
            }
            DvTreeStructureService.this.structureJustChanged();
        }

        @Override
        public <T extends RawDataSource> void dataSourceRemoved(@NotNull DataSourceManager<T> manager, @NotNull T dataSource2) {
            Intrinsics.checkNotNullParameter(manager, (String)"manager");
            Intrinsics.checkNotNullParameter(dataSource2, (String)"dataSource");
            DvTreeStructureService.this.dataSourceRemoved(dataSource2);
            DvTreeStructureService.this.structureJustChanged();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lcom/intellij/database/view/structure/DvTreeStructureService$OptionsChangedListener;", "Ljava/lang/Runnable;", "(Lcom/intellij/database/view/structure/DvTreeStructureService;)V", "run", "", "intellij.database.core.impl"})
    private final class OptionsChangedListener
    implements Runnable {
        @Override
        public void run() {
            DvTreeStructureService.this.onViewOptionsChanged();
            DvTreeStructureService.this.structureJustChanged();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/database/view/structure/DvTreeStructureService$StorageCoreListener;", "Lcom/intellij/database/dataSource/DataSourceStorage$Listener;", "(Lcom/intellij/database/view/structure/DvTreeStructureService;)V", "dataSourceChanged", "", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "dataSourceRemoved", "intellij.database.core.impl"})
    private final class StorageCoreListener
    implements DataSourceStorage.Listener {
        @Override
        public void dataSourceRemoved(@NotNull LocalDataSource dataSource2) {
            Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
            DvTreeStructureService.this.dataSourceRemoved(dataSource2);
            DvTreeStructureService.this.structureJustChanged();
        }

        @Override
        public void dataSourceChanged(@Nullable LocalDataSource dataSource2) {
            if (dataSource2 != null) {
                DvTreeStructureService.this.dataSourceChanged(dataSource2);
            } else {
                DvTreeStructureService.this.clearAll();
            }
            DvTreeStructureService.this.structureJustChanged();
        }
    }
}

