/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.structure;

import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.psi.DataSourceManager;
import com.intellij.database.view.DataSourceNode;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.structure.DvDsGroup;
import com.intellij.database.view.structure.DvFun;
import com.intellij.database.view.structure.DvSimpleDsGroup;
import com.intellij.database.view.structure.DvTreeLayer;
import com.intellij.database.view.structure.DvTreeStructureService;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a*\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t\u00a8\u0006\n"}, d2={"renameDsGroup", "", "project", "Lcom/intellij/openapi/project/Project;", "group", "Lcom/intellij/database/view/structure/DvSimpleDsGroup;", "newName", "", "loggingClass", "Ljava/lang/Class;", "intellij.database.impl"})
@JvmName(name="DvHandlers")
@SourceDebugExtension(value={"SMAP\nDvHandlers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DvHandlers.kt\ncom/intellij/database/view/structure/DvHandlers\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,59:1\n1855#2,2:60\n37#3,2:62\n*S KotlinDebug\n*F\n+ 1 DvHandlers.kt\ncom/intellij/database/view/structure/DvHandlers\n*L\n34#1:60,2\n51#1:62,2\n*E\n"})
public final class DvHandlers {
    public static final void renameDsGroup(@NotNull Project project, @NotNull DvSimpleDsGroup group2, @NotNull String newName, @NotNull Class<?> loggingClass) {
        BasicNode newGroup;
        Iterator $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        Intrinsics.checkNotNullParameter(loggingClass, (String)"loggingClass");
        DvTreeStructureService dvTreeStructureService = (DvTreeStructureService)project.getServiceIfCreated(DvTreeStructureService.class);
        if (dvTreeStructureService == null) {
            return;
        }
        DvTreeStructureService structureService = dvTreeStructureService;
        DvTreeLayer treeFoldersLayer = structureService.getFoldersLayer();
        BasicNode basicNode = treeFoldersLayer.parentOf(group2);
        if (basicNode == null) {
            return;
        }
        BasicNode parentGroup = basicNode;
        String parentPath = parentGroup instanceof DvSimpleDsGroup ? ((DvSimpleDsGroup)parentGroup).getPath() + "/" : "";
        String newPrefix = parentPath + newName;
        String removingPrefix = group2.getPath();
        int removingLength = removingPrefix.length();
        ArrayList affectedGroups = new ArrayList();
        ArrayList affectedDSN = new ArrayList();
        Object object = ((JBTreeTraverser)JBTreeTraverser.from(arg_0 -> DvHandlers.renameDsGroup$lambda$0((Function1)new Function1<BasicNode, Iterable<? extends BasicNode>>(treeFoldersLayer){
            final /* synthetic */ DvTreeLayer $treeFoldersLayer;
            {
                this.$treeFoldersLayer = $treeFoldersLayer;
                super(1);
            }

            public final Iterable<BasicNode> invoke(BasicNode node2) {
                return node2 instanceof DvDsGroup ? (Iterable)this.$treeFoldersLayer.childrenOf(node2) : (Iterable)JBIterable.empty();
            }
        }, arg_0)).withRoot((Object)group2)).traverse();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"traverse(...)");
        object = (Iterable)object;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv = iterator.next();
            BasicNode it2 = (BasicNode)element$iv;
            boolean bl = false;
            BasicNode basicNode2 = it2;
            if (basicNode2 instanceof DvSimpleDsGroup) {
                Collection collection2 = affectedGroups;
                Intrinsics.checkNotNull((Object)it2);
                collection2.add(it2);
                continue;
            }
            if (!(basicNode2 instanceof DataSourceNode)) continue;
            Collection collection3 = affectedDSN;
            Intrinsics.checkNotNull((Object)it2);
            collection3.add(it2);
        }
        for (DataSourceNode dsn : affectedDSN) {
            DataSourceManager<RawDataSource> dsManager;
            String oldPath;
            if (dsn.getGroupName() == null || !StringsKt.startsWith$default((String)oldPath, (String)removingPrefix, (boolean)false, (int)2, null)) continue;
            String string = oldPath.substring(removingLength);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String newPath = newPrefix + string;
            DataSourceManager<RawDataSource> dataSourceManager = dsManager = DataSourceManager.byDataSource(project, dsn.rawDataSource);
            if (dataSourceManager != null) {
                dataSourceManager.setGroupName(dsn.rawDataSource, newPath);
                continue;
            }
            Logger.getInstance(loggingClass).error("Cannot find DSManager for " + dsn.rawDataSource);
        }
        String[] dsn = new String[]{"/"};
        Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)newPrefix, (String[])dsn, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] newPathNames = thisCollection$iv.toArray(new String[0]);
        BasicNode basicNode3 = newGroup = DvFun.findNode(treeFoldersLayer, Arrays.copyOf(newPathNames, newPathNames.length));
        Set newSelection = basicNode3 != null ? SetsKt.setOf((Object)basicNode3) : SetsKt.emptySet();
        DatabaseView.refreshViewAndSelect(project, newSelection);
    }

    private static final Iterable renameDsGroup$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Iterable)$tmp0.invoke(p0);
    }
}

