/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.models;

import com.intellij.database.schemaEditor.SchemaExportHelper;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.view.models.EditorModelsCache;
import com.intellij.openapi.Disposable;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.JBIterable;
import java.util.EventListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public class EditorModelBase {
    public final EditorModelsCache modelsCache;
    private final DeModel myModel;
    private final EventDispatcher<Listener> myDispatcher;
    private boolean myModified;

    @NotNull
    public DeModel getModel() {
        DeModel deModel = this.myModel;
        if (deModel == null) {
            EditorModelBase.$$$reportNull$$$0(0);
        }
        return deModel;
    }

    @NotNull
    public JBIterable<? extends DeObject> getEditedObjects() {
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            EditorModelBase.$$$reportNull$$$0(1);
        }
        return jBIterable;
    }

    public EditorModelBase(@NotNull DeModel model2, @NotNull EditorModelsCache modelsCache) {
        if (model2 == null) {
            EditorModelBase.$$$reportNull$$$0(2);
        }
        if (modelsCache == null) {
            EditorModelBase.$$$reportNull$$$0(3);
        }
        this.myDispatcher = EventDispatcher.create(Listener.class);
        this.myModel = model2;
        this.modelsCache = modelsCache;
    }

    @NotNull
    public SchemaExportHelper getExportHelper() {
        SchemaExportHelper schemaExportHelper = this.myModel.getExportHelper();
        if (schemaExportHelper == null) {
            EditorModelBase.$$$reportNull$$$0(4);
        }
        return schemaExportHelper;
    }

    public void addListener(@NotNull Listener listener2, @NotNull Disposable parent2) {
        if (listener2 == null) {
            EditorModelBase.$$$reportNull$$$0(5);
        }
        if (parent2 == null) {
            EditorModelBase.$$$reportNull$$$0(6);
        }
        this.myDispatcher.addListener((EventListener)listener2, parent2);
    }

    public boolean isModified() {
        return this.myModified;
    }

    public void commit() {
        if (this.isModified()) {
            this.myModified = false;
            ((Listener)this.myDispatcher.getMulticaster()).changed();
        }
    }

    @TestOnly
    public void forceCommit() {
        this.myModified = false;
        ((Listener)this.myDispatcher.getMulticaster()).changed();
    }

    protected void modify() {
        this.myModified = true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/models/EditorModelBase";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsCache";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditedObjects";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/models/EditorModelBase";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getExportHelper";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 5, 6 -> new IllegalArgumentException(string);
        };
    }

    public static interface Listener
    extends EventListener {
        public void changed();
    }
}

