/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.introspection;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.properties.Level;
import com.intellij.database.view.introspection.DisabledIntrospectableSelection;
import com.intellij.database.view.introspection.IntrospectableSelection;
import com.intellij.database.view.introspection.NothingIntrospectableSelection;
import com.intellij.database.view.introspection.PreparedIntrospectableSelection;
import com.intellij.database.view.introspection.SetIntrospectionLevelActionKt;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002B\u0011\b\u0004\u0012\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0011\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0000H\u0096\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0015\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0010\u00a2\u0006\u0002\b\u0013J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0010H\u0016J\u001f\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH \u00a2\u0006\u0002\b\u001dJ\u000e\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0016J\u001d\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020 H\u0010\u00a2\u0006\u0002\b!R\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u0082\u0001\u0003\"#$\u00a8\u0006%"}, d2={"Lcom/intellij/database/view/introspection/SetIntrospectionLevelAction;", "Lcom/intellij/openapi/project/DumbAwareToggleAction;", "", "nameKey", "", "(Ljava/lang/String;)V", "level", "Lcom/intellij/database/model/properties/Level;", "getLevel", "()Lcom/intellij/database/model/properties/Level;", "compareTo", "", "other", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isApplicableFor", "", "sel", "Lcom/intellij/database/view/introspection/PreparedIntrospectableSelection;", "isApplicableFor$intellij_database_impl", "isSelected", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "setupLevel", "project", "Lcom/intellij/openapi/project/Project;", "setupLevel$intellij_database_impl", "update", "updateText", "Lcom/intellij/database/view/introspection/IntrospectableSelection;", "updateText$intellij_database_impl", "Lcom/intellij/database/view/introspection/SetAutoIntrospectionLevelAction;", "Lcom/intellij/database/view/introspection/SetInheritedIntrospectionLevelAction;", "Lcom/intellij/database/view/introspection/SetIntrospectionSpecificLevelAction;", "intellij.database.impl"})
public abstract class SetIntrospectionLevelAction
extends DumbAwareToggleAction
implements Comparable<SetIntrospectionLevelAction> {
    private SetIntrospectionLevelAction(@NotNull @PropertyKey(resourceBundle="messages.DatabaseBundle") String nameKey) {
        super(DatabaseBundle.messagePointer(nameKey, new Object[0]));
    }

    @Nullable
    public abstract Level getLevel();

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public final void update(@NotNull AnActionEvent e2) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        IntrospectableSelection sel = SetIntrospectionLevelActionKt.access$obtainIntrospectableSelection(e2);
        Presentation presentation = e2.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
        Presentation presentation2 = presentation;
        IntrospectableSelection introspectableSelection = sel;
        if (introspectableSelection instanceof PreparedIntrospectableSelection) {
            presentation2.setVisible(this.isApplicableFor$intellij_database_impl((PreparedIntrospectableSelection)sel));
            presentation2.setEnabled(((PreparedIntrospectableSelection)sel).getEnabled());
        } else if (introspectableSelection instanceof DisabledIntrospectableSelection) {
            presentation2.setVisible(this.getLevel() != null);
            presentation2.setEnabled(false);
        } else if (introspectableSelection instanceof NothingIntrospectableSelection) {
            presentation2.setEnabledAndVisible(false);
            return;
        }
        this.updateText$intellij_database_impl(e2, sel);
        super.update(e2);
    }

    public boolean isApplicableFor$intellij_database_impl(@NotNull PreparedIntrospectableSelection sel) {
        Intrinsics.checkNotNullParameter((Object)sel, (String)"sel");
        return true;
    }

    public void updateText$intellij_database_impl(@NotNull AnActionEvent e2, @NotNull IntrospectableSelection sel) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        Intrinsics.checkNotNullParameter((Object)sel, (String)"sel");
    }

    public boolean isSelected(@NotNull AnActionEvent e2) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        IntrospectableSelection sel = SetIntrospectionLevelActionKt.access$obtainIntrospectableSelection(e2);
        return sel instanceof PreparedIntrospectableSelection && ((PreparedIntrospectableSelection)sel).getCurrentDeclaredLevel() == this.getLevel() && (((PreparedIntrospectableSelection)sel).getCurrentEffectiveLevel() == this.getLevel() || this.getLevel() == null);
    }

    public void setSelected(@NotNull AnActionEvent e2, boolean state) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        if (!state) {
            return;
        }
        Project project = e2.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        IntrospectableSelection introspectableSelection = SetIntrospectionLevelActionKt.access$obtainIntrospectableSelection(e2);
        PreparedIntrospectableSelection preparedIntrospectableSelection = introspectableSelection instanceof PreparedIntrospectableSelection ? (PreparedIntrospectableSelection)introspectableSelection : null;
        if (preparedIntrospectableSelection == null) {
            return;
        }
        PreparedIntrospectableSelection sel = preparedIntrospectableSelection;
        this.setupLevel$intellij_database_impl(sel, project2);
        LocalDataSource localDataSource = sel.getDs().getLocalDataSource();
        boolean bl = localDataSource != null ? localDataSource.isAutoSynchronize() : false;
        if (bl) {
            SetIntrospectionLevelActionKt.access$introspect(sel, project2);
        }
    }

    public abstract void setupLevel$intellij_database_impl(@NotNull PreparedIntrospectableSelection var1, @Nullable Project var2);

    @Override
    public int compareTo(@NotNull SetIntrospectionLevelAction other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Level thisLevel = this.getLevel();
        Level thatLevel = other.getLevel();
        Level level = thisLevel;
        byte thisX = level != null ? level.level : (byte)0;
        Level level2 = thatLevel;
        byte thatX = level2 != null ? level2.level : (byte)0;
        return Intrinsics.compare((int)thisX, (int)thatX);
    }

    public /* synthetic */ SetIntrospectionLevelAction(String nameKey, DefaultConstructorMarker $constructor_marker) {
        this(nameKey);
    }
}

