/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0017\b\u0016\u0018\u0000 H2\u00020\u0001:\u0005HIJKLB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u001dH\u0016J\u0010\u0010*\u001a\u00020\u00102\u0006\u0010+\u001a\u00020\bH\u0002J\b\u0010,\u001a\u00020(H\u0002J\u0006\u0010-\u001a\u00020(J\u000e\u0010.\u001a\u00020(2\u0006\u0010\u0015\u001a\u00020\u0016J'\u0010/\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u0001002\b\u00101\u001a\u0004\u0018\u00010\r2\u0006\u0010+\u001a\u00020\bH\u0002\u00a2\u0006\u0002\u00102J\u001a\u00103\u001a\u0004\u0018\u00010\b2\u0006\u00104\u001a\u00020\b2\u0006\u00105\u001a\u000206H\u0016J\u0010\u00107\u001a\u0002062\u0006\u00104\u001a\u00020\bH\u0016J\u001c\u00108\u001a\u0002062\b\u00104\u001a\u0004\u0018\u00010\b2\b\u00109\u001a\u0004\u0018\u00010\bH\u0016J\n\u0010:\u001a\u0004\u0018\u00010\bH\u0016J\b\u0010;\u001a\u00020(H\u0002J\u0010\u0010<\u001a\u00020\u00102\u0006\u0010+\u001a\u00020\bH\u0016J\u0012\u0010=\u001a\u0004\u0018\u00010\t2\u0006\u0010+\u001a\u00020\bH\u0002J\u001a\u0010>\u001a\u00020\t2\b\u0010?\u001a\u0004\u0018\u00010\r2\u0006\u0010+\u001a\u00020\bH\u0004J\b\u0010@\u001a\u00020(H\u0002J\u0010\u0010A\u001a\u00020(2\u0006\u0010)\u001a\u00020\u001dH\u0016J\u0006\u0010B\u001a\u00020(J\b\u0010C\u001a\u00020(H\u0002J\b\u0010D\u001a\u00020(H\u0002J\u0018\u0010E\u001a\u00020(2\u0006\u0010F\u001a\u00020\r2\u0006\u0010G\u001a\u00020\bH\u0016R*\u0010\u0006\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\r0\fj\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\r`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0010X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\u001d0\u001cj\b\u0012\u0004\u0012\u00020\u001d`\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001f\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u0010\u0010\u0002\u001a\u00020\u00018\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010%\u001a\u00020\u00108\u00c4\u0002X\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0012\u00a8\u0006M"}, d2={"Lcom/intellij/database/view/TreeFilterModel;", "Ljavax/swing/tree/TreeModel;", "originModel", "jTree", "Ljavax/swing/JTree;", "(Ljavax/swing/tree/TreeModel;Ljavax/swing/JTree;)V", "cache", "Ljava/util/HashMap;", "", "Lcom/intellij/database/view/TreeFilterModel$Row;", "Lkotlin/collections/HashMap;", "expandedNodes", "Ljava/util/LinkedHashMap;", "Ljavax/swing/tree/TreePath;", "Lkotlin/collections/LinkedHashMap;", "filtering", "", "getFiltering", "()Z", "setFiltering", "(Z)V", "input", "", "getInput", "()Ljava/lang/String;", "setInput", "(Ljava/lang/String;)V", "listeners", "Ljava/util/ArrayList;", "Ljavax/swing/event/TreeModelListener;", "Lkotlin/collections/ArrayList;", "matcher", "Lcom/intellij/database/view/TreeFilterModel$Matcher;", "getMatcher", "()Lcom/intellij/database/view/TreeFilterModel$Matcher;", "setMatcher", "(Lcom/intellij/database/view/TreeFilterModel$Matcher;)V", "passing", "getPassing", "addTreeModelListener", "", "l", "checkNodeMatches", "node", "clearAllCaches", "expandAllNodesInTheTree", "filter", "gatherNodeChildren", "", "nodePath", "(Ljavax/swing/tree/TreePath;Ljava/lang/Object;)[Lcom/intellij/database/view/TreeFilterModel$Row;", "getChild", "parent", "index", "", "getChildCount", "getIndexOfChild", "child", "getRoot", "invalidateTreeComponent", "isLeaf", "obtainRow", "processNode", "parentPath", "processTreeNodes", "removeTreeModelListener", "reset", "restoreExpandedNodes", "saveExpandedNodes", "valueForPathChanged", "path", "newValue", "Companion", "Matcher", "OriginModelListener", "Row", "SimpleMatcher", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nTreeFilterModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TreeFilterModel.kt\ncom/intellij/database/view/TreeFilterModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,287:1\n83#1:292\n83#1:293\n83#1:294\n83#1:295\n1855#2,2:288\n37#3,2:290\n*S KotlinDebug\n*F\n+ 1 TreeFilterModel.kt\ncom/intellij/database/view/TreeFilterModel\n*L\n222#1:292\n228#1:293\n234#1:294\n244#1:295\n143#1:288,2\n180#1:290,2\n*E\n"})
public class TreeFilterModel
implements TreeModel {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public final TreeModel originModel;
    @NotNull
    private final JTree jTree;
    @NotNull
    private Matcher matcher;
    @NotNull
    private final LinkedHashMap<Object, TreePath> expandedNodes;
    @NotNull
    private final HashMap<Object, Row> cache;
    @Nullable
    private String input;
    private boolean filtering;
    @NotNull
    private final ArrayList<TreeModelListener> listeners;
    @Deprecated
    public static final int noIndex = -1;
    @Deprecated
    public static final int expandingLimit = 70;

    public TreeFilterModel(@NotNull TreeModel originModel, @NotNull JTree jTree) {
        Intrinsics.checkNotNullParameter((Object)originModel, (String)"originModel");
        Intrinsics.checkNotNullParameter((Object)jTree, (String)"jTree");
        this.originModel = originModel;
        this.jTree = jTree;
        this.matcher = SimpleMatcher.INSTANCE;
        this.expandedNodes = new LinkedHashMap();
        this.cache = new HashMap();
        this.listeners = new ArrayList();
        this.originModel.addTreeModelListener(new OriginModelListener());
    }

    @NotNull
    public final Matcher getMatcher() {
        return this.matcher;
    }

    public final void setMatcher(@NotNull Matcher matcher) {
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"<set-?>");
        this.matcher = matcher;
    }

    @Nullable
    protected final String getInput() {
        return this.input;
    }

    protected final void setInput(@Nullable String string) {
        this.input = string;
    }

    protected final boolean getFiltering() {
        return this.filtering;
    }

    protected final void setFiltering(boolean bl) {
        this.filtering = bl;
    }

    protected final boolean getPassing() {
        boolean $i$f$getPassing = false;
        return !this.filtering;
    }

    public final void filter(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        if (Intrinsics.areEqual((Object)this.input, (Object)input)) {
            return;
        }
        if (!this.filtering) {
            this.saveExpandedNodes();
            this.filtering = true;
            this.clearAllCaches();
        }
        this.input = input;
        this.processTreeNodes();
        this.invalidateTreeComponent();
        this.expandAllNodesInTheTree();
    }

    public final void reset() {
        this.input = null;
        if (this.filtering) {
            this.filtering = false;
            this.invalidateTreeComponent();
            this.restoreExpandedNodes();
        }
        this.clearAllCaches();
    }

    private final void saveExpandedNodes() {
        this.expandedNodes.clear();
        int n = this.jTree.getRowCount();
        for (int i2 = 0; i2 < n; ++i2) {
            Object object;
            if (!this.jTree.isExpanded(i2)) continue;
            TreePath p2 = this.jTree.getPathForRow(i2);
            Map map2 = this.expandedNodes;
            Intrinsics.checkNotNullExpressionValue((Object)p2.getLastPathComponent(), (String)"getLastPathComponent(...)");
            Intrinsics.checkNotNull((Object)p2);
            TreePath treePath = p2;
            map2.put(object, treePath);
        }
    }

    private final void restoreExpandedNodes() {
        for (TreePath path : this.expandedNodes.values()) {
            this.jTree.expandPath(path);
        }
    }

    private final void invalidateTreeComponent() {
        Object[] objectArray = new Object[]{this.originModel.getRoot()};
        TreeModelEvent eventInfo = new TreeModelEvent((Object)this.jTree, objectArray);
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TreeModelListener it2 = (TreeModelListener)element$iv;
            boolean bl = false;
            it2.treeStructureChanged(eventInfo);
        }
        this.jTree.repaint();
    }

    private final void processTreeNodes() {
        this.cache.clear();
        Object object = this.originModel.getRoot();
        if (object == null) {
            return;
        }
        Object rootNode = object;
        Row rootRow = this.processNode(null, rootNode);
        rootRow.visible = true;
    }

    @NotNull
    protected final Row processNode(@Nullable TreePath parentPath, @NotNull Object node2) {
        Row[] children2;
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        boolean matches2 = this.checkNodeMatches(node2);
        TreePath treePath = parentPath;
        TreePath nodePath = treePath != null ? treePath.pathByAddingChild(node2) : new TreePath(node2);
        boolean leaf = this.originModel.isLeaf(node2) || parentPath != null && !this.jTree.isExpanded(nodePath) && !this.expandedNodes.containsKey(node2);
        Row[] rowArray = children2 = !leaf ? this.gatherNodeChildren(nodePath, node2) : null;
        if (!leaf && children2 == null) {
            leaf = true;
        }
        boolean visible = matches2 || !leaf;
        Row row = new Row(node2, matches2);
        row.visible = visible;
        row.leaf = leaf;
        row.children = children2;
        ((Map)this.cache).put(node2, row);
        return row;
    }

    private final Row[] gatherNodeChildren(TreePath nodePath, Object node2) {
        Row[] rowArray;
        int n = this.originModel.getChildCount(node2);
        if (n < 1) {
            return null;
        }
        ArrayList childrenRows = new ArrayList(n);
        for (int i2 = 0; i2 < n; ++i2) {
            Object childNode;
            if (this.originModel.getChild(node2, i2) == null) continue;
            Row childRow = this.processNode(nodePath, childNode);
            if (!childRow.visible) continue;
            ((Collection)childrenRows).add(childRow);
        }
        if (!((Collection)childrenRows).isEmpty()) {
            Collection $this$toTypedArray$iv = childrenRows;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            rowArray = thisCollection$iv.toArray(new Row[0]);
        } else {
            rowArray = null;
        }
        return rowArray;
    }

    private final Row obtainRow(Object node2) {
        return this.cache.get(node2);
    }

    private final boolean checkNodeMatches(Object node2) {
        String string = this.input;
        if (string == null) {
            return false;
        }
        String input = string;
        return this.matcher.matches(node2, input);
    }

    public final void expandAllNodesInTheTree() {
        int n = this.jTree.getRowCount();
        for (int i2 = 0; i2 < n && n < 70; ++i2) {
            if (!this.jTree.isCollapsed(i2)) continue;
            this.jTree.expandRow(i2);
            n = this.jTree.getRowCount();
        }
    }

    private final void clearAllCaches() {
        this.cache.clear();
    }

    @Override
    @Nullable
    public Object getRoot() {
        return this.originModel.getRoot();
    }

    @Override
    @Nullable
    public Object getChild(@NotNull Object parent2, int index2) {
        Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
        TreeFilterModel this_$iv = this;
        boolean $i$f$getPassing = false;
        if (!this_$iv.filtering) {
            return this.originModel.getChild(parent2, index2);
        }
        Row row = this.obtainRow(parent2);
        if (row == null) {
            return null;
        }
        Row row2 = row;
        Row row3 = row2.getChild(index2);
        return row3 != null ? row3.node : null;
    }

    @Override
    public int getChildCount(@NotNull Object parent2) {
        Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
        TreeFilterModel this_$iv = this;
        boolean $i$f$getPassing = false;
        if (!this_$iv.filtering) {
            return this.originModel.getChildCount(parent2);
        }
        Row row = this.obtainRow(parent2);
        if (row == null) {
            return 0;
        }
        Row row2 = row;
        return row2.getChildrenCount();
    }

    @Override
    public boolean isLeaf(@NotNull Object node2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        TreeFilterModel this_$iv = this;
        boolean $i$f$getPassing = false;
        if (!this_$iv.filtering) {
            return this.originModel.isLeaf(node2);
        }
        Row row = this.obtainRow(node2);
        if (row == null) {
            return true;
        }
        Row row2 = row;
        return row2.leaf;
    }

    @Override
    public void valueForPathChanged(@NotNull TreePath path, @NotNull Object newValue) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
        this.originModel.valueForPathChanged(path, newValue);
    }

    @Override
    public int getIndexOfChild(@Nullable Object parent2, @Nullable Object child) {
        TreeFilterModel this_$iv = this;
        boolean $i$f$getPassing = false;
        if (!this_$iv.filtering) {
            return this.originModel.getIndexOfChild(parent2, child);
        }
        if (parent2 == null || child == null) {
            return -1;
        }
        if (this.obtainRow(parent2) == null) {
            return -1;
        }
        Row row = this.obtainRow(child);
        if (row == null) {
            return -1;
        }
        Row childRow = row;
        return childRow.index;
    }

    @Override
    public void addTreeModelListener(@NotNull TreeModelListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.listeners.add(0, l);
    }

    @Override
    public void removeTreeModelListener(@NotNull TreeModelListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.listeners.remove(l);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/database/view/TreeFilterModel$Companion;", "", "()V", "expandingLimit", "", "noIndex", "intellij.database.impl"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0007\u00c0\u0006\u0001"}, d2={"Lcom/intellij/database/view/TreeFilterModel$Matcher;", "", "matches", "", "node", "input", "", "intellij.database.impl"})
    public static interface Matcher {
        public boolean matches(@NotNull Object var1, @NotNull String var2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\f\u0010\n\u001a\u00020\u0006*\u00020\u0006H\u0002\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/view/TreeFilterModel$OriginModelListener;", "Ljavax/swing/event/TreeModelListener;", "(Lcom/intellij/database/view/TreeFilterModel;)V", "treeNodesChanged", "", "e", "Ljavax/swing/event/TreeModelEvent;", "treeNodesInserted", "treeNodesRemoved", "treeStructureChanged", "adjustEvent", "intellij.database.impl"})
    @SourceDebugExtension(value={"SMAP\nTreeFilterModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TreeFilterModel.kt\ncom/intellij/database/view/TreeFilterModel$OriginModelListener\n+ 2 TreeFilterModel.kt\ncom/intellij/database/view/TreeFilterModel\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,287:1\n83#2:288\n83#2:291\n83#2:294\n83#2:297\n1855#3,2:289\n1855#3,2:292\n1855#3,2:295\n1855#3,2:298\n*S KotlinDebug\n*F\n+ 1 TreeFilterModel.kt\ncom/intellij/database/view/TreeFilterModel$OriginModelListener\n*L\n265#1:288\n269#1:291\n273#1:294\n277#1:297\n265#1:289,2\n269#1:292,2\n273#1:295,2\n277#1:298,2\n*E\n"})
    private final class OriginModelListener
    implements TreeModelListener {
        @Override
        public void treeNodesChanged(@NotNull TreeModelEvent e2) {
            Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
            TreeFilterModel this_$iv = TreeFilterModel.this;
            boolean $i$f$getPassing = false;
            if (!this_$iv.filtering) {
                Iterable $this$forEach$iv = TreeFilterModel.this.listeners;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    TreeModelListener it2 = (TreeModelListener)element$iv;
                    boolean bl = false;
                    it2.treeNodesChanged(this.adjustEvent(e2));
                }
            }
        }

        @Override
        public void treeNodesInserted(@NotNull TreeModelEvent e2) {
            Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
            TreeFilterModel this_$iv = TreeFilterModel.this;
            boolean $i$f$getPassing = false;
            if (!this_$iv.filtering) {
                Iterable $this$forEach$iv = TreeFilterModel.this.listeners;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    TreeModelListener it2 = (TreeModelListener)element$iv;
                    boolean bl = false;
                    it2.treeNodesInserted(this.adjustEvent(e2));
                }
            }
        }

        @Override
        public void treeNodesRemoved(@NotNull TreeModelEvent e2) {
            Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
            TreeFilterModel this_$iv = TreeFilterModel.this;
            boolean $i$f$getPassing = false;
            if (!this_$iv.filtering) {
                Iterable $this$forEach$iv = TreeFilterModel.this.listeners;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    TreeModelListener it2 = (TreeModelListener)element$iv;
                    boolean bl = false;
                    it2.treeNodesRemoved(this.adjustEvent(e2));
                }
            }
        }

        @Override
        public void treeStructureChanged(@NotNull TreeModelEvent e2) {
            Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
            TreeFilterModel this_$iv = TreeFilterModel.this;
            boolean $i$f$getPassing = false;
            if (!this_$iv.filtering) {
                Iterable $this$forEach$iv = TreeFilterModel.this.listeners;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    TreeModelListener it2 = (TreeModelListener)element$iv;
                    boolean bl = false;
                    it2.treeStructureChanged(this.adjustEvent(e2));
                }
            }
        }

        private final TreeModelEvent adjustEvent(TreeModelEvent $this$adjustEvent) {
            return $this$adjustEvent.getSource() == TreeFilterModel.this.originModel ? new TreeModelEvent((Object)TreeFilterModel.this, $this$adjustEvent.getTreePath(), $this$adjustEvent.getChildIndices(), $this$adjustEvent.getChildren()) : $this$adjustEvent;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\r\u001a\u0004\u0018\u00010\u00002\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000e\u001a\u00020\nJ\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u001c\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0000\u0018\u00010\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0004\n\u0002\u0010\bR\u0012\u0010\t\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u00020\u00018\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/view/TreeFilterModel$Row;", "", "node", "matches", "", "(Ljava/lang/Object;Z)V", "children", "", "[Lcom/intellij/database/view/TreeFilterModel$Row;", "index", "", "leaf", "visible", "getChild", "getChildrenCount", "toString", "", "intellij.database.impl"})
    protected static final class Row {
        @JvmField
        @NotNull
        public final Object node;
        @JvmField
        public final boolean matches;
        @JvmField
        public boolean visible;
        @JvmField
        public boolean leaf;
        @JvmField
        public int index;
        @JvmField
        @Nullable
        public Row[] children;

        public Row(@NotNull Object node2, boolean matches2) {
            Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
            this.node = node2;
            this.matches = matches2;
            this.index = -1;
        }

        @Nullable
        public final Row getChild(int index2) {
            if (this.leaf || !this.visible) {
                return null;
            }
            if (this.children == null) {
                return null;
            }
            Row[] children2 = this.children;
            if (index2 >= 0 && index2 < children2.length) {
                return children2[index2];
            }
            return null;
        }

        public final int getChildrenCount() {
            if (this.leaf || !this.visible) {
                return 0;
            }
            if (this.children == null) {
                return 0;
            }
            Row[] children2 = this.children;
            return children2.length;
        }

        @NotNull
        public String toString() {
            return this.visible ? (this.leaf ? (char)'\u2013' : '+') + "[" + this.index + "] " + this.node : "[x] " + this.node;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/database/view/TreeFilterModel$SimpleMatcher;", "Lcom/intellij/database/view/TreeFilterModel$Matcher;", "()V", "matches", "", "node", "", "input", "", "intellij.database.impl"})
    public static final class SimpleMatcher
    implements Matcher {
        @NotNull
        public static final SimpleMatcher INSTANCE = new SimpleMatcher();

        private SimpleMatcher() {
        }

        @Override
        public boolean matches(@NotNull Object node2, @NotNull String input) {
            Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            return StringsKt.contains$default((CharSequence)node2.toString(), (CharSequence)input, (boolean)false, (int)2, null);
        }
    }
}

