/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.families.FamilyWithId;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbObject;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.view.DataSourceNode;
import com.intellij.database.view.DbContextDataSourceElements;
import com.intellij.database.view.structure.DvTreeStructureService;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.UtilKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\u0002\u0010\tJ\u001f\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u0015J\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00110\u0000J\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0018J\u0017\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0014\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u001bJ\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0000J\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0000J\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000J\u001c\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00002\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0000H\u0002J \u0010 \u001a\b\u0012\u0004\u0012\u0002H\u00010\u0000\"\u0004\b\u0001\u0010\u00012\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H\u00010\"J\u000e\u0010#\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0000J\u001c\u0010$\u001a\u0004\u0018\u00010\u001a2\b\u0010%\u001a\u0004\u0018\u00010\u001a2\u0006\u0010&\u001a\u00020'H\u0002J\f\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000J\u001c\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00002\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0000H\u0002J8\u0010)\u001a\b\u0012\u0004\u0012\u0002H*0\u0000\"\u0004\b\u0001\u0010*2\u001e\u0010+\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u0002H*0\b0,H\u0086\b\u00f8\u0001\u0000J \u0010)\u001a\b\u0012\u0004\u0012\u0002H*0\u0000\"\u0004\b\u0001\u0010*2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H*0\bJ\u0014\u0010-\u001a\b\u0012\u0004\u0012\u0002H*0\u0000\"\u0004\b\u0001\u0010*H\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006."}, d2={"Lcom/intellij/database/view/DbContextDataSourceElements;", "T", "", "project", "Lcom/intellij/openapi/project/Project;", "dataSource", "Lcom/intellij/database/model/RawDataSource;", "selection", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/model/RawDataSource;Ljava/lang/Iterable;)V", "getDataSource", "()Lcom/intellij/database/model/RawDataSource;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getSelection", "()Ljava/lang/Iterable;", "asDbElement", "Lcom/intellij/database/psi/DbElement;", "dbDs", "Lcom/intellij/database/psi/DbDataSource;", "o", "(Lcom/intellij/database/psi/DbDataSource;Ljava/lang/Object;)Lcom/intellij/database/psi/DbElement;", "asDbElements", "asIterable", "Lcom/intellij/util/containers/JBIterable;", "asNode", "Lcom/intellij/database/model/basic/BasicNode;", "(Ljava/lang/Object;)Lcom/intellij/database/model/basic/BasicNode;", "asNodes", "dataSourcesToRoots", "expandGroups", "sel", "filter", "clazz", "Ljava/lang/Class;", "nullize", "parentForGroup", "n", "ss", "Lcom/intellij/database/view/structure/DvTreeStructureService;", "parentsForGroups", "replace", "U", "replacer", "Lkotlin/Function1;", "unsafeCast", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDbContextElements.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbContextElements.kt\ncom/intellij/database/view/DbContextDataSourceElements\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,163:1\n157#1:164\n157#1:165\n157#1:166\n157#1:169\n31#2,2:167\n14#3:170\n14#3:171\n1#4:172\n*S KotlinDebug\n*F\n+ 1 DbContextElements.kt\ncom/intellij/database/view/DbContextDataSourceElements\n*L\n98#1:164\n120#1:165\n122#1:166\n130#1:169\n123#1:167,2\n144#1:170\n145#1:171\n*E\n"})
public final class DbContextDataSourceElements<T> {
    @NotNull
    private final Project project;
    @NotNull
    private final RawDataSource dataSource;
    @NotNull
    private final Iterable<T> selection;

    public DbContextDataSourceElements(@NotNull Project project, @NotNull RawDataSource dataSource2, @NotNull Iterable<? extends T> selection2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
        Intrinsics.checkNotNullParameter(selection2, (String)"selection");
        this.project = project;
        this.dataSource = dataSource2;
        this.selection = selection2;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final RawDataSource getDataSource() {
        return this.dataSource;
    }

    @NotNull
    public final Iterable<T> getSelection() {
        return this.selection;
    }

    @NotNull
    public final DbContextDataSourceElements<BasicNode> asNodes() {
        DbContextDataSourceElements<BasicNode> dbContextDataSourceElements;
        if (CollectionsKt.firstOrNull(this.selection) instanceof BasicNode) {
            dbContextDataSourceElements = this.unsafeCast();
        } else {
            JBIterable jBIterable = this.asIterable().filterMap(arg_0 -> DbContextDataSourceElements.asNodes$lambda$0((Function1)new Function1<T, BasicNode>(this){
                final /* synthetic */ DbContextDataSourceElements<T> this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final BasicNode invoke(T it2) {
                    return DbContextDataSourceElements.access$asNode(this.this$0, it2);
                }
            }, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filterMap(...)");
            dbContextDataSourceElements = this.replace((Iterable)jBIterable);
        }
        return dbContextDataSourceElements;
    }

    @NotNull
    public final JBIterable<T> asIterable() {
        return UtilKt.asJBIterable(this.selection);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T> DbContextDataSourceElements<T> filter(@NotNull Class<T> clazz) {
        void it2;
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        DbContextDataSourceElements this_$iv = this;
        boolean $i$f$replace = false;
        DbContextDataSourceElements dbContextDataSourceElements = this_$iv;
        DbContextDataSourceElements dbContextDataSourceElements2 = this_$iv;
        boolean bl = false;
        JBIterable jBIterable = it2.asIterable().filter(clazz);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
        return dbContextDataSourceElements2.replace((Iterable)jBIterable);
    }

    private final <U> DbContextDataSourceElements<U> unsafeCast() {
        Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type com.intellij.database.view.DbContextDataSourceElements<U of com.intellij.database.view.DbContextDataSourceElements.unsafeCast>");
        return this;
    }

    @NotNull
    public final DbContextDataSourceElements<DbElement> asDbElements() {
        DbContextDataSourceElements<DbElement> dbContextDataSourceElements;
        if (CollectionsKt.firstOrNull(this.selection) instanceof BasicNode) {
            JBIterable jBIterable;
            DbDataSource dbDs = DbPsiFacade.getInstance(this.project).findDataSource(this.dataSource.getUniqueId());
            if (dbDs == null) {
                JBIterable jBIterable2 = JBIterable.empty();
                jBIterable = jBIterable2;
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"empty(...)");
            } else {
                JBIterable jBIterable3 = this.asIterable().filterMap(arg_0 -> DbContextDataSourceElements.asDbElements$lambda$2((Function1)new Function1<T, DbElement>(this, dbDs){
                    final /* synthetic */ DbContextDataSourceElements<T> this$0;
                    final /* synthetic */ DbDataSource $dbDs;
                    {
                        this.this$0 = $receiver;
                        this.$dbDs = $dbDs;
                        super(1);
                    }

                    public final DbElement invoke(T it2) {
                        return DbContextDataSourceElements.access$asDbElement(this.this$0, this.$dbDs, it2);
                    }
                }, arg_0));
                jBIterable = jBIterable3;
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable3, (String)"filterMap(...)");
            }
            dbContextDataSourceElements = this.replace((Iterable)jBIterable);
        } else {
            dbContextDataSourceElements = this.unsafeCast();
        }
        return dbContextDataSourceElements;
    }

    @NotNull
    public final DbContextDataSourceElements<T> parentsForGroups() {
        return CollectionsKt.firstOrNull(this.selection) instanceof BasicNode ? super.unsafeCast() : this;
    }

    @NotNull
    public final DbContextDataSourceElements<T> expandGroups() {
        return CollectionsKt.firstOrNull(this.selection) instanceof BasicNode ? super.unsafeCast() : this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final DbContextDataSourceElements<BasicNode> dataSourcesToRoots() {
        void s2;
        DbContextDataSourceElements<BasicNode> this_$iv = this.asNodes();
        boolean $i$f$replace = false;
        DbContextDataSourceElements<BasicNode> dbContextDataSourceElements = this_$iv;
        DbContextDataSourceElements<BasicNode> dbContextDataSourceElements2 = this_$iv;
        boolean bl = false;
        JBIterable jBIterable = s2.asIterable().filterMap(arg_0 -> DbContextDataSourceElements.dataSourcesToRoots$lambda$4$lambda$3(dataSourcesToRoots.1.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filterMap(...)");
        return dbContextDataSourceElements2.replace((Iterable)jBIterable);
    }

    /*
     * WARNING - void declaration
     */
    private final DbContextDataSourceElements<BasicNode> expandGroups(DbContextDataSourceElements<BasicNode> sel) {
        void selection2;
        DbContextDataSourceElements<BasicNode> this_$iv = sel;
        boolean $i$f$replace = false;
        DbContextDataSourceElements<BasicNode> dbContextDataSourceElements = this_$iv;
        DbContextDataSourceElements<BasicNode> dbContextDataSourceElements2 = this_$iv;
        boolean bl = false;
        ComponentManager $this$service$iv = (ComponentManager)sel.project;
        boolean $i$f$service = false;
        Class<DvTreeStructureService> serviceClass$iv = DvTreeStructureService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        DvTreeStructureService ss2 = (DvTreeStructureService)object;
        JBIterable jBIterable = ((JBTreeTraverser)((JBTreeTraverser)JBTreeTraverser.from(arg_0 -> DbContextDataSourceElements.expandGroups$lambda$7$lambda$5((Function1)new Function1<BasicNode, Iterable<? extends BasicNode>>(ss2){
            final /* synthetic */ DvTreeStructureService $ss;
            {
                this.$ss = $ss;
                super(1);
            }

            public final Iterable<BasicNode> invoke(BasicNode it2) {
                Intrinsics.checkNotNull((Object)it2);
                return (Iterable)this.$ss.childrenOf(it2);
            }
        }, arg_0)).withRoots(selection2.selection)).expandAndSkip(arg_0 -> DbContextDataSourceElements.expandGroups$lambda$7$lambda$6(expandGroups.1.2.INSTANCE, arg_0))).traverse();
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"traverse(...)");
        return dbContextDataSourceElements2.replace((Iterable)jBIterable);
    }

    /*
     * WARNING - void declaration
     */
    private final DbContextDataSourceElements<BasicNode> parentsForGroups(DbContextDataSourceElements<BasicNode> sel) {
        void selection2;
        DbContextDataSourceElements<BasicNode> this_$iv = sel;
        boolean $i$f$replace = false;
        DbContextDataSourceElements<BasicNode> dbContextDataSourceElements = this_$iv;
        DbContextDataSourceElements<BasicNode> dbContextDataSourceElements2 = this_$iv;
        boolean bl = false;
        JBIterable jBIterable = selection2.asIterable().filterMap(arg_0 -> DbContextDataSourceElements.parentsForGroups$lambda$9$lambda$8((Function1)new Function1<BasicNode, BasicNode>(sel, this){
            final /* synthetic */ DbContextDataSourceElements<BasicNode> $sel;
            final /* synthetic */ DbContextDataSourceElements<T> this$0;
            {
                this.$sel = $sel;
                this.this$0 = $receiver;
                super(1);
            }

            public final BasicNode invoke(BasicNode n) {
                ComponentManager $this$service$iv = (ComponentManager)this.$sel.getProject();
                boolean $i$f$service = false;
                Class<DvTreeStructureService> serviceClass$iv = DvTreeStructureService.class;
                Object object = $this$service$iv.getService(serviceClass$iv);
                if (object == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                DvTreeStructureService ss2 = (DvTreeStructureService)object;
                return DbContextDataSourceElements.access$parentForGroup(this.this$0, n, ss2);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filterMap(...)");
        return dbContextDataSourceElements2.replace((Iterable)jBIterable);
    }

    private final BasicNode parentForGroup(BasicNode n, DvTreeStructureService ss2) {
        BasicNode basicNode = n;
        return basicNode instanceof DataSourceNode ? (BasicNode)((DataSourceNode)n).getModelRoot() : (basicNode instanceof FamilyWithId ? this.parentForGroup(ss2.parentOf(n), ss2) : n);
    }

    private final BasicNode asNode(T o2) {
        BasicNode basicNode;
        T t = o2;
        if (t instanceof DbDataSource) {
            DasModel $this$asSafely$iv = ((DbDataSource)o2).getDelegateDataSource().getModel();
            boolean $i$f$asSafely = false;
            DasModel dasModel = $this$asSafely$iv;
            if (!(dasModel instanceof BasicModel)) {
                dasModel = null;
            }
            BasicModel basicModel = (BasicModel)dasModel;
            basicNode = basicModel != null ? basicModel.getRoot() : null;
        } else if (t instanceof DataSourceNode) {
            DasModel $this$asSafely$iv = ((DataSourceNode)o2).rawDataSource.getModel();
            boolean $i$f$asSafely = false;
            DasModel dasModel = $this$asSafely$iv;
            if (!(dasModel instanceof BasicModel)) {
                dasModel = null;
            }
            BasicModel basicModel = (BasicModel)dasModel;
            basicNode = basicModel != null ? basicModel.getRoot() : null;
        } else {
            DasObject dasObject;
            basicNode = t instanceof DbObject ? ((dasObject = ((DbObject)o2).getDelegate()) instanceof BasicNode ? (BasicNode)((Object)dasObject) : null) : (o2 instanceof BasicNode ? (BasicNode)o2 : null);
        }
        return basicNode;
    }

    private final DbElement asDbElement(DbDataSource dbDs, T o2) {
        T t = o2;
        return t instanceof DasObject ? dbDs.findElement((DasObject)o2) : (t instanceof DataSourceNode ? (DbElement)((DataSourceNode)o2).dbDataSource : null);
    }

    @NotNull
    public final <U> DbContextDataSourceElements<U> replace(@NotNull Function1<? super DbContextDataSourceElements<T>, ? extends Iterable<? extends U>> replacer) {
        Intrinsics.checkNotNullParameter(replacer, (String)"replacer");
        boolean $i$f$replace = false;
        return this.replace((Iterable)replacer.invoke((Object)this));
    }

    @NotNull
    public final <U> DbContextDataSourceElements<U> replace(@NotNull Iterable<? extends U> selection2) {
        Intrinsics.checkNotNullParameter(selection2, (String)"selection");
        return new DbContextDataSourceElements<U>(this.project, this.dataSource, selection2);
    }

    @Nullable
    public final DbContextDataSourceElements<T> nullize() {
        DbContextDataSourceElements<T> dbContextDataSourceElements;
        DbContextDataSourceElements<T> it2 = dbContextDataSourceElements = this;
        boolean bl = false;
        return this.selection.iterator().hasNext() ? dbContextDataSourceElements : null;
    }

    private static final BasicNode asNodes$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (BasicNode)$tmp0.invoke(p0);
    }

    private static final DbElement asDbElements$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (DbElement)$tmp0.invoke(p0);
    }

    private static final BasicNode dataSourcesToRoots$lambda$4$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (BasicNode)$tmp0.invoke(p0);
    }

    private static final Iterable expandGroups$lambda$7$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Iterable)$tmp0.invoke(p0);
    }

    private static final boolean expandGroups$lambda$7$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final BasicNode parentsForGroups$lambda$9$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (BasicNode)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ BasicNode access$asNode(DbContextDataSourceElements $this, Object o2) {
        return $this.asNode(o2);
    }

    public static final /* synthetic */ DbElement access$asDbElement(DbContextDataSourceElements $this, DbDataSource dbDs, Object o2) {
        return $this.asDbElement(dbDs, o2);
    }

    public static final /* synthetic */ BasicNode access$parentForGroup(DbContextDataSourceElements $this, BasicNode n, DvTreeStructureService ss2) {
        return $this.parentForGroup(n, ss2);
    }
}

