/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.statistic;

import com.intellij.database.dbimport.ImportIndicatorUpdater;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ReaderTask;
import com.intellij.database.dbimport.editor.DbImportDialog;
import com.intellij.database.statistic.DbFusImportLoggerKt;
import com.intellij.database.statistic.DialogActivity;
import com.intellij.database.statistic.ImportActivity;
import com.intellij.database.statistic.Result;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.util.containers.CollectionFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012J\u001e\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0017J.\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u0012J\u0016\u0010 \u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\tJ\u0016\u0010!\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\tJ\u000e\u0010#\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005R)\u0010\u0003\u001a\u001d\u0012\t\u0012\u00070\u0005\u00a2\u0006\u0002\b\u0006\u0012\t\u0012\u00070\u0007\u00a2\u0006\u0002\b\u00060\u0004\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\b\u001a\u001d\u0012\t\u0012\u00070\t\u00a2\u0006\u0002\b\u0006\u0012\t\u0012\u00070\n\u00a2\u0006\u0002\b\u00060\u0004\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/database/statistic/DbFusImportCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "()V", "dialogActivities", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/openapi/ui/DialogWrapper;", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/database/statistic/DialogActivity;", "importActivities", "Lcom/intellij/database/dbimport/ImportInfo;", "Lcom/intellij/database/statistic/ImportActivity;", "finishedImports", "", "dialog", "getGroup", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "logDialogClosed", "ok", "", "logDialogShown", "project", "Lcom/intellij/openapi/project/Project;", "invocationType", "Lcom/intellij/database/dbimport/editor/DbImportDialog$InvocationType;", "logFinished", "info", "source", "Lcom/intellij/database/dbimport/ReaderTask$Source;", "updater", "Lcom/intellij/database/dbimport/ImportIndicatorUpdater;", "failed", "cancelled", "logStarted", "mapImportStarted", "importInfo", "startedImports", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDbFusImportLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbFusImportLogger.kt\ncom/intellij/database/statistic/DbFusImportCollector\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,293:1\n72#2,2:294\n1#3:296\n*S KotlinDebug\n*F\n+ 1 DbFusImportLogger.kt\ncom/intellij/database/statistic/DbFusImportCollector\n*L\n238#1:294,2\n238#1:296\n*E\n"})
public final class DbFusImportCollector
extends CounterUsagesCollector {
    @NotNull
    public static final DbFusImportCollector INSTANCE = new DbFusImportCollector();
    @NotNull
    private static final ConcurrentMap<DialogWrapper, DialogActivity> dialogActivities;
    @NotNull
    private static final ConcurrentMap<ImportInfo, ImportActivity> importActivities;

    private DbFusImportCollector() {
    }

    @NotNull
    public EventLogGroup getGroup() {
        return DbFusImportLoggerKt.access$getGROUP$p();
    }

    public final void logDialogShown(@NotNull Project project, @NotNull DialogWrapper dialog, @NotNull DbImportDialog.InvocationType invocationType) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dialog, (String)"dialog");
        Intrinsics.checkNotNullParameter((Object)((Object)invocationType), (String)"invocationType");
        DialogActivity dialogActivity = new DialogActivity();
        ((Map)dialogActivities).put(dialog, dialogActivity);
        dialogActivity.started(project, invocationType);
    }

    public final void logDialogClosed(@NotNull DialogWrapper dialog, boolean ok2) {
        Intrinsics.checkNotNullParameter((Object)dialog, (String)"dialog");
        DialogActivity dialogActivity = (DialogActivity)dialogActivities.get(dialog);
        boolean bl = dialogActivity != null ? dialogActivity.closed(ok2) : false;
        if (bl) {
            dialogActivities.remove(dialog);
        }
    }

    public final void mapImportStarted(@NotNull DialogWrapper dialog, @NotNull ImportInfo importInfo) {
        Intrinsics.checkNotNullParameter((Object)dialog, (String)"dialog");
        Intrinsics.checkNotNullParameter((Object)importInfo, (String)"importInfo");
        ((Map)importActivities).put(importInfo, new ImportActivity((DialogActivity)dialogActivities.get(dialog)));
    }

    public final void logStarted(@NotNull Project project, @NotNull ImportInfo info2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
        ConcurrentMap<ImportInfo, ImportActivity> $this$getOrPut$iv = importActivities;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(info2);
        if (object == null) {
            boolean bl = false;
            ImportActivity default$iv = new ImportActivity(null);
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(info2, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        ((ImportActivity)object).started(project);
    }

    public final void logFinished(@NotNull ImportInfo info2, @NotNull ReaderTask.Source source, @NotNull ImportIndicatorUpdater updater, boolean failed, boolean cancelled) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
            ImportActivity importActivity = (ImportActivity)importActivities.remove(info2);
            if (importActivity == null) break block0;
            importActivity.finished(updater, info2, source, cancelled ? Result.CANCELLED : (failed ? Result.FAILED : Result.OK));
        }
    }

    public final void startedImports(@NotNull DialogWrapper dialog) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)dialog, (String)"dialog");
            DialogActivity dialogActivity = (DialogActivity)dialogActivities.get(dialog);
            if (dialogActivity == null) break block0;
            dialogActivity.ref();
        }
    }

    public final void finishedImports(@NotNull DialogWrapper dialog) {
        Intrinsics.checkNotNullParameter((Object)dialog, (String)"dialog");
        DialogActivity dialogActivity = (DialogActivity)dialogActivities.get(dialog);
        boolean bl = dialogActivity != null ? dialogActivity.deref() : false;
        if (bl) {
            dialogActivities.remove(dialog);
        }
    }

    static {
        ImportActivity.Companion.getIMPORT_ACTIVITY();
        ConcurrentMap concurrentMap = CollectionFactory.createConcurrentWeakMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentWeakMap(...)");
        dialogActivities = concurrentMap;
        ConcurrentMap concurrentMap2 = CollectionFactory.createConcurrentWeakMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap2, (String)"createConcurrentWeakMap(...)");
        importActivities = concurrentMap2;
    }
}

