/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.database.model.BaseModel;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ModelLightCopier;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicArrangedElement;
import com.intellij.database.model.basic.BasicDataObject;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicGrantsHolder;
import com.intellij.database.model.basic.BasicHierarchicalObject;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.ContextMetaObjectFactory;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaReference;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.model.meta.BasicResolveAssistant;
import com.intellij.database.model.properties.BasicReference;
import com.intellij.database.model.properties.references.BasicInlineObjectReference;
import com.intellij.database.schemaEditor.ElementIdentity;
import com.intellij.database.schemaEditor.ElementMatcher;
import com.intellij.database.schemaEditor.ElementOwner;
import com.intellij.database.schemaEditor.ElementOwnerResolveAssistant;
import com.intellij.database.schemaEditor.MultiElementIdentity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ElementMatcherImpl
implements ElementMatcher {
    @Nullable
    private final ElementOwnerImpl myOriginalOwner;
    private final ChildProvider myChildProvider;
    private final AtomicInteger myCounter = new AtomicInteger();
    private final Set<ElementOwnerImpl> myOwners = Collections.synchronizedSet(ContainerUtil.createWeakSet());
    private final MultiMap<Id<?>, Id<?>> myCachedChildrenIds = new MultiMap<Id<?>, Id<?>>(CollectionFactory.createConcurrentWeakMap()){

        @NotNull
        protected Collection<Id<?>> createCollection() {
            Set<Id<?>> set = Collections.synchronizedSet(ContainerUtil.createWeakSet());
            if (set == null) {
                1.$$$reportNull$$$0(0);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/ElementMatcherImpl$1", "createCollection"));
        }
    };

    public ElementMatcherImpl(boolean withOriginal, @Nullable ChildProvider childProvider) {
        this.myOriginalOwner = withOriginal ? this.createOwner() : null;
        this.myChildProvider = childProvider;
    }

    @Override
    @NotNull
    public ElementOwnerImpl createOwner() {
        ElementOwnerImpl res2 = new ElementOwnerImpl(this, this.myOriginalOwner);
        this.addOwner(res2);
        ElementOwnerImpl elementOwnerImpl = res2;
        if (elementOwnerImpl == null) {
            ElementMatcherImpl.$$$reportNull$$$0(0);
        }
        return elementOwnerImpl;
    }

    @Override
    public void removeOwner(@NotNull ElementOwner owner) {
        if (owner == null) {
            ElementMatcherImpl.$$$reportNull$$$0(1);
        }
        this.myOwners.remove(owner);
    }

    private void addOwner(@NotNull ElementOwnerImpl owner) {
        if (owner == null) {
            ElementMatcherImpl.$$$reportNull$$$0(2);
        }
        this.myOwners.add(owner);
    }

    @Override
    @Nullable
    public ElementOwner getOriginalOwner() {
        return this.myOriginalOwner;
    }

    @Override
    @Nullable
    public ElementOwnerImpl getOwner(@NotNull BasicElement e2) {
        if (e2 == null) {
            ElementMatcherImpl.$$$reportNull$$$0(3);
        }
        return (ElementOwnerImpl)ContainerUtil.find(this.myOwners, o2 -> o2.findId(e2) != null);
    }

    private void cache(@NotNull Id<?> id) {
        if (id == null) {
            ElementMatcherImpl.$$$reportNull$$$0(4);
        }
        this.myCachedChildrenIds.getModifiable(id);
        Id<?> parent2 = id.getParentId();
        if (parent2 != null) {
            this.myCachedChildrenIds.putValue(parent2, id);
        }
    }

    private Iterable<Id<?>> getCachedIds() {
        return this.myCachedChildrenIds.keySet();
    }

    private Iterable<Id<?>> getCachedChildren(Id<?> id) {
        return this.myCachedChildrenIds.get(id);
    }

    protected static boolean isNull(BasicElement res2) {
        return res2 == null || res2 instanceof BasicModElement && ((BasicModElement)res2).isDropped();
    }

    @Override
    @Nullable
    public ElementIdentity<?> getParent(@NotNull ElementIdentity<?> identity) {
        Id<?> id;
        if (identity == null) {
            ElementMatcherImpl.$$$reportNull$$$0(5);
        }
        if ((id = ElementMatcherImpl.asId(identity)) == null) {
            if (identity instanceof MultiElementIdentity) {
                MultiElementIdentity mi = (MultiElementIdentity)identity;
                JBIterable parents2 = JBIterable.from(mi.getIdentities()).map(this::getParent);
                return MultiElementIdentity.asSingleIdentityFiltered(parents2.unique());
            }
            return null;
        }
        return id.getParentId();
    }

    @Nullable
    public <E extends BasicElement> E findElement(@NotNull ElementIdentity<E> id) {
        if (id == null) {
            ElementMatcherImpl.$$$reportNull$$$0(6);
        }
        for (ElementOwnerImpl owner : this.myOwners) {
            E element2 = owner.findElement(id);
            if (element2 == null) continue;
            return element2;
        }
        return null;
    }

    @NotNull
    private <P extends BasicElement, E extends BasicElement> Iterable<E> getObjectChildren(@NotNull P original, @NotNull ElementIdentity<P> identity, @NotNull BasicMetaObject<E> childMeta) {
        if (original == null) {
            ElementMatcherImpl.$$$reportNull$$$0(7);
        }
        if (identity == null) {
            ElementMatcherImpl.$$$reportNull$$$0(8);
        }
        if (childMeta == null) {
            ElementMatcherImpl.$$$reportNull$$$0(9);
        }
        if (this.myChildProvider == null) {
            Object family = BasicMetaUtils.getFamily(original, childMeta);
            Object object = family == null ? JBIterable.empty() : family;
            if (object == null) {
                ElementMatcherImpl.$$$reportNull$$$0(10);
            }
            return object;
        }
        Iterable<E> iterable = this.myChildProvider.getChildren(original, identity, childMeta);
        if (iterable == null) {
            ElementMatcherImpl.$$$reportNull$$$0(11);
        }
        return iterable;
    }

    @NotNull
    public <S extends BasicElement, T extends BasicElement> Id<T> createInlineRef(@NotNull ElementIdentity<S> parentId, @NotNull BasicMetaReference<S, T> ref2, @NotNull BasicMetaObject<T> meta) {
        if (parentId == null) {
            ElementMatcherImpl.$$$reportNull$$$0(12);
        }
        if (ref2 == null) {
            ElementMatcherImpl.$$$reportNull$$$0(13);
        }
        if (meta == null) {
            ElementMatcherImpl.$$$reportNull$$$0(14);
        }
        return new Id<T>(ElementMatcherImpl.asId(parentId), this, ref2, meta, this.myCounter.getAndIncrement());
    }

    @Override
    @Nullable
    public <E extends BasicElement> BasicMetaReference<?, E> getInlineMetaRef(@NotNull ElementIdentity<E> identity) {
        Id<E> id;
        if (identity == null) {
            ElementMatcherImpl.$$$reportNull$$$0(15);
        }
        return (id = ElementMatcherImpl.asId(identity)) != null ? id.myInlined : null;
    }

    @Override
    @Nullable
    public BasicMetaObject<?> getMetaParent(@Nullable BasicMetaObject<?> meta) {
        return this.myChildProvider == null ? (meta == null ? null : meta.getParent()) : this.myChildProvider.getParent(meta);
    }

    @Override
    @NotNull
    public Iterable<BasicMetaObject<?>> getMetaChildren(@Nullable BasicMetaObject<?> meta) {
        JBIterable jBIterable = this.myChildProvider == null ? JBIterable.of((Object[])(meta == null ? null : meta.children)) : this.myChildProvider.getChildren(meta);
        if (jBIterable == null) {
            ElementMatcherImpl.$$$reportNull$$$0(16);
        }
        return jBIterable;
    }

    @NotNull
    public <E extends BasicElement> Id<E> create(@Nullable ElementIdentity<?> parent2, @NotNull BasicMetaObject<E> meta) {
        if (meta == null) {
            ElementMatcherImpl.$$$reportNull$$$0(17);
        }
        return new Id<E>(ElementMatcherImpl.asId(parent2), this, meta, this.myCounter.getAndIncrement());
    }

    @Nullable
    public <E extends BasicElement> E find(@NotNull ElementOwner base, @NotNull ElementIdentity<E> identity) {
        if (base == null) {
            ElementMatcherImpl.$$$reportNull$$$0(18);
        }
        if (identity == null) {
            ElementMatcherImpl.$$$reportNull$$$0(19);
        }
        return base.find(identity);
    }

    @Nullable
    private static <E extends BasicElement> E findInlined(BasicElement p2, @NotNull Id<E> id) {
        BasicMetaReference<BasicElement, BasicElement> metaRef;
        if (id == null) {
            ElementMatcherImpl.$$$reportNull$$$0(20);
        }
        if ((metaRef = id.getInlined(p2)) == null) {
            return null;
        }
        BasicReference ref2 = (BasicReference)metaRef.get(p2);
        BasicInlineObjectReference inline = (BasicInlineObjectReference)ObjectUtils.tryCast((Object)ref2, BasicInlineObjectReference.class);
        return inline == null ? null : (E)inline.getInlineData(metaRef.getReferenceDesc());
    }

    @Nullable
    private static <E extends BasicElement> Id<E> asId(@Nullable ElementIdentity<E> identity) {
        return (Id)ObjectUtils.tryCast(identity, Id.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 12, 13, 14, 15, 17, 18, 19, 20 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/ElementMatcherImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: 
            case 6: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 5: 
            case 8: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identity";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childMeta";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentId";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meta";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createOwner";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/ElementMatcherImpl";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectChildren";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetaChildren";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "removeOwner";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addOwner";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getOwner";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "cache";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getParent";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findElement";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getObjectChildren";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createInlineRef";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getInlineMetaRef";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findInlined";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 12, 13, 14, 15, 17, 18, 19, 20 -> new IllegalArgumentException(string);
        };
    }

    public static class ElementOwnerImpl
    implements ElementOwner {
        private final EventDispatcher<ElementOwner.ElementListener> myDispatcher;
        private final ElementMatcherImpl myMatcher;
        private final OriginalHelper myOriginalHelper;
        private final ConcurrentMap<BasicElement, Id<?>> myIds;
        private final ConcurrentMap<Id<?>, BasicElement> myRev;
        private final Set<Id<?>> myDrops;
        private final Set<BasicElement> myStrongRefs;
        private final BasicResolveAssistant myResolveAssistant;

        public ElementOwnerImpl(@NotNull ElementMatcherImpl matcher, @Nullable ElementOwnerImpl originalOwner) {
            if (matcher == null) {
                ElementOwnerImpl.$$$reportNull$$$0(0);
            }
            this.myDispatcher = EventDispatcher.create(ElementOwner.ElementListener.class);
            this.myIds = ContainerUtil.createConcurrentWeakMap();
            this.myRev = CollectionFactory.createConcurrentWeakValueMap();
            this.myDrops = ConcurrentCollectionFactory.createConcurrentSet();
            this.myStrongRefs = ConcurrentCollectionFactory.createConcurrentSet();
            this.myResolveAssistant = new ElementOwnerResolveAssistant(this);
            this.myMatcher = matcher;
            this.myOriginalHelper = originalOwner == null ? null : new OriginalHelper(originalOwner);
        }

        public Iterable<? extends ElementIdentity<?>> getCached() {
            return JBIterable.from(this.myMatcher.getCachedIds()).filter(id -> id.myInlined == null);
        }

        @NotNull
        private <T extends BasicElement> Id<T> computeIdIfAbsent(@NotNull T element2, @NotNull Function<T, Id<T>> compute2) {
            if (element2 == null) {
                ElementOwnerImpl.$$$reportNull$$$0(1);
            }
            if (compute2 == null) {
                ElementOwnerImpl.$$$reportNull$$$0(2);
            }
            Id id = this.myIds.computeIfAbsent(element2, e2 -> (Id)compute2.apply(e2));
            if (id == null) {
                ElementOwnerImpl.$$$reportNull$$$0(3);
            }
            return id;
        }

        @NotNull
        protected <E extends BasicElement> Id<E> createId(@NotNull E element2) {
            if (element2 == null) {
                ElementOwnerImpl.$$$reportNull$$$0(4);
            }
            Id<E> id = this.createIdImpl(element2);
            if (id == null) {
                ElementOwnerImpl.$$$reportNull$$$0(5);
            }
            return id;
        }

        private <T extends BasicElement, S extends BasicElement> Id<T> createInlineId(S owner, BasicMetaReference<S, T> ref2, T orig) {
            return this.createInlineIdImpl(owner, ref2, orig);
        }

        @NotNull
        private <T extends BasicElement, S extends BasicElement> Id<T> createInlineIdImpl(S owner, BasicMetaReference<S, T> ref2, T orig) {
            Id<BasicElement> res2 = this.computeIdIfAbsent(orig, e2 -> new Id<BasicElement>(this.createIdImpl(owner), this.myMatcher, ref2, BasicMetaUtils.getMetaObject(orig), this.myMatcher.myCounter.getAndIncrement()));
            this.addTargetImpl(res2, orig);
            Id<BasicElement> id = res2;
            if (id == null) {
                ElementOwnerImpl.$$$reportNull$$$0(6);
            }
            return id;
        }

        protected <E extends BasicElement> void addResolution(@NotNull Id<E> id, @NotNull E element2) {
            if (id == null) {
                ElementOwnerImpl.$$$reportNull$$$0(7);
            }
            if (element2 == null) {
                ElementOwnerImpl.$$$reportNull$$$0(8);
            }
            if (this.myOriginalHelper == null) {
                throw new AssertionError((Object)"Attempt to add resolution for original element");
            }
            this.addResolutionImpl(id, element2);
        }

        private <E extends BasicElement> void addResolutionImpl(@Nullable Id<E> id, @Nullable E element2) {
            if (id == null || element2 == null) {
                return;
            }
            Id<E> prev = this.myIds.putIfAbsent(element2, id);
            if (prev != null) {
                if (prev != id) {
                    throw new AssertionError((Object)"Attempt to override existing resolution");
                }
                return;
            }
            this.addTargetImpl(id, element2);
            this.addResolutionImpl(id.getParentId(), element2.getParent());
        }

        private <E extends BasicElement> void addTargetImpl(@NotNull Id<E> id, @Nullable E element2) {
            if (id == null) {
                ElementOwnerImpl.$$$reportNull$$$0(9);
            }
            this.myRev.put(id, element2);
            if (element2 instanceof BasicDataObject || element2 instanceof BasicRoot) {
                this.myStrongRefs.add(element2);
            }
            this.myDrops.remove(id);
            ((ElementOwner.ElementListener)this.myDispatcher.getMulticaster()).onAdded(element2, id);
        }

        private <E extends BasicElement> Id<E> createIdImpl(@Nullable E element2) {
            if (element2 == null) {
                return null;
            }
            Id<BasicElement> res2 = this.computeIdIfAbsent(element2, e2 -> new Id<BasicElement>(this.createIdImpl(element2.getParent()), this.myMatcher, BasicMetaUtils.getMetaObject(element2), this.myMatcher.myCounter.getAndIncrement()));
            this.addTargetImpl(res2, element2);
            return res2;
        }

        @Override
        public <E extends BasicElement> void addMatch(@NotNull ElementIdentity<E> identity, @NotNull E element2) {
            Id<E> id;
            if (identity == null) {
                ElementOwnerImpl.$$$reportNull$$$0(10);
            }
            if (element2 == null) {
                ElementOwnerImpl.$$$reportNull$$$0(11);
            }
            if ((id = ElementMatcherImpl.asId(identity)) != null) {
                this.addResolution(id, element2);
            }
        }

        @Override
        public <E extends BasicElement> void addMatchAndPull(@NotNull ElementIdentity<E> identity, @NotNull E element2) {
            Id<E> id;
            if (identity == null) {
                ElementOwnerImpl.$$$reportNull$$$0(12);
            }
            if (element2 == null) {
                ElementOwnerImpl.$$$reportNull$$$0(13);
            }
            if ((id = ElementMatcherImpl.asId(identity)) != null) {
                if (this.myOriginalHelper == null) {
                    throw new AssertionError((Object)"Attempt to add match for original element");
                }
                this.myOriginalHelper.addMatchAndPull(id, element2);
            }
        }

        @Nullable
        private <E extends BasicElement> Id<E> findId(@NotNull E e2) {
            if (e2 == null) {
                ElementOwnerImpl.$$$reportNull$$$0(14);
            }
            return (Id)this.myIds.get(e2);
        }

        @Override
        @Nullable
        public <E extends BasicElement> ElementIdentity<E> findIdentity(@Nullable E e2) {
            return e2 == null ? null : this.findId(e2);
        }

        @NotNull
        public <E extends BasicElement> Id<E> identify(@NotNull E e2) {
            Id<E> id;
            if (e2 == null) {
                ElementOwnerImpl.$$$reportNull$$$0(15);
            }
            if ((id = this.findId(e2)) != null) {
                Id<E> id2 = id;
                if (id2 == null) {
                    ElementOwnerImpl.$$$reportNull$$$0(16);
                }
                return id2;
            }
            Id<E> id3 = this.createId(e2);
            if (id3 == null) {
                ElementOwnerImpl.$$$reportNull$$$0(17);
            }
            return id3;
        }

        @NotNull
        public <S extends BasicElement, T extends BasicElement> Id<T> identifyInlineRef(@NotNull S owner, @NotNull BasicMetaReference<S, T> metaRef, @NotNull T e2) {
            Id<T> id;
            if (owner == null) {
                ElementOwnerImpl.$$$reportNull$$$0(18);
            }
            if (metaRef == null) {
                ElementOwnerImpl.$$$reportNull$$$0(19);
            }
            if (e2 == null) {
                ElementOwnerImpl.$$$reportNull$$$0(20);
            }
            if ((id = this.findId(e2)) != null) {
                Id<T> id2 = id;
                if (id2 == null) {
                    ElementOwnerImpl.$$$reportNull$$$0(21);
                }
                return id2;
            }
            if (this.myOriginalHelper != null) {
                ElementIdentity ownerId = this.identify(owner);
                this.myOriginalHelper.pullFromOriginal(ownerId);
                id = this.findId(e2);
                if (id != null) {
                    Id<T> id3 = id;
                    if (id3 == null) {
                        ElementOwnerImpl.$$$reportNull$$$0(22);
                    }
                    return id3;
                }
            }
            Id<T> id4 = this.createInlineId(owner, metaRef, e2);
            if (id4 == null) {
                ElementOwnerImpl.$$$reportNull$$$0(23);
            }
            return id4;
        }

        @Override
        @NotNull
        public <E extends BasicElement> JBIterable<ElementIdentity<E>> getChildren(@NotNull ElementIdentity<?> identity, @NotNull BasicMetaObject<E> childMeta) {
            Id<?> id;
            if (identity == null) {
                ElementOwnerImpl.$$$reportNull$$$0(24);
            }
            if (childMeta == null) {
                ElementOwnerImpl.$$$reportNull$$$0(25);
            }
            if ((id = ElementMatcherImpl.asId(identity)) == null) {
                JBIterable jBIterable = JBIterable.empty();
                if (jBIterable == null) {
                    ElementOwnerImpl.$$$reportNull$$$0(26);
                }
                return jBIterable;
            }
            this.fillChildrenCacheUsingOriginal(id, childMeta);
            JBIterable jBIterable = JBIterable.from(this.myMatcher.getCachedChildren(id)).filter(cId -> cId.getMetaObject() == childMeta && !this.isDropped((ElementIdentity<?>)cId)).filterMap(cId -> ElementIdentity.tryCast(cId, childMeta)).collect();
            if (jBIterable == null) {
                ElementOwnerImpl.$$$reportNull$$$0(27);
            }
            return jBIterable;
        }

        @Override
        @Nullable
        public ElementIdentity<?> getParent(@NotNull ElementIdentity<?> identity) {
            Id<?> id;
            if (identity == null) {
                ElementOwnerImpl.$$$reportNull$$$0(28);
            }
            return (id = ElementMatcherImpl.asId(identity)) == null ? null : id.getParentId();
        }

        private <P extends BasicElement, E extends BasicElement> void fillChildrenCacheUsingOriginal(@NotNull Id<P> identity, @NotNull BasicMetaObject<E> childMeta) {
            if (identity == null) {
                ElementOwnerImpl.$$$reportNull$$$0(29);
            }
            if (childMeta == null) {
                ElementOwnerImpl.$$$reportNull$$$0(30);
            }
            if (this.myOriginalHelper != null) {
                this.myOriginalHelper.myOriginalOwner.fillChildrenCacheUsingOriginal(identity, childMeta);
                return;
            }
            if (!identity.myPulled.add(childMeta)) {
                return;
            }
            P original = this.findElement(identity);
            if (original == null) {
                return;
            }
            for (BasicElement child : this.myMatcher.getObjectChildren(original, identity, childMeta)) {
                if (child instanceof BasicDataObject) {
                    ElementIdentity cId = this.create(identity, (BasicMetaObject)childMeta);
                    this.addResolutionImpl((Id<E>)cId, (E)child);
                    continue;
                }
                this.identify(child);
            }
        }

        @Override
        @Nullable
        public <E extends BasicElement> E findOrCreate(@NotNull ElementIdentity<E> identity) {
            Id<?> parentId;
            if (identity == null) {
                ElementOwnerImpl.$$$reportNull$$$0(31);
            }
            Id<E> id = ElementMatcherImpl.asId(identity);
            E res2 = this.find(identity);
            if (res2 != null) {
                return this.ensureMutable(id, res2);
            }
            Id<?> id2 = parentId = id == null ? null : id.getParentId();
            if (parentId == null) {
                return null;
            }
            Object parent2 = this.findOrCreate(parentId);
            return this.createObject(parentId, (BasicElement)parent2, id);
        }

        @Nullable
        private <E extends BasicElement> E createObject(@NotNull Id<?> parentId, @Nullable BasicElement parent2, @NotNull Id<E> id) {
            BasicModel model2;
            if (parentId == null) {
                ElementOwnerImpl.$$$reportNull$$$0(32);
            }
            if (id == null) {
                ElementOwnerImpl.$$$reportNull$$$0(33);
            }
            if (parent2 instanceof BasicHierarchicalObject) {
                BasicHierarchicalObject h2 = (BasicHierarchicalObject)parent2;
                v0 = h2.getModel();
            } else {
                v0 = model2 = null;
            }
            if (model2 == null) {
                return this.createObjectImpl(parentId, parent2, id);
            }
            Ref res2 = Ref.create();
            model2.mod(r -> res2.set(this.createObjectImpl(parentId, parent2, id)));
            return (E)((BasicElement)res2.get());
        }

        @Nullable
        private <E extends BasicElement> E createObjectImpl(@NotNull Id<?> parentId, @Nullable BasicElement parent2, @NotNull Id<E> id) {
            E res2;
            BasicMetaReference<BasicElement, BasicElement> inlined2;
            if (parentId == null) {
                ElementOwnerImpl.$$$reportNull$$$0(34);
            }
            if (id == null) {
                ElementOwnerImpl.$$$reportNull$$$0(35);
            }
            if ((inlined2 = id.getInlined(parent2)) != null) {
                res2 = id.getMetaObject().newDataObject();
                if (parent2 != null) {
                    inlined2.set(parent2, (BasicElement)((Object)BasicInlineObjectReference.createMutable(res2)));
                }
            } else {
                res2 = this.createObj(parentId, parent2, id.getMetaObject());
            }
            if (res2 == null) {
                return null;
            }
            if (this.myOriginalHelper != null) {
                this.addResolution(id, res2);
            } else if (res2.getModel() == null) {
                this.addResolutionImpl(id, res2);
            }
            return res2;
        }

        @NotNull
        private <E extends BasicElement> E ensureMutable(@Nullable Id<E> id, @NotNull E element2) {
            Id<?> parentId;
            if (element2 == null) {
                ElementOwnerImpl.$$$reportNull$$$0(36);
            }
            Id<?> id2 = parentId = id == null ? null : id.getParentId();
            if (parentId == null) {
                E e2 = element2;
                if (e2 == null) {
                    ElementOwnerImpl.$$$reportNull$$$0(37);
                }
                return e2;
            }
            E replacement = this.ensureMutableImpl(id, element2);
            if (replacement == element2) {
                E e3 = element2;
                if (e3 == null) {
                    ElementOwnerImpl.$$$reportNull$$$0(38);
                }
                return e3;
            }
            Object parent2 = this.findOrCreate(parentId);
            if (parent2 == null) {
                E e4 = replacement;
                if (e4 == null) {
                    ElementOwnerImpl.$$$reportNull$$$0(39);
                }
                return e4;
            }
            BasicMetaReference<?, ?> inlined2 = id.getInlined(parent2);
            if (inlined2 != null) {
                inlined2.set(parent2, BasicInlineObjectReference.createMutable(replacement));
            }
            E e5 = replacement;
            if (e5 == null) {
                ElementOwnerImpl.$$$reportNull$$$0(40);
            }
            return e5;
        }

        private <E extends BasicElement> E ensureMutableImpl(@NotNull Id<E> id, @NotNull E element2) {
            if (id == null) {
                ElementOwnerImpl.$$$reportNull$$$0(41);
            }
            if (element2 == null) {
                ElementOwnerImpl.$$$reportNull$$$0(42);
            }
            if (id.myInlined == null) {
                return element2;
            }
            BasicDataObject o2 = (BasicDataObject)ObjectUtils.tryCast(element2, BasicDataObject.class);
            if (o2 == null || !o2.isFrozen()) {
                return element2;
            }
            BasicElement model2 = (BasicElement)this.myRev.remove(element2);
            if (model2 == null) {
                return element2;
            }
            BasicDataObject res2 = o2.copy();
            if (this.myStrongRefs.remove(element2)) {
                this.myStrongRefs.add(res2);
            }
            this.myIds.remove(element2);
            this.myIds.put(res2, id);
            this.myRev.put(id, res2);
            return (E)res2;
        }

        @Override
        public boolean isDropped(@NotNull ElementIdentity<?> identity) {
            if (identity == null) {
                ElementOwnerImpl.$$$reportNull$$$0(43);
            }
            return this.myDrops.contains(identity);
        }

        @Override
        @Nullable
        public <E extends BasicElement> E find(@NotNull ElementIdentity<E> identity) {
            if (identity == null) {
                ElementOwnerImpl.$$$reportNull$$$0(44);
            }
            if (this.isDropped(identity)) {
                return null;
            }
            Id<E> id = ElementMatcherImpl.asId(identity);
            if (id == null) {
                return null;
            }
            E res2 = this.findElement(id);
            if (res2 == null && this.myOriginalHelper != null) {
                res2 = this.myOriginalHelper.pullFromOriginal(id);
            }
            return res2;
        }

        @Nullable
        private <E extends BasicElement> E createObj(Id<?> parentId, BasicElement parent2, BasicMetaObject<E> meta) {
            return this.createObjMod(parentId, (BasicModElement)parent2, meta);
        }

        @Nullable
        private <E extends BasicModElement> E createObjMod(Id<?> parentId, BasicModElement parent2, BasicMetaObject<E> meta) {
            if (parent2 == null) {
                return null;
            }
            ModFamily family = (ModFamily)BasicMetaUtils.getFamily(parent2, meta);
            if (family == null) {
                return (E)((BasicModElement)meta.newDataObject());
            }
            if (family.isEmpty() && meta.kindOf(BasicArrangedElement.class) && this.myOriginalHelper != null) {
                this.myOriginalHelper.fillFamilyUsingOriginal(parentId, meta, family);
            }
            return family.createNewOne();
        }

        @Override
        public <E extends BasicElement> void drop(@NotNull ElementIdentity<E> identity) {
            Id<E> id;
            if (identity == null) {
                ElementOwnerImpl.$$$reportNull$$$0(45);
            }
            if ((id = ElementMatcherImpl.asId(identity)) == null) {
                return;
            }
            E e2 = this.find(id);
            if (e2 != null) {
                if (id.myInlined != null) {
                    this.dropInlineRef(id);
                } else if (!(e2 instanceof BasicDataObject)) {
                    ((BasicModElement)e2).drop();
                }
            }
            this.myDrops.add(id);
        }

        private <E extends BasicElement> void dropInlineRef(Id<E> id) {
            Id<?> parentId = id.getParentId();
            this.dropInlineRef(parentId, id.myInlined);
        }

        private <S extends BasicElement, T extends BasicElement> void dropInlineRef(Id<S> parentId, BasicMetaReference<S, T> inlined2) {
            Object parent2;
            Object e2 = parent2 = parentId == null ? null : (Object)this.find(parentId);
            if (parent2 != null) {
                inlined2.set(parent2, null);
            }
        }

        @NotNull
        public <E extends BasicElement> Id<E> create(@Nullable ElementIdentity<?> parent2, @NotNull BasicMetaObject<E> meta) {
            if (meta == null) {
                ElementOwnerImpl.$$$reportNull$$$0(46);
            }
            ElementIdentity elementIdentity = this.myMatcher.create((ElementIdentity)parent2, (BasicMetaObject)meta);
            if (elementIdentity == null) {
                ElementOwnerImpl.$$$reportNull$$$0(47);
            }
            return elementIdentity;
        }

        @NotNull
        public <E extends BasicElement> Id<E> register(@Nullable ElementIdentity<?> parent2, @NotNull E object) {
            BasicModModel model2;
            BasicElement p2;
            if (object == null) {
                ElementOwnerImpl.$$$reportNull$$$0(48);
            }
            if ((p2 = object.getParent()) != null && p2 != this.findElement(parent2)) {
                throw new AssertionError((Object)"Invalid parent provided");
            }
            ElementIdentity res2 = this.create((ElementIdentity)parent2, (BasicMetaObject)BasicMetaUtils.getMetaObject(object));
            this.addResolutionImpl((Id<E>)res2, object);
            if (this.myOriginalHelper != null && (model2 = (BasicModModel)ObjectUtils.tryCast((Object)object.getModel(), BasicModModel.class)) != null) {
                BaseModel.setResolveAssistant(model2, this.getResolveAssistant());
            }
            ElementIdentity elementIdentity = res2;
            if (elementIdentity == null) {
                ElementOwnerImpl.$$$reportNull$$$0(49);
            }
            return elementIdentity;
        }

        @Override
        @NotNull
        public ElementMatcher getMatcher() {
            ElementMatcherImpl elementMatcherImpl = this.myMatcher;
            if (elementMatcherImpl == null) {
                ElementOwnerImpl.$$$reportNull$$$0(50);
            }
            return elementMatcherImpl;
        }

        @Override
        @Nullable
        public ElementOwnerImpl getOriginal() {
            return this.myOriginalHelper == null ? null : this.myOriginalHelper.myOriginalOwner;
        }

        @Override
        @NotNull
        public BasicResolveAssistant getResolveAssistant() {
            BasicResolveAssistant basicResolveAssistant = this.myResolveAssistant;
            if (basicResolveAssistant == null) {
                ElementOwnerImpl.$$$reportNull$$$0(51);
            }
            return basicResolveAssistant;
        }

        @Override
        public void addListener(@NotNull ElementOwner.ElementListener listener2, @NotNull Disposable parent2) {
            if (listener2 == null) {
                ElementOwnerImpl.$$$reportNull$$$0(52);
            }
            if (parent2 == null) {
                ElementOwnerImpl.$$$reportNull$$$0(53);
            }
            this.myDispatcher.addListener((EventListener)listener2, parent2);
        }

        @Override
        @Nullable
        public <E extends BasicElement> E findElement(@Nullable ElementIdentity<E> id) {
            BasicElement res2 = id == null ? null : (BasicElement)this.myRev.get(id);
            return ElementMatcherImpl.isNull(res2) ? null : (E)id.getMetaObject().tryCast(res2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 5, 6, 16, 17, 21, 22, 23, 26, 27, 37, 38, 39, 40, 47, 49, 50, 51 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "matcher";
                    break;
                }
                case 1: 
                case 4: 
                case 8: 
                case 11: 
                case 13: 
                case 36: 
                case 42: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "compute";
                    break;
                }
                case 3: 
                case 5: 
                case 6: 
                case 16: 
                case 17: 
                case 21: 
                case 22: 
                case 23: 
                case 26: 
                case 27: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 47: 
                case 49: 
                case 50: 
                case 51: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/ElementMatcherImpl$ElementOwnerImpl";
                    break;
                }
                case 7: 
                case 9: 
                case 33: 
                case 35: 
                case 41: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
                case 10: 
                case 12: 
                case 24: 
                case 28: 
                case 29: 
                case 31: 
                case 43: 
                case 44: 
                case 45: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "identity";
                    break;
                }
                case 14: 
                case 15: 
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "metaRef";
                    break;
                }
                case 25: 
                case 30: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "childMeta";
                    break;
                }
                case 32: 
                case 34: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentId";
                    break;
                }
                case 46: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "meta";
                    break;
                }
                case 48: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
                case 52: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listener";
                    break;
                }
                case 53: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/ElementMatcherImpl$ElementOwnerImpl";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "computeIdIfAbsent";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createId";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createInlineIdImpl";
                    break;
                }
                case 16: 
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "identify";
                    break;
                }
                case 21: 
                case 22: 
                case 23: {
                    objectArray = objectArray2;
                    objectArray2[1] = "identifyInlineRef";
                    break;
                }
                case 26: 
                case 27: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 37: 
                case 38: 
                case 39: 
                case 40: {
                    objectArray = objectArray2;
                    objectArray2[1] = "ensureMutable";
                    break;
                }
                case 47: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
                case 49: {
                    objectArray = objectArray2;
                    objectArray2[1] = "register";
                    break;
                }
                case 50: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMatcher";
                    break;
                }
                case 51: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResolveAssistant";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "computeIdIfAbsent";
                    break;
                }
                case 3: 
                case 5: 
                case 6: 
                case 16: 
                case 17: 
                case 21: 
                case 22: 
                case 23: 
                case 26: 
                case 27: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 47: 
                case 49: 
                case 50: 
                case 51: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createId";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "addResolution";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "addTargetImpl";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "addMatch";
                    break;
                }
                case 12: 
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "addMatchAndPull";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "findId";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "identify";
                    break;
                }
                case 18: 
                case 19: 
                case 20: {
                    objectArray = objectArray;
                    objectArray[2] = "identifyInlineRef";
                    break;
                }
                case 24: 
                case 25: {
                    objectArray = objectArray;
                    objectArray[2] = "getChildren";
                    break;
                }
                case 28: {
                    objectArray = objectArray;
                    objectArray[2] = "getParent";
                    break;
                }
                case 29: 
                case 30: {
                    objectArray = objectArray;
                    objectArray[2] = "fillChildrenCacheUsingOriginal";
                    break;
                }
                case 31: {
                    objectArray = objectArray;
                    objectArray[2] = "findOrCreate";
                    break;
                }
                case 32: 
                case 33: {
                    objectArray = objectArray;
                    objectArray[2] = "createObject";
                    break;
                }
                case 34: 
                case 35: {
                    objectArray = objectArray;
                    objectArray[2] = "createObjectImpl";
                    break;
                }
                case 36: {
                    objectArray = objectArray;
                    objectArray[2] = "ensureMutable";
                    break;
                }
                case 41: 
                case 42: {
                    objectArray = objectArray;
                    objectArray[2] = "ensureMutableImpl";
                    break;
                }
                case 43: {
                    objectArray = objectArray;
                    objectArray[2] = "isDropped";
                    break;
                }
                case 44: {
                    objectArray = objectArray;
                    objectArray[2] = "find";
                    break;
                }
                case 45: {
                    objectArray = objectArray;
                    objectArray[2] = "drop";
                    break;
                }
                case 46: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 48: {
                    objectArray = objectArray;
                    objectArray[2] = "register";
                    break;
                }
                case 52: 
                case 53: {
                    objectArray = objectArray;
                    objectArray[2] = "addListener";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 5, 6, 16, 17, 21, 22, 23, 26, 27, 37, 38, 39, 40, 47, 49, 50, 51 -> new IllegalStateException(string);
            };
        }

        private class OriginalHelper {
            private final ElementOwnerImpl myOriginalOwner;

            private OriginalHelper(ElementOwnerImpl owner) {
                if (owner == null) {
                    OriginalHelper.$$$reportNull$$$0(0);
                }
                this.myOriginalOwner = owner;
            }

            @Nullable
            private <E extends BasicElement> E pullFromOriginal(@NotNull Id<E> id) {
                E orig;
                if (id == null) {
                    OriginalHelper.$$$reportNull$$$0(1);
                }
                if ((orig = this.myOriginalOwner.findElement(id)) == null) {
                    return null;
                }
                Id<?> parentId = id.getParentId();
                if (parentId == null) {
                    return this.pullRootLikeObject(id, orig);
                }
                Object parent2 = ElementOwnerImpl.this.find(parentId);
                if (parent2 == null) {
                    return null;
                }
                if (id.myInlined != null) {
                    E res2 = ElementMatcherImpl.findInlined(parent2, id);
                    if (res2 != null) {
                        ElementOwnerImpl.this.addResolution(id, res2);
                    }
                    return res2;
                }
                E res3 = this.pullRootLikeObject(id, orig);
                if (res3 != null) {
                    return res3;
                }
                this.pull(id, (BasicElement)parent2, orig);
                return ElementOwnerImpl.this.findElement(id);
            }

            private <E extends BasicElement> void addMatchAndPull(@NotNull Id<E> id, E res2) {
                if (id == null) {
                    OriginalHelper.$$$reportNull$$$0(2);
                }
                Id<?> parentId = id.getParentId();
                BasicElement parent2 = res2.getParent();
                if (parentId != null && parent2 != null) {
                    this.addMatchAndPull(parentId, parent2);
                }
                ElementOwnerImpl.this.addResolution(id, res2);
                E orig = this.myOriginalOwner.findElement(id);
                if (orig != null) {
                    this.pullElementTo(id, res2, orig);
                }
            }

            @Nullable
            private <E extends BasicElement> E pullRootLikeObject(@NotNull Id<E> id, E orig) {
                if (id == null) {
                    OriginalHelper.$$$reportNull$$$0(3);
                }
                if (orig instanceof BasicRoot) {
                    return this.pullModelRoot(id, orig);
                }
                if (orig instanceof BasicDataObject) {
                    E res2 = BasicMetaUtils.getMetaObject(orig).newDataObject();
                    this.pullElementProperties(id, res2, orig);
                    return res2;
                }
                return null;
            }

            @NotNull
            private <E extends BasicElement> E pullModelRoot(Id<E> id, E orig) {
                Object model2 = orig.getMetaObject().getModel().newModel();
                BaseModel.setResolveAssistant(model2, ElementOwnerImpl.this.getResolveAssistant());
                BasicRoot root2 = model2.getRoot();
                this.pullElementTo(id, root2, orig);
                BasicRoot basicRoot = root2;
                if (basicRoot == null) {
                    OriginalHelper.$$$reportNull$$$0(4);
                }
                return (E)basicRoot;
            }

            private <E extends BasicModElement> void fillFamilyUsingOriginal(Id<?> parentId, BasicMetaObject<E> meta, ModFamily<E> family) {
                Object origParent = this.myOriginalOwner.findElement(parentId);
                Family<?> srcFamily = origParent == null ? null : (Family<?>)BasicMetaUtils.getFamily(origParent, meta);
                this.pullFamily(family, srcFamily);
            }

            private <E extends BasicElement> void pull(@NotNull Id<E> id, @NotNull BasicElement parent2, @NotNull E orig) {
                BasicModel model2;
                if (id == null) {
                    OriginalHelper.$$$reportNull$$$0(5);
                }
                if (parent2 == null) {
                    OriginalHelper.$$$reportNull$$$0(6);
                }
                if (orig == null) {
                    OriginalHelper.$$$reportNull$$$0(7);
                }
                if (parent2 instanceof BasicHierarchicalObject) {
                    BasicHierarchicalObject h2 = (BasicHierarchicalObject)parent2;
                    v0 = h2.getModel();
                } else {
                    v0 = model2 = null;
                }
                if (model2 == null) {
                    this.pullImpl(id, parent2, orig);
                } else {
                    model2.modify(BasicModRoot.class, r -> this.pullImpl(id, parent2, orig));
                }
            }

            private <E extends BasicElement> void pullImpl(@NotNull Id<E> id, @NotNull BasicElement parent2, @NotNull E orig) {
                ModFamily tgtFamily;
                if (id == null) {
                    OriginalHelper.$$$reportNull$$$0(8);
                }
                if (parent2 == null) {
                    OriginalHelper.$$$reportNull$$$0(9);
                }
                if (orig == null) {
                    OriginalHelper.$$$reportNull$$$0(10);
                }
                if ((tgtFamily = (ModFamily)parent2.familyOf(orig.getKind())) == null || tgtFamily.getMetaObject() != orig.getMetaObject()) {
                    return;
                }
                if (orig instanceof BasicArrangedElement) {
                    this.pullFamily(tgtFamily, orig.getParentFamily());
                } else {
                    this.pullElement(id, tgtFamily, orig);
                }
            }

            private void pullFamily(@Nullable ModFamily<?> tgtFamily, @Nullable Family<?> srcFamily) {
                if (tgtFamily == null || srcFamily == null || !tgtFamily.isEmpty()) {
                    return;
                }
                for (BasicElement srcE : srcFamily) {
                    this.pullElement((Id)this.myOriginalOwner.identify(srcE), tgtFamily, (BasicElement)srcE);
                }
            }

            private <E extends BasicElement> void pullElement(@NotNull Id<E> id, @Nullable ModFamily<?> tgtFamily, E srcE) {
                if (id == null) {
                    OriginalHelper.$$$reportNull$$$0(11);
                }
                if (tgtFamily == null) {
                    return;
                }
                Object tgtE = tgtFamily.createNewOne();
                this.pullElementTo(id, (E)tgtE, srcE);
            }

            private <E extends BasicElement> void pullElementTo(@NotNull Id<E> id, E tgtE, E srcE) {
                if (id == null) {
                    OriginalHelper.$$$reportNull$$$0(12);
                }
                this.pullElementProperties(id, tgtE, srcE);
                if (tgtE instanceof DasRoutine || tgtE instanceof DasTable) {
                    this.pullFamilies(tgtE, srcE);
                } else {
                    this.pullGrantHolderChildren(tgtE, srcE);
                }
            }

            private <E extends BasicElement> void pullGrantHolderChildren(E tgtE, E srcE) {
                for (Family<? extends BasicElement> family : srcE.getFamilies()) {
                    if (!family.getMetaObject().kindOf(BasicGrantsHolder.class)) continue;
                    this.pullFamilyTo(tgtE, family);
                }
            }

            private <E extends BasicElement> void pullElementProperties(Id<E> id, E tgtE, E srcE) {
                ModelLightCopier.copyProperties(srcE, (BasicModElement)tgtE, true, true);
                ElementOwnerImpl.this.addResolution(id, tgtE);
                this.processInlineReferences(tgtE, srcE);
            }

            private <E extends BasicElement> void processInlineReferences(E tgtE, E srcE) {
                BasicMetaUtils.makeInlinesMutable(tgtE);
                for (BasicMetaReference ref2 : BasicMetaUtils.getMetaObject(tgtE).getAllProperties().filterMap(BasicMetaReference::asRef)) {
                    this.addInlineRefResolution(tgtE, srcE, ref2);
                }
            }

            private <E extends BasicElement, T extends BasicElement> void addInlineRefResolution(E tgtE, E srcE, BasicMetaReference<E, T> metaRef) {
                if (metaRef.isAbstract()) {
                    return;
                }
                BasicReference tgt = (BasicReference)metaRef.get(tgtE);
                BasicReference src2 = (BasicReference)metaRef.get(srcE);
                if (tgt instanceof BasicInlineObjectReference) {
                    BasicInlineObjectReference tgtI = (BasicInlineObjectReference)tgt;
                    if (src2 instanceof BasicInlineObjectReference) {
                        BasicInlineObjectReference srcI = (BasicInlineObjectReference)src2;
                        Object tgtObj = tgtI.getInlineData(metaRef.getReferenceDesc());
                        Object srcObj = srcI.getInlineData(metaRef.getReferenceDesc());
                        if (tgtObj != null && srcObj != null) {
                            ElementIdentity origId = this.myOriginalOwner.identifyInlineRef(srcE, (BasicMetaReference)metaRef, (BasicElement)srcObj);
                            if (((BasicDataObject)tgtObj).isFrozen()) {
                                throw new AssertionError((Object)"Should be mutable");
                            }
                            ElementOwnerImpl.this.addResolution(origId, tgtObj);
                        }
                    }
                }
            }

            private void pullFamilies(BasicElement tgtE, BasicElement srcE) {
                for (Family<? extends BasicElement> family : srcE.getFamilies()) {
                    this.pullFamilyTo(tgtE, family);
                }
            }

            private void pullFamilyTo(BasicElement tgtE, Family<? extends BasicElement> srcF) {
                this.pullFamily((ModFamily)tgtE.familyOf(srcF.getMetaObject().kind), srcF);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 4 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "owner";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 5: 
                    case 8: 
                    case 11: 
                    case 12: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "id";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/schemaEditor/ElementMatcherImpl$ElementOwnerImpl$OriginalHelper";
                        break;
                    }
                    case 6: 
                    case 9: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "parent";
                        break;
                    }
                    case 7: 
                    case 10: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "orig";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/schemaEditor/ElementMatcherImpl$ElementOwnerImpl$OriginalHelper";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "pullModelRoot";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "pullFromOriginal";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "addMatchAndPull";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "pullRootLikeObject";
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 7: {
                        objectArray = objectArray;
                        objectArray[2] = "pull";
                        break;
                    }
                    case 8: 
                    case 9: 
                    case 10: {
                        objectArray = objectArray;
                        objectArray[2] = "pullImpl";
                        break;
                    }
                    case 11: {
                        objectArray = objectArray;
                        objectArray[2] = "pullElement";
                        break;
                    }
                    case 12: {
                        objectArray = objectArray;
                        objectArray[2] = "pullElementTo";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 4 -> new IllegalStateException(string);
                };
            }
        }
    }

    public static interface ChildProvider {
        @NotNull
        public <P extends BasicElement, E extends BasicElement> Iterable<E> getChildren(@NotNull P var1, @NotNull ElementIdentity<P> var2, @NotNull BasicMetaObject<E> var3);

        @NotNull
        public Iterable<BasicMetaObject<?>> getChildren(@Nullable BasicMetaObject<?> var1);

        @Nullable
        public BasicMetaObject<?> getParent(@Nullable BasicMetaObject<?> var1);
    }

    protected static class Id<E extends BasicElement>
    implements ElementIdentity<E>,
    Comparable<Id<?>> {
        private final Object myParentIdOrMatcher;
        private final BasicMetaObject<E> myMetaObject;
        private final BasicMetaReference<?, E> myInlined;
        private final int myOrder;
        private final Set<BasicMetaObject<?>> myPulled;

        private Id(@Nullable Id<?> parentId, @NotNull ElementMatcherImpl matcher, @NotNull BasicMetaObject<E> metaObject, int order2) {
            if (matcher == null) {
                Id.$$$reportNull$$$0(0);
            }
            if (metaObject == null) {
                Id.$$$reportNull$$$0(1);
            }
            this(parentId, matcher, null, metaObject, order2);
        }

        private Id(@Nullable Id<?> parentId, @NotNull ElementMatcherImpl matcher, @Nullable BasicMetaReference<?, E> inlined2, @NotNull BasicMetaObject<E> metaObject, int order2) {
            if (matcher == null) {
                Id.$$$reportNull$$$0(2);
            }
            if (metaObject == null) {
                Id.$$$reportNull$$$0(3);
            }
            this.myPulled = new HashSet();
            ContextMetaObjectFactory.assertBound(metaObject);
            this.myParentIdOrMatcher = parentId == null ? matcher : parentId;
            this.myMetaObject = metaObject;
            this.myOrder = order2;
            this.myInlined = inlined2;
            this.getMatcher().cache(this);
        }

        @NotNull
        private ElementMatcherImpl getMatcher() {
            Id<?> p2 = this.getParentId();
            return p2 == null ? (ElementMatcherImpl)this.myParentIdOrMatcher : p2.getMatcher();
        }

        @Override
        @NotNull
        public BasicMetaObject<E> getMetaObject() {
            BasicMetaObject<E> basicMetaObject = this.myMetaObject;
            if (basicMetaObject == null) {
                Id.$$$reportNull$$$0(4);
            }
            return basicMetaObject;
        }

        @Nullable
        private <S extends BasicElement> BasicMetaReference<S, E> getInlined(S parent2) {
            return this.myInlined;
        }

        @Nullable
        public Id<?> getParentId() {
            return (Id)ObjectUtils.tryCast((Object)this.myParentIdOrMatcher, Id.class);
        }

        @Override
        public int compareTo(@NotNull Id<?> o2) {
            if (o2 == null) {
                Id.$$$reportNull$$$0(5);
            }
            return Integer.compare(this.myOrder, o2.myOrder);
        }

        public String toString() {
            List path = (List)JBIterable.generate((Object)this, Id::getParentId).addAllTo(new ArrayList());
            Collections.reverse(path);
            Object res2 = StringUtil.join((Collection)path, Id::getPathItem, (String)".");
            if (!((String)res2).endsWith("]")) {
                res2 = (String)res2 + ":" + this.getKindAndOrder();
            }
            return res2;
        }

        private String getPathItem() {
            if (this.myMetaObject.kind == ObjectKind.ROOT) {
                return "";
            }
            String anyName = this.findName();
            return anyName == null ? "[+" + this.getKindAndOrder() + "]" : anyName;
        }

        @Nullable
        private String findName() {
            for (ElementOwnerImpl owner : this.getMatcher().myOwners) {
                Object r = owner.findElement(this);
                if (ElementMatcherImpl.isNull(r) || r.getName().isEmpty()) continue;
                return r.getName();
            }
            return null;
        }

        @NotNull
        private String getKindAndOrder() {
            String string = this.myMetaObject.kind.code() + " #" + this.myOrder;
            if (string == null) {
                Id.$$$reportNull$$$0(6);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "matcher";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "metaObject";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/ElementMatcherImpl$Id";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/ElementMatcherImpl$Id";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMetaObject";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKindAndOrder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 6: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "compareTo";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 6 -> new IllegalStateException(string);
            };
        }
    }

    public static class SingleElementOwner
    implements ElementOwner {
        private final ElementMatcher myMatcher;
        private final ElementIdentity<? extends BasicElement> myIdentity;
        private final BasicElement myElement;
        private final BasicResolveAssistant myResolveAssistant;

        public <T extends BasicElement> SingleElementOwner(@NotNull ElementMatcher matcher, @NotNull ElementIdentity<T> identity, @Nullable T element2) {
            if (matcher == null) {
                SingleElementOwner.$$$reportNull$$$0(0);
            }
            if (identity == null) {
                SingleElementOwner.$$$reportNull$$$0(1);
            }
            this.myResolveAssistant = new ElementOwnerResolveAssistant(this);
            this.myMatcher = matcher;
            this.myIdentity = identity;
            this.myElement = element2;
        }

        @Override
        public void addListener(@NotNull ElementOwner.ElementListener listener2, @NotNull Disposable parent2) {
            if (listener2 == null) {
                SingleElementOwner.$$$reportNull$$$0(2);
            }
            if (parent2 == null) {
                SingleElementOwner.$$$reportNull$$$0(3);
            }
        }

        @Override
        @NotNull
        public BasicResolveAssistant getResolveAssistant() {
            BasicResolveAssistant basicResolveAssistant = this.myResolveAssistant;
            if (basicResolveAssistant == null) {
                SingleElementOwner.$$$reportNull$$$0(4);
            }
            return basicResolveAssistant;
        }

        @Override
        @NotNull
        public <E extends BasicElement> ElementIdentity<E> identify(@NotNull E e2) {
            if (e2 == null) {
                SingleElementOwner.$$$reportNull$$$0(5);
            }
            BasicMetaObject<E> meta = BasicMetaUtils.getMetaObject(e2);
            ElementIdentity<E> elementIdentity = e2 == this.myElement ? Objects.requireNonNull(ElementIdentity.tryCast(this.myIdentity, meta)) : this.create(null, meta);
            if (elementIdentity == null) {
                SingleElementOwner.$$$reportNull$$$0(6);
            }
            return elementIdentity;
        }

        @Override
        @Nullable
        public <E extends BasicElement> ElementIdentity<E> findIdentity(@Nullable E e2) {
            if (e2 == null) {
                return null;
            }
            BasicMetaObject<E> meta = BasicMetaUtils.getMetaObject(e2);
            return e2 == this.myElement ? ElementIdentity.tryCast(this.myIdentity, meta) : null;
        }

        @Override
        @Nullable
        public <E extends BasicElement> E findElement(@Nullable ElementIdentity<E> e2) {
            return this.find(e2);
        }

        @Override
        @Nullable
        public ElementIdentity<?> getParent(@NotNull ElementIdentity<?> identity) {
            if (identity == null) {
                SingleElementOwner.$$$reportNull$$$0(7);
            }
            return this.myMatcher.getParent(identity);
        }

        @Override
        public <E extends BasicElement> void addMatch(@NotNull ElementIdentity<E> identity, @NotNull E element2) {
            if (identity == null) {
                SingleElementOwner.$$$reportNull$$$0(8);
            }
            if (element2 == null) {
                SingleElementOwner.$$$reportNull$$$0(9);
            }
        }

        @Override
        public <E extends BasicElement> void addMatchAndPull(@NotNull ElementIdentity<E> identity, @NotNull E element2) {
            if (identity == null) {
                SingleElementOwner.$$$reportNull$$$0(10);
            }
            if (element2 == null) {
                SingleElementOwner.$$$reportNull$$$0(11);
            }
        }

        @Override
        @NotNull
        public <S extends BasicElement, T extends BasicElement> ElementIdentity<T> identifyInlineRef(@NotNull S owner, @NotNull BasicMetaReference<S, T> ref2, @NotNull T e2) {
            if (owner == null) {
                SingleElementOwner.$$$reportNull$$$0(12);
            }
            if (ref2 == null) {
                SingleElementOwner.$$$reportNull$$$0(13);
            }
            if (e2 == null) {
                SingleElementOwner.$$$reportNull$$$0(14);
            }
            if (e2 == this.myElement) {
                ElementIdentity<T> elementIdentity = this.identify(e2);
                if (elementIdentity == null) {
                    SingleElementOwner.$$$reportNull$$$0(15);
                }
                return elementIdentity;
            }
            ElementIdentity elementIdentity = ((ElementMatcherImpl)this.myMatcher).createInlineRef((ElementIdentity)this.identify(owner), (BasicMetaReference)ref2, (BasicMetaObject)BasicMetaUtils.getMetaObject(e2));
            if (elementIdentity == null) {
                SingleElementOwner.$$$reportNull$$$0(16);
            }
            return elementIdentity;
        }

        @Override
        @NotNull
        public <E extends BasicElement> JBIterable<ElementIdentity<E>> getChildren(@NotNull ElementIdentity<?> identity, @NotNull BasicMetaObject<E> childMeta) {
            if (identity == null) {
                SingleElementOwner.$$$reportNull$$$0(17);
            }
            if (childMeta == null) {
                SingleElementOwner.$$$reportNull$$$0(18);
            }
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                SingleElementOwner.$$$reportNull$$$0(19);
            }
            return jBIterable;
        }

        @Override
        @Nullable
        public <E extends BasicElement> E findOrCreate(@NotNull ElementIdentity<E> identity) {
            if (identity == null) {
                SingleElementOwner.$$$reportNull$$$0(20);
            }
            return this.find(identity);
        }

        @Override
        public boolean isDropped(@NotNull ElementIdentity<?> identity) {
            if (identity == null) {
                SingleElementOwner.$$$reportNull$$$0(21);
            }
            return false;
        }

        @Override
        public <E extends BasicElement> void drop(@NotNull ElementIdentity<E> identity) {
            if (identity == null) {
                SingleElementOwner.$$$reportNull$$$0(22);
            }
        }

        @Override
        @NotNull
        public <E extends BasicElement> ElementIdentity<E> create(@Nullable ElementIdentity<?> parent2, @NotNull BasicMetaObject<E> meta) {
            if (meta == null) {
                SingleElementOwner.$$$reportNull$$$0(23);
            }
            ElementIdentity elementIdentity = ((ElementMatcherImpl)this.myMatcher).create((ElementIdentity)parent2, (BasicMetaObject)meta);
            if (elementIdentity == null) {
                SingleElementOwner.$$$reportNull$$$0(24);
            }
            return elementIdentity;
        }

        @Override
        @NotNull
        public ElementMatcher getMatcher() {
            ElementMatcher elementMatcher = this.myMatcher;
            if (elementMatcher == null) {
                SingleElementOwner.$$$reportNull$$$0(25);
            }
            return elementMatcher;
        }

        @Override
        @Nullable
        public ElementOwner getOriginal() {
            return null;
        }

        @Override
        @NotNull
        public <E extends BasicElement> ElementIdentity<E> register(@Nullable ElementIdentity<?> parent2, @NotNull E object) {
            if (object == null) {
                SingleElementOwner.$$$reportNull$$$0(26);
            }
            ElementIdentity<E> elementIdentity = this.identify(object);
            if (elementIdentity == null) {
                SingleElementOwner.$$$reportNull$$$0(27);
            }
            return elementIdentity;
        }

        @Override
        @Nullable
        public <E extends BasicElement> E find(@NotNull ElementIdentity<E> identity) {
            if (identity == null) {
                SingleElementOwner.$$$reportNull$$$0(28);
            }
            return identity == this.myIdentity ? (E)identity.getMetaObject().tryCast(this.myElement) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 6, 15, 16, 19, 24, 25, 27 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "matcher";
                    break;
                }
                case 1: 
                case 7: 
                case 8: 
                case 10: 
                case 17: 
                case 20: 
                case 21: 
                case 22: 
                case 28: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "identity";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listener";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 4: 
                case 6: 
                case 15: 
                case 16: 
                case 19: 
                case 24: 
                case 25: 
                case 27: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/ElementMatcherImpl$SingleElementOwner";
                    break;
                }
                case 5: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 9: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ref";
                    break;
                }
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "childMeta";
                    break;
                }
                case 23: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "meta";
                    break;
                }
                case 26: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/ElementMatcherImpl$SingleElementOwner";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResolveAssistant";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "identify";
                    break;
                }
                case 15: 
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "identifyInlineRef";
                    break;
                }
                case 19: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 24: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
                case 25: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMatcher";
                    break;
                }
                case 27: {
                    objectArray = objectArray2;
                    objectArray2[1] = "register";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "addListener";
                    break;
                }
                case 4: 
                case 6: 
                case 15: 
                case 16: 
                case 19: 
                case 24: 
                case 25: 
                case 27: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "identify";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getParent";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "addMatch";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "addMatchAndPull";
                    break;
                }
                case 12: 
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "identifyInlineRef";
                    break;
                }
                case 17: 
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "getChildren";
                    break;
                }
                case 20: {
                    objectArray = objectArray;
                    objectArray[2] = "findOrCreate";
                    break;
                }
                case 21: {
                    objectArray = objectArray;
                    objectArray[2] = "isDropped";
                    break;
                }
                case 22: {
                    objectArray = objectArray;
                    objectArray[2] = "drop";
                    break;
                }
                case 23: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 26: {
                    objectArray = objectArray;
                    objectArray[2] = "register";
                    break;
                }
                case 28: {
                    objectArray = objectArray;
                    objectArray[2] = "find";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 6, 15, 16, 19, 24, 25, 27 -> new IllegalStateException(string);
            };
        }
    }
}

