/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicGrantee;
import com.intellij.database.model.basic.BasicGrantsHolder;
import com.intellij.database.model.meta.BasicResolveAssistant;
import com.intellij.database.model.properties.Grants;
import com.intellij.database.schemaEditor.ElementIdentity;
import com.intellij.database.schemaEditor.ElementOwner;
import com.intellij.database.schemaEditor.GrantDataKt;
import com.intellij.database.schemaEditor.GrantForUser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001aB\u0010\u0000\u001a\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u00032\u0010\u0010\u0004\u001a\f\u0012\u0004\u0012\u0002H\u0002\u0012\u0002\b\u00030\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00020\n\u001aD\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00020\n\"\b\b\u0000\u0010\u0002*\u00020\u00032\u0010\u0010\u0004\u001a\f\u0012\u0004\u0012\u0002H\u0002\u0012\u0002\b\u00030\u00052\u0006\u0010\b\u001a\u00020\u00072\u0012\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u000e0\r\u001a(\u0010\u000f\u001a\u00020\u0010\"\u0004\b\u0000\u0010\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00110\n2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00110\n\u001aL\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u000e0\n\"\b\b\u0000\u0010\u0002*\u00020\u0003\"\b\b\u0001\u0010\u0015*\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00150\u00052\u0006\u0010\b\u001a\u00020\u0007\u00a8\u0006\u0019"}, d2={"applyGrants", "", "G", "Lcom/intellij/database/model/properties/Grants$Grant;", "grantCtl", "Lcom/intellij/database/model/properties/Grants$Controller;", "edited", "Lcom/intellij/database/model/basic/BasicElement;", "e", "newGrants", "", "convertGrants", "items", "", "Lcom/intellij/database/schemaEditor/GrantForUser;", "equalsUnordered", "", "T", "list1", "list2", "extractGrants", "U", "Lcom/intellij/database/model/basic/BasicGrantee;", "owner", "Lcom/intellij/database/schemaEditor/ElementOwner;", "intellij.database.core.impl"})
@JvmName(name="DbObjectGrantsEditorCore")
@SourceDebugExtension(value={"SMAP\nDbObjectGrantsEditorCore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbObjectGrantsEditorCore.kt\ncom/intellij/database/schemaEditor/DbObjectGrantsEditorCore\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,51:1\n1#2:52\n1855#3,2:53\n*S KotlinDebug\n*F\n+ 1 DbObjectGrantsEditorCore.kt\ncom/intellij/database/schemaEditor/DbObjectGrantsEditorCore\n*L\n34#1:53,2\n*E\n"})
public final class DbObjectGrantsEditorCore {
    public static final <G extends Grants.Grant> void applyGrants(@NotNull Grants.Controller<G, ?> grantCtl, @Nullable BasicElement edited, @NotNull BasicElement e2, @NotNull List<? extends G> newGrants) {
        Intrinsics.checkNotNullParameter(grantCtl, (String)"grantCtl");
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        Intrinsics.checkNotNullParameter(newGrants, (String)"newGrants");
        BasicGrantsHolder<G> basicGrantsHolder = grantCtl.grantsHolder(e2);
        if (basicGrantsHolder == null) {
            return;
        }
        BasicGrantsHolder<G> holder = basicGrantsHolder;
        SortedSet<G> grants = holder.getGrants().toMutableSet();
        BasicElement basicElement = edited;
        if (basicElement != null) {
            BasicElement it2 = basicElement;
            boolean bl = false;
            G g2 = grantCtl.lower(it2);
            basicElement = g2;
            if (g2 != null) {
                it2 = basicElement;
                boolean bl2 = false;
                grants.subSet(it2, grantCtl.upper(it2)).clear();
            }
        }
        grants.addAll((Collection)newGrants);
        holder.setGrants(holder.getGrants().with((Iterable)grants));
    }

    @NotNull
    public static final <G extends Grants.Grant> List<G> convertGrants(@NotNull Grants.Controller<G, ?> grantCtl, @NotNull BasicElement e2, @NotNull Iterable<GrantForUser<G>> items2) {
        Intrinsics.checkNotNullParameter(grantCtl, (String)"grantCtl");
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        Intrinsics.checkNotNullParameter(items2, (String)"items");
        G objectGrant = grantCtl.lower(e2);
        if (objectGrant == null) {
            return CollectionsKt.emptyList();
        }
        ArrayList res2 = new ArrayList();
        for (GrantForUser<G> item : items2) {
            G userGrant = grantCtl.withGranteeFrom(objectGrant, item.getUserKey());
            GrantDataKt.extractPermissions(item, grantCtl, userGrant, res2);
        }
        return res2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <G extends Grants.Grant, U extends BasicGrantee> List<GrantForUser<G>> extractGrants(@Nullable ElementOwner owner, @NotNull Grants.Controller<G, U> grantCtl, @NotNull BasicElement e2) {
        ArrayList<GrantForUser<G>> res2;
        block6: {
            Grants<G> grants;
            BasicGrantsHolder<G> holder;
            Intrinsics.checkNotNullParameter(grantCtl, (String)"grantCtl");
            Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
            BasicGrantsHolder<G> basicGrantsHolder = holder = grantCtl.grantsHolder(e2);
            Grants<G> grants2 = grants = basicGrantsHolder != null ? basicGrantsHolder.getGrants() : null;
            Iterable<Collection<G>> objectGrants = grants2 != null ? grants2.grantsForByGrantee(e2) : null;
            res2 = new ArrayList<GrantForUser<G>>();
            Iterable<Collection<G>> iterable = objectGrants;
            if (iterable == null) break block6;
            Iterable<Collection<G>> $this$forEach$iv = iterable;
            boolean $i$f$forEach = false;
            Iterator<Collection<G>> iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                ElementIdentity<BasicElement> elementIdentity;
                ObjectKind objectKind;
                ObjectKind objectKind2;
                Collection<G> element$iv;
                Collection<G> gGrants = element$iv = iterator.next();
                boolean bl = false;
                Grants.Grant cur = (Grants.Grant)CollectionsKt.first((Iterable)gGrants);
                BasicElement basicElement = holder;
                Object object = owner;
                if (object == null || (object = object.getResolveAssistant()) == null) {
                    object = BasicResolveAssistant.DEFAULT;
                }
                Object object2 = object;
                Intrinsics.checkNotNull((Object)object2);
                U grantee = grantCtl.findGrantee(cur, basicElement, (BasicResolveAssistant)object2);
                GrantForUser<Grants.Grant> g2 = new GrantForUser<Grants.Grant>(grantCtl);
                Intrinsics.checkNotNull((Object)cur);
                g2.setUserKey(cur);
                U u = grantee;
                ObjectKind objectKind3 = objectKind2 = u != null ? u.getKind() : null;
                if (objectKind3 == null) {
                    ObjectKind objectKind4 = ObjectKind.USER;
                    objectKind = objectKind4;
                    Intrinsics.checkNotNullExpressionValue((Object)objectKind4, (String)"USER");
                } else {
                    Intrinsics.checkNotNull((Object)objectKind3);
                    objectKind = objectKind2;
                }
                g2.setUserKind(objectKind);
                g2.setUserText(grantCtl.granteeText(grantee, (Grants.Grant)g2.getUserKey()));
                GrantForUser<Grants.Grant> grantForUser = g2;
                if (grantee != null) {
                    void it2;
                    GrantForUser<Grants.Grant> grantForUser2 = grantForUser;
                    boolean bl2 = false;
                    ElementOwner elementOwner = owner;
                    elementIdentity = elementOwner != null ? elementOwner.identify((BasicElement)it2) : null;
                    grantForUser = grantForUser2;
                } else {
                    elementIdentity = null;
                }
                grantForUser.setUserId(elementIdentity);
                GrantDataKt.collectPermissions(g2, gGrants);
                res2.add(g2);
            }
        }
        return res2;
    }

    public static final <T> boolean equalsUnordered(@NotNull List<? extends T> list1, @NotNull List<? extends T> list2) {
        Intrinsics.checkNotNullParameter(list1, (String)"list1");
        Intrinsics.checkNotNullParameter(list2, (String)"list2");
        return list1.size() == list2.size() && CollectionsKt.toHashSet((Iterable)list1).containsAll((Collection)list2);
    }
}

