/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.ElementDelta;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicDataObject;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicMateNamespace;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.VmElement;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.schemaEditor.DbEditorDialogModel;
import com.intellij.database.schemaEditor.DbObjectEditorDialogPanelBase;
import com.intellij.database.schemaEditor.ElementIdentity;
import com.intellij.database.schemaEditor.ElementMatcher;
import com.intellij.database.schemaEditor.ElementMatcherImpl;
import com.intellij.database.schemaEditor.ElementOwner;
import com.intellij.database.schemaEditor.model.DbEditorModel;
import com.intellij.database.schemaEditor.model.DbEditorModelController;
import com.intellij.database.schemaEditor.model.DbModelModifiedCache;
import com.intellij.database.schemaEditor.model.state.DbObjectModelState;
import com.intellij.database.schemaEditor.model.state.DbStructureObjectModelState;
import com.intellij.database.script.generator.DefaultScriptingOptions;
import com.intellij.database.script.generator.ScriptGenerator;
import com.intellij.database.script.generator.ScriptGenerators;
import com.intellij.database.script.generator.ScriptingOptions;
import com.intellij.database.util.BasicPaths;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.view.DatabaseRefactoringHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Pair;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0016\u0018\u0000 62\u00020\u0001:\u00016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JF\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u001a\u0010\"\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0006\u0012\u0004\u0018\u00010%\u0012\u0004\u0012\u00020&0$0#2\u001a\u0010'\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0006\u0012\u0004\u0018\u00010%\u0012\u0004\u0012\u00020&0$0#J\b\u0010(\u001a\u00020\u001fH\u0016J\u000e\u0010)\u001a\u00020\u001f2\u0006\u0010*\u001a\u00020+J,\u0010,\u001a\u00020\u001f2\u0010\u0010-\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030/0.2\u0012\u00100\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0018\u000101J\u0006\u00102\u001a\u000203J\u000e\u00104\u001a\u000203H\u0096@\u00a2\u0006\u0002\u00105R\u0019\u0010\u0005\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0015\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u00067"}, d2={"Lcom/intellij/database/schemaEditor/DbEditorDialogModel;", "Lcom/intellij/openapi/Disposable;", "bootstrapper", "Lcom/intellij/database/schemaEditor/DbObjectEditorDialogPanelBase$DialogBootstrapper;", "(Lcom/intellij/database/schemaEditor/DbObjectEditorDialogPanelBase$DialogBootstrapper;)V", "editorModel", "Lcom/intellij/database/schemaEditor/model/DbEditorModel;", "getEditorModel", "()Lcom/intellij/database/schemaEditor/model/DbEditorModel;", "identity", "Lcom/intellij/database/schemaEditor/ElementIdentity;", "getIdentity", "()Lcom/intellij/database/schemaEditor/ElementIdentity;", "modelController", "Lcom/intellij/database/schemaEditor/model/DbEditorModelController;", "getModelController", "()Lcom/intellij/database/schemaEditor/model/DbEditorModelController;", "myMatcher", "Lcom/intellij/database/schemaEditor/ElementMatcher;", "supplier", "Lkotlin/Function0;", "Lcom/intellij/database/script/generator/ScriptingOptions;", "getSupplier", "()Lkotlin/jvm/functions/Function0;", "setSupplier", "(Lkotlin/jvm/functions/Function0;)V", "targetOwner", "Lcom/intellij/database/schemaEditor/ElementOwner;", "getTargetOwner", "()Lcom/intellij/database/schemaEditor/ElementOwner;", "collectChangesInVm", "", "localDataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "toRemove", "", "Lcom/intellij/openapi/util/Pair;", "Lcom/intellij/database/util/ObjectPath;", "Lcom/intellij/database/model/basic/VmElement;", "toAdd", "dispose", "fillContext", "handler", "Lcom/intellij/database/view/DatabaseRefactoringHandler;", "fillCorrespondence", "correspondence", "", "Lcom/intellij/database/model/ElementDelta;", "filter", "Ljava/util/function/Predicate;", "isModified", "", "waitBackgroundTasks", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "intellij.database.impl"})
public class DbEditorDialogModel
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DbEditorModelController modelController;
    @NotNull
    private final ElementMatcher myMatcher;
    @NotNull
    private final ElementOwner targetOwner;
    @NotNull
    private final ElementIdentity<?> identity;
    @NotNull
    private final DbEditorModel<?, ?> editorModel;
    @NotNull
    private Function0<? extends ScriptingOptions> supplier;

    public DbEditorDialogModel(@NotNull DbObjectEditorDialogPanelBase.DialogBootstrapper bootstrapper) {
        Intrinsics.checkNotNullParameter((Object)bootstrapper, (String)"bootstrapper");
        this.modelController = bootstrapper.getModelController();
        this.myMatcher = bootstrapper.getMyMatcher();
        this.targetOwner = bootstrapper.getTargetOwner();
        this.identity = bootstrapper.getIdentity();
        this.editorModel = bootstrapper.getEditorModel();
        this.supplier = supplier.1.INSTANCE;
        this.modelController.setScriptingOptions(() -> DbEditorDialogModel._init_$lambda$0(this));
    }

    @NotNull
    public final DbEditorModelController getModelController() {
        return this.modelController;
    }

    @NotNull
    public final ElementOwner getTargetOwner() {
        return this.targetOwner;
    }

    @NotNull
    public final ElementIdentity<?> getIdentity() {
        return this.identity;
    }

    @NotNull
    public final DbEditorModel<?, ?> getEditorModel() {
        return this.editorModel;
    }

    @NotNull
    public final Function0<ScriptingOptions> getSupplier() {
        return this.supplier;
    }

    public final void setSupplier(@NotNull Function0<? extends ScriptingOptions> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"<set-?>");
        this.supplier = function0;
    }

    public final void fillContext(@NotNull DatabaseRefactoringHandler handler2) {
        BasicElement original;
        ElementOwner oOwner;
        Intrinsics.checkNotNullParameter((Object)handler2, (String)"handler");
        LocalDataSource localDataSource = handler2.getDataSource();
        Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"getDataSource(...)");
        LocalDataSource localDataSource2 = localDataSource;
        ElementMatcher elementMatcher = this.modelController.getMatcher();
        Intrinsics.checkNotNullExpressionValue((Object)elementMatcher, (String)"getMatcher(...)");
        ElementMatcher matcher = elementMatcher;
        ElementOwner elementOwner = oOwner = matcher.getOriginalOwner();
        BasicElement basicElement = original = elementOwner != null ? (BasicElement)elementOwner.find(this.identity) : null;
        if (this.identity.getMetaObject().kindOf(BasicMateNamespace.class) && localDataSource2.shouldTrackNamespaces()) {
            ObjectPath src2 = BasicPaths.of(original);
            ObjectPath tgt = BasicPaths.of(this.targetOwner.findOrCreate(this.identity));
            handler2.getScopeUpdater().toRemove(src2);
            handler2.getScopeUpdater().toAdd(tgt);
            handler2.include(tgt);
        } else if (original == null) {
            ElementIdentity<?> targetParentId = this.myMatcher.getParent(this.identity);
            if (targetParentId != null) {
                ElementOwner elementOwner2 = oOwner;
                Object originalParent = elementOwner2 != null ? elementOwner2.find(targetParentId) : null;
                handler2.include((BasicElement)originalParent);
            }
        } else {
            handler2.include(original);
        }
        if (original == null) {
            handler2.setElementToFocus(BasicPaths.of(this.targetOwner.findOrCreate(this.identity)));
        }
    }

    public final boolean isModified() {
        DbEditorModelController controller = this.modelController;
        ElementMatcher elementMatcher = controller.getMatcher();
        Intrinsics.checkNotNullExpressionValue((Object)elementMatcher, (String)"getMatcher(...)");
        ElementMatcher matcher = elementMatcher;
        DbModelModifiedCache dbModelModifiedCache = controller.getModifiedCache();
        Intrinsics.checkNotNullExpressionValue((Object)dbModelModifiedCache, (String)"getModifiedCache(...)");
        DbModelModifiedCache modCache = dbModelModifiedCache;
        ElementOwner oOwner = matcher.getOriginalOwner();
        ElementOwner elementOwner = this.targetOwner;
        Intrinsics.checkNotNull((Object)elementOwner, (String)"null cannot be cast to non-null type com.intellij.database.schemaEditor.ElementMatcherImpl.ElementOwnerImpl");
        for (ElementIdentity<?> identity : ((ElementMatcherImpl.ElementOwnerImpl)elementOwner).getCached()) {
            boolean exists;
            DbEditorModel<?, DbStructureObjectModelState<?>> model2 = controller.getStructureNodeModel(identity);
            ElementOwner elementOwner2 = oOwner;
            Object original = elementOwner2 != null ? elementOwner2.find(identity) : null;
            boolean existed = original != null;
            ElementIdentity<?> elementIdentity = identity;
            Intrinsics.checkNotNull(elementIdentity);
            boolean bl = exists = !this.targetOwner.isDropped(elementIdentity);
            if (existed != exists) {
                return true;
            }
            if (model2 == null || !modCache.isModified(model2)) continue;
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public final void collectChangesInVm(@NotNull LocalDataSource localDataSource, @NotNull List<Pair<ObjectPath, VmElement>> toRemove, @NotNull List<Pair<ObjectPath, VmElement>> toAdd) {
        Intrinsics.checkNotNullParameter((Object)localDataSource, (String)"localDataSource");
        Intrinsics.checkNotNullParameter(toRemove, (String)"toRemove");
        Intrinsics.checkNotNullParameter(toAdd, (String)"toAdd");
        generator = (ScriptGenerator)ScriptGenerators.INSTANCE.forDbms(localDataSource.getDbms());
        oOwner = this.myMatcher.getOriginalOwner();
        v0 = this.targetOwner;
        Intrinsics.checkNotNull((Object)v0, (String)"null cannot be cast to non-null type com.intellij.database.schemaEditor.ElementMatcherImpl.ElementOwnerImpl");
        for (ElementIdentity<?> identity : ((ElementMatcherImpl.ElementOwnerImpl)v0).getCached()) {
            if (ElementIdentity.tryCast(identity, VmElement.class) == null) continue;
            parent = this.myMatcher.getParent(vmId);
            v1 = oOwner;
            v2 = orig = v1 != null ? v1.find(vmId) : null;
            if (orig == null) ** GOTO lbl-1000
            v3 = parent;
            if (v3 == null) lbl-1000:
            // 2 sources

            {
                v4 = null;
            } else {
                v4 = oOwner.find(v3);
            }
            origParent = v4;
            tgt = this.targetOwner.find(vmId);
            v5 = tgtParent = tgt == null || parent == null ? null : this.targetOwner.find(parent);
            if (tgt != null && orig != null && generator.isEqual(orig, tgt, DefaultScriptingOptions.INSTANCE)) continue;
            if (orig != null && origParent != null) {
                v6 = Pair.create((Object)ObjectPaths.of(origParent), (Object)orig);
                Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"create(...)");
                toRemove.add((Pair<ObjectPath, VmElement>)v6);
            }
            if (tgt == null || tgtParent == null) continue;
            v7 = Pair.create((Object)ObjectPaths.of(tgtParent), (Object)tgt);
            Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"create(...)");
            toAdd.add((Pair<ObjectPath, VmElement>)v7);
        }
    }

    public final void fillCorrespondence(@NotNull Set<ElementDelta<?>> correspondence, @Nullable Predicate<ElementIdentity<?>> filter2) {
        Intrinsics.checkNotNullParameter(correspondence, (String)"correspondence");
        Companion.fillCorrespondence(correspondence, this.myMatcher.getOriginalOwner(), this.targetOwner, this.modelController, filter2);
    }

    @Nullable
    public Object waitBackgroundTasks(@NotNull Continuation<? super Boolean> $completion) {
        return DbEditorDialogModel.waitBackgroundTasks$suspendImpl(this, $completion);
    }

    static /* synthetic */ Object waitBackgroundTasks$suspendImpl(DbEditorDialogModel $this, Continuation<? super Boolean> $completion) {
        return $this.modelController.getTransactionManager().waitAllFinished($completion);
    }

    public void dispose() {
    }

    private static final ScriptingOptions _init_$lambda$0(DbEditorDialogModel this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return (ScriptingOptions)this$0.supplier.invoke();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0010\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\tH\u0002JF\u0010\u0003\u001a\u00020\u00042\u0010\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0012\u0018\u00010\u0011J0\u0010\u0013\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00122\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0012\u0018\u00010\u0011J$\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\r\u001a\u00020\fH\u0002\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/schemaEditor/DbEditorDialogModel$Companion;", "", "()V", "fillCorrespondence", "", "orig", "Lcom/intellij/database/model/basic/BasicElement;", "edited", "correspondence", "", "Lcom/intellij/database/model/ElementDelta;", "originalOwner", "Lcom/intellij/database/schemaEditor/ElementOwner;", "targetOwner", "controller", "Lcom/intellij/database/schemaEditor/model/DbEditorModelController;", "filter", "Ljava/util/function/Predicate;", "Lcom/intellij/database/schemaEditor/ElementIdentity;", "findSearchPathExample", "isInterestingObject", "", "identity", "intellij.database.impl"})
    public static final class Companion {
        private Companion() {
        }

        public final void fillCorrespondence(@NotNull Set<ElementDelta<?>> correspondence, @Nullable ElementOwner originalOwner, @NotNull ElementOwner targetOwner, @NotNull DbEditorModelController controller, @Nullable Predicate<ElementIdentity<?>> filter2) {
            Intrinsics.checkNotNullParameter(correspondence, (String)"correspondence");
            Intrinsics.checkNotNullParameter((Object)targetOwner, (String)"targetOwner");
            Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
            for (ElementIdentity<?> identity : ((ElementMatcherImpl.ElementOwnerImpl)targetOwner).getCached()) {
                Predicate<ElementIdentity<?>> predicate = filter2;
                if ((predicate != null ? !predicate.test(identity) : false) || identity.getMetaObject().kindOf(BasicRoot.class)) continue;
                ElementOwner elementOwner = originalOwner;
                Object original = elementOwner != null ? elementOwner.find(identity) : null;
                Object target2 = targetOwner.find(identity);
                if (original == null && target2 == null || original instanceof BasicDataObject || target2 instanceof BasicDataObject || original != null && target2 != null && controller.getObjectModelState(identity) == null) continue;
                this.fillCorrespondence((BasicElement)original, (BasicElement)target2, correspondence);
                correspondence.add(ElementDelta.Companion.create(original, target2));
            }
        }

        @Nullable
        public final ElementIdentity<?> findSearchPathExample(@NotNull ElementOwner targetOwner, @NotNull DbEditorModelController controller, @Nullable Predicate<ElementIdentity<?>> filter2) {
            Intrinsics.checkNotNullParameter((Object)targetOwner, (String)"targetOwner");
            Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
            ElementIdentity<?> res2 = null;
            for (ElementIdentity<?> identity : ((ElementMatcherImpl.ElementOwnerImpl)targetOwner).getCached()) {
                BasicMetaObject<?> m2;
                Predicate<ElementIdentity<?>> predicate = filter2;
                if ((predicate != null ? !predicate.test(identity) : false) || identity.getMetaObject().kindOf(BasicRoot.class)) continue;
                Intrinsics.checkNotNull(identity);
                if (!this.isInterestingObject(controller, identity, targetOwner)) continue;
                ElementIdentity<?> elementIdentity = res2;
                BasicMetaObject m1 = elementIdentity != null ? elementIdentity.getMetaObject() : null;
                Intrinsics.checkNotNullExpressionValue(identity.getMetaObject(), (String)"getMetaObject(...)");
                if (Intrinsics.areEqual(m1, m2) || m1 != null && BasicMetaUtils.getDepth(m1) > BasicMetaUtils.getDepth(m2)) continue;
                res2 = identity;
            }
            return res2;
        }

        private final boolean isInterestingObject(DbEditorModelController controller, ElementIdentity<?> identity, ElementOwner targetOwner) {
            DbEditorModel<?, DbObjectModelState<?>> dbEditorModel = controller.getObjectModel(identity);
            if (dbEditorModel == null) {
                return false;
            }
            DbEditorModel<?, DbObjectModelState<?>> model2 = dbEditorModel;
            boolean targetExists = targetOwner.find(identity) != null;
            ElementOwner elementOwner = targetOwner.getOriginal();
            boolean sourceExists = (elementOwner != null ? elementOwner.find(identity) : null) != null;
            return targetExists != sourceExists || controller.getModifiedCache().isModified(model2);
        }

        private final void fillCorrespondence(BasicElement orig, BasicElement edited, Set<ElementDelta<?>> correspondence) {
            BasicElement e1 = orig;
            BasicElement e2 = edited;
            while (e1 != null && e2 != null) {
                if (e1.getKind() == ObjectKind.ROOT) {
                    e1 = e1.getParent();
                    e2 = e2.getParent();
                    continue;
                }
                if (!correspondence.add(ElementDelta.Companion.create(e1, e2))) break;
                e1 = e1.getParent();
                e2 = e2.getParent();
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

