/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.documentation;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.ColumnRef;
import com.intellij.database.data.types.DasColumnRef;
import com.intellij.database.data.types.PredicateValuesKt;
import com.intellij.database.data.types.PredicatesHelperKt;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtilCore;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasConstraint;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ModelRelationManager;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.script.generator.dml.DmlHelper;
import com.intellij.database.script.generator.dml.DmlTaskKt;
import com.intellij.database.script.generator.dml.DmlUtilKt;
import com.intellij.database.script.generator.dml.SelectTask;
import com.intellij.database.script.generator.dml.WhereClause;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Pair;
import kotlin.Triple;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DataGridDocumentationUtil {
    @NotNull
    public static List<QueryInfo> buildQueries(@NotNull DasDataSource dataSource2, @NotNull DataGrid dataGrid, @NotNull ModelIndexSet<GridRow> selectedRows, @NotNull EnumSet<KeyType> keyTypes) {
        if (dataSource2 == null) {
            DataGridDocumentationUtil.$$$reportNull$$$0(0);
        }
        if (dataGrid == null) {
            DataGridDocumentationUtil.$$$reportNull$$$0(1);
        }
        if (selectedRows == null) {
            DataGridDocumentationUtil.$$$reportNull$$$0(2);
        }
        if (keyTypes == null) {
            DataGridDocumentationUtil.$$$reportNull$$$0(3);
        }
        IntOpenHashSet selectedColumnIndices = new IntOpenHashSet(dataGrid.getSelectionModel().getSelectedColumns().asArray());
        DasTable databaseTable = (DasTable)ObjectUtils.tryCast((Object)DataGridUtilCore.getDatabaseTable((CoreGrid<GridRow, GridColumn>)dataGrid), DasTable.class);
        LinkedHashMap<String, QueryInfo> queries = new LinkedHashMap<String, QueryInfo>();
        if (keyTypes.contains((Object)KeyType.FOREIGN) && databaseTable != null) {
            DataGridDocumentationUtil.collectForeignKeyQueries(queries, databaseTable, dataSource2.getDbms(), dataGrid, selectedRows, (IntSet)selectedColumnIndices);
        }
        if (keyTypes.contains((Object)KeyType.EXPORTED) && databaseTable != null) {
            DataGridDocumentationUtil.collectExportedKeyQueries(queries, databaseTable, dataSource2.getDbms(), dataGrid, selectedRows, (IntSet)selectedColumnIndices);
        }
        return new ArrayList<QueryInfo>(queries.values());
    }

    private static void collectForeignKeyQueries(@NotNull Map<String, QueryInfo> queries, @NotNull DasTable databaseTable, @NotNull Dbms dbms, @NotNull DataGrid dataGrid, @NotNull ModelIndexSet<GridRow> selectedRows, @NotNull IntSet selectedColumns) {
        if (queries == null) {
            DataGridDocumentationUtil.$$$reportNull$$$0(4);
        }
        if (databaseTable == null) {
            DataGridDocumentationUtil.$$$reportNull$$$0(5);
        }
        if (dbms == null) {
            DataGridDocumentationUtil.$$$reportNull$$$0(6);
        }
        if (dataGrid == null) {
            DataGridDocumentationUtil.$$$reportNull$$$0(7);
        }
        if (selectedRows == null) {
            DataGridDocumentationUtil.$$$reportNull$$$0(8);
        }
        if (selectedColumns == null) {
            DataGridDocumentationUtil.$$$reportNull$$$0(9);
        }
        for (DasForeignKey key2 : ModelRelationManager.getForeignKeys(dataGrid.getProject(), databaseTable)) {
            DataGridDocumentationUtil.collectKeyQueries(queries, databaseTable, dbms, dataGrid, selectedRows, selectedColumns, key2, false);
        }
    }

    private static void collectKeyQueries(@NotNull Map<String, QueryInfo> queries, @NotNull DasTable databaseTable, @NotNull Dbms dbms, @NotNull DataGrid dataGrid, @NotNull ModelIndexSet<GridRow> selectedRows, @NotNull IntSet selectedColumns, @NotNull DasForeignKey key2, boolean exported) {
        DasTable table;
        if (queries == null) {
            DataGridDocumentationUtil.$$$reportNull$$$0(10);
        }
        if (databaseTable == null) {
            DataGridDocumentationUtil.$$$reportNull$$$0(11);
        }
        if (dbms == null) {
            DataGridDocumentationUtil.$$$reportNull$$$0(12);
        }
        if (dataGrid == null) {
            DataGridDocumentationUtil.$$$reportNull$$$0(13);
        }
        if (selectedRows == null) {
            DataGridDocumentationUtil.$$$reportNull$$$0(14);
        }
        if (selectedColumns == null) {
            DataGridDocumentationUtil.$$$reportNull$$$0(15);
        }
        if (key2 == null) {
            DataGridDocumentationUtil.$$$reportNull$$$0(16);
        }
        DasTable dasTable = table = exported ? key2.getTable() : key2.getRefTable();
        if (table == null) {
            return;
        }
        JBIterable keyColumns = JBIterable.from((!exported ? key2.getColumnsRef() : key2.getRefColumns()).resolveObjects()).filter(DasColumn.class).map(dasColumn -> GridUtil.findColumn((DataGrid)dataGrid, (String)dasColumn.getName()));
        IntOpenHashSet keyColumnsSet = new IntOpenHashSet((Collection)keyColumns.map(c2 -> c2.asInteger()).toList());
        List columnsAndValuesList = ExtractorsUtil.collectColumnsAndValuesList((CoreGrid<GridRow, GridColumn>)dataGrid, selectedRows, (IntSet)keyColumnsSet, row -> DataGridDocumentationUtil.tryCollectValues(dataGrid, (ModelIndex<GridRow>)row, selectedColumns, key2, !exported));
        if (columnsAndValuesList.isEmpty()) {
            return;
        }
        GridModel dataModel = dataGrid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
        WhereClause whereClause2 = ExtractorsUtil.createWhereClauseTask(false, PredicatesHelperKt.predicatesHelper(dbms).getSupportsInOperator(), columnsAndValuesList, (column2, object) -> PredicateValuesKt.predicateValue(DataGridUtilCore.formatValue((GridColumn)dataModel.getColumn(column2), dataGrid.getObjectFormatter(), dbms, object)));
        DbDataSource system = DataGridUtilCore.getDatabaseSystem((CoreGrid<GridRow, GridColumn>)dataGrid);
        Version version = system == null ? null : system.getVersion();
        SelectTask task = DmlTaskKt.allColumns(table).version(version).whereClause(whereClause2).build(DbImplUtilCore.createBuilderForUIExec(dbms, (DasObject)databaseTable));
        DmlHelper generator = DmlUtilKt.dmlGenerator(dbms);
        String query = generator.generate(task).getStatement();
        DataGridDocumentationUtil.collectQuery(queries, new QueryInfo(query, table, exported, ArrayUtil.toStringArray((Collection)ContainerUtil.map((Collection)columnsAndValuesList.get(0), c2 -> ((ColumnRef)c2.getFirst()).getName())), ContainerUtil.map((Collection)columnsAndValuesList.get(0), c2 -> (GridColumn)dataModel.getColumn((ModelIndex)c2.getSecond())).toArray(new GridColumn[0]), ContainerUtil.map(columnsAndValuesList, columnsAndValues -> ContainerUtil.map((Collection)columnsAndValues, c2 -> c2.getThird()).toArray())), key2);
    }

    private static void collectExportedKeyQueries(@NotNull Map<String, QueryInfo> queries, @NotNull DasTable databaseTable, @NotNull Dbms dbms, @NotNull DataGrid dataGrid, @NotNull ModelIndexSet<GridRow> selectedRows, @NotNull IntSet selectedColumns) {
        if (queries == null) {
            DataGridDocumentationUtil.$$$reportNull$$$0(17);
        }
        if (databaseTable == null) {
            DataGridDocumentationUtil.$$$reportNull$$$0(18);
        }
        if (dbms == null) {
            DataGridDocumentationUtil.$$$reportNull$$$0(19);
        }
        if (dataGrid == null) {
            DataGridDocumentationUtil.$$$reportNull$$$0(20);
        }
        if (selectedRows == null) {
            DataGridDocumentationUtil.$$$reportNull$$$0(21);
        }
        if (selectedColumns == null) {
            DataGridDocumentationUtil.$$$reportNull$$$0(22);
        }
        JBIterable referencingKeys = ModelRelationManager.getExportedKeys(dataGrid.getProject(), databaseTable).filter(DasForeignKey.class);
        for (DasForeignKey key2 : referencingKeys) {
            DataGridDocumentationUtil.collectKeyQueries(queries, databaseTable, dbms, dataGrid, selectedRows, selectedColumns, key2, true);
        }
    }

    private static void collectQuery(@NotNull Map<String, QueryInfo> queries, @NotNull QueryInfo newQueryInfo, @NotNull DasConstraint key2) {
        String keyText;
        String query;
        QueryInfo info2;
        if (queries == null) {
            DataGridDocumentationUtil.$$$reportNull$$$0(23);
        }
        if (newQueryInfo == null) {
            DataGridDocumentationUtil.$$$reportNull$$$0(24);
        }
        if (key2 == null) {
            DataGridDocumentationUtil.$$$reportNull$$$0(25);
        }
        if ((info2 = queries.get(query = newQueryInfo.query)) == null || info2.values != newQueryInfo.values) {
            info2 = newQueryInfo;
            queries.put(query, info2);
        }
        if (!info2.keysAndColumns.contains(keyText = key2.getName() + "(" + StringUtil.join(key2.getColumnsRef().names(), (String)", ") + ")")) {
            if (!info2.keysAndColumns.isEmpty()) {
                info2.keysAndColumns = info2.keysAndColumns + ", ";
            }
            info2.keysAndColumns = info2.keysAndColumns + keyText;
        }
    }

    @Nullable
    private static List<Triple<ColumnRef, ModelIndex<GridColumn>, Object>> tryCollectValues(@NotNull DataGrid dataGrid, @NotNull ModelIndex<GridRow> selectedRow, @NotNull IntSet selectedColumns, @NotNull DasForeignKey key2, boolean keyInCurrentGrid) {
        boolean noIndexColumnSelected;
        if (dataGrid == null) {
            DataGridDocumentationUtil.$$$reportNull$$$0(26);
        }
        if (selectedRow == null) {
            DataGridDocumentationUtil.$$$reportNull$$$0(27);
        }
        if (selectedColumns == null) {
            DataGridDocumentationUtil.$$$reportNull$$$0(28);
        }
        if (key2 == null) {
            DataGridDocumentationUtil.$$$reportNull$$$0(29);
        }
        List currentGridColumns = JBIterable.from((keyInCurrentGrid ? key2.getColumnsRef() : key2.getRefColumns()).resolveObjects()).filter(DasColumn.class).toList();
        List otherGridColumns = JBIterable.from((keyInCurrentGrid ? key2.getRefColumns() : key2.getColumnsRef()).resolveObjects()).filter(DasColumn.class).toList();
        ArrayList<Pair> columnsAndIndexes = new ArrayList<Pair>();
        for (int i2 = 0; i2 < currentGridColumns.size(); ++i2) {
            DasColumn currentGridColumn = (DasColumn)currentGridColumns.get(i2);
            ModelIndex idx = GridUtil.findColumn((DataGrid)dataGrid, (String)currentGridColumn.getName());
            if (!idx.isValid((CoreGrid)dataGrid) || i2 >= otherGridColumns.size()) continue;
            DasColumn otherGridColumn = (DasColumn)otherGridColumns.get(i2);
            columnsAndIndexes.add(new Pair((Object)otherGridColumn, (Object)idx));
        }
        boolean bl = noIndexColumnSelected = ContainerUtil.find(columnsAndIndexes, column2 -> selectedColumns.contains(((ModelIndex)column2.getSecond()).asInteger())) == null;
        if (noIndexColumnSelected) {
            return null;
        }
        GridModel dataModel = dataGrid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
        return ContainerUtil.map(columnsAndIndexes, columnAndIndex -> new Triple((Object)new DasColumnRef((DasColumn)columnAndIndex.getFirst()), (Object)((ModelIndex)columnAndIndex.getSecond()), dataModel.getValueAt(selectedRow, (ModelIndex)columnAndIndex.getSecond())));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 1: 
            case 7: 
            case 13: 
            case 20: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataGrid";
                break;
            }
            case 2: 
            case 8: 
            case 14: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedRows";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyTypes";
                break;
            }
            case 4: 
            case 10: 
            case 17: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queries";
                break;
            }
            case 5: 
            case 11: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databaseTable";
                break;
            }
            case 6: 
            case 12: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 9: 
            case 15: 
            case 22: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedColumns";
                break;
            }
            case 16: 
            case 25: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newQueryInfo";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedRow";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/run/ui/grid/documentation/DataGridDocumentationUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildQueries";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "collectForeignKeyQueries";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "collectKeyQueries";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "collectExportedKeyQueries";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "collectQuery";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[2] = "tryCollectValues";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum KeyType {
        EXPORTED,
        FOREIGN;

    }

    public static class QueryInfo {
        public final String query;
        public final DasTable table;
        public final boolean exported;
        public final String[] targetColumnNames;
        public final GridColumn[] sourceColumns;
        public final List<Object[]> values;
        @NlsSafe
        public String keysAndColumns;

        QueryInfo(@NotNull String query, @NotNull DasTable table, boolean exported, String @NotNull [] targetColumnNames, GridColumn @NotNull [] sourceColumns, @NotNull List<Object[]> values2) {
            if (query == null) {
                QueryInfo.$$$reportNull$$$0(0);
            }
            if (table == null) {
                QueryInfo.$$$reportNull$$$0(1);
            }
            if (values2 == null) {
                QueryInfo.$$$reportNull$$$0(2);
            }
            if (targetColumnNames == null) {
                QueryInfo.$$$reportNull$$$0(3);
            }
            if (sourceColumns == null) {
                QueryInfo.$$$reportNull$$$0(4);
            }
            this.keysAndColumns = "";
            this.query = query;
            this.table = table;
            this.exported = exported;
            this.targetColumnNames = targetColumnNames;
            this.sourceColumns = sourceColumns;
            this.values = values2;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            QueryInfo info2 = (QueryInfo)o2;
            return this.query.equals(info2.query);
        }

        public int hashCode() {
            return this.query.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "query";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "table";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "values";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "targetColumnNames";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "sourceColumns";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/run/ui/grid/documentation/DataGridDocumentationUtil$QueryInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

