/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run;

import com.intellij.database.DataBus;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.run.session.LogView;
import com.intellij.database.run.session.LogViewHolder;
import com.intellij.database.run.session.LogViewOwner;
import com.intellij.database.script.ScriptModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractQueryLanguageConsole<T, V extends LogViewOwner>
extends UserDataHolderBase
implements DataProvider,
Disposable.Parent,
DataRequest.Owner,
LogViewHolder<V> {
    protected static final Logger LOG = Logger.getInstance(AbstractQueryLanguageConsole.class);
    private final Project myProject;
    private final DataBus.Consuming myMessageBus;
    private final T myTarget;
    private boolean myDisposed;

    public AbstractQueryLanguageConsole(@NotNull Project project, @NotNull T target2, @NotNull DataBus.Consuming messageBus) {
        if (project == null) {
            AbstractQueryLanguageConsole.$$$reportNull$$$0(0);
        }
        if (target2 == null) {
            AbstractQueryLanguageConsole.$$$reportNull$$$0(1);
        }
        if (messageBus == null) {
            AbstractQueryLanguageConsole.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myTarget = target2;
        this.myMessageBus = messageBus.filterFor(this);
        Disposer.register((Disposable)this.getProject(), (Disposable)this);
    }

    @NotNull
    public T getTarget() {
        T t = this.myTarget;
        if (t == null) {
            AbstractQueryLanguageConsole.$$$reportNull$$$0(3);
        }
        return t;
    }

    @NotNull
    public String getDisplayName() {
        String string = DatabaseBundle.message("console.0", this.getTitle());
        if (string == null) {
            AbstractQueryLanguageConsole.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public DataBus.Consuming getMessageBus() {
        DataBus.Consuming consuming = this.myMessageBus;
        if (consuming == null) {
            AbstractQueryLanguageConsole.$$$reportNull$$$0(5);
        }
        return consuming;
    }

    public boolean isValid() {
        return !this.isDisposed() && this.isViewValid();
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            AbstractQueryLanguageConsole.$$$reportNull$$$0(6);
        }
        return project;
    }

    @NotNull
    public abstract String getTitle();

    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            AbstractQueryLanguageConsole.$$$reportNull$$$0(7);
        }
        if (PlatformCoreDataKeys.HELP_ID.is(dataId)) {
            return this.getHelpID();
        }
        return null;
    }

    public void beforeTreeDispose() {
        this.myDisposed = true;
    }

    public void dispose() {
    }

    protected boolean isViewValid() {
        return this.getView().isValid();
    }

    protected final boolean isDisposed() {
        return this.myDisposed;
    }

    public abstract boolean beforeExecuteQueries(@NotNull ScriptModel<?> var1);

    public abstract boolean isIdle();

    @Nullable
    protected abstract String getHelpID();

    @Override
    @NotNull
    public abstract LogView<V> getView();

    @NotNull
    public abstract ScriptModel<?> getScriptModel();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageBus";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/AbstractQueryLanguageConsole";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/AbstractQueryLanguageConsole";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTarget";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessageBus";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

