/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbTargetUtil;
import com.intellij.database.vfs.DatabaseElementSourceVirtualFileImpl;
import com.intellij.database.view.DatabaseUiService;
import com.intellij.database.view.structure.DvViewOptions;
import com.intellij.database.view.structure.DvViewOptionsFun;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.TextEditorLocation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.TextChunk;
import com.intellij.usages.UsagePresentation;
import com.intellij.usages.UsageView;
import com.intellij.usages.rules.PsiElementUsage;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DbElementUsageBase<T extends DbElement>
implements PsiElementUsage,
UsagePresentation,
DataProvider {
    protected final TextChunk[] myChunks;
    protected final String myText;
    protected final T myElement;

    public DbElementUsageBase(@NotNull String text2, @NotNull T element2) {
        if (text2 == null) {
            DbElementUsageBase.$$$reportNull$$$0(0);
        }
        if (element2 == null) {
            DbElementUsageBase.$$$reportNull$$$0(1);
        }
        this(text2, element2, new TextChunk[]{new TextChunk(SimpleTextAttributes.REGULAR_ATTRIBUTES.toTextAttributes(), text2)});
    }

    protected DbElementUsageBase(@NotNull String text2, @NotNull T element2, TextChunk @NotNull [] chunks) {
        if (text2 == null) {
            DbElementUsageBase.$$$reportNull$$$0(2);
        }
        if (element2 == null) {
            DbElementUsageBase.$$$reportNull$$$0(3);
        }
        if (chunks == null) {
            DbElementUsageBase.$$$reportNull$$$0(4);
        }
        this.myText = text2;
        this.myElement = element2;
        this.myChunks = chunks;
    }

    @NotNull
    public UsagePresentation getPresentation() {
        DbElementUsageBase dbElementUsageBase = this;
        if (dbElementUsageBase == null) {
            DbElementUsageBase.$$$reportNull$$$0(5);
        }
        return dbElementUsageBase;
    }

    public boolean isValid() {
        return this.myElement.isValid();
    }

    public boolean isReadOnly() {
        return true;
    }

    public FileEditorLocation getLocation() {
        FileEditor editor2;
        VirtualFile file = DbTargetUtil.getContainingFile(this.myElement, false);
        FileEditor fileEditor = editor2 = file == null ? null : FileEditorManager.getInstance((Project)this.myElement.getProject()).getSelectedEditor(file);
        if (!(editor2 instanceof TextEditor)) {
            return null;
        }
        return new TextEditorLocation(0, (TextEditor)editor2);
    }

    public void selectInEditor() {
    }

    public void highlightInEditor() {
    }

    protected T getNavigateElement() {
        return this.myElement;
    }

    public void navigate(boolean requestFocus) {
        DvViewOptions viewOptions = DvViewOptionsFun.getDatabaseViewOptions(this.myElement.getProject());
        if (this.myElement instanceof DbDataSource) {
            DatabaseUiService.getInstance().selectInDatabaseView((PsiElement)this.myElement, requestFocus);
        } else if (!viewOptions.getHiddenKinds().contains(this.myElement.getKind().code())) {
            this.doNavigate(requestFocus);
        } else {
            this.getNavigateElement().navigate(requestFocus);
        }
    }

    protected void doNavigate(boolean requestFocus) {
        this.myElement.navigate(requestFocus);
    }

    public boolean canNavigate() {
        return true;
    }

    public PsiElement getElement() {
        return this.myElement;
    }

    public boolean isNonCodeUsage() {
        return true;
    }

    public TextChunk @NotNull [] getText() {
        if (this.myChunks == null) {
            DbElementUsageBase.$$$reportNull$$$0(6);
        }
        return this.myChunks;
    }

    @NotNull
    public String getPlainText() {
        String string = this.myText;
        if (string == null) {
            DbElementUsageBase.$$$reportNull$$$0(7);
        }
        return string;
    }

    public Icon getIcon() {
        return this.myElement.getIcon();
    }

    @NlsSafe
    public String getTooltipText() {
        return this.myText;
    }

    private Object getSlowData(@NotNull String dataId) {
        if (dataId == null) {
            DbElementUsageBase.$$$reportNull$$$0(8);
        }
        if (UsageView.USAGE_INFO_LIST_KEY.is(dataId)) {
            return this.getUsageInfo();
        }
        return null;
    }

    @Nullable
    private List<UsageInfo> getUsageInfo() {
        DasObject target2;
        VirtualFile file = DbTargetUtil.getContainingFile(this.myElement, false);
        if (file == null) {
            return null;
        }
        if (file instanceof DatabaseElementSourceVirtualFileImpl) {
            DatabaseUiService.getInstance().reloadIfNeeded(this.myElement.getProject(), (DatabaseElementSourceVirtualFileImpl)file);
        }
        if ((target2 = DbTargetUtil.calcTarget(this.myElement.getProject(), file, this.myElement)) instanceof PsiElement) {
            return Collections.singletonList(new UsageInfo((PsiElement)target2));
        }
        PsiFile psiFile = this.myElement.getManager().findFile(file);
        return psiFile == null ? null : Collections.singletonList(new UsageInfo(psiFile));
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            DbElementUsageBase.$$$reportNull$$$0(9);
        }
        if (PlatformCoreDataKeys.BGT_DATA_PROVIDER.is(dataId)) {
            return this::getSlowData;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunks";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/psi/DbElementUsageBase";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/psi/DbElementUsageBase";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlainText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSlowData";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7 -> new IllegalStateException(string);
        };
    }
}

