/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.serialization.converters;

import com.intellij.database.Dbms;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.properties.references.BasicParentReference;
import com.intellij.database.model.serialization.Converter;
import com.intellij.database.model.serialization.ModelElementMem;
import com.intellij.database.model.serialization.ModelMem;
import com.intellij.database.model.serialization.ModelSerializationFun;
import com.intellij.database.model.serialization.MutableNameAndValue;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.script.generator.NamingServices;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.util.Pair;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\t"}, d2={"Lcom/intellij/database/model/serialization/converters/Converter_4_26;", "Lcom/intellij/database/model/serialization/Converter;", "()V", "convertExa", "", "modelMem", "Lcom/intellij/database/model/serialization/ModelMem;", "convertMem", "convertPg", "intellij.database.core.impl"})
public final class Converter_4_26
extends Converter {
    @NotNull
    public static final Converter_4_26 INSTANCE = new Converter_4_26();

    private Converter_4_26() {
        int[] nArray = new int[]{4, 26};
        super(nArray);
    }

    @Override
    public void convertMem(@NotNull ModelMem modelMem) {
        Intrinsics.checkNotNullParameter((Object)modelMem, (String)"modelMem");
        if (Intrinsics.areEqual((Object)modelMem.getDbms(), (Object)Dbms.EXASOL)) {
            this.convertExa(modelMem);
        }
        if (Intrinsics.areEqual((Object)modelMem.getDbms(), (Object)Dbms.GREENPLUM) || Intrinsics.areEqual((Object)modelMem.getDbms(), (Object)Dbms.POSTGRES)) {
            this.convertPg(modelMem);
        }
    }

    private final void convertExa(ModelMem modelMem) {
        String es = ObjectKind.EXTERNAL_SCHEMA.code();
        for (ModelElementMem node2 : modelMem.getNodes()) {
            if (!Intrinsics.areEqual((Object)node2.getKind(), (Object)es)) continue;
            MutableNameAndValue mutableNameAndValue = ModelSerializationFun.find(node2.getProperties(), "AdapterSchema");
            if (mutableNameAndValue == null) continue;
            mutableNameAndValue.setName("AdapterParentName");
        }
    }

    private final void convertPg(ModelMem modelMem) {
        String am = ObjectKind.ACCESS_METHOD.code();
        String fdw2 = ObjectKind.FOREIGN_DATA_WRAPPER.code();
        NamingService ns = NamingServices.getNamingService$default(modelMem.getDbms(), null, null, 6, null);
        Lexer lexer = ((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage((Language)DbSqlUtilCore.getSqlDialect(modelMem.getDbms()))).createLexer(null);
        Intrinsics.checkNotNullExpressionValue((Object)lexer, (String)"createLexer(...)");
        Lexer lex = lexer;
        for (ModelElementMem node2 : modelMem.getNodes()) {
            if (Intrinsics.areEqual((Object)node2.getKind(), (Object)am)) {
                if (ModelSerializationFun.find(node2.getProperties(), "Handler") != null) {
                    Pair<String, String> p2;
                    MutableNameAndValue it2;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue(BasicParentReference.parseNameRef(it2.getValue(), ns, lex), (String)"parseNameRef(...)");
                    if (p2.first != null) {
                        Collection collection2 = node2.getProperties();
                        Object object = p2.first;
                        Intrinsics.checkNotNull((Object)object);
                        collection2.add(new MutableNameAndValue("HandlerParentName", (String)object));
                    }
                    Collection collection3 = node2.getProperties();
                    Object object = p2.second;
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"second");
                    collection3.add(new MutableNameAndValue("HandlerName", (String)object));
                }
                continue;
            }
            if (!Intrinsics.areEqual((Object)node2.getKind(), (Object)fdw2)) continue;
            MutableNameAndValue mutableNameAndValue = ModelSerializationFun.find(node2.getProperties(), "Handler");
            if (mutableNameAndValue != null) {
                mutableNameAndValue.setName("HandlerName");
            }
            MutableNameAndValue mutableNameAndValue2 = ModelSerializationFun.find(node2.getProperties(), "HandlerSchema");
            if (mutableNameAndValue2 != null) {
                mutableNameAndValue2.setName("ValidatorParentName");
            }
            MutableNameAndValue mutableNameAndValue3 = ModelSerializationFun.find(node2.getProperties(), "Validator");
            if (mutableNameAndValue3 != null) {
                mutableNameAndValue3.setName("ValidatorName");
            }
            MutableNameAndValue mutableNameAndValue4 = ModelSerializationFun.find(node2.getProperties(), "ValidatorSchema");
            if (mutableNameAndValue4 == null) continue;
            mutableNameAndValue4.setName("ValidatorParentName");
        }
    }
}

