/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.serialization;

import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.serialization.ModelElementMem;
import com.intellij.database.model.serialization.ModelMem;
import com.intellij.database.util.Version;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0015\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b \u0018\u00002\u00020\u0001B\u0013\b\u0016\u0012\n\u0010\u0002\u001a\u00020\u0003\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\r\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ.\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0014\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0012H\u0016J\u0010\u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/model/serialization/Converter;", "", "ver", "", "", "([I)V", "version", "Lcom/intellij/database/util/Version;", "(Lcom/intellij/database/util/Version;)V", "getVersion", "()Lcom/intellij/database/util/Version;", "applyMem", "", "modelMem", "Lcom/intellij/database/model/serialization/ModelMem;", "model", "Lcom/intellij/database/model/basic/BasicModModel;", "getter", "Lkotlin/Function1;", "Lcom/intellij/database/model/serialization/ModelElementMem;", "Lcom/intellij/database/model/basic/BasicModElement;", "convertMem", "convertModel", "intellij.database.core.impl"})
public abstract class Converter {
    @NotNull
    private final Version version;

    public Converter(@NotNull Version version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        this.version = version;
    }

    @NotNull
    public final Version getVersion() {
        return this.version;
    }

    public Converter(int ... ver) {
        Intrinsics.checkNotNullParameter((Object)ver, (String)"ver");
        Version version = Version.of(Arrays.copyOf(ver, ver.length));
        Intrinsics.checkNotNullExpressionValue((Object)version, (String)"of(...)");
        this(version);
    }

    public void convertMem(@NotNull ModelMem modelMem) {
        Intrinsics.checkNotNullParameter((Object)modelMem, (String)"modelMem");
    }

    public void convertModel(@NotNull BasicModModel model2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
    }

    public void applyMem(@NotNull ModelMem modelMem, @NotNull BasicModModel model2, @NotNull Function1<? super ModelElementMem, ? extends BasicModElement> getter) {
        Intrinsics.checkNotNullParameter((Object)modelMem, (String)"modelMem");
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter(getter, (String)"getter");
    }
}

