/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.meta;

import com.intellij.database.Dbms;
import com.intellij.database.model.NameValueGetter;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.meta.BasicMetaField;
import com.intellij.database.model.meta.BasicMetaId;
import com.intellij.database.model.meta.BasicMetaModel;
import com.intellij.database.model.meta.BasicMetaProperty;
import com.intellij.database.model.meta.BasicMetaPropertyId;
import com.intellij.database.model.meta.BasicMetaReference;
import com.intellij.database.model.meta.BasicMetaReferenceId;
import com.intellij.database.model.meta.BasicMetaReferenceList;
import com.intellij.database.model.meta.BasicMetaReferenceListId;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BasicMetaObject<M extends BasicElement> {
    public static final BasicMetaObject<?>[] EMPTY_ARRAY = new BasicMetaObject[0];
    private static final BasicMetaProperty<?, ?>[] EMPTY_PROPS_ARRAY = new BasicMetaProperty[0];
    private static final BasicMetaReference<?, ?>[] EMPTY_REFS_ARRAY = new BasicMetaReference[0];
    public final ObjectKind kind;
    public final Class<? extends BasicElement> apiClass;
    public final Function<BasicMetaObject<M>, ? extends M> dataFactory;
    public final BiConsumer<M, NameValueGetter<String>> dataDeserializer;
    public final BasicMetaProperty<M, ?>[] properties;
    public final BasicMetaProperty<M, ?>[] references;
    public final BasicMetaObject<?>[] children;
    private Object myParent;

    public BasicMetaObject(ObjectKind kind, Class<? extends BasicElement> apiClass, Function<BasicMetaObject<M>, ? extends M> dataFactory, BiConsumer<M, NameValueGetter<String>> dataDeserializer, BasicMetaProperty<M, ?>[] properties2, BasicMetaProperty<M, ?>[] references, BasicMetaObject<?>[] children2) {
        this.kind = kind;
        this.apiClass = apiClass;
        this.dataFactory = dataFactory;
        this.dataDeserializer = dataDeserializer;
        this.properties = properties2 == null ? EMPTY_PROPS_ARRAY : properties2;
        this.references = references == null ? EMPTY_PROPS_ARRAY : references;
        for (BasicMetaObject<?> child : this.children = children2 == null ? EMPTY_ARRAY : children2) {
            if (child.myParent instanceof Class || child.myParent instanceof BasicMetaModel) continue;
            assert (child.myParent == null);
            child.myParent = this;
        }
    }

    @Nullable
    public BasicMetaObject<?> getParent() {
        return (BasicMetaObject)ObjectUtils.tryCast((Object)this.myParent, BasicMetaObject.class);
    }

    @Nullable
    public BasicMetaObject<?> getParent(int i2) {
        BasicMetaObject<?> cur;
        for (cur = this; i2 > 0 && cur != null; cur = cur.getParent(), --i2) {
        }
        return cur;
    }

    @Nullable
    public ObjectKind getParentKind(int i2) {
        BasicMetaObject<?> cur = this.getParent(i2);
        return cur == null ? null : cur.kind;
    }

    @NotNull
    public BasicMetaModel<?> getModel() {
        BasicMetaModel basicMetaModel = (BasicMetaModel)this.getTerminalParent();
        if (basicMetaModel == null) {
            BasicMetaObject.$$$reportNull$$$0(0);
        }
        return basicMetaModel;
    }

    @Nullable
    public BasicMetaModel<?> getModelOpt() {
        Object parent2 = this.getTerminalParent();
        return parent2 instanceof BasicMetaModel ? (BasicMetaModel)parent2 : null;
    }

    private Object getTerminalParent() {
        Object parent2 = this.myParent;
        while (parent2 instanceof BasicMetaObject) {
            parent2 = ((BasicMetaObject)parent2).myParent;
        }
        return parent2;
    }

    @Nullable
    public Dbms getDbmsOpt() {
        BasicMetaModel<?> model2 = this.getModelOpt();
        return model2 == null ? null : model2.getDbms();
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = this.getDbmsOpt();
        Dbms dbms2 = dbms == null ? Dbms.UNKNOWN : dbms;
        if (dbms2 == null) {
            BasicMetaObject.$$$reportNull$$$0(1);
        }
        return dbms2;
    }

    void setModel(@NotNull BasicMetaModel<?> model2) {
        if (model2 == null) {
            BasicMetaObject.$$$reportNull$$$0(2);
        }
        assert (this.myParent == null);
        this.myParent = model2;
    }

    @Nullable
    public Class<? extends BasicElement> getParentClass() {
        BasicMetaObject<?> parent2 = this.getParent();
        if (parent2 != null) {
            return parent2.apiClass;
        }
        Class clazz = (Class)ObjectUtils.tryCast((Object)this.myParent, Class.class);
        return clazz;
    }

    public boolean kindOf(@Nullable Class<?> clazz) {
        return clazz != null && clazz.isAssignableFrom(this.apiClass);
    }

    public <T extends BasicElement> BasicMetaObject<T> tryCast(@Nullable Class<T> clazz) {
        return this.kindOf(clazz) ? this : null;
    }

    public <T extends BasicElement> BasicMetaObject<T> tryCast(@Nullable BasicMetaObject<T> m) {
        return this.tryCast(m == null ? null : m.apiClass);
    }

    public M tryCast(@Nullable BasicElement e2) {
        return (M)(e2 != null && this.apiClass.isAssignableFrom(e2.getClass()) ? e2 : null);
    }

    @NotNull
    public M newDataObject() {
        BasicElement basicElement = (BasicElement)this.dataFactory.fun((Object)this);
        if (basicElement == null) {
            BasicMetaObject.$$$reportNull$$$0(3);
        }
        return (M)basicElement;
    }

    @Nullable
    public BasicMetaField<M> getField(@NotNull BasicMetaId id) {
        if (id == null) {
            BasicMetaObject.$$$reportNull$$$0(4);
        }
        if (id instanceof BasicMetaReferenceId) {
            return this.getReference((BasicMetaReferenceId)id);
        }
        if (id instanceof BasicMetaReferenceListId) {
            return this.getReference((BasicMetaReferenceListId)id);
        }
        if (id instanceof BasicMetaPropertyId) {
            return this.getObjectProperty((BasicMetaPropertyId)id);
        }
        return null;
    }

    @Nullable
    public <T extends BasicElement> BasicMetaReference<M, T> getReference(@NotNull BasicMetaReferenceId<T> refId) {
        int idx;
        if (refId == null) {
            BasicMetaObject.$$$reportNull$$$0(5);
        }
        BasicMetaReference<M, ?> res2 = (idx = this.indexOf(this.references, refId, -1)) == -1 ? null : BasicMetaReference.asRef(this.references[idx]);
        return res2 == null ? null : res2.asId(refId);
    }

    @Nullable
    public <T extends BasicElement> BasicMetaReferenceList<M, T> getReference(@NotNull BasicMetaReferenceListId<T> refId) {
        int idx;
        if (refId == null) {
            BasicMetaObject.$$$reportNull$$$0(6);
        }
        BasicMetaReferenceList<M, ?> res2 = (idx = this.indexOf(this.references, refId, -1)) == -1 ? null : BasicMetaReferenceList.asRefList(this.references[idx]);
        return res2 == null ? null : res2.asId(refId);
    }

    public boolean isAbstract(@NotNull BasicMetaId id) {
        BasicMetaField<M> field;
        if (id == null) {
            BasicMetaObject.$$$reportNull$$$0(7);
        }
        return (field = this.getField(id)) == null || field.isAbstract();
    }

    @Nullable
    public <T> BasicMetaProperty<M, T> getObjectProperty(@NotNull BasicMetaPropertyId<T> id) {
        int idx;
        if (id == null) {
            BasicMetaObject.$$$reportNull$$$0(8);
        }
        return (idx = this.indexOf(this.properties, id, -1)) == -1 ? null : this.properties[idx].asId(id);
    }

    private <T extends BasicMetaField<?>> int indexOf(T @NotNull [] objects2, @NotNull BasicMetaId id, int hint) {
        if (id == null) {
            BasicMetaObject.$$$reportNull$$$0(9);
        }
        if (objects2 == null) {
            BasicMetaObject.$$$reportNull$$$0(10);
        }
        if (hint != -1) {
            if (objects2[hint].getId() != id) {
                throw new AssertionError((Object)("Wrong hint for " + id + " in " + this));
            }
            return hint;
        }
        int length = objects2.length;
        for (int i2 = 0; i2 < length; ++i2) {
            T p2 = objects2[i2];
            if (p2.getId() != id) continue;
            return i2;
        }
        return -1;
    }

    @NotNull
    public String toString() {
        if (this.myParent instanceof BasicMetaObject) {
            String string = this.myParent + "." + this.kind.code();
            if (string == null) {
                BasicMetaObject.$$$reportNull$$$0(11);
            }
            return string;
        }
        if (this.myParent instanceof BasicMetaModel) {
            String string = ((BasicMetaModel)this.myParent).dbms.getDisplayName() + ": " + this.kind.code();
            if (string == null) {
                BasicMetaObject.$$$reportNull$$$0(12);
            }
            return string;
        }
        String string = this.kind.code();
        if (string == null) {
            BasicMetaObject.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    public JBIterable<BasicMetaProperty<M, ?>> getAllProperties() {
        JBIterable jBIterable = JBIterable.of((Object[])this.properties).append((Object[])this.references);
        if (jBIterable == null) {
            BasicMetaObject.$$$reportNull$$$0(14);
        }
        return jBIterable;
    }

    public static BasicMetaObject<?> bindVirtualRoot(@NotNull BasicMetaObject<?> meta, @NotNull Class<? extends BasicElement> parentClass) {
        if (meta == null) {
            BasicMetaObject.$$$reportNull$$$0(15);
        }
        if (parentClass == null) {
            BasicMetaObject.$$$reportNull$$$0(16);
        }
        meta.myParent = parentClass;
        return meta;
    }

    public static void bindVirtualRoot(@NotNull BasicMetaObject<?> meta, @NotNull BasicMetaObject<?> parent2) {
        if (meta == null) {
            BasicMetaObject.$$$reportNull$$$0(17);
        }
        if (parent2 == null) {
            BasicMetaObject.$$$reportNull$$$0(18);
        }
        meta.myParent = parent2;
    }

    public static <T extends BasicElement> BasicMetaObject<T>[] toArray(@NotNull Collection<BasicMetaObject<T>> c2) {
        if (c2 == null) {
            BasicMetaObject.$$$reportNull$$$0(19);
        }
        return c2.toArray(EMPTY_ARRAY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 4, 5, 6, 7, 8, 9, 10, 15, 16, 17, 18, 19 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/meta/BasicMetaObject";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refId";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meta";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentClass";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/meta/BasicMetaObject";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "newDataObject";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllProperties";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setModel";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getField";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getReference";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isAbstract";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getObjectProperty";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "indexOf";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "bindVirtualRoot";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "toArray";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 4, 5, 6, 7, 8, 9, 10, 15, 16, 17, 18, 19 -> new IllegalArgumentException(string);
        };
    }
}

