/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.model.properties.SourceError;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.types.DasUnresolvedTypeReference;
import com.intellij.database.util.DasUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public interface ModelConsts {
    public static final short NO_POSITION = 0;
    public static final long NO_ID = Long.MIN_VALUE;
    public static final long INVALID_ID = -9223372036854775807L;
    @NotNull
    public static final String NO_NAME = DasUtil.NO_NAME;
    @NotNull
    public static final DataType NO_DATA_TYPE = DataType.UNKNOWN;
    @NotNull
    public static final DasType NO_DAS_TYPE = DasTypeSystemBase.UNKNOWN;
    public static final String NO_DISPLAY_ORDER = "\uffff";
    @NotNull
    public static final List<SourceError> NO_ERRORS = Collections.emptyList();
    public static final String ROOT_IDENTITY = "#ROOT";
    @NotNull
    public static final Set<ObjectKind> TABLE_OR_VIEW_KINDS = ModelConsts.setOf(ObjectKind.TABLE, ObjectKind.MAT_VIEW, ObjectKind.VIEW, ObjectKind.VIRTUAL_TABLE, ObjectKind.FOREIGN_TABLE);
    @NotNull
    public static final Set<ObjectKind> CONSTRAINT_KINDS = ModelConsts.setOf(ObjectKind.KEY, ObjectKind.FOREIGN_KEY, ObjectKind.CHECK);
    public static final DataType ANY_TYPE = DataTypeFactory.of("any");
    public static final DasType DAS_ANY_TYPE = DasUnresolvedTypeReference.of(ANY_TYPE);
    public static final String UNKNOWN_DEFAULT = "???";

    public static <E> Set<E> setOf(E ... items2) {
        return Collections.unmodifiableSet(new LinkedHashSet<E>(Arrays.asList(items2)));
    }
}

